// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_IN_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_IN_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SmartCardReaderStateFlagsIn;

class MODULES_EXPORT SmartCardReaderStateIn : public bindings::InputDictionaryBase {
  
  public:
static SmartCardReaderStateIn* Create() {
  return MakeGarbageCollected<SmartCardReaderStateIn>();
}
static SmartCardReaderStateIn* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SmartCardReaderStateIn>(isolate);
}
static SmartCardReaderStateIn* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SmartCardReaderStateIn();
explicit  SmartCardReaderStateIn(v8::Isolate* isolate);

bool hasCurrentCount() const {
  return has_current_count_;
}
uint32_t currentCount() const {
  DCHECK(hasCurrentCount());
return member_current_count_;
}
uint32_t getCurrentCountOr(uint32_t fallback_value) const {
  if (!hasCurrentCount()) {
  return fallback_value;
}
return member_current_count_;
}
void setCurrentCount(uint32_t value) {
  member_current_count_ = value;
has_current_count_ = true;
}

bool hasCurrentState() const {
  return true;
}
SmartCardReaderStateFlagsIn* currentState() const {
  return member_current_state_.Get();
}
void setCurrentState(SmartCardReaderStateFlagsIn* value) {
  member_current_state_ = value;
DCHECK(member_current_state_);
}

bool hasReaderName() const {
  return true;
}
const String& readerName() const {
  return member_reader_name_;
}
void setReaderName(const String& value);
void setReaderName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_current_count_ = false;

uint32_t member_current_count_;
Member<SmartCardReaderStateFlagsIn> member_current_state_;
String member_reader_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_IN_H_
