// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_FLAGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_FLAGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SmartCardReaderStateFlags : public bindings::DictionaryBase {
  
  public:
static SmartCardReaderStateFlags* Create() {
  return MakeGarbageCollected<SmartCardReaderStateFlags>();
}
static SmartCardReaderStateFlags* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SmartCardReaderStateFlags>(isolate);
}
static SmartCardReaderStateFlags* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SmartCardReaderStateFlags();
explicit  SmartCardReaderStateFlags(v8::Isolate* isolate);

bool hasEmpty() const {
  return true;
}
bool empty() const {
  return member_empty_;
}
void setEmpty(bool value) {
  member_empty_ = value;
}

bool hasExclusive() const {
  return true;
}
bool exclusive() const {
  return member_exclusive_;
}
void setExclusive(bool value) {
  member_exclusive_ = value;
}

bool hasIgnore() const {
  return true;
}
bool ignore() const {
  return member_ignore_;
}
void setIgnore(bool value) {
  member_ignore_ = value;
}

bool hasInuse() const {
  return true;
}
bool inuse() const {
  return member_inuse_;
}
void setInuse(bool value) {
  member_inuse_ = value;
}

bool hasMute() const {
  return true;
}
bool mute() const {
  return member_mute_;
}
void setMute(bool value) {
  member_mute_ = value;
}

bool hasPresent() const {
  return true;
}
bool present() const {
  return member_present_;
}
void setPresent(bool value) {
  member_present_ = value;
}

bool hasUnavailable() const {
  return true;
}
bool unavailable() const {
  return member_unavailable_;
}
void setUnavailable(bool value) {
  member_unavailable_ = value;
}

bool hasUnpowered() const {
  return true;
}
bool unpowered() const {
  return member_unpowered_;
}
void setUnpowered(bool value) {
  member_unpowered_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_empty_{false};
bool member_exclusive_{false};
bool member_ignore_{false};
bool member_inuse_{false};
bool member_mute_{false};
bool member_present_{false};
bool member_unavailable_{false};
bool member_unpowered_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_READER_STATE_FLAGS_H_
