// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_private_aggregation_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aggregationCoordinatorOrigin",
"contextId",
"filteringIdMaxBytes",
"maxContributions",
};


}  // namespace 

SharedStoragePrivateAggregationConfig* SharedStoragePrivateAggregationConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SharedStoragePrivateAggregationConfig* dictionary = MakeGarbageCollected<SharedStoragePrivateAggregationConfig>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SharedStoragePrivateAggregationConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfig() {
  
}

 SharedStoragePrivateAggregationConfig::SharedStoragePrivateAggregationConfig(v8::Isolate* isolate) {
  
}



String SharedStoragePrivateAggregationConfig::getAggregationCoordinatorOriginOr(const String& fallback_value) const {
  if (!hasAggregationCoordinatorOrigin()) {
  return fallback_value;
}
return member_aggregation_coordinator_origin_;
}

String SharedStoragePrivateAggregationConfig::getAggregationCoordinatorOriginOr(String&& fallback_value) const {
  if (!hasAggregationCoordinatorOrigin()) {
  return std::move(fallback_value);
}
return member_aggregation_coordinator_origin_;
}

void SharedStoragePrivateAggregationConfig::setAggregationCoordinatorOrigin(const String& value) {
  member_aggregation_coordinator_origin_ = value;
has_aggregation_coordinator_origin_ = true;
}

void SharedStoragePrivateAggregationConfig::setAggregationCoordinatorOrigin(String&& value) {
  member_aggregation_coordinator_origin_ = std::move(value);
has_aggregation_coordinator_origin_ = true;
}




String SharedStoragePrivateAggregationConfig::getContextIdOr(const String& fallback_value) const {
  if (!hasContextId()) {
  return fallback_value;
}
return member_context_id_;
}

String SharedStoragePrivateAggregationConfig::getContextIdOr(String&& fallback_value) const {
  if (!hasContextId()) {
  return std::move(fallback_value);
}
return member_context_id_;
}

void SharedStoragePrivateAggregationConfig::setContextId(const String& value) {
  member_context_id_ = value;
has_context_id_ = true;
}

void SharedStoragePrivateAggregationConfig::setContextId(String&& value) {
  member_context_id_ = std::move(value);
has_context_id_ = true;
}

















void SharedStoragePrivateAggregationConfig::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void SharedStoragePrivateAggregationConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SharedStoragePrivateAggregationConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aggregationCoordinatorOrigin");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_aggregation_coordinator_origin_, member_aggregation_coordinator_origin_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contextId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_context_id_, member_context_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("filteringIdMaxBytes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_filtering_id_max_bytes_, member_filtering_id_max_bytes_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::PrivateAggregationApiMaxContributionsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("maxContributions");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_max_contributions_, member_max_contributions_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> SharedStoragePrivateAggregationConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
