// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_share_data.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/fileapi/file.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"files",
"text",
"title",
"url",
};


}  // namespace 

ShareData* ShareData::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ShareData* dictionary = MakeGarbageCollected<ShareData>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ShareData";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ShareData::ShareData() {
  
}

 ShareData::ShareData(v8::Isolate* isolate) {
  
}



HeapVector<Member<File>> ShareData::getFilesOr(const HeapVector<Member<File>>& fallback_value) const {
  if (!hasFiles()) {
  return fallback_value;
}
return member_files_;
}

HeapVector<Member<File>> ShareData::getFilesOr(HeapVector<Member<File>>&& fallback_value) const {
  if (!hasFiles()) {
  return std::move(fallback_value);
}
return member_files_;
}

void ShareData::setFiles(const HeapVector<Member<File>>& value) {
  member_files_ = value;
has_files_ = true;
}

void ShareData::setFiles(HeapVector<Member<File>>&& value) {
  member_files_ = std::move(value);
has_files_ = true;
}




String ShareData::getTextOr(const String& fallback_value) const {
  if (!hasText()) {
  return fallback_value;
}
return member_text_;
}

String ShareData::getTextOr(String&& fallback_value) const {
  if (!hasText()) {
  return std::move(fallback_value);
}
return member_text_;
}

void ShareData::setText(const String& value) {
  member_text_ = value;
has_text_ = true;
}

void ShareData::setText(String&& value) {
  member_text_ = std::move(value);
has_text_ = true;
}




String ShareData::getTitleOr(const String& fallback_value) const {
  if (!hasTitle()) {
  return fallback_value;
}
return member_title_;
}

String ShareData::getTitleOr(String&& fallback_value) const {
  if (!hasTitle()) {
  return std::move(fallback_value);
}
return member_title_;
}

void ShareData::setTitle(const String& value) {
  member_title_ = value;
has_title_ = true;
}

void ShareData::setTitle(String&& value) {
  member_title_ = std::move(value);
has_title_ = true;
}




String ShareData::getUrlOr(const String& fallback_value) const {
  if (!hasUrl()) {
  return fallback_value;
}
return member_url_;
}

String ShareData::getUrlOr(String&& fallback_value) const {
  if (!hasUrl()) {
  return std::move(fallback_value);
}
return member_url_;
}

void ShareData::setUrl(const String& value) {
  member_url_ = value;
has_url_ = true;
}

void ShareData::setUrl(String&& value) {
  member_url_ = std::move(value);
has_url_ = true;
}



void ShareData::Trace(Visitor* visitor) const {
  visitor->Trace(member_files_);
bindings::InputDictionaryBase::Trace(visitor);
}

void ShareData::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ShareData";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("files");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<File>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_files_, member_files_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("text");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_text_, member_text_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("title");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_title_, member_title_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("url");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_url_, member_url_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ShareData::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
