// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_abort_signal.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_interventions_test.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_x.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_skew_y.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_custom_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_exception.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_quad.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect_read_only.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_string_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_error_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_font_face.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_font_face_set.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_form_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_headers.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_channel.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_port.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_handle.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_interface_interceptor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_interface_request_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mojo_watcher.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigator_ua_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_origin.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_entry.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_mark.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_measure.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_observer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_observer_entry_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_resource_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_server_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_promise_rejection_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_report_body.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_reporting_observer.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_response.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scheduler.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_security_policy_violation_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_subscriber.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_priority_change_event.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_task_signal.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_cluster.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_metrics.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_html.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_type_policy_factory.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_search_params.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_user_activation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_location.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worker_navigator.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_abort_payment_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_record.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_registration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_background_fetch_update_ui_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_barcode_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_broadcast_channel.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cache.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cache_storage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_can_make_payment_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_gradient.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_pattern.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_client.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_clients.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_close_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_compression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_content_index.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_content_index_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_store.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_store_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_create_monitor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crop_target.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto_key.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_decompression_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_event_source.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_cookie_change_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_extendable_message_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_face_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_fetch_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_directory_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_file_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_file_system_writable_file_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_adapter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_adapter_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_bind_group_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_usage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_canvas_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_color_write.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_command_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compilation_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compilation_message.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_compute_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_device_lost_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_heap_property.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_internal_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_map_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_memory_heap_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_out_of_memory_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_pipeline_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_query_set.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_queue.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_bundle_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pass_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_render_pipeline.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_module.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_shader_stage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_subgroup_matrix_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_features.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_supported_limits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_usage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_uncaptured_error_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_validation_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_connection_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid_input_report_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor_with_value.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_database.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_factory.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_index.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_key_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_object_store.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_open_db_request.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_record.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_request.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_transaction.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_version_change_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_bitmap_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_install_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_language_model_params.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_capabilities.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_index_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_uv_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_vertex_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_graph.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_graph_builder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operand.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_tensor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_multicast_controller.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigation_preload_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_network_information.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_notification_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_path_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_request_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_periodic_sync_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_periodic_sync_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permission_status.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permissions.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_proofreader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_message_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_subscription.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_subscription_change_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_push_subscription_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_restriction_target.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rewriter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_received_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_ice_candidate.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_ice_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_registration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_subtle_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_sync_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_sync_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_tcp_server_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_tcp_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_detector.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_timestamp_trigger.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_translator.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_udp_socket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_alternate_interface.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_configuration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_connection_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_device.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_endpoint.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_in_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_interface.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_in_transfer_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_in_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_out_transfer_packet.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb_isochronous_out_transfer_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_bidirectional_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_datagram_duplex_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_transport_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context_webgpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_active_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_context_event.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_framebuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_object.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_program.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_query.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_renderbuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context_webgpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader_precision_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sync.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_transform_feedback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_uniform_location.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_vertex_array_object.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket_error.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket_stream.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_wgsl_language_features.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_window_client.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_writer.h"
#include "third_party/blink/renderer/core/context_features/context_feature_settings.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/background_fetch/service_worker_global_scope_background_fetch.h"
#include "third_party/blink/renderer/modules/background_sync/service_worker_global_scope_sync.h"
#include "third_party/blink/renderer/modules/content_index/service_worker_global_scope_content_index.h"
#include "third_party/blink/renderer/modules/cookie_store/cookie_store.h"
#include "third_party/blink/renderer/modules/cookie_store/global_cookie_store.h"
#include "third_party/blink/renderer/modules/notifications/service_worker_global_scope_notifications.h"
#include "third_party/blink/renderer/modules/payments/payment_app_service_worker_global_scope.h"
#include "third_party/blink/renderer/modules/push_messaging/service_worker_global_scope_push.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker_clients.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker_global_scope.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker_registration.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8ServiceWorkerGlobalScope::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsServiceWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8ServiceWorkerGlobalScope::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8ServiceWorkerGlobalScope::InstallInterfaceTemplate,
    V8ServiceWorkerGlobalScope::InstallContextDependentProperties,
    "ServiceWorkerGlobalScope",
    V8WorkerGlobalScope::GetWrapperTypeInfo(),
    V8ServiceWorkerGlobalScope::kThisTag,
    V8ServiceWorkerGlobalScope::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& ServiceWorkerGlobalScope::wrapper_type_info_ =
    V8ServiceWorkerGlobalScope::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, ServiceWorkerGlobalScope>::value,
    "ServiceWorkerGlobalScope does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_service_worker_global_scope {


void ClientsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_clients_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.clients.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->clients();
static_assert(bindings::IsReturnTypeCompatible<ServiceWorkerClients, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void RegistrationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_registration_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.registration.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->registration();
static_assert(bindings::IsReturnTypeCompatible<ServiceWorkerRegistration, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ServiceWorkerAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_serviceWorker_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.serviceWorker.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->serviceWorker();
static_assert(bindings::IsReturnTypeCompatible<ServiceWorker, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void OnactivateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onactivate_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onactivate.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onactivate();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnactivateAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onactivate_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onactivate.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnactivate(event_handler);
}


void OnfetchAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onfetch_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onfetch.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onfetch();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnfetchAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onfetch_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onfetch.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnfetch(event_handler);
}


void OninstallAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oninstall_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oninstall.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->oninstall();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OninstallAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oninstall_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oninstall.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOninstall(event_handler);
}


void OnmessageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onmessage_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onmessage.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onmessage();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnmessageAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onmessage_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onmessage.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnmessage(event_handler);
}


void OnmessageerrorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onmessageerror_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onmessageerror.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onmessageerror();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnmessageerrorAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onmessageerror_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onmessageerror.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnmessageerror(event_handler);
}


void OnbackgroundfetchsuccessAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchsuccess_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchsuccess.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeBackgroundFetch::onbackgroundfetchsuccess(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnbackgroundfetchsuccessAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchsuccess_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchsuccess.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeBackgroundFetch::setOnbackgroundfetchsuccess(*blink_receiver, event_handler);
}


void OnbackgroundfetchfailAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchfail_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchfail.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeBackgroundFetch::onbackgroundfetchfail(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnbackgroundfetchfailAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchfail_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchfail.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeBackgroundFetch::setOnbackgroundfetchfail(*blink_receiver, event_handler);
}


void OnbackgroundfetchabortAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchabort_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchabort.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeBackgroundFetch::onbackgroundfetchabort(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnbackgroundfetchabortAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchabort_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchabort.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeBackgroundFetch::setOnbackgroundfetchabort(*blink_receiver, event_handler);
}


void OnbackgroundfetchclickAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchclick_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchclick.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeBackgroundFetch::onbackgroundfetchclick(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnbackgroundfetchclickAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onbackgroundfetchclick_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onbackgroundfetchclick.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeBackgroundFetch::setOnbackgroundfetchclick(*blink_receiver, event_handler);
}


void OnsyncAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onsync_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onsync.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeSync::onsync(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnsyncAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onsync_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onsync.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeSync::setOnsync(*blink_receiver, event_handler);
}


void OnperiodicsyncAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onperiodicsync_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onperiodicsync.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeSync::onperiodicsync(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnperiodicsyncAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onperiodicsync_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onperiodicsync.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeSync::setOnperiodicsync(*blink_receiver, event_handler);
}


void OncontentdeleteAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncontentdelete_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncontentdelete.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeContentIndex::oncontentdelete(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OncontentdeleteAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncontentdelete_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncontentdelete.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeContentIndex::setOncontentdelete(*blink_receiver, event_handler);
}


void CookieStoreAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_cookieStore_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.cookieStore.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalCookieStore::cookieStore(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<CookieStore, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void OncookiechangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncookiechange_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncookiechange.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GlobalCookieStore::oncookiechange(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OncookiechangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncookiechange_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncookiechange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
GlobalCookieStore::setOncookiechange(*blink_receiver, event_handler);
}


void OnnotificationclickAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onnotificationclick_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onnotificationclick.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeNotifications::onnotificationclick(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnnotificationclickAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onnotificationclick_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onnotificationclick.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeNotifications::setOnnotificationclick(*blink_receiver, event_handler);
}


void OnnotificationcloseAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onnotificationclose_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onnotificationclose.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopeNotifications::onnotificationclose(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnnotificationcloseAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onnotificationclose_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onnotificationclose.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopeNotifications::setOnnotificationclose(*blink_receiver, event_handler);
}


void OnabortpaymentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onabortpayment_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onabortpayment.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = PaymentAppServiceWorkerGlobalScope::onabortpayment(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnabortpaymentAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onabortpayment_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onabortpayment.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
PaymentAppServiceWorkerGlobalScope::setOnabortpayment(*blink_receiver, event_handler);
}


void OncanmakepaymentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncanmakepayment_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncanmakepayment.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = PaymentAppServiceWorkerGlobalScope::oncanmakepayment(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OncanmakepaymentAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_oncanmakepayment_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.oncanmakepayment.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
PaymentAppServiceWorkerGlobalScope::setOncanmakepayment(*blink_receiver, event_handler);
}


void OnpaymentrequestAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpaymentrequest_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpaymentrequest.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = PaymentAppServiceWorkerGlobalScope::onpaymentrequest(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnpaymentrequestAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpaymentrequest_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpaymentrequest.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
PaymentAppServiceWorkerGlobalScope::setOnpaymentrequest(*blink_receiver, event_handler);
}


void OnpushAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpush_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpush.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopePush::onpush(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnpushAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpush_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpush.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopePush::setOnpush(*blink_receiver, event_handler);
}


void OnpushsubscriptionchangeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpushsubscriptionchange_Getter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpushsubscriptionchange.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ServiceWorkerGlobalScopePush::onpushsubscriptionchange(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnpushsubscriptionchangeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_onpushsubscriptionchange_Setter");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.onpushsubscriptionchange.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ServiceWorkerGlobalScopePush::setOnpushsubscriptionchange(*blink_receiver, event_handler);
}

void AbortControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_AbortController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.AbortController");

bindings::V8SetReturnValue(info, V8AbortController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AbortPaymentEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_AbortPaymentEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.AbortPaymentEvent");

bindings::V8SetReturnValue(info, V8AbortPaymentEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void AbortSignalExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_AbortSignal_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.AbortSignal");

bindings::V8SetReturnValue(info, V8AbortSignal::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BackgroundFetchEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BackgroundFetchEvent");

bindings::V8SetReturnValue(info, V8BackgroundFetchEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BackgroundFetchManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BackgroundFetchManager");

bindings::V8SetReturnValue(info, V8BackgroundFetchManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchRecordExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BackgroundFetchRecord_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BackgroundFetchRecord");

bindings::V8SetReturnValue(info, V8BackgroundFetchRecord::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchRegistrationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BackgroundFetchRegistration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BackgroundFetchRegistration");

bindings::V8SetReturnValue(info, V8BackgroundFetchRegistration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BackgroundFetchUpdateUIEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BackgroundFetchUpdateUIEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BackgroundFetchUpdateUIEvent");

bindings::V8SetReturnValue(info, V8BackgroundFetchUpdateUIEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BarcodeDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BarcodeDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BarcodeDetector");

bindings::V8SetReturnValue(info, V8BarcodeDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BlobExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Blob_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Blob");

bindings::V8SetReturnValue(info, V8Blob::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void BroadcastChannelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_BroadcastChannel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.BroadcastChannel");

bindings::V8SetReturnValue(info, V8BroadcastChannel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewXExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CSSSkewX_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CSSSkewX");

bindings::V8SetReturnValue(info, V8CSSSkewX::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CSSSkewYExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CSSSkewY_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CSSSkewY");

bindings::V8SetReturnValue(info, V8CSSSkewY::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CacheExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Cache_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Cache");

bindings::V8SetReturnValue(info, V8Cache::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CacheStorageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CacheStorage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CacheStorage");

bindings::V8SetReturnValue(info, V8CacheStorage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanMakePaymentEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CanMakePaymentEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CanMakePaymentEvent");

bindings::V8SetReturnValue(info, V8CanMakePaymentEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasFilterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CanvasFilter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CanvasFilter");

bindings::V8SetReturnValue(info, V8CanvasFilter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasGradientExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CanvasGradient_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CanvasGradient");

bindings::V8SetReturnValue(info, V8CanvasGradient::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasInterventionsTestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CanvasInterventionsTest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CanvasInterventionsTest");

bindings::V8SetReturnValue(info, V8CanvasInterventionsTest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CanvasPatternExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CanvasPattern_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CanvasPattern");

bindings::V8SetReturnValue(info, V8CanvasPattern::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ClientExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Client_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Client");

bindings::V8SetReturnValue(info, V8Client::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ClientsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Clients_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Clients");

bindings::V8SetReturnValue(info, V8Clients::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CloseEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CloseEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CloseEvent");

bindings::V8SetReturnValue(info, V8CloseEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CompressionStream");

bindings::V8SetReturnValue(info, V8CompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ContentIndexExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ContentIndex_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ContentIndex");

bindings::V8SetReturnValue(info, V8ContentIndex::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ContentIndexEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ContentIndexEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ContentIndexEvent");

bindings::V8SetReturnValue(info, V8ContentIndexEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CookieStoreExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CookieStore_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CookieStore");

bindings::V8SetReturnValue(info, V8CookieStore::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CookieStoreManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CookieStoreManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CookieStoreManager");

bindings::V8SetReturnValue(info, V8CookieStoreManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CreateMonitorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CreateMonitor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CreateMonitor");

bindings::V8SetReturnValue(info, V8CreateMonitor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CropTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CropTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CropTarget");

bindings::V8SetReturnValue(info, V8CropTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Crypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Crypto");

bindings::V8SetReturnValue(info, V8Crypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoKeyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CryptoKey_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CryptoKey");

bindings::V8SetReturnValue(info, V8CryptoKey::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CustomEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_CustomEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.CustomEvent");

bindings::V8SetReturnValue(info, V8CustomEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMExceptionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMException_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMException");

bindings::V8SetReturnValue(info, V8DOMException::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMMatrixExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMMatrix_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMMatrix");

bindings::V8SetReturnValue(info, V8DOMMatrix::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMMatrixReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMMatrixReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMMatrixReadOnly");

bindings::V8SetReturnValue(info, V8DOMMatrixReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMPointExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMPoint_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMPoint");

bindings::V8SetReturnValue(info, V8DOMPoint::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMPointReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMPointReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMPointReadOnly");

bindings::V8SetReturnValue(info, V8DOMPointReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMQuadExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMQuad_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMQuad");

bindings::V8SetReturnValue(info, V8DOMQuad::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMRectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMRect_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMRect");

bindings::V8SetReturnValue(info, V8DOMRect::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMRectReadOnlyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMRectReadOnly_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMRectReadOnly");

bindings::V8SetReturnValue(info, V8DOMRectReadOnly::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DOMStringListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DOMStringList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DOMStringList");

bindings::V8SetReturnValue(info, V8DOMStringList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void DecompressionStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_DecompressionStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.DecompressionStream");

bindings::V8SetReturnValue(info, V8DecompressionStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ErrorEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ErrorEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ErrorEvent");

bindings::V8SetReturnValue(info, V8ErrorEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Event_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Event");

bindings::V8SetReturnValue(info, V8Event::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventSourceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_EventSource_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.EventSource");

bindings::V8SetReturnValue(info, V8EventSource::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void EventTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_EventTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.EventTarget");

bindings::V8SetReturnValue(info, V8EventTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ExtendableCookieChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ExtendableCookieChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ExtendableCookieChangeEvent");

bindings::V8SetReturnValue(info, V8ExtendableCookieChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ExtendableEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ExtendableEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ExtendableEvent");

bindings::V8SetReturnValue(info, V8ExtendableEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ExtendableMessageEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ExtendableMessageEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ExtendableMessageEvent");

bindings::V8SetReturnValue(info, V8ExtendableMessageEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FaceDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FaceDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FaceDetector");

bindings::V8SetReturnValue(info, V8FaceDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FetchEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FetchEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FetchEvent");

bindings::V8SetReturnValue(info, V8FetchEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_File_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.File");

bindings::V8SetReturnValue(info, V8File::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileList");

bindings::V8SetReturnValue(info, V8FileList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileReader");

bindings::V8SetReturnValue(info, V8FileReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemDirectoryHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileSystemDirectoryHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileSystemDirectoryHandle");

bindings::V8SetReturnValue(info, V8FileSystemDirectoryHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemFileHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileSystemFileHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileSystemFileHandle");

bindings::V8SetReturnValue(info, V8FileSystemFileHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileSystemHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileSystemHandle");

bindings::V8SetReturnValue(info, V8FileSystemHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FileSystemWritableFileStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FileSystemWritableFileStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FileSystemWritableFileStream");

bindings::V8SetReturnValue(info, V8FileSystemWritableFileStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FontFaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FontFace_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FontFace");

bindings::V8SetReturnValue(info, V8FontFace::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void FormDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_FormData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.FormData");

bindings::V8SetReturnValue(info, V8FormData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPU");

bindings::V8SetReturnValue(info, V8GPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUAdapterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUAdapter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUAdapter");

bindings::V8SetReturnValue(info, V8GPUAdapter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUAdapterInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUAdapterInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUAdapterInfo");

bindings::V8SetReturnValue(info, V8GPUAdapterInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBindGroupExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUBindGroup_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUBindGroup");

bindings::V8SetReturnValue(info, V8GPUBindGroup::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBindGroupLayoutExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUBindGroupLayout_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUBindGroupLayout");

bindings::V8SetReturnValue(info, V8GPUBindGroupLayout::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUBuffer");

bindings::V8SetReturnValue(info, V8GPUBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUBufferUsageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUBufferUsage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUBufferUsage");

bindings::V8SetReturnValue(info, V8GPUBufferUsage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUCanvasContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUCanvasContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUCanvasContext");

bindings::V8SetReturnValue(info, V8GPUCanvasContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUColorWriteExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUColorWrite_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUColorWrite");

bindings::V8SetReturnValue(info, V8GPUColorWrite::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUCommandBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUCommandBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUCommandBuffer");

bindings::V8SetReturnValue(info, V8GPUCommandBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCommandEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUCommandEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUCommandEncoder");

bindings::V8SetReturnValue(info, V8GPUCommandEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCompilationInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUCompilationInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUCompilationInfo");

bindings::V8SetReturnValue(info, V8GPUCompilationInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUCompilationMessageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUCompilationMessage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUCompilationMessage");

bindings::V8SetReturnValue(info, V8GPUCompilationMessage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUComputePassEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUComputePassEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUComputePassEncoder");

bindings::V8SetReturnValue(info, V8GPUComputePassEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUComputePipelineExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUComputePipeline_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUComputePipeline");

bindings::V8SetReturnValue(info, V8GPUComputePipeline::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUDevice");

bindings::V8SetReturnValue(info, V8GPUDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUDeviceLostInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUDeviceLostInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUDeviceLostInfo");

bindings::V8SetReturnValue(info, V8GPUDeviceLostInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUError");

bindings::V8SetReturnValue(info, V8GPUError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUExternalTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUExternalTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUExternalTexture");

bindings::V8SetReturnValue(info, V8GPUExternalTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUHeapPropertyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUHeapProperty_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUHeapProperty");

bindings::V8SetReturnValue(info, V8GPUHeapProperty::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUInternalErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUInternalError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUInternalError");

bindings::V8SetReturnValue(info, V8GPUInternalError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUMapModeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUMapMode_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUMapMode");

bindings::V8SetReturnValue(info, V8GPUMapMode::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUMemoryHeapInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUMemoryHeapInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUMemoryHeapInfo");

bindings::V8SetReturnValue(info, V8GPUMemoryHeapInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUOutOfMemoryErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUOutOfMemoryError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUOutOfMemoryError");

bindings::V8SetReturnValue(info, V8GPUOutOfMemoryError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUPipelineErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUPipelineError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUPipelineError");

bindings::V8SetReturnValue(info, V8GPUPipelineError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUPipelineLayoutExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUPipelineLayout_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUPipelineLayout");

bindings::V8SetReturnValue(info, V8GPUPipelineLayout::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUQuerySetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUQuerySet_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUQuerySet");

bindings::V8SetReturnValue(info, V8GPUQuerySet::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUQueueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUQueue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUQueue");

bindings::V8SetReturnValue(info, V8GPUQueue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderBundleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPURenderBundle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPURenderBundle");

bindings::V8SetReturnValue(info, V8GPURenderBundle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderBundleEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPURenderBundleEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPURenderBundleEncoder");

bindings::V8SetReturnValue(info, V8GPURenderBundleEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderPassEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPURenderPassEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPURenderPassEncoder");

bindings::V8SetReturnValue(info, V8GPURenderPassEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPURenderPipelineExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPURenderPipeline_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPURenderPipeline");

bindings::V8SetReturnValue(info, V8GPURenderPipeline::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSamplerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUSampler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUSampler");

bindings::V8SetReturnValue(info, V8GPUSampler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUShaderModuleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUShaderModule_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUShaderModule");

bindings::V8SetReturnValue(info, V8GPUShaderModule::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUShaderStageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUShaderStage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUShaderStage");

bindings::V8SetReturnValue(info, V8GPUShaderStage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUSubgroupMatrixConfigExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUSubgroupMatrixConfig_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUSubgroupMatrixConfig");

bindings::V8SetReturnValue(info, V8GPUSubgroupMatrixConfig::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSupportedFeaturesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUSupportedFeatures_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUSupportedFeatures");

bindings::V8SetReturnValue(info, V8GPUSupportedFeatures::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUSupportedLimitsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUSupportedLimits_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUSupportedLimits");

bindings::V8SetReturnValue(info, V8GPUSupportedLimits::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUTexture");

bindings::V8SetReturnValue(info, V8GPUTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUTextureUsageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUTextureUsage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUTextureUsage");

bindings::V8SetReturnValue(info, V8GPUTextureUsage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kNamespaceObject);
}

void GPUTextureViewExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUTextureView_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUTextureView");

bindings::V8SetReturnValue(info, V8GPUTextureView::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUUncapturedErrorEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUUncapturedErrorEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUUncapturedErrorEvent");

bindings::V8SetReturnValue(info, V8GPUUncapturedErrorEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void GPUValidationErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_GPUValidationError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.GPUValidationError");

bindings::V8SetReturnValue(info, V8GPUValidationError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_HID_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.HID");

bindings::V8SetReturnValue(info, V8HID::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDConnectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_HIDConnectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.HIDConnectionEvent");

bindings::V8SetReturnValue(info, V8HIDConnectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_HIDDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.HIDDevice");

bindings::V8SetReturnValue(info, V8HIDDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HIDInputReportEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_HIDInputReportEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.HIDInputReportEvent");

bindings::V8SetReturnValue(info, V8HIDInputReportEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void HeadersExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Headers_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Headers");

bindings::V8SetReturnValue(info, V8Headers::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBCursorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBCursor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBCursor");

bindings::V8SetReturnValue(info, V8IDBCursor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBCursorWithValueExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBCursorWithValue_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBCursorWithValue");

bindings::V8SetReturnValue(info, V8IDBCursorWithValue::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBDatabaseExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBDatabase_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBDatabase");

bindings::V8SetReturnValue(info, V8IDBDatabase::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBFactoryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBFactory_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBFactory");

bindings::V8SetReturnValue(info, V8IDBFactory::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBIndexExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBIndex_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBIndex");

bindings::V8SetReturnValue(info, V8IDBIndex::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBKeyRangeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBKeyRange_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBKeyRange");

bindings::V8SetReturnValue(info, V8IDBKeyRange::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBObjectStoreExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBObjectStore_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBObjectStore");

bindings::V8SetReturnValue(info, V8IDBObjectStore::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBOpenDBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBOpenDBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBOpenDBRequest");

bindings::V8SetReturnValue(info, V8IDBOpenDBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBRecordExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBRecord_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBRecord");

bindings::V8SetReturnValue(info, V8IDBRecord::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBRequest");

bindings::V8SetReturnValue(info, V8IDBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBTransactionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBTransaction_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBTransaction");

bindings::V8SetReturnValue(info, V8IDBTransaction::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void IDBVersionChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_IDBVersionChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.IDBVersionChangeEvent");

bindings::V8SetReturnValue(info, V8IDBVersionChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageBitmapExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ImageBitmap_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ImageBitmap");

bindings::V8SetReturnValue(info, V8ImageBitmap::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageBitmapRenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ImageBitmapRenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ImageBitmapRenderingContext");

bindings::V8SetReturnValue(info, V8ImageBitmapRenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ImageDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ImageData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ImageData");

bindings::V8SetReturnValue(info, V8ImageData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void InstallEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_InstallEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.InstallEvent");

bindings::V8SetReturnValue(info, V8InstallEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_LanguageDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.LanguageDetector");

bindings::V8SetReturnValue(info, V8LanguageDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageModelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_LanguageModel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.LanguageModel");

bindings::V8SetReturnValue(info, V8LanguageModel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LanguageModelParamsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_LanguageModelParams_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.LanguageModelParams");

bindings::V8SetReturnValue(info, V8LanguageModelParams::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Lock_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Lock");

bindings::V8SetReturnValue(info, V8Lock::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_LockManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.LockManager");

bindings::V8SetReturnValue(info, V8LockManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ML_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ML");

bindings::V8SetReturnValue(info, V8ML::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MLContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MLContext");

bindings::V8SetReturnValue(info, V8MLContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLGraphExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MLGraph_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MLGraph");

bindings::V8SetReturnValue(info, V8MLGraph::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLGraphBuilderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MLGraphBuilder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MLGraphBuilder");

bindings::V8SetReturnValue(info, V8MLGraphBuilder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLOperandExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MLOperand_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MLOperand");

bindings::V8SetReturnValue(info, V8MLOperand::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MLTensorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MLTensor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MLTensor");

bindings::V8SetReturnValue(info, V8MLTensor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MediaCapabilitiesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MediaCapabilities_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MediaCapabilities");

bindings::V8SetReturnValue(info, V8MediaCapabilities::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DIndexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Mesh2DIndexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Mesh2DIndexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DIndexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DUVBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Mesh2DUVBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Mesh2DUVBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DUVBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Mesh2DVertexBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Mesh2DVertexBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Mesh2DVertexBuffer");

bindings::V8SetReturnValue(info, V8Mesh2DVertexBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessageChannelExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MessageChannel_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MessageChannel");

bindings::V8SetReturnValue(info, V8MessageChannel::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessageEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MessageEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MessageEvent");

bindings::V8SetReturnValue(info, V8MessageEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MessagePortExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MessagePort_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MessagePort");

bindings::V8SetReturnValue(info, V8MessagePort::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Mojo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Mojo");

bindings::V8SetReturnValue(info, V8Mojo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoHandleExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MojoHandle_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MojoHandle");

bindings::V8SetReturnValue(info, V8MojoHandle::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoInterfaceInterceptorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MojoInterfaceInterceptor_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MojoInterfaceInterceptor");

bindings::V8SetReturnValue(info, V8MojoInterfaceInterceptor::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoInterfaceRequestEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MojoInterfaceRequestEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MojoInterfaceRequestEvent");

bindings::V8SetReturnValue(info, V8MojoInterfaceRequestEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MojoWatcherExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MojoWatcher_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MojoWatcher");

bindings::V8SetReturnValue(info, V8MojoWatcher::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void MulticastControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_MulticastController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.MulticastController");

bindings::V8SetReturnValue(info, V8MulticastController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NavigationPreloadManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_NavigationPreloadManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.NavigationPreloadManager");

bindings::V8SetReturnValue(info, V8NavigationPreloadManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NavigatorUADataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_NavigatorUAData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.NavigatorUAData");

bindings::V8SetReturnValue(info, V8NavigatorUAData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NetworkInformationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_NetworkInformation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.NetworkInformation");

bindings::V8SetReturnValue(info, V8NetworkInformation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NotificationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Notification_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Notification");

bindings::V8SetReturnValue(info, V8Notification::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void NotificationEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_NotificationEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.NotificationEvent");

bindings::V8SetReturnValue(info, V8NotificationEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ObservableExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Observable_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Observable");

bindings::V8SetReturnValue(info, V8Observable::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OffscreenCanvasExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_OffscreenCanvas_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.OffscreenCanvas");

bindings::V8SetReturnValue(info, V8OffscreenCanvas::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OffscreenCanvasRenderingContext2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_OffscreenCanvasRenderingContext2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.OffscreenCanvasRenderingContext2D");

bindings::V8SetReturnValue(info, V8OffscreenCanvasRenderingContext2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void OriginExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Origin_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Origin");

bindings::V8SetReturnValue(info, V8Origin::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void Path2DExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Path2D_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Path2D");

bindings::V8SetReturnValue(info, V8Path2D::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PaymentRequestEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PaymentRequestEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PaymentRequestEvent");

bindings::V8SetReturnValue(info, V8PaymentRequestEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Performance_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Performance");

bindings::V8SetReturnValue(info, V8Performance::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceEntryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceEntry_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceEntry");

bindings::V8SetReturnValue(info, V8PerformanceEntry::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceMarkExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceMark_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceMark");

bindings::V8SetReturnValue(info, V8PerformanceMark::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceMeasureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceMeasure_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceMeasure");

bindings::V8SetReturnValue(info, V8PerformanceMeasure::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceObserver");

bindings::V8SetReturnValue(info, V8PerformanceObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceObserverEntryListExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceObserverEntryList_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceObserverEntryList");

bindings::V8SetReturnValue(info, V8PerformanceObserverEntryList::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceResourceTimingExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceResourceTiming_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceResourceTiming");

bindings::V8SetReturnValue(info, V8PerformanceResourceTiming::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PerformanceServerTimingExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PerformanceServerTiming_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PerformanceServerTiming");

bindings::V8SetReturnValue(info, V8PerformanceServerTiming::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PeriodicSyncEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PeriodicSyncEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PeriodicSyncEvent");

bindings::V8SetReturnValue(info, V8PeriodicSyncEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PeriodicSyncManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PeriodicSyncManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PeriodicSyncManager");

bindings::V8SetReturnValue(info, V8PeriodicSyncManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PermissionStatusExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PermissionStatus_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PermissionStatus");

bindings::V8SetReturnValue(info, V8PermissionStatus::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PermissionsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Permissions_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Permissions");

bindings::V8SetReturnValue(info, V8Permissions::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PromiseRejectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PromiseRejectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PromiseRejectionEvent");

bindings::V8SetReturnValue(info, V8PromiseRejectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ProofreaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Proofreader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Proofreader");

bindings::V8SetReturnValue(info, V8Proofreader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushEvent");

bindings::V8SetReturnValue(info, V8PushEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushManager");

bindings::V8SetReturnValue(info, V8PushManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushMessageDataExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushMessageData_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushMessageData");

bindings::V8SetReturnValue(info, V8PushMessageData::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushSubscriptionExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushSubscription_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushSubscription");

bindings::V8SetReturnValue(info, V8PushSubscription::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushSubscriptionChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushSubscriptionChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushSubscriptionChangeEvent");

bindings::V8SetReturnValue(info, V8PushSubscriptionChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PushSubscriptionOptionsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_PushSubscriptionOptions_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.PushSubscriptionOptions");

bindings::V8SetReturnValue(info, V8PushSubscriptionOptions::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReportBodyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReportBody_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReportBody");

bindings::V8SetReturnValue(info, V8ReportBody::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReportingObserverExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ReportingObserver_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ReportingObserver");

bindings::V8SetReturnValue(info, V8ReportingObserver::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Request_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Request");

bindings::V8SetReturnValue(info, V8Request::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ResponseExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Response_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Response");

bindings::V8SetReturnValue(info, V8Response::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RestrictionTargetExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_RestrictionTarget_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.RestrictionTarget");

bindings::V8SetReturnValue(info, V8RestrictionTarget::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RewriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Rewriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Rewriter");

bindings::V8SetReturnValue(info, V8Rewriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcReceivedPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_RtcReceivedPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.RtcReceivedPacket");

bindings::V8SetReturnValue(info, V8RtcReceivedPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_RtcTransport_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.RtcTransport");

bindings::V8SetReturnValue(info, V8RtcTransport::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportIceCandidateExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_RtcTransportIceCandidate_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.RtcTransportIceCandidate");

bindings::V8SetReturnValue(info, V8RtcTransportIceCandidate::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void RtcTransportIceEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_RtcTransportIceEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.RtcTransportIceEvent");

bindings::V8SetReturnValue(info, V8RtcTransportIceEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SchedulerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Scheduler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Scheduler");

bindings::V8SetReturnValue(info, V8Scheduler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SecurityPolicyViolationEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_SecurityPolicyViolationEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.SecurityPolicyViolationEvent");

bindings::V8SetReturnValue(info, V8SecurityPolicyViolationEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ServiceWorker_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ServiceWorker");

bindings::V8SetReturnValue(info, V8ServiceWorker::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ServiceWorkerGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ServiceWorkerGlobalScope");

bindings::V8SetReturnValue(info, V8ServiceWorkerGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ServiceWorkerRegistrationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_ServiceWorkerRegistration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.ServiceWorkerRegistration");

bindings::V8SetReturnValue(info, V8ServiceWorkerRegistration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageBucketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_StorageBucket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.StorageBucket");

bindings::V8SetReturnValue(info, V8StorageBucket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageBucketManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_StorageBucketManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.StorageBucketManager");

bindings::V8SetReturnValue(info, V8StorageBucketManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void StorageManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_StorageManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.StorageManager");

bindings::V8SetReturnValue(info, V8StorageManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubscriberExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Subscriber_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Subscriber");

bindings::V8SetReturnValue(info, V8Subscriber::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubtleCryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_SubtleCrypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.SubtleCrypto");

bindings::V8SetReturnValue(info, V8SubtleCrypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SummarizerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Summarizer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Summarizer");

bindings::V8SetReturnValue(info, V8Summarizer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SyncEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_SyncEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.SyncEvent");

bindings::V8SetReturnValue(info, V8SyncEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SyncManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_SyncManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.SyncManager");

bindings::V8SetReturnValue(info, V8SyncManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TCPServerSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TCPServerSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TCPServerSocket");

bindings::V8SetReturnValue(info, V8TCPServerSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TCPSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TCPSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TCPSocket");

bindings::V8SetReturnValue(info, V8TCPSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TaskController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TaskController");

bindings::V8SetReturnValue(info, V8TaskController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskPriorityChangeEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TaskPriorityChangeEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TaskPriorityChangeEvent");

bindings::V8SetReturnValue(info, V8TaskPriorityChangeEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TaskSignalExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TaskSignal_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TaskSignal");

bindings::V8SetReturnValue(info, V8TaskSignal::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextClusterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextCluster_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextCluster");

bindings::V8SetReturnValue(info, V8TextCluster::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextDecoder");

bindings::V8SetReturnValue(info, V8TextDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextDecoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextDecoderStream");

bindings::V8SetReturnValue(info, V8TextDecoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDetectorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextDetector_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextDetector");

bindings::V8SetReturnValue(info, V8TextDetector::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextEncoder");

bindings::V8SetReturnValue(info, V8TextEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextEncoderStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextEncoderStream");

bindings::V8SetReturnValue(info, V8TextEncoderStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextMetricsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TextMetrics_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TextMetrics");

bindings::V8SetReturnValue(info, V8TextMetrics::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TimestampTriggerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TimestampTrigger_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TimestampTrigger");

bindings::V8SetReturnValue(info, V8TimestampTrigger::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TranslatorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Translator_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Translator");

bindings::V8SetReturnValue(info, V8Translator::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedHTMLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TrustedHTML_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TrustedHTML");

bindings::V8SetReturnValue(info, V8TrustedHTML::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedScriptExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TrustedScript_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TrustedScript");

bindings::V8SetReturnValue(info, V8TrustedScript::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedScriptURLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TrustedScriptURL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TrustedScriptURL");

bindings::V8SetReturnValue(info, V8TrustedScriptURL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedTypePolicyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TrustedTypePolicy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TrustedTypePolicy");

bindings::V8SetReturnValue(info, V8TrustedTypePolicy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TrustedTypePolicyFactoryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_TrustedTypePolicyFactory_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.TrustedTypePolicyFactory");

bindings::V8SetReturnValue(info, V8TrustedTypePolicyFactory::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void UDPSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_UDPSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.UDPSocket");

bindings::V8SetReturnValue(info, V8UDPSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_URL_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.URL");

bindings::V8SetReturnValue(info, V8URL::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLPatternExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_URLPattern_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.URLPattern");

bindings::V8SetReturnValue(info, V8URLPattern::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void URLSearchParamsExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_URLSearchParams_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.URLSearchParams");

bindings::V8SetReturnValue(info, V8URLSearchParams::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USB_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USB");

bindings::V8SetReturnValue(info, V8USB::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBAlternateInterfaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBAlternateInterface_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBAlternateInterface");

bindings::V8SetReturnValue(info, V8USBAlternateInterface::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBConfigurationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBConfiguration_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBConfiguration");

bindings::V8SetReturnValue(info, V8USBConfiguration::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBConnectionEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBConnectionEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBConnectionEvent");

bindings::V8SetReturnValue(info, V8USBConnectionEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBDeviceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBDevice_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBDevice");

bindings::V8SetReturnValue(info, V8USBDevice::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBEndpointExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBEndpoint_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBEndpoint");

bindings::V8SetReturnValue(info, V8USBEndpoint::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBInTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBInTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBInTransferResult");

bindings::V8SetReturnValue(info, V8USBInTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBInterfaceExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBInterface_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBInterface");

bindings::V8SetReturnValue(info, V8USBInterface::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousInTransferPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBIsochronousInTransferPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBIsochronousInTransferPacket");

bindings::V8SetReturnValue(info, V8USBIsochronousInTransferPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousInTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBIsochronousInTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBIsochronousInTransferResult");

bindings::V8SetReturnValue(info, V8USBIsochronousInTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousOutTransferPacketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBIsochronousOutTransferPacket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBIsochronousOutTransferPacket");

bindings::V8SetReturnValue(info, V8USBIsochronousOutTransferPacket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void USBIsochronousOutTransferResultExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_USBIsochronousOutTransferResult_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.USBIsochronousOutTransferResult");

bindings::V8SetReturnValue(info, V8USBIsochronousOutTransferResult::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void UserActivationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_UserActivation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.UserActivation");

bindings::V8SetReturnValue(info, V8UserActivation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WGSLLanguageFeaturesExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WGSLLanguageFeatures_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WGSLLanguageFeatures");

bindings::V8SetReturnValue(info, V8WGSLLanguageFeatures::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGL2RenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGL2RenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGL2RenderingContext");

bindings::V8SetReturnValue(info, V8WebGL2RenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGL2RenderingContextWebGPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGL2RenderingContextWebGPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGL2RenderingContextWebGPU");

bindings::V8SetReturnValue(info, V8WebGL2RenderingContextWebGPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLActiveInfoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLActiveInfo_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLActiveInfo");

bindings::V8SetReturnValue(info, V8WebGLActiveInfo::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLBufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLBuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLBuffer");

bindings::V8SetReturnValue(info, V8WebGLBuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLContextEventExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLContextEvent_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLContextEvent");

bindings::V8SetReturnValue(info, V8WebGLContextEvent::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLFramebufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLFramebuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLFramebuffer");

bindings::V8SetReturnValue(info, V8WebGLFramebuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLObjectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLObject_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLObject");

bindings::V8SetReturnValue(info, V8WebGLObject::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLProgramExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLProgram_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLProgram");

bindings::V8SetReturnValue(info, V8WebGLProgram::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLQueryExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLQuery_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLQuery");

bindings::V8SetReturnValue(info, V8WebGLQuery::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderbufferExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLRenderbuffer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLRenderbuffer");

bindings::V8SetReturnValue(info, V8WebGLRenderbuffer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderingContextExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLRenderingContext_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLRenderingContext");

bindings::V8SetReturnValue(info, V8WebGLRenderingContext::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLRenderingContextWebGPUExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLRenderingContextWebGPU_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLRenderingContextWebGPU");

bindings::V8SetReturnValue(info, V8WebGLRenderingContextWebGPU::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLSamplerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLSampler_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLSampler");

bindings::V8SetReturnValue(info, V8WebGLSampler::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLShaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLShader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLShader");

bindings::V8SetReturnValue(info, V8WebGLShader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLShaderPrecisionFormatExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLShaderPrecisionFormat_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLShaderPrecisionFormat");

bindings::V8SetReturnValue(info, V8WebGLShaderPrecisionFormat::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLSyncExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLSync_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLSync");

bindings::V8SetReturnValue(info, V8WebGLSync::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLTextureExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLTexture_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLTexture");

bindings::V8SetReturnValue(info, V8WebGLTexture::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLTransformFeedbackExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLTransformFeedback_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLTransformFeedback");

bindings::V8SetReturnValue(info, V8WebGLTransformFeedback::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLUniformLocationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLUniformLocation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLUniformLocation");

bindings::V8SetReturnValue(info, V8WebGLUniformLocation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebGLVertexArrayObjectExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebGLVertexArrayObject_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebGLVertexArrayObject");

bindings::V8SetReturnValue(info, V8WebGLVertexArrayObject::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebPrintingManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebPrintingManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebPrintingManager");

bindings::V8SetReturnValue(info, V8WebPrintingManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebSocket_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebSocket");

bindings::V8SetReturnValue(info, V8WebSocket::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebSocketError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebSocketError");

bindings::V8SetReturnValue(info, V8WebSocketError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebSocketStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebSocketStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebSocketStream");

bindings::V8SetReturnValue(info, V8WebSocketStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebTransport_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebTransport");

bindings::V8SetReturnValue(info, V8WebTransport::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportBidirectionalStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebTransportBidirectionalStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebTransportBidirectionalStream");

bindings::V8SetReturnValue(info, V8WebTransportBidirectionalStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportDatagramDuplexStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebTransportDatagramDuplexStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebTransportDatagramDuplexStream");

bindings::V8SetReturnValue(info, V8WebTransportDatagramDuplexStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WebTransportErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WebTransportError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WebTransportError");

bindings::V8SetReturnValue(info, V8WebTransportError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WindowClientExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WindowClient_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WindowClient");

bindings::V8SetReturnValue(info, V8WindowClient::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WorkerGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WorkerGlobalScope");

bindings::V8SetReturnValue(info, V8WorkerGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerLocationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WorkerLocation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WorkerLocation");

bindings::V8SetReturnValue(info, V8WorkerLocation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WorkerNavigatorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WorkerNavigator_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WorkerNavigator");

bindings::V8SetReturnValue(info, V8WorkerNavigator::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_Writer_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.Writer");

bindings::V8SetReturnValue(info, V8Writer::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SkipWaitingOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_ServiceWorkerGlobalScope_skipWaiting");
BLINK_BINDINGS_TRACE_EVENT("ServiceWorkerGlobalScope.skipWaiting");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8ServiceWorkerGlobalScope::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





ServiceWorkerGlobalScope* blink_receiver = V8ServiceWorkerGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->skipWaiting(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_service_worker_global_scope

using namespace v8_service_worker_global_scope;

}  // namespace 

void V8ServiceWorkerGlobalScope::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8ServiceWorkerGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8ServiceWorkerGlobalScope::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"clients", ClientsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"registration", RegistrationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"serviceWorker", ServiceWorkerAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onactivate", OnactivateAttributeGetCallback, OnactivateAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onfetch", OnfetchAttributeGetCallback, OnfetchAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"oninstall", OninstallAttributeGetCallback, OninstallAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onmessage", OnmessageAttributeGetCallback, OnmessageAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onmessageerror", OnmessageerrorAttributeGetCallback, OnmessageerrorAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onsync", OnsyncAttributeGetCallback, OnsyncAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"cookieStore", CookieStoreAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"oncookiechange", OncookiechangeAttributeGetCallback, OncookiechangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}




{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AbortController", AbortControllerExposedConstructCallback}, 
{"AbortSignal", AbortSignalExposedConstructCallback}, 
{"Blob", BlobExposedConstructCallback}, 
{"BroadcastChannel", BroadcastChannelExposedConstructCallback}, 
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CSSSkewX", CSSSkewXExposedConstructCallback}, 
{"CSSSkewY", CSSSkewYExposedConstructCallback}, 
{"CanvasGradient", CanvasGradientExposedConstructCallback}, 
{"CanvasPattern", CanvasPatternExposedConstructCallback}, 
{"Client", ClientExposedConstructCallback}, 
{"Clients", ClientsExposedConstructCallback}, 
{"CloseEvent", CloseEventExposedConstructCallback}, 
{"CompressionStream", CompressionStreamExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"Crypto", CryptoExposedConstructCallback}, 
{"CustomEvent", CustomEventExposedConstructCallback}, 
{"DOMException", DOMExceptionExposedConstructCallback}, 
{"DOMMatrix", DOMMatrixExposedConstructCallback}, 
{"DOMMatrixReadOnly", DOMMatrixReadOnlyExposedConstructCallback}, 
{"DOMPoint", DOMPointExposedConstructCallback}, 
{"DOMPointReadOnly", DOMPointReadOnlyExposedConstructCallback}, 
{"DOMQuad", DOMQuadExposedConstructCallback}, 
{"DOMRect", DOMRectExposedConstructCallback}, 
{"DOMRectReadOnly", DOMRectReadOnlyExposedConstructCallback}, 
{"DOMStringList", DOMStringListExposedConstructCallback}, 
{"DecompressionStream", DecompressionStreamExposedConstructCallback}, 
{"ErrorEvent", ErrorEventExposedConstructCallback}, 
{"Event", EventExposedConstructCallback}, 
{"EventSource", EventSourceExposedConstructCallback}, 
{"EventTarget", EventTargetExposedConstructCallback}, 
{"ExtendableCookieChangeEvent", ExtendableCookieChangeEventExposedConstructCallback}, 
{"ExtendableEvent", ExtendableEventExposedConstructCallback}, 
{"ExtendableMessageEvent", ExtendableMessageEventExposedConstructCallback}, 
{"FetchEvent", FetchEventExposedConstructCallback}, 
{"File", FileExposedConstructCallback}, 
{"FileList", FileListExposedConstructCallback}, 
{"FileReader", FileReaderExposedConstructCallback}, 
{"FontFace", FontFaceExposedConstructCallback}, 
{"FormData", FormDataExposedConstructCallback}, 
{"Headers", HeadersExposedConstructCallback}, 
{"IDBCursor", IDBCursorExposedConstructCallback}, 
{"IDBCursorWithValue", IDBCursorWithValueExposedConstructCallback}, 
{"IDBDatabase", IDBDatabaseExposedConstructCallback}, 
{"IDBFactory", IDBFactoryExposedConstructCallback}, 
{"IDBIndex", IDBIndexExposedConstructCallback}, 
{"IDBKeyRange", IDBKeyRangeExposedConstructCallback}, 
{"IDBObjectStore", IDBObjectStoreExposedConstructCallback}, 
{"IDBOpenDBRequest", IDBOpenDBRequestExposedConstructCallback}, 
{"IDBRequest", IDBRequestExposedConstructCallback}, 
{"IDBTransaction", IDBTransactionExposedConstructCallback}, 
{"IDBVersionChangeEvent", IDBVersionChangeEventExposedConstructCallback}, 
{"ImageBitmap", ImageBitmapExposedConstructCallback}, 
{"ImageBitmapRenderingContext", ImageBitmapRenderingContextExposedConstructCallback}, 
{"ImageData", ImageDataExposedConstructCallback}, 
{"InstallEvent", InstallEventExposedConstructCallback}, 
{"MediaCapabilities", MediaCapabilitiesExposedConstructCallback}, 
{"MessageChannel", MessageChannelExposedConstructCallback}, 
{"MessageEvent", MessageEventExposedConstructCallback}, 
{"MessagePort", MessagePortExposedConstructCallback}, 
{"NavigatorUAData", NavigatorUADataExposedConstructCallback}, 
{"NetworkInformation", NetworkInformationExposedConstructCallback}, 
{"Observable", ObservableExposedConstructCallback}, 
{"OffscreenCanvas", OffscreenCanvasExposedConstructCallback}, 
{"OffscreenCanvasRenderingContext2D", OffscreenCanvasRenderingContext2DExposedConstructCallback}, 
{"Path2D", Path2DExposedConstructCallback}, 
{"Performance", PerformanceExposedConstructCallback}, 
{"PerformanceEntry", PerformanceEntryExposedConstructCallback}, 
{"PerformanceMark", PerformanceMarkExposedConstructCallback}, 
{"PerformanceMeasure", PerformanceMeasureExposedConstructCallback}, 
{"PerformanceObserver", PerformanceObserverExposedConstructCallback}, 
{"PerformanceObserverEntryList", PerformanceObserverEntryListExposedConstructCallback}, 
{"PerformanceResourceTiming", PerformanceResourceTimingExposedConstructCallback}, 
{"PerformanceServerTiming", PerformanceServerTimingExposedConstructCallback}, 
{"PromiseRejectionEvent", PromiseRejectionEventExposedConstructCallback}, 
{"PushMessageData", PushMessageDataExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"ReportBody", ReportBodyExposedConstructCallback}, 
{"ReportingObserver", ReportingObserverExposedConstructCallback}, 
{"Request", RequestExposedConstructCallback}, 
{"Response", ResponseExposedConstructCallback}, 
{"Scheduler", SchedulerExposedConstructCallback}, 
{"SecurityPolicyViolationEvent", SecurityPolicyViolationEventExposedConstructCallback}, 
{"ServiceWorkerGlobalScope", ServiceWorkerGlobalScopeExposedConstructCallback}, 
{"Subscriber", SubscriberExposedConstructCallback}, 
{"SyncEvent", SyncEventExposedConstructCallback}, 
{"SyncManager", SyncManagerExposedConstructCallback}, 
{"TaskController", TaskControllerExposedConstructCallback}, 
{"TaskPriorityChangeEvent", TaskPriorityChangeEventExposedConstructCallback}, 
{"TaskSignal", TaskSignalExposedConstructCallback}, 
{"TextDecoder", TextDecoderExposedConstructCallback}, 
{"TextDecoderStream", TextDecoderStreamExposedConstructCallback}, 
{"TextEncoder", TextEncoderExposedConstructCallback}, 
{"TextEncoderStream", TextEncoderStreamExposedConstructCallback}, 
{"TextMetrics", TextMetricsExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"TrustedHTML", TrustedHTMLExposedConstructCallback}, 
{"TrustedScript", TrustedScriptExposedConstructCallback}, 
{"TrustedScriptURL", TrustedScriptURLExposedConstructCallback}, 
{"TrustedTypePolicy", TrustedTypePolicyExposedConstructCallback}, 
{"TrustedTypePolicyFactory", TrustedTypePolicyFactoryExposedConstructCallback}, 
{"URL", URLExposedConstructCallback}, 
{"URLPattern", URLPatternExposedConstructCallback}, 
{"URLSearchParams", URLSearchParamsExposedConstructCallback}, 
{"UserActivation", UserActivationExposedConstructCallback}, 
{"WebGL2RenderingContext", WebGL2RenderingContextExposedConstructCallback}, 
{"WebGLActiveInfo", WebGLActiveInfoExposedConstructCallback}, 
{"WebGLBuffer", WebGLBufferExposedConstructCallback}, 
{"WebGLContextEvent", WebGLContextEventExposedConstructCallback}, 
{"WebGLFramebuffer", WebGLFramebufferExposedConstructCallback}, 
{"WebGLObject", WebGLObjectExposedConstructCallback}, 
{"WebGLProgram", WebGLProgramExposedConstructCallback}, 
{"WebGLQuery", WebGLQueryExposedConstructCallback}, 
{"WebGLRenderbuffer", WebGLRenderbufferExposedConstructCallback}, 
{"WebGLRenderingContext", WebGLRenderingContextExposedConstructCallback}, 
{"WebGLSampler", WebGLSamplerExposedConstructCallback}, 
{"WebGLShader", WebGLShaderExposedConstructCallback}, 
{"WebGLShaderPrecisionFormat", WebGLShaderPrecisionFormatExposedConstructCallback}, 
{"WebGLSync", WebGLSyncExposedConstructCallback}, 
{"WebGLTexture", WebGLTextureExposedConstructCallback}, 
{"WebGLTransformFeedback", WebGLTransformFeedbackExposedConstructCallback}, 
{"WebGLUniformLocation", WebGLUniformLocationExposedConstructCallback}, 
{"WebGLVertexArrayObject", WebGLVertexArrayObjectExposedConstructCallback}, 
{"WebSocket", WebSocketExposedConstructCallback}, 
{"WindowClient", WindowClientExposedConstructCallback}, 
{"WorkerGlobalScope", WorkerGlobalScopeExposedConstructCallback}, 
{"WorkerLocation", WorkerLocationExposedConstructCallback}, 
{"WorkerNavigator", WorkerNavigatorExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"skipWaiting", SkipWaitingOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kOperationTable);
}



}

void V8ServiceWorkerGlobalScope::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::BackgroundFetchEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onbackgroundfetchsuccess", OnbackgroundfetchsuccessAttributeGetCallback, OnbackgroundfetchsuccessAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onbackgroundfetchfail", OnbackgroundfetchfailAttributeGetCallback, OnbackgroundfetchfailAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onbackgroundfetchabort", OnbackgroundfetchabortAttributeGetCallback, OnbackgroundfetchabortAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onbackgroundfetchclick", OnbackgroundfetchclickAttributeGetCallback, OnbackgroundfetchclickAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::PeriodicBackgroundSyncEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onperiodicsync", OnperiodicsyncAttributeGetCallback, OnperiodicsyncAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::ContentIndexEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"oncontentdelete", OncontentdeleteAttributeGetCallback, OncontentdeleteAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::NotificationsEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onnotificationclick", OnnotificationclickAttributeGetCallback, OnnotificationclickAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onnotificationclose", OnnotificationcloseAttributeGetCallback, OnnotificationcloseAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::PaymentAppEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onabortpayment", OnabortpaymentAttributeGetCallback, OnabortpaymentAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"oncanmakepayment", OncanmakepaymentAttributeGetCallback, OncanmakepaymentAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onpaymentrequest", OnpaymentrequestAttributeGetCallback, OnpaymentrequestAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::PushMessagingEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onpush", OnpushAttributeGetCallback, OnpushAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}
if (RuntimeEnabledFeatures::PushMessagingEnabled() && RuntimeEnabledFeatures::PushMessagingSubscriptionChangeEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"onpushsubscriptionchange", OnpushsubscriptionchangeAttributeGetCallback, OnpushsubscriptionchangeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "ServiceWorkerGlobalScope", kAttributeTable);
}



if (RuntimeEnabledFeatures::PaymentAppEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"AbortPaymentEvent", AbortPaymentEventExposedConstructCallback}, 
{"CanMakePaymentEvent", CanMakePaymentEventExposedConstructCallback}, 
{"PaymentRequestEvent", PaymentRequestEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::BackgroundFetchEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"BackgroundFetchEvent", BackgroundFetchEventExposedConstructCallback}, 
{"BackgroundFetchManager", BackgroundFetchManagerExposedConstructCallback}, 
{"BackgroundFetchRecord", BackgroundFetchRecordExposedConstructCallback}, 
{"BackgroundFetchRegistration", BackgroundFetchRegistrationExposedConstructCallback}, 
{"BackgroundFetchUpdateUIEvent", BackgroundFetchUpdateUIEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::Canvas2dCanvasFilterEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CanvasFilter", CanvasFilterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::CanvasInterventionsTestEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CanvasInterventionsTest", CanvasInterventionsTestExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::ContentIndexEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ContentIndex", ContentIndexExposedConstructCallback}, 
{"ContentIndexEvent", ContentIndexEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::RegionCaptureEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CropTarget", CropTargetExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::IndexedDbGetAllRecordsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"IDBRecord", IDBRecordExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ML", MLExposedConstructCallback}, 
{"MLGraph", MLGraphExposedConstructCallback}, 
{"MLGraphBuilder", MLGraphBuilderExposedConstructCallback}, 
{"MLOperand", MLOperandExposedConstructCallback}, 
{"MLTensor", MLTensorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::MojoJSTestEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MojoInterfaceInterceptor", MojoInterfaceInterceptorExposedConstructCallback}, 
{"MojoInterfaceRequestEvent", MojoInterfaceRequestEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::NotificationsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Notification", NotificationExposedConstructCallback}, 
{"NotificationEvent", NotificationEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::OriginAPIEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Origin", OriginExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PeriodicBackgroundSyncEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PeriodicSyncEvent", PeriodicSyncEventExposedConstructCallback}, 
{"PeriodicSyncManager", PeriodicSyncManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PermissionsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PermissionStatus", PermissionStatusExposedConstructCallback}, 
{"Permissions", PermissionsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PushMessagingEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PushEvent", PushEventExposedConstructCallback}, 
{"PushManager", PushManagerExposedConstructCallback}, 
{"PushSubscription", PushSubscriptionExposedConstructCallback}, 
{"PushSubscriptionOptions", PushSubscriptionOptionsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::PushMessagingSubscriptionChangeEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PushSubscriptionChangeEvent", PushSubscriptionChangeEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::ElementCaptureEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RestrictionTarget", RestrictionTargetExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::RTCRtpTransportEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RtcReceivedPacket", RtcReceivedPacketExposedConstructCallback}, 
{"RtcTransportIceCandidate", RtcTransportIceCandidateExposedConstructCallback}, 
{"RtcTransportIceEvent", RtcTransportIceEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TextCluster", TextClusterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::WebGLOnWebGPUEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebGL2RenderingContextWebGPU", WebGL2RenderingContextWebGPUExposedConstructCallback}, 
{"WebGLRenderingContextWebGPU", WebGLRenderingContextWebGPUExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::WebSocketStreamEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebSocketError", WebSocketErrorExposedConstructCallback}, 
{"WebSocketStream", WebSocketStreamExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}



}

void V8ServiceWorkerGlobalScope::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (instance_object.IsEmpty()) {
  instance_object = context->Global();
}




v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const bool is_in_secure_context = execution_context->IsSecureContext();
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::BarcodeDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"BarcodeDetector", BarcodeDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && feature_selector.IsAll()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Cache", CacheExposedConstructCallback}, 
{"CacheStorage", CacheStorageExposedConstructCallback}, 
{"CookieStore", CookieStoreExposedConstructCallback}, 
{"CookieStoreManager", CookieStoreManagerExposedConstructCallback}, 
{"CryptoKey", CryptoKeyExposedConstructCallback}, 
{"GPU", GPUExposedConstructCallback}, 
{"GPUAdapter", GPUAdapterExposedConstructCallback}, 
{"GPUAdapterInfo", GPUAdapterInfoExposedConstructCallback}, 
{"GPUBindGroup", GPUBindGroupExposedConstructCallback}, 
{"GPUBindGroupLayout", GPUBindGroupLayoutExposedConstructCallback}, 
{"GPUBuffer", GPUBufferExposedConstructCallback}, 
{"GPUBufferUsage", GPUBufferUsageExposedConstructCallback}, 
{"GPUCanvasContext", GPUCanvasContextExposedConstructCallback}, 
{"GPUColorWrite", GPUColorWriteExposedConstructCallback}, 
{"GPUCommandBuffer", GPUCommandBufferExposedConstructCallback}, 
{"GPUCommandEncoder", GPUCommandEncoderExposedConstructCallback}, 
{"GPUCompilationInfo", GPUCompilationInfoExposedConstructCallback}, 
{"GPUCompilationMessage", GPUCompilationMessageExposedConstructCallback}, 
{"GPUComputePassEncoder", GPUComputePassEncoderExposedConstructCallback}, 
{"GPUComputePipeline", GPUComputePipelineExposedConstructCallback}, 
{"GPUDevice", GPUDeviceExposedConstructCallback}, 
{"GPUDeviceLostInfo", GPUDeviceLostInfoExposedConstructCallback}, 
{"GPUError", GPUErrorExposedConstructCallback}, 
{"GPUExternalTexture", GPUExternalTextureExposedConstructCallback}, 
{"GPUInternalError", GPUInternalErrorExposedConstructCallback}, 
{"GPUMapMode", GPUMapModeExposedConstructCallback}, 
{"GPUOutOfMemoryError", GPUOutOfMemoryErrorExposedConstructCallback}, 
{"GPUPipelineError", GPUPipelineErrorExposedConstructCallback}, 
{"GPUPipelineLayout", GPUPipelineLayoutExposedConstructCallback}, 
{"GPUQuerySet", GPUQuerySetExposedConstructCallback}, 
{"GPUQueue", GPUQueueExposedConstructCallback}, 
{"GPURenderBundle", GPURenderBundleExposedConstructCallback}, 
{"GPURenderBundleEncoder", GPURenderBundleEncoderExposedConstructCallback}, 
{"GPURenderPassEncoder", GPURenderPassEncoderExposedConstructCallback}, 
{"GPURenderPipeline", GPURenderPipelineExposedConstructCallback}, 
{"GPUSampler", GPUSamplerExposedConstructCallback}, 
{"GPUShaderModule", GPUShaderModuleExposedConstructCallback}, 
{"GPUShaderStage", GPUShaderStageExposedConstructCallback}, 
{"GPUSupportedFeatures", GPUSupportedFeaturesExposedConstructCallback}, 
{"GPUSupportedLimits", GPUSupportedLimitsExposedConstructCallback}, 
{"GPUTexture", GPUTextureExposedConstructCallback}, 
{"GPUTextureUsage", GPUTextureUsageExposedConstructCallback}, 
{"GPUTextureView", GPUTextureViewExposedConstructCallback}, 
{"GPUUncapturedErrorEvent", GPUUncapturedErrorEventExposedConstructCallback}, 
{"GPUValidationError", GPUValidationErrorExposedConstructCallback}, 
{"NavigationPreloadManager", NavigationPreloadManagerExposedConstructCallback}, 
{"ServiceWorkerRegistration", ServiceWorkerRegistrationExposedConstructCallback}, 
{"StorageManager", StorageManagerExposedConstructCallback}, 
{"SubtleCrypto", SubtleCryptoExposedConstructCallback}, 
{"WGSLLanguageFeatures", WGSLLanguageFeaturesExposedConstructCallback}, 
{"WebTransport", WebTransportExposedConstructCallback}, 
{"WebTransportBidirectionalStream", WebTransportBidirectionalStreamExposedConstructCallback}, 
{"WebTransportDatagramDuplexStream", WebTransportDatagramDuplexStreamExposedConstructCallback}, 
{"WebTransportError", WebTransportErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::BuiltInAIAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kBuiltInAIAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CreateMonitor", CreateMonitorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FaceDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"FaceDetector", FaceDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FileSystemAccessEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"FileSystemDirectoryHandle", FileSystemDirectoryHandleExposedConstructCallback}, 
{"FileSystemFileHandle", FileSystemFileHandleExposedConstructCallback}, 
{"FileSystemHandle", FileSystemHandleExposedConstructCallback}, 
{"FileSystemWritableFileStream", FileSystemWritableFileStreamExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebGPUDeveloperFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"GPUHeapProperty", GPUHeapPropertyExposedConstructCallback}, 
{"GPUMemoryHeapInfo", GPUMemoryHeapInfoExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"GPUSubgroupMatrixConfig", GPUSubgroupMatrixConfigExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebHIDOnServiceWorkersEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"HID", HIDExposedConstructCallback}, 
{"HIDConnectionEvent", HIDConnectionEventExposedConstructCallback}, 
{"HIDDevice", HIDDeviceExposedConstructCallback}, 
{"HIDInputReportEvent", HIDInputReportEventExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::LanguageDetectionAPIForWorkersEnabled() && RuntimeEnabledFeatures::LanguageDetectionAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kLanguageDetectionAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"LanguageDetector", LanguageDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIPromptAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIPromptAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIPromptAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"LanguageModel", LanguageModelExposedConstructCallback}, 
{"LanguageModelParams", LanguageModelParamsExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::StableBlinkFeaturesEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Lock", LockExposedConstructCallback}, 
{"LockManager", LockManagerExposedConstructCallback}, 
{"ServiceWorker", ServiceWorkerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MLContext", MLContextExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::Canvas2dMeshEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kCanvas2dMesh)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Mesh2DIndexBuffer", Mesh2DIndexBufferExposedConstructCallback}, 
{"Mesh2DUVBuffer", Mesh2DUVBufferExposedConstructCallback}, 
{"Mesh2DVertexBuffer", Mesh2DVertexBufferExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
const ContextFeatureSettings* context_feature_settings = ContextFeatureSettings::From(execution_context, ContextFeatureSettings::CreationMode::kDontCreateIfNotExists);
if (feature_selector.IsAll() && (RuntimeEnabledFeatures::MojoJSEnabled() || (context_feature_settings && context_feature_settings->isMojoJSEnabled()))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Mojo", MojoExposedConstructCallback}, 
{"MojoHandle", MojoHandleExposedConstructCallback}, 
{"MojoWatcher", MojoWatcherExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
const bool is_in_isolated_context = execution_context->IsIsolatedContext();
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"MulticastController", MulticastControllerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIProofreadingAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIProofreadingAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Proofreader", ProofreaderExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIRewriterAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIRewriterAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIRewriterAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Rewriter", RewriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::RTCRtpTransportEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"RtcTransport", RtcTransportExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::StorageBucketsEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"StorageBucket", StorageBucketExposedConstructCallback}, 
{"StorageBucketManager", StorageBucketManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::AISummarizationAPIForWorkersEnabled() && RuntimeEnabledFeatures::AISummarizationAPIEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Summarizer", SummarizerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::DirectSocketsInServiceWorkersEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TCPServerSocket", TCPServerSocketExposedConstructCallback}, 
{"TCPSocket", TCPSocketExposedConstructCallback}, 
{"UDPSocket", UDPSocketExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::TextDetectorEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TextDetector", TextDetectorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::NotificationTriggersEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kNotificationTriggers)) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"TimestampTrigger", TimestampTriggerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::TranslationAPIForWorkersEnabled() && RuntimeEnabledFeatures::TranslationAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kTranslationAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Translator", TranslatorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebUSBOnServiceWorkersEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"USB", USBExposedConstructCallback}, 
{"USBAlternateInterface", USBAlternateInterfaceExposedConstructCallback}, 
{"USBConfiguration", USBConfigurationExposedConstructCallback}, 
{"USBConnectionEvent", USBConnectionEventExposedConstructCallback}, 
{"USBDevice", USBDeviceExposedConstructCallback}, 
{"USBEndpoint", USBEndpointExposedConstructCallback}, 
{"USBInTransferResult", USBInTransferResultExposedConstructCallback}, 
{"USBInterface", USBInterfaceExposedConstructCallback}, 
{"USBIsochronousInTransferPacket", USBIsochronousInTransferPacketExposedConstructCallback}, 
{"USBIsochronousInTransferResult", USBIsochronousInTransferResultExposedConstructCallback}, 
{"USBIsochronousOutTransferPacket", USBIsochronousOutTransferPacketExposedConstructCallback}, 
{"USBIsochronousOutTransferResult", USBIsochronousOutTransferResultExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_isolated_context && is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebPrintingEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"WebPrintingManager", WebPrintingManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AIWriterAPIForWorkersEnabled() && RuntimeEnabledFeatures::AIWriterAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAIWriterAPI))) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Writer", WriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}



}


}  // namespace blink
