// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_FILTER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_FILTER_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionStringOrUnsignedLong;

class MODULES_EXPORT SerialPortFilter : public bindings::InputDictionaryBase {
  
  public:
static SerialPortFilter* Create() {
  return MakeGarbageCollected<SerialPortFilter>();
}
static SerialPortFilter* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SerialPortFilter>(isolate);
}
static SerialPortFilter* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SerialPortFilter();
explicit  SerialPortFilter(v8::Isolate* isolate);

bool hasBluetoothServiceClassId() const {
  return has_bluetooth_service_class_id_;
}
V8UnionStringOrUnsignedLong* bluetoothServiceClassId() const {
  DCHECK(hasBluetoothServiceClassId());
return member_bluetooth_service_class_id_.Get();
}
V8UnionStringOrUnsignedLong* getBluetoothServiceClassIdOr(V8UnionStringOrUnsignedLong* fallback_value) const {
  if (!hasBluetoothServiceClassId()) {
  return fallback_value;
}
return member_bluetooth_service_class_id_.Get();
}
void setBluetoothServiceClassId(V8UnionStringOrUnsignedLong* value) {
  member_bluetooth_service_class_id_ = value;
has_bluetooth_service_class_id_ = true;
DCHECK(member_bluetooth_service_class_id_);
}

bool hasUsbProductId() const {
  return has_usb_product_id_;
}
uint16_t usbProductId() const {
  DCHECK(hasUsbProductId());
return member_usb_product_id_;
}
uint16_t getUsbProductIdOr(uint16_t fallback_value) const {
  if (!hasUsbProductId()) {
  return fallback_value;
}
return member_usb_product_id_;
}
void setUsbProductId(uint16_t value) {
  member_usb_product_id_ = value;
has_usb_product_id_ = true;
}

bool hasUsbVendorId() const {
  return has_usb_vendor_id_;
}
uint16_t usbVendorId() const {
  DCHECK(hasUsbVendorId());
return member_usb_vendor_id_;
}
uint16_t getUsbVendorIdOr(uint16_t fallback_value) const {
  if (!hasUsbVendorId()) {
  return fallback_value;
}
return member_usb_vendor_id_;
}
void setUsbVendorId(uint16_t value) {
  member_usb_vendor_id_ = value;
has_usb_vendor_id_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bluetooth_service_class_id_ = false;
bool has_usb_product_id_ = false;
bool has_usb_vendor_id_ = false;

Member<V8UnionStringOrUnsignedLong> member_bluetooth_service_class_id_;
uint16_t member_usb_product_id_;
uint16_t member_usb_vendor_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_PORT_FILTER_H_
