// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SECURE_PAYMENT_CONFIRMATION_REQUEST_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SECURE_PAYMENT_CONFIRMATION_REQUEST_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientInputs;
class ExceptionState;
class PaymentCredentialInstrument;
class PaymentEntityLogo;
class PublicKeyCredentialParameters;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT SecurePaymentConfirmationRequest : public bindings::DictionaryBase {
  
  public:
static SecurePaymentConfirmationRequest* Create() {
  return MakeGarbageCollected<SecurePaymentConfirmationRequest>();
}
static SecurePaymentConfirmationRequest* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SecurePaymentConfirmationRequest>(isolate);
}
static SecurePaymentConfirmationRequest* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SecurePaymentConfirmationRequest();
explicit  SecurePaymentConfirmationRequest(v8::Isolate* isolate);

bool hasBrowserBoundPubKeyCredParams() const {
  return has_browser_bound_pub_key_cred_params_;
}
const HeapVector<Member<PublicKeyCredentialParameters>>& browserBoundPubKeyCredParams() const {
  DCHECK(hasBrowserBoundPubKeyCredParams());
return member_browser_bound_pub_key_cred_params_;
}
HeapVector<Member<PublicKeyCredentialParameters>> getBrowserBoundPubKeyCredParamsOr(const HeapVector<Member<PublicKeyCredentialParameters>>& fallback_value) const;
HeapVector<Member<PublicKeyCredentialParameters>> getBrowserBoundPubKeyCredParamsOr(HeapVector<Member<PublicKeyCredentialParameters>>&& fallback_value) const;
void setBrowserBoundPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value);
void setBrowserBoundPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value);

bool hasChallenge() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* challenge() const {
  return member_challenge_.Get();
}
void setChallenge(V8UnionArrayBufferOrArrayBufferView* value) {
  member_challenge_ = value;
DCHECK(member_challenge_);
}

bool hasCredentialIds() const {
  return true;
}
const HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>>& credentialIds() const {
  return member_credential_ids_;
}
void setCredentialIds(const HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>>& value);
void setCredentialIds(HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>>&& value);

bool hasExtensions() const {
  return has_extensions_;
}
AuthenticationExtensionsClientInputs* extensions() const {
  DCHECK(hasExtensions());
return member_extensions_.Get();
}
AuthenticationExtensionsClientInputs* getExtensionsOr(AuthenticationExtensionsClientInputs* fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_.Get();
}
void setExtensions(AuthenticationExtensionsClientInputs* value) {
  member_extensions_ = value;
has_extensions_ = true;
DCHECK(member_extensions_);
}

bool hasInstrument() const {
  return true;
}
PaymentCredentialInstrument* instrument() const {
  return member_instrument_.Get();
}
void setInstrument(PaymentCredentialInstrument* value) {
  member_instrument_ = value;
DCHECK(member_instrument_);
}

bool hasLocale() const {
  return has_locale_;
}
const Vector<String>& locale() const {
  DCHECK(hasLocale());
return member_locale_;
}
Vector<String> getLocaleOr(const Vector<String>& fallback_value) const;
Vector<String> getLocaleOr(Vector<String>&& fallback_value) const;
void setLocale(const Vector<String>& value);
void setLocale(Vector<String>&& value);

bool hasPayeeName() const {
  return has_payee_name_;
}
const String& payeeName() const {
  DCHECK(hasPayeeName());
return member_payee_name_;
}
String getPayeeNameOr(const String& fallback_value) const;
String getPayeeNameOr(String&& fallback_value) const;
void setPayeeName(const String& value);
void setPayeeName(String&& value);

bool hasPayeeOrigin() const {
  return has_payee_origin_;
}
const String& payeeOrigin() const {
  DCHECK(hasPayeeOrigin());
return member_payee_origin_;
}
String getPayeeOriginOr(const String& fallback_value) const;
String getPayeeOriginOr(String&& fallback_value) const;
void setPayeeOrigin(const String& value);
void setPayeeOrigin(String&& value);

bool hasPaymentEntitiesLogos() const {
  return has_payment_entities_logos_;
}
const HeapVector<Member<PaymentEntityLogo>>& paymentEntitiesLogos() const {
  DCHECK(hasPaymentEntitiesLogos());
return member_payment_entities_logos_;
}
HeapVector<Member<PaymentEntityLogo>> getPaymentEntitiesLogosOr(const HeapVector<Member<PaymentEntityLogo>>& fallback_value) const;
HeapVector<Member<PaymentEntityLogo>> getPaymentEntitiesLogosOr(HeapVector<Member<PaymentEntityLogo>>&& fallback_value) const;
void setPaymentEntitiesLogos(const HeapVector<Member<PaymentEntityLogo>>& value);
void setPaymentEntitiesLogos(HeapVector<Member<PaymentEntityLogo>>&& value);

bool hasRpId() const {
  return true;
}
const String& rpId() const {
  return member_rp_id_;
}
void setRpId(const String& value);
void setRpId(String&& value);

bool hasShowOptOut() const {
  return has_show_opt_out_;
}
bool showOptOut() const {
  DCHECK(hasShowOptOut());
return member_show_opt_out_;
}
bool getShowOptOutOr(bool fallback_value) const {
  if (!hasShowOptOut()) {
  return fallback_value;
}
return member_show_opt_out_;
}
void setShowOptOut(bool value) {
  member_show_opt_out_ = value;
has_show_opt_out_ = true;
}

bool hasTimeout() const {
  return has_timeout_;
}
uint32_t timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
uint32_t getTimeoutOr(uint32_t fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
has_timeout_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 12;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_browser_bound_pub_key_cred_params_ = false;
bool has_extensions_ = false;
bool has_locale_ = false;
bool has_payee_name_ = false;
bool has_payee_origin_ = false;
bool has_payment_entities_logos_ = false;
bool has_show_opt_out_ = false;
bool has_timeout_ = false;

HeapVector<Member<PublicKeyCredentialParameters>> member_browser_bound_pub_key_cred_params_;
Member<V8UnionArrayBufferOrArrayBufferView> member_challenge_;
HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>> member_credential_ids_;
Member<AuthenticationExtensionsClientInputs> member_extensions_;
Member<PaymentCredentialInstrument> member_instrument_;
Vector<String> member_locale_;
String member_payee_name_;
String member_payee_origin_;
HeapVector<Member<PaymentEntityLogo>> member_payment_entities_logos_;
String member_rp_id_;
bool member_show_opt_out_;
uint32_t member_timeout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SECURE_PAYMENT_CONFIRMATION_REQUEST_H_
