// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_secure_payment_confirmation_request.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_credential_instrument.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_payment_entity_logo.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_parameters.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"browserBoundPubKeyCredParams",
"challenge",
"credentialIds",
"extensions",
"instrument",
"locale",
"payeeName",
"payeeOrigin",
"paymentEntitiesLogos",
"rpId",
"showOptOut",
"timeout",
};


}  // namespace 

SecurePaymentConfirmationRequest* SecurePaymentConfirmationRequest::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SecurePaymentConfirmationRequest* dictionary = MakeGarbageCollected<SecurePaymentConfirmationRequest>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SecurePaymentConfirmationRequest";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest() {
  
}

 SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest(v8::Isolate* isolate) {
  
}



HeapVector<Member<PublicKeyCredentialParameters>> SecurePaymentConfirmationRequest::getBrowserBoundPubKeyCredParamsOr(const HeapVector<Member<PublicKeyCredentialParameters>>& fallback_value) const {
  if (!hasBrowserBoundPubKeyCredParams()) {
  return fallback_value;
}
return member_browser_bound_pub_key_cred_params_;
}

HeapVector<Member<PublicKeyCredentialParameters>> SecurePaymentConfirmationRequest::getBrowserBoundPubKeyCredParamsOr(HeapVector<Member<PublicKeyCredentialParameters>>&& fallback_value) const {
  if (!hasBrowserBoundPubKeyCredParams()) {
  return std::move(fallback_value);
}
return member_browser_bound_pub_key_cred_params_;
}

void SecurePaymentConfirmationRequest::setBrowserBoundPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value) {
  member_browser_bound_pub_key_cred_params_ = value;
has_browser_bound_pub_key_cred_params_ = true;
}

void SecurePaymentConfirmationRequest::setBrowserBoundPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value) {
  member_browser_bound_pub_key_cred_params_ = std::move(value);
has_browser_bound_pub_key_cred_params_ = true;
}









void SecurePaymentConfirmationRequest::setCredentialIds(const HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>>& value) {
  member_credential_ids_ = value;
}

void SecurePaymentConfirmationRequest::setCredentialIds(HeapVector<Member<V8UnionArrayBufferOrArrayBufferView>>&& value) {
  member_credential_ids_ = std::move(value);
}
















Vector<String> SecurePaymentConfirmationRequest::getLocaleOr(const Vector<String>& fallback_value) const {
  if (!hasLocale()) {
  return fallback_value;
}
return member_locale_;
}

Vector<String> SecurePaymentConfirmationRequest::getLocaleOr(Vector<String>&& fallback_value) const {
  if (!hasLocale()) {
  return std::move(fallback_value);
}
return member_locale_;
}

void SecurePaymentConfirmationRequest::setLocale(const Vector<String>& value) {
  member_locale_ = value;
has_locale_ = true;
}

void SecurePaymentConfirmationRequest::setLocale(Vector<String>&& value) {
  member_locale_ = std::move(value);
has_locale_ = true;
}




String SecurePaymentConfirmationRequest::getPayeeNameOr(const String& fallback_value) const {
  if (!hasPayeeName()) {
  return fallback_value;
}
return member_payee_name_;
}

String SecurePaymentConfirmationRequest::getPayeeNameOr(String&& fallback_value) const {
  if (!hasPayeeName()) {
  return std::move(fallback_value);
}
return member_payee_name_;
}

void SecurePaymentConfirmationRequest::setPayeeName(const String& value) {
  member_payee_name_ = value;
has_payee_name_ = true;
}

void SecurePaymentConfirmationRequest::setPayeeName(String&& value) {
  member_payee_name_ = std::move(value);
has_payee_name_ = true;
}




String SecurePaymentConfirmationRequest::getPayeeOriginOr(const String& fallback_value) const {
  if (!hasPayeeOrigin()) {
  return fallback_value;
}
return member_payee_origin_;
}

String SecurePaymentConfirmationRequest::getPayeeOriginOr(String&& fallback_value) const {
  if (!hasPayeeOrigin()) {
  return std::move(fallback_value);
}
return member_payee_origin_;
}

void SecurePaymentConfirmationRequest::setPayeeOrigin(const String& value) {
  member_payee_origin_ = value;
has_payee_origin_ = true;
}

void SecurePaymentConfirmationRequest::setPayeeOrigin(String&& value) {
  member_payee_origin_ = std::move(value);
has_payee_origin_ = true;
}




HeapVector<Member<PaymentEntityLogo>> SecurePaymentConfirmationRequest::getPaymentEntitiesLogosOr(const HeapVector<Member<PaymentEntityLogo>>& fallback_value) const {
  if (!hasPaymentEntitiesLogos()) {
  return fallback_value;
}
return member_payment_entities_logos_;
}

HeapVector<Member<PaymentEntityLogo>> SecurePaymentConfirmationRequest::getPaymentEntitiesLogosOr(HeapVector<Member<PaymentEntityLogo>>&& fallback_value) const {
  if (!hasPaymentEntitiesLogos()) {
  return std::move(fallback_value);
}
return member_payment_entities_logos_;
}

void SecurePaymentConfirmationRequest::setPaymentEntitiesLogos(const HeapVector<Member<PaymentEntityLogo>>& value) {
  member_payment_entities_logos_ = value;
has_payment_entities_logos_ = true;
}

void SecurePaymentConfirmationRequest::setPaymentEntitiesLogos(HeapVector<Member<PaymentEntityLogo>>&& value) {
  member_payment_entities_logos_ = std::move(value);
has_payment_entities_logos_ = true;
}




void SecurePaymentConfirmationRequest::setRpId(const String& value) {
  member_rp_id_ = value;
}

void SecurePaymentConfirmationRequest::setRpId(String&& value) {
  member_rp_id_ = std::move(value);
}

















void SecurePaymentConfirmationRequest::Trace(Visitor* visitor) const {
  visitor->Trace(member_browser_bound_pub_key_cred_params_);
visitor->Trace(member_challenge_);
visitor->Trace(member_credential_ids_);
visitor->Trace(member_extensions_);
visitor->Trace(member_instrument_);
visitor->Trace(member_payment_entities_logos_);
bindings::DictionaryBase::Trace(visitor);
}

void SecurePaymentConfirmationRequest::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void SecurePaymentConfirmationRequest::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (RuntimeEnabledFeatures::SecurePaymentConfirmationBrowserBoundKeysEnabled()) {
  if (hasBrowserBoundPubKeyCredParams()) {
  values[0] = ToV8Traits<IDLSequence<PublicKeyCredentialParameters>>::ToV8(script_state, member_browser_bound_pub_key_cred_params_);
DCHECK(!values[0].IsEmpty());
}
}
if (hasChallenge()) {
  values[1] = ToV8Traits<V8UnionArrayBufferOrArrayBufferView>::ToV8(script_state, member_challenge_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasCredentialIds()) {
  values[2] = ToV8Traits<IDLSequence<V8UnionArrayBufferOrArrayBufferView>>::ToV8(script_state, member_credential_ids_);
DCHECK(!values[2].IsEmpty());
}
if (hasExtensions()) {
  values[3] = ToV8Traits<AuthenticationExtensionsClientInputs>::ToV8(script_state, member_extensions_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasInstrument()) {
  values[4] = ToV8Traits<PaymentCredentialInstrument>::ToV8(script_state, member_instrument_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasLocale()) {
  values[5] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_locale_);
DCHECK(!values[5].IsEmpty());
}
if (hasPayeeName()) {
  values[6] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_payee_name_);
DCHECK(!values[6].IsEmpty());
}
if (hasPayeeOrigin()) {
  values[7] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_payee_origin_);
DCHECK(!values[7].IsEmpty());
}
if (RuntimeEnabledFeatures::SecurePaymentConfirmationUxRefreshEnabled()) {
  if (hasPaymentEntitiesLogos()) {
  values[8] = ToV8Traits<IDLSequence<PaymentEntityLogo>>::ToV8(script_state, member_payment_entities_logos_);
DCHECK(!values[8].IsEmpty());
}
}
if (hasRpId()) {
  values[9] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_rp_id_);
DCHECK(!values[9].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::SecurePaymentConfirmationOptOutEnabled(execution_context)) {
  if (hasShowOptOut()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_show_opt_out_);
DCHECK(!values[10].IsEmpty());
}
}
if (hasTimeout()) {
  values[11] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_timeout_);
DCHECK(!values[11].IsEmpty());
}
}

const void* SecurePaymentConfirmationRequest::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> SecurePaymentConfirmationRequest::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void SecurePaymentConfirmationRequest::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SecurePaymentConfirmationRequest";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::SecurePaymentConfirmationBrowserBoundKeysEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("browserBoundPubKeyCredParams");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialParameters>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_browser_bound_pub_key_cred_params_, member_browser_bound_pub_key_cred_params_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferOrArrayBufferView, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_challenge_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("credentialIds");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionArrayBufferOrArrayBufferView>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_credential_ids_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("instrument");
if (!bindings::GetDictionaryMemberFromV8Object<PaymentCredentialInstrument, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_instrument_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("locale");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_locale_, member_locale_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payeeName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_payee_name_, member_payee_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("payeeOrigin");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_payee_origin_, member_payee_origin_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::SecurePaymentConfirmationUxRefreshEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("paymentEntitiesLogos");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PaymentEntityLogo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_payment_entities_logos_, member_payment_entities_logos_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("rpId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_rp_id_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::SecurePaymentConfirmationOptOutEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("showOptOut");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_show_opt_out_, member_show_opt_out_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("timeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_timeout_, member_timeout_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SecurePaymentConfirmationRequest::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
