// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_dtls_role.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_dtls_transport_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_role.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_transport_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCTransportStats : public RTCStats {
  
  public:
static RTCTransportStats* Create() {
  return MakeGarbageCollected<RTCTransportStats>();
}
static RTCTransportStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCTransportStats>(isolate);
}
static RTCTransportStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCTransportStats();
explicit  RTCTransportStats(v8::Isolate* isolate);

bool hasBytesReceived() const {
  return has_bytes_received_;
}
uint64_t bytesReceived() const {
  DCHECK(hasBytesReceived());
return member_bytes_received_;
}
uint64_t getBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasBytesReceived()) {
  return fallback_value;
}
return member_bytes_received_;
}
void setBytesReceived(uint64_t value) {
  member_bytes_received_ = value;
has_bytes_received_ = true;
}

bool hasBytesSent() const {
  return has_bytes_sent_;
}
uint64_t bytesSent() const {
  DCHECK(hasBytesSent());
return member_bytes_sent_;
}
uint64_t getBytesSentOr(uint64_t fallback_value) const {
  if (!hasBytesSent()) {
  return fallback_value;
}
return member_bytes_sent_;
}
void setBytesSent(uint64_t value) {
  member_bytes_sent_ = value;
has_bytes_sent_ = true;
}

bool hasCcbfMessagesReceived() const {
  return has_ccbf_messages_received_;
}
uint32_t ccbfMessagesReceived() const {
  DCHECK(hasCcbfMessagesReceived());
return member_ccbf_messages_received_;
}
uint32_t getCcbfMessagesReceivedOr(uint32_t fallback_value) const {
  if (!hasCcbfMessagesReceived()) {
  return fallback_value;
}
return member_ccbf_messages_received_;
}
void setCcbfMessagesReceived(uint32_t value) {
  member_ccbf_messages_received_ = value;
has_ccbf_messages_received_ = true;
}

bool hasDtlsCipher() const {
  return has_dtls_cipher_;
}
const String& dtlsCipher() const {
  DCHECK(hasDtlsCipher());
return member_dtls_cipher_;
}
String getDtlsCipherOr(const String& fallback_value) const;
String getDtlsCipherOr(String&& fallback_value) const;
void setDtlsCipher(const String& value);
void setDtlsCipher(String&& value);

bool hasDtlsRole() const {
  return has_dtls_role_;
}
V8RTCDtlsRole dtlsRole() const {
  DCHECK(hasDtlsRole());
return member_dtls_role_;
}
V8RTCDtlsRole getDtlsRoleOr(V8RTCDtlsRole fallback_value) const {
  if (!hasDtlsRole()) {
  return fallback_value;
}
return member_dtls_role_;
}
void setDtlsRole(V8RTCDtlsRole value) {
  member_dtls_role_ = value;
has_dtls_role_ = true;
}
void setDtlsRole(V8RTCDtlsRole::Enum value) {
  member_dtls_role_ = V8RTCDtlsRole(value);
has_dtls_role_ = true;
}

bool hasDtlsState() const {
  return true;
}
V8RTCDtlsTransportState dtlsState() const {
  return member_dtls_state_;
}
void setDtlsState(V8RTCDtlsTransportState value) {
  member_dtls_state_ = value;
}
void setDtlsState(V8RTCDtlsTransportState::Enum value) {
  member_dtls_state_ = V8RTCDtlsTransportState(value);
}

bool hasIceLocalUsernameFragment() const {
  return has_ice_local_username_fragment_;
}
const String& iceLocalUsernameFragment() const {
  DCHECK(hasIceLocalUsernameFragment());
return member_ice_local_username_fragment_;
}
String getIceLocalUsernameFragmentOr(const String& fallback_value) const;
String getIceLocalUsernameFragmentOr(String&& fallback_value) const;
void setIceLocalUsernameFragment(const String& value);
void setIceLocalUsernameFragment(String&& value);

bool hasIceRole() const {
  return has_ice_role_;
}
V8RTCIceRole iceRole() const {
  DCHECK(hasIceRole());
return member_ice_role_;
}
V8RTCIceRole getIceRoleOr(V8RTCIceRole fallback_value) const {
  if (!hasIceRole()) {
  return fallback_value;
}
return member_ice_role_;
}
void setIceRole(V8RTCIceRole value) {
  member_ice_role_ = value;
has_ice_role_ = true;
}
void setIceRole(V8RTCIceRole::Enum value) {
  member_ice_role_ = V8RTCIceRole(value);
has_ice_role_ = true;
}

bool hasIceState() const {
  return has_ice_state_;
}
V8RTCIceTransportState iceState() const {
  DCHECK(hasIceState());
return member_ice_state_;
}
V8RTCIceTransportState getIceStateOr(V8RTCIceTransportState fallback_value) const {
  if (!hasIceState()) {
  return fallback_value;
}
return member_ice_state_;
}
void setIceState(V8RTCIceTransportState value) {
  member_ice_state_ = value;
has_ice_state_ = true;
}
void setIceState(V8RTCIceTransportState::Enum value) {
  member_ice_state_ = V8RTCIceTransportState(value);
has_ice_state_ = true;
}

bool hasLocalCertificateId() const {
  return has_local_certificate_id_;
}
const String& localCertificateId() const {
  DCHECK(hasLocalCertificateId());
return member_local_certificate_id_;
}
String getLocalCertificateIdOr(const String& fallback_value) const;
String getLocalCertificateIdOr(String&& fallback_value) const;
void setLocalCertificateId(const String& value);
void setLocalCertificateId(String&& value);

bool hasPacketsReceived() const {
  return has_packets_received_;
}
uint64_t packetsReceived() const {
  DCHECK(hasPacketsReceived());
return member_packets_received_;
}
uint64_t getPacketsReceivedOr(uint64_t fallback_value) const {
  if (!hasPacketsReceived()) {
  return fallback_value;
}
return member_packets_received_;
}
void setPacketsReceived(uint64_t value) {
  member_packets_received_ = value;
has_packets_received_ = true;
}

bool hasPacketsSent() const {
  return has_packets_sent_;
}
uint64_t packetsSent() const {
  DCHECK(hasPacketsSent());
return member_packets_sent_;
}
uint64_t getPacketsSentOr(uint64_t fallback_value) const {
  if (!hasPacketsSent()) {
  return fallback_value;
}
return member_packets_sent_;
}
void setPacketsSent(uint64_t value) {
  member_packets_sent_ = value;
has_packets_sent_ = true;
}

bool hasRemoteCertificateId() const {
  return has_remote_certificate_id_;
}
const String& remoteCertificateId() const {
  DCHECK(hasRemoteCertificateId());
return member_remote_certificate_id_;
}
String getRemoteCertificateIdOr(const String& fallback_value) const;
String getRemoteCertificateIdOr(String&& fallback_value) const;
void setRemoteCertificateId(const String& value);
void setRemoteCertificateId(String&& value);

bool hasRtcpTransportStatsId() const {
  return has_rtcp_transport_stats_id_;
}
const String& rtcpTransportStatsId() const {
  DCHECK(hasRtcpTransportStatsId());
return member_rtcp_transport_stats_id_;
}
String getRtcpTransportStatsIdOr(const String& fallback_value) const;
String getRtcpTransportStatsIdOr(String&& fallback_value) const;
void setRtcpTransportStatsId(const String& value);
void setRtcpTransportStatsId(String&& value);

bool hasSelectedCandidatePairChanges() const {
  return has_selected_candidate_pair_changes_;
}
uint32_t selectedCandidatePairChanges() const {
  DCHECK(hasSelectedCandidatePairChanges());
return member_selected_candidate_pair_changes_;
}
uint32_t getSelectedCandidatePairChangesOr(uint32_t fallback_value) const {
  if (!hasSelectedCandidatePairChanges()) {
  return fallback_value;
}
return member_selected_candidate_pair_changes_;
}
void setSelectedCandidatePairChanges(uint32_t value) {
  member_selected_candidate_pair_changes_ = value;
has_selected_candidate_pair_changes_ = true;
}

bool hasSelectedCandidatePairId() const {
  return has_selected_candidate_pair_id_;
}
const String& selectedCandidatePairId() const {
  DCHECK(hasSelectedCandidatePairId());
return member_selected_candidate_pair_id_;
}
String getSelectedCandidatePairIdOr(const String& fallback_value) const;
String getSelectedCandidatePairIdOr(String&& fallback_value) const;
void setSelectedCandidatePairId(const String& value);
void setSelectedCandidatePairId(String&& value);

bool hasSrtpCipher() const {
  return has_srtp_cipher_;
}
const String& srtpCipher() const {
  DCHECK(hasSrtpCipher());
return member_srtp_cipher_;
}
String getSrtpCipherOr(const String& fallback_value) const;
String getSrtpCipherOr(String&& fallback_value) const;
void setSrtpCipher(const String& value);
void setSrtpCipher(String&& value);

bool hasTlsVersion() const {
  return has_tls_version_;
}
const String& tlsVersion() const {
  DCHECK(hasTlsVersion());
return member_tls_version_;
}
String getTlsVersionOr(const String& fallback_value) const;
String getTlsVersionOr(String&& fallback_value) const;
void setTlsVersion(const String& value);
void setTlsVersion(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 18;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bytes_received_ = false;
bool has_bytes_sent_ = false;
bool has_ccbf_messages_received_ = false;
bool has_dtls_cipher_ = false;
bool has_dtls_role_ = false;
bool has_ice_local_username_fragment_ = false;
bool has_ice_role_ = false;
bool has_ice_state_ = false;
bool has_local_certificate_id_ = false;
bool has_packets_received_ = false;
bool has_packets_sent_ = false;
bool has_remote_certificate_id_ = false;
bool has_rtcp_transport_stats_id_ = false;
bool has_selected_candidate_pair_changes_ = false;
bool has_selected_candidate_pair_id_ = false;
bool has_srtp_cipher_ = false;
bool has_tls_version_ = false;

uint64_t member_bytes_received_;
uint64_t member_bytes_sent_;
uint32_t member_ccbf_messages_received_;
String member_dtls_cipher_;
V8RTCDtlsRole member_dtls_role_{static_cast<V8RTCDtlsRole::Enum>(0)};
V8RTCDtlsTransportState member_dtls_state_{static_cast<V8RTCDtlsTransportState::Enum>(0)};
String member_ice_local_username_fragment_;
V8RTCIceRole member_ice_role_{static_cast<V8RTCIceRole::Enum>(0)};
V8RTCIceTransportState member_ice_state_{static_cast<V8RTCIceTransportState::Enum>(0)};
String member_local_certificate_id_;
uint64_t member_packets_received_;
uint64_t member_packets_sent_;
String member_remote_certificate_id_;
String member_rtcp_transport_stats_id_;
uint32_t member_selected_candidate_pair_changes_;
String member_selected_candidate_pair_id_;
String member_srtp_cipher_;
String member_tls_version_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_STATS_H_
