// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SENT_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SENT_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_stream_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCSentRtpStreamStats : public RTCRtpStreamStats {
  
  public:
static RTCSentRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCSentRtpStreamStats>();
}
static RTCSentRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCSentRtpStreamStats>(isolate);
}
static RTCSentRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCSentRtpStreamStats();
explicit  RTCSentRtpStreamStats(v8::Isolate* isolate);

bool hasBytesSent() const {
  return has_bytes_sent_;
}
uint64_t bytesSent() const {
  DCHECK(hasBytesSent());
return member_bytes_sent_;
}
uint64_t getBytesSentOr(uint64_t fallback_value) const {
  if (!hasBytesSent()) {
  return fallback_value;
}
return member_bytes_sent_;
}
void setBytesSent(uint64_t value) {
  member_bytes_sent_ = value;
has_bytes_sent_ = true;
}

bool hasPacketsSent() const {
  return has_packets_sent_;
}
uint64_t packetsSent() const {
  DCHECK(hasPacketsSent());
return member_packets_sent_;
}
uint64_t getPacketsSentOr(uint64_t fallback_value) const {
  if (!hasPacketsSent()) {
  return fallback_value;
}
return member_packets_sent_;
}
void setPacketsSent(uint64_t value) {
  member_packets_sent_ = value;
has_packets_sent_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCRtpStreamStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bytes_sent_ = false;
bool has_packets_sent_ = false;

uint64_t member_bytes_sent_;
uint64_t member_packets_sent_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_SENT_RTP_STREAM_STATS_H_
