// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OFFER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OFFER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_offer_answer_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCOfferOptions : public RTCOfferAnswerOptions {
  
  public:
static RTCOfferOptions* Create() {
  return MakeGarbageCollected<RTCOfferOptions>();
}
static RTCOfferOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCOfferOptions>(isolate);
}
static RTCOfferOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCOfferOptions();
explicit  RTCOfferOptions(v8::Isolate* isolate);

bool hasIceRestart() const {
  return true;
}
bool iceRestart() const {
  return member_ice_restart_;
}
void setIceRestart(bool value) {
  member_ice_restart_ = value;
}

bool hasOfferToReceiveAudio() const {
  return has_offer_to_receive_audio_;
}
int32_t offerToReceiveAudio() const {
  DCHECK(hasOfferToReceiveAudio());
return member_offer_to_receive_audio_;
}
int32_t getOfferToReceiveAudioOr(int32_t fallback_value) const {
  if (!hasOfferToReceiveAudio()) {
  return fallback_value;
}
return member_offer_to_receive_audio_;
}
void setOfferToReceiveAudio(int32_t value) {
  member_offer_to_receive_audio_ = value;
has_offer_to_receive_audio_ = true;
}

bool hasOfferToReceiveVideo() const {
  return has_offer_to_receive_video_;
}
int32_t offerToReceiveVideo() const {
  DCHECK(hasOfferToReceiveVideo());
return member_offer_to_receive_video_;
}
int32_t getOfferToReceiveVideoOr(int32_t fallback_value) const {
  if (!hasOfferToReceiveVideo()) {
  return fallback_value;
}
return member_offer_to_receive_video_;
}
void setOfferToReceiveVideo(int32_t value) {
  member_offer_to_receive_video_ = value;
has_offer_to_receive_video_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCOfferAnswerOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_offer_to_receive_audio_ = false;
bool has_offer_to_receive_video_ = false;

bool member_ice_restart_{false};
int32_t member_offer_to_receive_audio_;
int32_t member_offer_to_receive_video_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OFFER_OPTIONS_H_
