// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INSERTABLE_STREAMS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INSERTABLE_STREAMS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ReadableStream;
class WritableStream;

class MODULES_EXPORT RTCInsertableStreams : public bindings::DictionaryBase {
  
  public:
static RTCInsertableStreams* Create() {
  return MakeGarbageCollected<RTCInsertableStreams>();
}
static RTCInsertableStreams* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCInsertableStreams>(isolate);
}
static RTCInsertableStreams* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCInsertableStreams();
explicit  RTCInsertableStreams(v8::Isolate* isolate);

bool hasReadable() const {
  return has_readable_;
}
ReadableStream* readable() const {
  DCHECK(hasReadable());
return member_readable_.Get();
}
ReadableStream* getReadableOr(ReadableStream* fallback_value) const {
  if (!hasReadable()) {
  return fallback_value;
}
return member_readable_.Get();
}
void setReadable(ReadableStream* value) {
  member_readable_ = value;
has_readable_ = true;
DCHECK(member_readable_);
}

bool hasWritable() const {
  return has_writable_;
}
WritableStream* writable() const {
  DCHECK(hasWritable());
return member_writable_.Get();
}
WritableStream* getWritableOr(WritableStream* fallback_value) const {
  if (!hasWritable()) {
  return fallback_value;
}
return member_writable_.Get();
}
void setWritable(WritableStream* value) {
  member_writable_ = value;
has_writable_ = true;
DCHECK(member_writable_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_readable_ = false;
bool has_writable_ = false;

Member<ReadableStream> member_readable_;
Member<WritableStream> member_writable_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INSERTABLE_STREAMS_H_
