// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INBOUND_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INBOUND_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_received_rtp_stream_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCInboundRtpStreamStats : public RTCReceivedRtpStreamStats {
  
  public:
static RTCInboundRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCInboundRtpStreamStats>();
}
static RTCInboundRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCInboundRtpStreamStats>(isolate);
}
static RTCInboundRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCInboundRtpStreamStats();
explicit  RTCInboundRtpStreamStats(v8::Isolate* isolate);

bool hasAudioLevel() const {
  return has_audio_level_;
}
double audioLevel() const {
  DCHECK(hasAudioLevel());
return member_audio_level_;
}
double getAudioLevelOr(double fallback_value) const {
  if (!hasAudioLevel()) {
  return fallback_value;
}
return member_audio_level_;
}
void setAudioLevel(double value) {
  member_audio_level_ = value;
has_audio_level_ = true;
}

bool hasBytesReceived() const {
  return has_bytes_received_;
}
uint64_t bytesReceived() const {
  DCHECK(hasBytesReceived());
return member_bytes_received_;
}
uint64_t getBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasBytesReceived()) {
  return fallback_value;
}
return member_bytes_received_;
}
void setBytesReceived(uint64_t value) {
  member_bytes_received_ = value;
has_bytes_received_ = true;
}

bool hasConcealedSamples() const {
  return has_concealed_samples_;
}
uint64_t concealedSamples() const {
  DCHECK(hasConcealedSamples());
return member_concealed_samples_;
}
uint64_t getConcealedSamplesOr(uint64_t fallback_value) const {
  if (!hasConcealedSamples()) {
  return fallback_value;
}
return member_concealed_samples_;
}
void setConcealedSamples(uint64_t value) {
  member_concealed_samples_ = value;
has_concealed_samples_ = true;
}

bool hasConcealmentEvents() const {
  return has_concealment_events_;
}
uint64_t concealmentEvents() const {
  DCHECK(hasConcealmentEvents());
return member_concealment_events_;
}
uint64_t getConcealmentEventsOr(uint64_t fallback_value) const {
  if (!hasConcealmentEvents()) {
  return fallback_value;
}
return member_concealment_events_;
}
void setConcealmentEvents(uint64_t value) {
  member_concealment_events_ = value;
has_concealment_events_ = true;
}

bool hasContentType() const {
  return has_content_type_;
}
const String& contentType() const {
  DCHECK(hasContentType());
return member_content_type_;
}
String getContentTypeOr(const String& fallback_value) const;
String getContentTypeOr(String&& fallback_value) const;
void setContentType(const String& value);
void setContentType(String&& value);

bool hasCorruptionMeasurements() const {
  return has_corruption_measurements_;
}
uint64_t corruptionMeasurements() const {
  DCHECK(hasCorruptionMeasurements());
return member_corruption_measurements_;
}
uint64_t getCorruptionMeasurementsOr(uint64_t fallback_value) const {
  if (!hasCorruptionMeasurements()) {
  return fallback_value;
}
return member_corruption_measurements_;
}
void setCorruptionMeasurements(uint64_t value) {
  member_corruption_measurements_ = value;
has_corruption_measurements_ = true;
}

bool hasDecoderImplementation() const {
  return has_decoder_implementation_;
}
const String& decoderImplementation() const {
  DCHECK(hasDecoderImplementation());
return member_decoder_implementation_;
}
String getDecoderImplementationOr(const String& fallback_value) const;
String getDecoderImplementationOr(String&& fallback_value) const;
void setDecoderImplementation(const String& value);
void setDecoderImplementation(String&& value);

bool hasEstimatedPlayoutTimestamp() const {
  return has_estimated_playout_timestamp_;
}
double estimatedPlayoutTimestamp() const {
  DCHECK(hasEstimatedPlayoutTimestamp());
return member_estimated_playout_timestamp_;
}
double getEstimatedPlayoutTimestampOr(double fallback_value) const {
  if (!hasEstimatedPlayoutTimestamp()) {
  return fallback_value;
}
return member_estimated_playout_timestamp_;
}
void setEstimatedPlayoutTimestamp(double value) {
  member_estimated_playout_timestamp_ = value;
has_estimated_playout_timestamp_ = true;
}

bool hasFecBytesReceived() const {
  return has_fec_bytes_received_;
}
uint64_t fecBytesReceived() const {
  DCHECK(hasFecBytesReceived());
return member_fec_bytes_received_;
}
uint64_t getFecBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasFecBytesReceived()) {
  return fallback_value;
}
return member_fec_bytes_received_;
}
void setFecBytesReceived(uint64_t value) {
  member_fec_bytes_received_ = value;
has_fec_bytes_received_ = true;
}

bool hasFecPacketsDiscarded() const {
  return has_fec_packets_discarded_;
}
uint64_t fecPacketsDiscarded() const {
  DCHECK(hasFecPacketsDiscarded());
return member_fec_packets_discarded_;
}
uint64_t getFecPacketsDiscardedOr(uint64_t fallback_value) const {
  if (!hasFecPacketsDiscarded()) {
  return fallback_value;
}
return member_fec_packets_discarded_;
}
void setFecPacketsDiscarded(uint64_t value) {
  member_fec_packets_discarded_ = value;
has_fec_packets_discarded_ = true;
}

bool hasFecPacketsReceived() const {
  return has_fec_packets_received_;
}
uint64_t fecPacketsReceived() const {
  DCHECK(hasFecPacketsReceived());
return member_fec_packets_received_;
}
uint64_t getFecPacketsReceivedOr(uint64_t fallback_value) const {
  if (!hasFecPacketsReceived()) {
  return fallback_value;
}
return member_fec_packets_received_;
}
void setFecPacketsReceived(uint64_t value) {
  member_fec_packets_received_ = value;
has_fec_packets_received_ = true;
}

bool hasFecSsrc() const {
  return has_fec_ssrc_;
}
uint32_t fecSsrc() const {
  DCHECK(hasFecSsrc());
return member_fec_ssrc_;
}
uint32_t getFecSsrcOr(uint32_t fallback_value) const {
  if (!hasFecSsrc()) {
  return fallback_value;
}
return member_fec_ssrc_;
}
void setFecSsrc(uint32_t value) {
  member_fec_ssrc_ = value;
has_fec_ssrc_ = true;
}

bool hasFirCount() const {
  return has_fir_count_;
}
uint32_t firCount() const {
  DCHECK(hasFirCount());
return member_fir_count_;
}
uint32_t getFirCountOr(uint32_t fallback_value) const {
  if (!hasFirCount()) {
  return fallback_value;
}
return member_fir_count_;
}
void setFirCount(uint32_t value) {
  member_fir_count_ = value;
has_fir_count_ = true;
}

bool hasFrameHeight() const {
  return has_frame_height_;
}
uint32_t frameHeight() const {
  DCHECK(hasFrameHeight());
return member_frame_height_;
}
uint32_t getFrameHeightOr(uint32_t fallback_value) const {
  if (!hasFrameHeight()) {
  return fallback_value;
}
return member_frame_height_;
}
void setFrameHeight(uint32_t value) {
  member_frame_height_ = value;
has_frame_height_ = true;
}

bool hasFrameWidth() const {
  return has_frame_width_;
}
uint32_t frameWidth() const {
  DCHECK(hasFrameWidth());
return member_frame_width_;
}
uint32_t getFrameWidthOr(uint32_t fallback_value) const {
  if (!hasFrameWidth()) {
  return fallback_value;
}
return member_frame_width_;
}
void setFrameWidth(uint32_t value) {
  member_frame_width_ = value;
has_frame_width_ = true;
}

bool hasFramesAssembledFromMultiplePackets() const {
  return has_frames_assembled_from_multiple_packets_;
}
uint32_t framesAssembledFromMultiplePackets() const {
  DCHECK(hasFramesAssembledFromMultiplePackets());
return member_frames_assembled_from_multiple_packets_;
}
uint32_t getFramesAssembledFromMultiplePacketsOr(uint32_t fallback_value) const {
  if (!hasFramesAssembledFromMultiplePackets()) {
  return fallback_value;
}
return member_frames_assembled_from_multiple_packets_;
}
void setFramesAssembledFromMultiplePackets(uint32_t value) {
  member_frames_assembled_from_multiple_packets_ = value;
has_frames_assembled_from_multiple_packets_ = true;
}

bool hasFramesDecoded() const {
  return has_frames_decoded_;
}
uint32_t framesDecoded() const {
  DCHECK(hasFramesDecoded());
return member_frames_decoded_;
}
uint32_t getFramesDecodedOr(uint32_t fallback_value) const {
  if (!hasFramesDecoded()) {
  return fallback_value;
}
return member_frames_decoded_;
}
void setFramesDecoded(uint32_t value) {
  member_frames_decoded_ = value;
has_frames_decoded_ = true;
}

bool hasFramesDropped() const {
  return has_frames_dropped_;
}
uint32_t framesDropped() const {
  DCHECK(hasFramesDropped());
return member_frames_dropped_;
}
uint32_t getFramesDroppedOr(uint32_t fallback_value) const {
  if (!hasFramesDropped()) {
  return fallback_value;
}
return member_frames_dropped_;
}
void setFramesDropped(uint32_t value) {
  member_frames_dropped_ = value;
has_frames_dropped_ = true;
}

bool hasFramesPerSecond() const {
  return has_frames_per_second_;
}
double framesPerSecond() const {
  DCHECK(hasFramesPerSecond());
return member_frames_per_second_;
}
double getFramesPerSecondOr(double fallback_value) const {
  if (!hasFramesPerSecond()) {
  return fallback_value;
}
return member_frames_per_second_;
}
void setFramesPerSecond(double value) {
  member_frames_per_second_ = value;
has_frames_per_second_ = true;
}

bool hasFramesReceived() const {
  return has_frames_received_;
}
uint32_t framesReceived() const {
  DCHECK(hasFramesReceived());
return member_frames_received_;
}
uint32_t getFramesReceivedOr(uint32_t fallback_value) const {
  if (!hasFramesReceived()) {
  return fallback_value;
}
return member_frames_received_;
}
void setFramesReceived(uint32_t value) {
  member_frames_received_ = value;
has_frames_received_ = true;
}

bool hasFreezeCount() const {
  return has_freeze_count_;
}
uint32_t freezeCount() const {
  DCHECK(hasFreezeCount());
return member_freeze_count_;
}
uint32_t getFreezeCountOr(uint32_t fallback_value) const {
  if (!hasFreezeCount()) {
  return fallback_value;
}
return member_freeze_count_;
}
void setFreezeCount(uint32_t value) {
  member_freeze_count_ = value;
has_freeze_count_ = true;
}

bool hasGoogTimingFrameInfo() const {
  return has_goog_timing_frame_info_;
}
const String& googTimingFrameInfo() const {
  DCHECK(hasGoogTimingFrameInfo());
return member_goog_timing_frame_info_;
}
String getGoogTimingFrameInfoOr(const String& fallback_value) const;
String getGoogTimingFrameInfoOr(String&& fallback_value) const;
void setGoogTimingFrameInfo(const String& value);
void setGoogTimingFrameInfo(String&& value);

bool hasHeaderBytesReceived() const {
  return has_header_bytes_received_;
}
uint64_t headerBytesReceived() const {
  DCHECK(hasHeaderBytesReceived());
return member_header_bytes_received_;
}
uint64_t getHeaderBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasHeaderBytesReceived()) {
  return fallback_value;
}
return member_header_bytes_received_;
}
void setHeaderBytesReceived(uint64_t value) {
  member_header_bytes_received_ = value;
has_header_bytes_received_ = true;
}

bool hasInsertedSamplesForDeceleration() const {
  return has_inserted_samples_for_deceleration_;
}
uint64_t insertedSamplesForDeceleration() const {
  DCHECK(hasInsertedSamplesForDeceleration());
return member_inserted_samples_for_deceleration_;
}
uint64_t getInsertedSamplesForDecelerationOr(uint64_t fallback_value) const {
  if (!hasInsertedSamplesForDeceleration()) {
  return fallback_value;
}
return member_inserted_samples_for_deceleration_;
}
void setInsertedSamplesForDeceleration(uint64_t value) {
  member_inserted_samples_for_deceleration_ = value;
has_inserted_samples_for_deceleration_ = true;
}

bool hasJitterBufferDelay() const {
  return has_jitter_buffer_delay_;
}
double jitterBufferDelay() const {
  DCHECK(hasJitterBufferDelay());
return member_jitter_buffer_delay_;
}
double getJitterBufferDelayOr(double fallback_value) const {
  if (!hasJitterBufferDelay()) {
  return fallback_value;
}
return member_jitter_buffer_delay_;
}
void setJitterBufferDelay(double value) {
  member_jitter_buffer_delay_ = value;
has_jitter_buffer_delay_ = true;
}

bool hasJitterBufferEmittedCount() const {
  return has_jitter_buffer_emitted_count_;
}
uint64_t jitterBufferEmittedCount() const {
  DCHECK(hasJitterBufferEmittedCount());
return member_jitter_buffer_emitted_count_;
}
uint64_t getJitterBufferEmittedCountOr(uint64_t fallback_value) const {
  if (!hasJitterBufferEmittedCount()) {
  return fallback_value;
}
return member_jitter_buffer_emitted_count_;
}
void setJitterBufferEmittedCount(uint64_t value) {
  member_jitter_buffer_emitted_count_ = value;
has_jitter_buffer_emitted_count_ = true;
}

bool hasJitterBufferMinimumDelay() const {
  return has_jitter_buffer_minimum_delay_;
}
double jitterBufferMinimumDelay() const {
  DCHECK(hasJitterBufferMinimumDelay());
return member_jitter_buffer_minimum_delay_;
}
double getJitterBufferMinimumDelayOr(double fallback_value) const {
  if (!hasJitterBufferMinimumDelay()) {
  return fallback_value;
}
return member_jitter_buffer_minimum_delay_;
}
void setJitterBufferMinimumDelay(double value) {
  member_jitter_buffer_minimum_delay_ = value;
has_jitter_buffer_minimum_delay_ = true;
}

bool hasJitterBufferTargetDelay() const {
  return has_jitter_buffer_target_delay_;
}
double jitterBufferTargetDelay() const {
  DCHECK(hasJitterBufferTargetDelay());
return member_jitter_buffer_target_delay_;
}
double getJitterBufferTargetDelayOr(double fallback_value) const {
  if (!hasJitterBufferTargetDelay()) {
  return fallback_value;
}
return member_jitter_buffer_target_delay_;
}
void setJitterBufferTargetDelay(double value) {
  member_jitter_buffer_target_delay_ = value;
has_jitter_buffer_target_delay_ = true;
}

bool hasKeyFramesDecoded() const {
  return has_key_frames_decoded_;
}
uint32_t keyFramesDecoded() const {
  DCHECK(hasKeyFramesDecoded());
return member_key_frames_decoded_;
}
uint32_t getKeyFramesDecodedOr(uint32_t fallback_value) const {
  if (!hasKeyFramesDecoded()) {
  return fallback_value;
}
return member_key_frames_decoded_;
}
void setKeyFramesDecoded(uint32_t value) {
  member_key_frames_decoded_ = value;
has_key_frames_decoded_ = true;
}

bool hasLastPacketReceivedTimestamp() const {
  return has_last_packet_received_timestamp_;
}
double lastPacketReceivedTimestamp() const {
  DCHECK(hasLastPacketReceivedTimestamp());
return member_last_packet_received_timestamp_;
}
double getLastPacketReceivedTimestampOr(double fallback_value) const {
  if (!hasLastPacketReceivedTimestamp()) {
  return fallback_value;
}
return member_last_packet_received_timestamp_;
}
void setLastPacketReceivedTimestamp(double value) {
  member_last_packet_received_timestamp_ = value;
has_last_packet_received_timestamp_ = true;
}

bool hasMid() const {
  return has_mid_;
}
const String& mid() const {
  DCHECK(hasMid());
return member_mid_;
}
String getMidOr(const String& fallback_value) const;
String getMidOr(String&& fallback_value) const;
void setMid(const String& value);
void setMid(String&& value);

bool hasNackCount() const {
  return has_nack_count_;
}
uint32_t nackCount() const {
  DCHECK(hasNackCount());
return member_nack_count_;
}
uint32_t getNackCountOr(uint32_t fallback_value) const {
  if (!hasNackCount()) {
  return fallback_value;
}
return member_nack_count_;
}
void setNackCount(uint32_t value) {
  member_nack_count_ = value;
has_nack_count_ = true;
}

bool hasPacketsDiscarded() const {
  return has_packets_discarded_;
}
uint64_t packetsDiscarded() const {
  DCHECK(hasPacketsDiscarded());
return member_packets_discarded_;
}
uint64_t getPacketsDiscardedOr(uint64_t fallback_value) const {
  if (!hasPacketsDiscarded()) {
  return fallback_value;
}
return member_packets_discarded_;
}
void setPacketsDiscarded(uint64_t value) {
  member_packets_discarded_ = value;
has_packets_discarded_ = true;
}

bool hasPauseCount() const {
  return has_pause_count_;
}
uint32_t pauseCount() const {
  DCHECK(hasPauseCount());
return member_pause_count_;
}
uint32_t getPauseCountOr(uint32_t fallback_value) const {
  if (!hasPauseCount()) {
  return fallback_value;
}
return member_pause_count_;
}
void setPauseCount(uint32_t value) {
  member_pause_count_ = value;
has_pause_count_ = true;
}

bool hasPlayoutId() const {
  return has_playout_id_;
}
const String& playoutId() const {
  DCHECK(hasPlayoutId());
return member_playout_id_;
}
String getPlayoutIdOr(const String& fallback_value) const;
String getPlayoutIdOr(String&& fallback_value) const;
void setPlayoutId(const String& value);
void setPlayoutId(String&& value);

bool hasPliCount() const {
  return has_pli_count_;
}
uint32_t pliCount() const {
  DCHECK(hasPliCount());
return member_pli_count_;
}
uint32_t getPliCountOr(uint32_t fallback_value) const {
  if (!hasPliCount()) {
  return fallback_value;
}
return member_pli_count_;
}
void setPliCount(uint32_t value) {
  member_pli_count_ = value;
has_pli_count_ = true;
}

bool hasPowerEfficientDecoder() const {
  return has_power_efficient_decoder_;
}
bool powerEfficientDecoder() const {
  DCHECK(hasPowerEfficientDecoder());
return member_power_efficient_decoder_;
}
bool getPowerEfficientDecoderOr(bool fallback_value) const {
  if (!hasPowerEfficientDecoder()) {
  return fallback_value;
}
return member_power_efficient_decoder_;
}
void setPowerEfficientDecoder(bool value) {
  member_power_efficient_decoder_ = value;
has_power_efficient_decoder_ = true;
}

bool hasQpSum() const {
  return has_qp_sum_;
}
uint64_t qpSum() const {
  DCHECK(hasQpSum());
return member_qp_sum_;
}
uint64_t getQpSumOr(uint64_t fallback_value) const {
  if (!hasQpSum()) {
  return fallback_value;
}
return member_qp_sum_;
}
void setQpSum(uint64_t value) {
  member_qp_sum_ = value;
has_qp_sum_ = true;
}

bool hasRemoteId() const {
  return has_remote_id_;
}
const String& remoteId() const {
  DCHECK(hasRemoteId());
return member_remote_id_;
}
String getRemoteIdOr(const String& fallback_value) const;
String getRemoteIdOr(String&& fallback_value) const;
void setRemoteId(const String& value);
void setRemoteId(String&& value);

bool hasRemovedSamplesForAcceleration() const {
  return has_removed_samples_for_acceleration_;
}
uint64_t removedSamplesForAcceleration() const {
  DCHECK(hasRemovedSamplesForAcceleration());
return member_removed_samples_for_acceleration_;
}
uint64_t getRemovedSamplesForAccelerationOr(uint64_t fallback_value) const {
  if (!hasRemovedSamplesForAcceleration()) {
  return fallback_value;
}
return member_removed_samples_for_acceleration_;
}
void setRemovedSamplesForAcceleration(uint64_t value) {
  member_removed_samples_for_acceleration_ = value;
has_removed_samples_for_acceleration_ = true;
}

bool hasRetransmittedBytesReceived() const {
  return has_retransmitted_bytes_received_;
}
uint64_t retransmittedBytesReceived() const {
  DCHECK(hasRetransmittedBytesReceived());
return member_retransmitted_bytes_received_;
}
uint64_t getRetransmittedBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasRetransmittedBytesReceived()) {
  return fallback_value;
}
return member_retransmitted_bytes_received_;
}
void setRetransmittedBytesReceived(uint64_t value) {
  member_retransmitted_bytes_received_ = value;
has_retransmitted_bytes_received_ = true;
}

bool hasRetransmittedPacketsReceived() const {
  return has_retransmitted_packets_received_;
}
uint64_t retransmittedPacketsReceived() const {
  DCHECK(hasRetransmittedPacketsReceived());
return member_retransmitted_packets_received_;
}
uint64_t getRetransmittedPacketsReceivedOr(uint64_t fallback_value) const {
  if (!hasRetransmittedPacketsReceived()) {
  return fallback_value;
}
return member_retransmitted_packets_received_;
}
void setRetransmittedPacketsReceived(uint64_t value) {
  member_retransmitted_packets_received_ = value;
has_retransmitted_packets_received_ = true;
}

bool hasRtxSsrc() const {
  return has_rtx_ssrc_;
}
uint32_t rtxSsrc() const {
  DCHECK(hasRtxSsrc());
return member_rtx_ssrc_;
}
uint32_t getRtxSsrcOr(uint32_t fallback_value) const {
  if (!hasRtxSsrc()) {
  return fallback_value;
}
return member_rtx_ssrc_;
}
void setRtxSsrc(uint32_t value) {
  member_rtx_ssrc_ = value;
has_rtx_ssrc_ = true;
}

bool hasSilentConcealedSamples() const {
  return has_silent_concealed_samples_;
}
uint64_t silentConcealedSamples() const {
  DCHECK(hasSilentConcealedSamples());
return member_silent_concealed_samples_;
}
uint64_t getSilentConcealedSamplesOr(uint64_t fallback_value) const {
  if (!hasSilentConcealedSamples()) {
  return fallback_value;
}
return member_silent_concealed_samples_;
}
void setSilentConcealedSamples(uint64_t value) {
  member_silent_concealed_samples_ = value;
has_silent_concealed_samples_ = true;
}

bool hasTotalAssemblyTime() const {
  return has_total_assembly_time_;
}
double totalAssemblyTime() const {
  DCHECK(hasTotalAssemblyTime());
return member_total_assembly_time_;
}
double getTotalAssemblyTimeOr(double fallback_value) const {
  if (!hasTotalAssemblyTime()) {
  return fallback_value;
}
return member_total_assembly_time_;
}
void setTotalAssemblyTime(double value) {
  member_total_assembly_time_ = value;
has_total_assembly_time_ = true;
}

bool hasTotalAudioEnergy() const {
  return has_total_audio_energy_;
}
double totalAudioEnergy() const {
  DCHECK(hasTotalAudioEnergy());
return member_total_audio_energy_;
}
double getTotalAudioEnergyOr(double fallback_value) const {
  if (!hasTotalAudioEnergy()) {
  return fallback_value;
}
return member_total_audio_energy_;
}
void setTotalAudioEnergy(double value) {
  member_total_audio_energy_ = value;
has_total_audio_energy_ = true;
}

bool hasTotalCorruptionProbability() const {
  return has_total_corruption_probability_;
}
double totalCorruptionProbability() const {
  DCHECK(hasTotalCorruptionProbability());
return member_total_corruption_probability_;
}
double getTotalCorruptionProbabilityOr(double fallback_value) const {
  if (!hasTotalCorruptionProbability()) {
  return fallback_value;
}
return member_total_corruption_probability_;
}
void setTotalCorruptionProbability(double value) {
  member_total_corruption_probability_ = value;
has_total_corruption_probability_ = true;
}

bool hasTotalDecodeTime() const {
  return has_total_decode_time_;
}
double totalDecodeTime() const {
  DCHECK(hasTotalDecodeTime());
return member_total_decode_time_;
}
double getTotalDecodeTimeOr(double fallback_value) const {
  if (!hasTotalDecodeTime()) {
  return fallback_value;
}
return member_total_decode_time_;
}
void setTotalDecodeTime(double value) {
  member_total_decode_time_ = value;
has_total_decode_time_ = true;
}

bool hasTotalFreezesDuration() const {
  return has_total_freezes_duration_;
}
double totalFreezesDuration() const {
  DCHECK(hasTotalFreezesDuration());
return member_total_freezes_duration_;
}
double getTotalFreezesDurationOr(double fallback_value) const {
  if (!hasTotalFreezesDuration()) {
  return fallback_value;
}
return member_total_freezes_duration_;
}
void setTotalFreezesDuration(double value) {
  member_total_freezes_duration_ = value;
has_total_freezes_duration_ = true;
}

bool hasTotalInterFrameDelay() const {
  return has_total_inter_frame_delay_;
}
double totalInterFrameDelay() const {
  DCHECK(hasTotalInterFrameDelay());
return member_total_inter_frame_delay_;
}
double getTotalInterFrameDelayOr(double fallback_value) const {
  if (!hasTotalInterFrameDelay()) {
  return fallback_value;
}
return member_total_inter_frame_delay_;
}
void setTotalInterFrameDelay(double value) {
  member_total_inter_frame_delay_ = value;
has_total_inter_frame_delay_ = true;
}

bool hasTotalPausesDuration() const {
  return has_total_pauses_duration_;
}
double totalPausesDuration() const {
  DCHECK(hasTotalPausesDuration());
return member_total_pauses_duration_;
}
double getTotalPausesDurationOr(double fallback_value) const {
  if (!hasTotalPausesDuration()) {
  return fallback_value;
}
return member_total_pauses_duration_;
}
void setTotalPausesDuration(double value) {
  member_total_pauses_duration_ = value;
has_total_pauses_duration_ = true;
}

bool hasTotalProcessingDelay() const {
  return has_total_processing_delay_;
}
double totalProcessingDelay() const {
  DCHECK(hasTotalProcessingDelay());
return member_total_processing_delay_;
}
double getTotalProcessingDelayOr(double fallback_value) const {
  if (!hasTotalProcessingDelay()) {
  return fallback_value;
}
return member_total_processing_delay_;
}
void setTotalProcessingDelay(double value) {
  member_total_processing_delay_ = value;
has_total_processing_delay_ = true;
}

bool hasTotalSamplesDuration() const {
  return has_total_samples_duration_;
}
double totalSamplesDuration() const {
  DCHECK(hasTotalSamplesDuration());
return member_total_samples_duration_;
}
double getTotalSamplesDurationOr(double fallback_value) const {
  if (!hasTotalSamplesDuration()) {
  return fallback_value;
}
return member_total_samples_duration_;
}
void setTotalSamplesDuration(double value) {
  member_total_samples_duration_ = value;
has_total_samples_duration_ = true;
}

bool hasTotalSamplesReceived() const {
  return has_total_samples_received_;
}
uint64_t totalSamplesReceived() const {
  DCHECK(hasTotalSamplesReceived());
return member_total_samples_received_;
}
uint64_t getTotalSamplesReceivedOr(uint64_t fallback_value) const {
  if (!hasTotalSamplesReceived()) {
  return fallback_value;
}
return member_total_samples_received_;
}
void setTotalSamplesReceived(uint64_t value) {
  member_total_samples_received_ = value;
has_total_samples_received_ = true;
}

bool hasTotalSquaredCorruptionProbability() const {
  return has_total_squared_corruption_probability_;
}
double totalSquaredCorruptionProbability() const {
  DCHECK(hasTotalSquaredCorruptionProbability());
return member_total_squared_corruption_probability_;
}
double getTotalSquaredCorruptionProbabilityOr(double fallback_value) const {
  if (!hasTotalSquaredCorruptionProbability()) {
  return fallback_value;
}
return member_total_squared_corruption_probability_;
}
void setTotalSquaredCorruptionProbability(double value) {
  member_total_squared_corruption_probability_ = value;
has_total_squared_corruption_probability_ = true;
}

bool hasTotalSquaredInterFrameDelay() const {
  return has_total_squared_inter_frame_delay_;
}
double totalSquaredInterFrameDelay() const {
  DCHECK(hasTotalSquaredInterFrameDelay());
return member_total_squared_inter_frame_delay_;
}
double getTotalSquaredInterFrameDelayOr(double fallback_value) const {
  if (!hasTotalSquaredInterFrameDelay()) {
  return fallback_value;
}
return member_total_squared_inter_frame_delay_;
}
void setTotalSquaredInterFrameDelay(double value) {
  member_total_squared_inter_frame_delay_ = value;
has_total_squared_inter_frame_delay_ = true;
}

bool hasTrackIdentifier() const {
  return true;
}
const String& trackIdentifier() const {
  return member_track_identifier_;
}
void setTrackIdentifier(const String& value);
void setTrackIdentifier(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCReceivedRtpStreamStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 57;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_level_ = false;
bool has_bytes_received_ = false;
bool has_concealed_samples_ = false;
bool has_concealment_events_ = false;
bool has_content_type_ = false;
bool has_corruption_measurements_ = false;
bool has_decoder_implementation_ = false;
bool has_estimated_playout_timestamp_ = false;
bool has_fec_bytes_received_ = false;
bool has_fec_packets_discarded_ = false;
bool has_fec_packets_received_ = false;
bool has_fec_ssrc_ = false;
bool has_fir_count_ = false;
bool has_frame_height_ = false;
bool has_frame_width_ = false;
bool has_frames_assembled_from_multiple_packets_ = false;
bool has_frames_decoded_ = false;
bool has_frames_dropped_ = false;
bool has_frames_per_second_ = false;
bool has_frames_received_ = false;
bool has_freeze_count_ = false;
bool has_goog_timing_frame_info_ = false;
bool has_header_bytes_received_ = false;
bool has_inserted_samples_for_deceleration_ = false;
bool has_jitter_buffer_delay_ = false;
bool has_jitter_buffer_emitted_count_ = false;
bool has_jitter_buffer_minimum_delay_ = false;
bool has_jitter_buffer_target_delay_ = false;
bool has_key_frames_decoded_ = false;
bool has_last_packet_received_timestamp_ = false;
bool has_mid_ = false;
bool has_nack_count_ = false;
bool has_packets_discarded_ = false;
bool has_pause_count_ = false;
bool has_playout_id_ = false;
bool has_pli_count_ = false;
bool has_power_efficient_decoder_ = false;
bool has_qp_sum_ = false;
bool has_remote_id_ = false;
bool has_removed_samples_for_acceleration_ = false;
bool has_retransmitted_bytes_received_ = false;
bool has_retransmitted_packets_received_ = false;
bool has_rtx_ssrc_ = false;
bool has_silent_concealed_samples_ = false;
bool has_total_assembly_time_ = false;
bool has_total_audio_energy_ = false;
bool has_total_corruption_probability_ = false;
bool has_total_decode_time_ = false;
bool has_total_freezes_duration_ = false;
bool has_total_inter_frame_delay_ = false;
bool has_total_pauses_duration_ = false;
bool has_total_processing_delay_ = false;
bool has_total_samples_duration_ = false;
bool has_total_samples_received_ = false;
bool has_total_squared_corruption_probability_ = false;
bool has_total_squared_inter_frame_delay_ = false;

double member_audio_level_;
uint64_t member_bytes_received_;
uint64_t member_concealed_samples_;
uint64_t member_concealment_events_;
String member_content_type_;
uint64_t member_corruption_measurements_;
String member_decoder_implementation_;
double member_estimated_playout_timestamp_;
uint64_t member_fec_bytes_received_;
uint64_t member_fec_packets_discarded_;
uint64_t member_fec_packets_received_;
uint32_t member_fec_ssrc_;
uint32_t member_fir_count_;
uint32_t member_frame_height_;
uint32_t member_frame_width_;
uint32_t member_frames_assembled_from_multiple_packets_;
uint32_t member_frames_decoded_;
uint32_t member_frames_dropped_;
double member_frames_per_second_;
uint32_t member_frames_received_;
uint32_t member_freeze_count_;
String member_goog_timing_frame_info_;
uint64_t member_header_bytes_received_;
uint64_t member_inserted_samples_for_deceleration_;
double member_jitter_buffer_delay_;
uint64_t member_jitter_buffer_emitted_count_;
double member_jitter_buffer_minimum_delay_;
double member_jitter_buffer_target_delay_;
uint32_t member_key_frames_decoded_;
double member_last_packet_received_timestamp_;
String member_mid_;
uint32_t member_nack_count_;
uint64_t member_packets_discarded_;
uint32_t member_pause_count_;
String member_playout_id_;
uint32_t member_pli_count_;
bool member_power_efficient_decoder_;
uint64_t member_qp_sum_;
String member_remote_id_;
uint64_t member_removed_samples_for_acceleration_;
uint64_t member_retransmitted_bytes_received_;
uint64_t member_retransmitted_packets_received_;
uint32_t member_rtx_ssrc_;
uint64_t member_silent_concealed_samples_;
double member_total_assembly_time_;
double member_total_audio_energy_;
double member_total_corruption_probability_;
double member_total_decode_time_;
double member_total_freezes_duration_;
double member_total_inter_frame_delay_;
double member_total_pauses_duration_;
double member_total_processing_delay_;
double member_total_samples_duration_;
uint64_t member_total_samples_received_;
double member_total_squared_corruption_probability_;
double member_total_squared_inter_frame_delay_;
String member_track_identifier_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_INBOUND_RTP_STREAM_STATS_H_
