// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCIceParameters : public bindings::DictionaryBase {
  
  public:
static RTCIceParameters* Create() {
  return MakeGarbageCollected<RTCIceParameters>();
}
static RTCIceParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCIceParameters>(isolate);
}
static RTCIceParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCIceParameters();
explicit  RTCIceParameters(v8::Isolate* isolate);

bool hasPassword() const {
  return has_password_;
}
const String& password() const {
  DCHECK(hasPassword());
return member_password_;
}
String getPasswordOr(const String& fallback_value) const;
String getPasswordOr(String&& fallback_value) const;
void setPassword(const String& value);
void setPassword(String&& value);

bool hasUsernameFragment() const {
  return has_username_fragment_;
}
const String& usernameFragment() const {
  DCHECK(hasUsernameFragment());
return member_username_fragment_;
}
String getUsernameFragmentOr(const String& fallback_value) const;
String getUsernameFragmentOr(String&& fallback_value) const;
void setUsernameFragment(const String& value);
void setUsernameFragment(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_password_ = false;
bool has_username_fragment_ = false;

String member_password_;
String member_username_fragment_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_PARAMETERS_H_
