// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats_ice_candidate_pair_state.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCIceCandidatePairStats : public RTCStats {
  
  public:
static RTCIceCandidatePairStats* Create() {
  return MakeGarbageCollected<RTCIceCandidatePairStats>();
}
static RTCIceCandidatePairStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCIceCandidatePairStats>(isolate);
}
static RTCIceCandidatePairStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCIceCandidatePairStats();
explicit  RTCIceCandidatePairStats(v8::Isolate* isolate);

bool hasAvailableIncomingBitrate() const {
  return has_available_incoming_bitrate_;
}
double availableIncomingBitrate() const {
  DCHECK(hasAvailableIncomingBitrate());
return member_available_incoming_bitrate_;
}
double getAvailableIncomingBitrateOr(double fallback_value) const {
  if (!hasAvailableIncomingBitrate()) {
  return fallback_value;
}
return member_available_incoming_bitrate_;
}
void setAvailableIncomingBitrate(double value) {
  member_available_incoming_bitrate_ = value;
has_available_incoming_bitrate_ = true;
}

bool hasAvailableOutgoingBitrate() const {
  return has_available_outgoing_bitrate_;
}
double availableOutgoingBitrate() const {
  DCHECK(hasAvailableOutgoingBitrate());
return member_available_outgoing_bitrate_;
}
double getAvailableOutgoingBitrateOr(double fallback_value) const {
  if (!hasAvailableOutgoingBitrate()) {
  return fallback_value;
}
return member_available_outgoing_bitrate_;
}
void setAvailableOutgoingBitrate(double value) {
  member_available_outgoing_bitrate_ = value;
has_available_outgoing_bitrate_ = true;
}

bool hasBytesDiscardedOnSend() const {
  return has_bytes_discarded_on_send_;
}
uint64_t bytesDiscardedOnSend() const {
  DCHECK(hasBytesDiscardedOnSend());
return member_bytes_discarded_on_send_;
}
uint64_t getBytesDiscardedOnSendOr(uint64_t fallback_value) const {
  if (!hasBytesDiscardedOnSend()) {
  return fallback_value;
}
return member_bytes_discarded_on_send_;
}
void setBytesDiscardedOnSend(uint64_t value) {
  member_bytes_discarded_on_send_ = value;
has_bytes_discarded_on_send_ = true;
}

bool hasBytesReceived() const {
  return has_bytes_received_;
}
uint64_t bytesReceived() const {
  DCHECK(hasBytesReceived());
return member_bytes_received_;
}
uint64_t getBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasBytesReceived()) {
  return fallback_value;
}
return member_bytes_received_;
}
void setBytesReceived(uint64_t value) {
  member_bytes_received_ = value;
has_bytes_received_ = true;
}

bool hasBytesSent() const {
  return has_bytes_sent_;
}
uint64_t bytesSent() const {
  DCHECK(hasBytesSent());
return member_bytes_sent_;
}
uint64_t getBytesSentOr(uint64_t fallback_value) const {
  if (!hasBytesSent()) {
  return fallback_value;
}
return member_bytes_sent_;
}
void setBytesSent(uint64_t value) {
  member_bytes_sent_ = value;
has_bytes_sent_ = true;
}

bool hasConsentRequestsSent() const {
  return has_consent_requests_sent_;
}
uint64_t consentRequestsSent() const {
  DCHECK(hasConsentRequestsSent());
return member_consent_requests_sent_;
}
uint64_t getConsentRequestsSentOr(uint64_t fallback_value) const {
  if (!hasConsentRequestsSent()) {
  return fallback_value;
}
return member_consent_requests_sent_;
}
void setConsentRequestsSent(uint64_t value) {
  member_consent_requests_sent_ = value;
has_consent_requests_sent_ = true;
}

bool hasCurrentRoundTripTime() const {
  return has_current_round_trip_time_;
}
double currentRoundTripTime() const {
  DCHECK(hasCurrentRoundTripTime());
return member_current_round_trip_time_;
}
double getCurrentRoundTripTimeOr(double fallback_value) const {
  if (!hasCurrentRoundTripTime()) {
  return fallback_value;
}
return member_current_round_trip_time_;
}
void setCurrentRoundTripTime(double value) {
  member_current_round_trip_time_ = value;
has_current_round_trip_time_ = true;
}

bool hasLastPacketReceivedTimestamp() const {
  return has_last_packet_received_timestamp_;
}
double lastPacketReceivedTimestamp() const {
  DCHECK(hasLastPacketReceivedTimestamp());
return member_last_packet_received_timestamp_;
}
double getLastPacketReceivedTimestampOr(double fallback_value) const {
  if (!hasLastPacketReceivedTimestamp()) {
  return fallback_value;
}
return member_last_packet_received_timestamp_;
}
void setLastPacketReceivedTimestamp(double value) {
  member_last_packet_received_timestamp_ = value;
has_last_packet_received_timestamp_ = true;
}

bool hasLastPacketSentTimestamp() const {
  return has_last_packet_sent_timestamp_;
}
double lastPacketSentTimestamp() const {
  DCHECK(hasLastPacketSentTimestamp());
return member_last_packet_sent_timestamp_;
}
double getLastPacketSentTimestampOr(double fallback_value) const {
  if (!hasLastPacketSentTimestamp()) {
  return fallback_value;
}
return member_last_packet_sent_timestamp_;
}
void setLastPacketSentTimestamp(double value) {
  member_last_packet_sent_timestamp_ = value;
has_last_packet_sent_timestamp_ = true;
}

bool hasLocalCandidateId() const {
  return true;
}
const String& localCandidateId() const {
  return member_local_candidate_id_;
}
void setLocalCandidateId(const String& value);
void setLocalCandidateId(String&& value);

bool hasNominated() const {
  return has_nominated_;
}
bool nominated() const {
  DCHECK(hasNominated());
return member_nominated_;
}
bool getNominatedOr(bool fallback_value) const {
  if (!hasNominated()) {
  return fallback_value;
}
return member_nominated_;
}
void setNominated(bool value) {
  member_nominated_ = value;
has_nominated_ = true;
}

bool hasPacketsDiscardedOnSend() const {
  return has_packets_discarded_on_send_;
}
uint32_t packetsDiscardedOnSend() const {
  DCHECK(hasPacketsDiscardedOnSend());
return member_packets_discarded_on_send_;
}
uint32_t getPacketsDiscardedOnSendOr(uint32_t fallback_value) const {
  if (!hasPacketsDiscardedOnSend()) {
  return fallback_value;
}
return member_packets_discarded_on_send_;
}
void setPacketsDiscardedOnSend(uint32_t value) {
  member_packets_discarded_on_send_ = value;
has_packets_discarded_on_send_ = true;
}

bool hasPacketsReceived() const {
  return has_packets_received_;
}
uint64_t packetsReceived() const {
  DCHECK(hasPacketsReceived());
return member_packets_received_;
}
uint64_t getPacketsReceivedOr(uint64_t fallback_value) const {
  if (!hasPacketsReceived()) {
  return fallback_value;
}
return member_packets_received_;
}
void setPacketsReceived(uint64_t value) {
  member_packets_received_ = value;
has_packets_received_ = true;
}

bool hasPacketsSent() const {
  return has_packets_sent_;
}
uint64_t packetsSent() const {
  DCHECK(hasPacketsSent());
return member_packets_sent_;
}
uint64_t getPacketsSentOr(uint64_t fallback_value) const {
  if (!hasPacketsSent()) {
  return fallback_value;
}
return member_packets_sent_;
}
void setPacketsSent(uint64_t value) {
  member_packets_sent_ = value;
has_packets_sent_ = true;
}

bool hasPriority() const {
  return has_priority_;
}
uint64_t priority() const {
  DCHECK(hasPriority());
return member_priority_;
}
uint64_t getPriorityOr(uint64_t fallback_value) const {
  if (!hasPriority()) {
  return fallback_value;
}
return member_priority_;
}
void setPriority(uint64_t value) {
  member_priority_ = value;
has_priority_ = true;
}

bool hasRemoteCandidateId() const {
  return true;
}
const String& remoteCandidateId() const {
  return member_remote_candidate_id_;
}
void setRemoteCandidateId(const String& value);
void setRemoteCandidateId(String&& value);

bool hasRequestsReceived() const {
  return has_requests_received_;
}
uint64_t requestsReceived() const {
  DCHECK(hasRequestsReceived());
return member_requests_received_;
}
uint64_t getRequestsReceivedOr(uint64_t fallback_value) const {
  if (!hasRequestsReceived()) {
  return fallback_value;
}
return member_requests_received_;
}
void setRequestsReceived(uint64_t value) {
  member_requests_received_ = value;
has_requests_received_ = true;
}

bool hasRequestsSent() const {
  return has_requests_sent_;
}
uint64_t requestsSent() const {
  DCHECK(hasRequestsSent());
return member_requests_sent_;
}
uint64_t getRequestsSentOr(uint64_t fallback_value) const {
  if (!hasRequestsSent()) {
  return fallback_value;
}
return member_requests_sent_;
}
void setRequestsSent(uint64_t value) {
  member_requests_sent_ = value;
has_requests_sent_ = true;
}

bool hasResponsesReceived() const {
  return has_responses_received_;
}
uint64_t responsesReceived() const {
  DCHECK(hasResponsesReceived());
return member_responses_received_;
}
uint64_t getResponsesReceivedOr(uint64_t fallback_value) const {
  if (!hasResponsesReceived()) {
  return fallback_value;
}
return member_responses_received_;
}
void setResponsesReceived(uint64_t value) {
  member_responses_received_ = value;
has_responses_received_ = true;
}

bool hasResponsesSent() const {
  return has_responses_sent_;
}
uint64_t responsesSent() const {
  DCHECK(hasResponsesSent());
return member_responses_sent_;
}
uint64_t getResponsesSentOr(uint64_t fallback_value) const {
  if (!hasResponsesSent()) {
  return fallback_value;
}
return member_responses_sent_;
}
void setResponsesSent(uint64_t value) {
  member_responses_sent_ = value;
has_responses_sent_ = true;
}

bool hasState() const {
  return true;
}
V8RTCStatsIceCandidatePairState state() const {
  return member_state_;
}
void setState(V8RTCStatsIceCandidatePairState value) {
  member_state_ = value;
}
void setState(V8RTCStatsIceCandidatePairState::Enum value) {
  member_state_ = V8RTCStatsIceCandidatePairState(value);
}

bool hasTotalRoundTripTime() const {
  return has_total_round_trip_time_;
}
double totalRoundTripTime() const {
  DCHECK(hasTotalRoundTripTime());
return member_total_round_trip_time_;
}
double getTotalRoundTripTimeOr(double fallback_value) const {
  if (!hasTotalRoundTripTime()) {
  return fallback_value;
}
return member_total_round_trip_time_;
}
void setTotalRoundTripTime(double value) {
  member_total_round_trip_time_ = value;
has_total_round_trip_time_ = true;
}

bool hasTransportId() const {
  return true;
}
const String& transportId() const {
  return member_transport_id_;
}
void setTransportId(const String& value);
void setTransportId(String&& value);

bool hasWritable() const {
  return has_writable_;
}
bool writable() const {
  DCHECK(hasWritable());
return member_writable_;
}
bool getWritableOr(bool fallback_value) const {
  if (!hasWritable()) {
  return fallback_value;
}
return member_writable_;
}
void setWritable(bool value) {
  member_writable_ = value;
has_writable_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 24;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_available_incoming_bitrate_ = false;
bool has_available_outgoing_bitrate_ = false;
bool has_bytes_discarded_on_send_ = false;
bool has_bytes_received_ = false;
bool has_bytes_sent_ = false;
bool has_consent_requests_sent_ = false;
bool has_current_round_trip_time_ = false;
bool has_last_packet_received_timestamp_ = false;
bool has_last_packet_sent_timestamp_ = false;
bool has_nominated_ = false;
bool has_packets_discarded_on_send_ = false;
bool has_packets_received_ = false;
bool has_packets_sent_ = false;
bool has_priority_ = false;
bool has_requests_received_ = false;
bool has_requests_sent_ = false;
bool has_responses_received_ = false;
bool has_responses_sent_ = false;
bool has_total_round_trip_time_ = false;
bool has_writable_ = false;

double member_available_incoming_bitrate_;
double member_available_outgoing_bitrate_;
uint64_t member_bytes_discarded_on_send_;
uint64_t member_bytes_received_;
uint64_t member_bytes_sent_;
uint64_t member_consent_requests_sent_;
double member_current_round_trip_time_;
double member_last_packet_received_timestamp_;
double member_last_packet_sent_timestamp_;
String member_local_candidate_id_;
bool member_nominated_;
uint32_t member_packets_discarded_on_send_;
uint64_t member_packets_received_;
uint64_t member_packets_sent_;
uint64_t member_priority_;
String member_remote_candidate_id_;
uint64_t member_requests_received_;
uint64_t member_requests_sent_;
uint64_t member_responses_received_;
uint64_t member_responses_sent_;
V8RTCStatsIceCandidatePairState member_state_{static_cast<V8RTCStatsIceCandidatePairState::Enum>(0)};
double member_total_round_trip_time_;
String member_transport_id_;
bool member_writable_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_PAIR_STATS_H_
