// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_data_channel_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCDataChannelStats : public RTCStats {
  
  public:
static RTCDataChannelStats* Create() {
  return MakeGarbageCollected<RTCDataChannelStats>();
}
static RTCDataChannelStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCDataChannelStats>(isolate);
}
static RTCDataChannelStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCDataChannelStats();
explicit  RTCDataChannelStats(v8::Isolate* isolate);

bool hasBytesReceived() const {
  return has_bytes_received_;
}
uint64_t bytesReceived() const {
  DCHECK(hasBytesReceived());
return member_bytes_received_;
}
uint64_t getBytesReceivedOr(uint64_t fallback_value) const {
  if (!hasBytesReceived()) {
  return fallback_value;
}
return member_bytes_received_;
}
void setBytesReceived(uint64_t value) {
  member_bytes_received_ = value;
has_bytes_received_ = true;
}

bool hasBytesSent() const {
  return has_bytes_sent_;
}
uint64_t bytesSent() const {
  DCHECK(hasBytesSent());
return member_bytes_sent_;
}
uint64_t getBytesSentOr(uint64_t fallback_value) const {
  if (!hasBytesSent()) {
  return fallback_value;
}
return member_bytes_sent_;
}
void setBytesSent(uint64_t value) {
  member_bytes_sent_ = value;
has_bytes_sent_ = true;
}

bool hasDataChannelIdentifier() const {
  return has_data_channel_identifier_;
}
uint16_t dataChannelIdentifier() const {
  DCHECK(hasDataChannelIdentifier());
return member_data_channel_identifier_;
}
uint16_t getDataChannelIdentifierOr(uint16_t fallback_value) const {
  if (!hasDataChannelIdentifier()) {
  return fallback_value;
}
return member_data_channel_identifier_;
}
void setDataChannelIdentifier(uint16_t value) {
  member_data_channel_identifier_ = value;
has_data_channel_identifier_ = true;
}

bool hasLabel() const {
  return has_label_;
}
const String& label() const {
  DCHECK(hasLabel());
return member_label_;
}
String getLabelOr(const String& fallback_value) const;
String getLabelOr(String&& fallback_value) const;
void setLabel(const String& value);
void setLabel(String&& value);

bool hasMessagesReceived() const {
  return has_messages_received_;
}
uint32_t messagesReceived() const {
  DCHECK(hasMessagesReceived());
return member_messages_received_;
}
uint32_t getMessagesReceivedOr(uint32_t fallback_value) const {
  if (!hasMessagesReceived()) {
  return fallback_value;
}
return member_messages_received_;
}
void setMessagesReceived(uint32_t value) {
  member_messages_received_ = value;
has_messages_received_ = true;
}

bool hasMessagesSent() const {
  return has_messages_sent_;
}
uint32_t messagesSent() const {
  DCHECK(hasMessagesSent());
return member_messages_sent_;
}
uint32_t getMessagesSentOr(uint32_t fallback_value) const {
  if (!hasMessagesSent()) {
  return fallback_value;
}
return member_messages_sent_;
}
void setMessagesSent(uint32_t value) {
  member_messages_sent_ = value;
has_messages_sent_ = true;
}

bool hasProtocol() const {
  return has_protocol_;
}
const String& protocol() const {
  DCHECK(hasProtocol());
return member_protocol_;
}
String getProtocolOr(const String& fallback_value) const;
String getProtocolOr(String&& fallback_value) const;
void setProtocol(const String& value);
void setProtocol(String&& value);

bool hasState() const {
  return true;
}
V8RTCDataChannelState state() const {
  return member_state_;
}
void setState(V8RTCDataChannelState value) {
  member_state_ = value;
}
void setState(V8RTCDataChannelState::Enum value) {
  member_state_ = V8RTCDataChannelState(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bytes_received_ = false;
bool has_bytes_sent_ = false;
bool has_data_channel_identifier_ = false;
bool has_label_ = false;
bool has_messages_received_ = false;
bool has_messages_sent_ = false;
bool has_protocol_ = false;

uint64_t member_bytes_received_;
uint64_t member_bytes_sent_;
uint16_t member_data_channel_identifier_;
String member_label_;
uint32_t member_messages_received_;
uint32_t member_messages_sent_;
String member_protocol_;
V8RTCDataChannelState member_state_{static_cast<V8RTCDataChannelState::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_DATA_CHANNEL_STATS_H_
