// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_audio_source_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"audioLevel",
"echoReturnLoss",
"echoReturnLossEnhancement",
"totalAudioEnergy",
"totalSamplesDuration",
};


}  // namespace 

RTCAudioSourceStats* RTCAudioSourceStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCAudioSourceStats* dictionary = MakeGarbageCollected<RTCAudioSourceStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCAudioSourceStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCAudioSourceStats::RTCAudioSourceStats() {
  
}

 RTCAudioSourceStats::RTCAudioSourceStats(v8::Isolate* isolate) : RTCMediaSourceStats(isolate) {
  
}





































void RTCAudioSourceStats::Trace(Visitor* visitor) const {
  RTCMediaSourceStats::Trace(visitor);
}

void RTCAudioSourceStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCMediaSourceStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCAudioSourceStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCMediaSourceStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAudioLevel()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_audio_level_);
DCHECK(!values[0].IsEmpty());
}
if (hasEchoReturnLoss()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_echo_return_loss_);
DCHECK(!values[1].IsEmpty());
}
if (hasEchoReturnLossEnhancement()) {
  values[2] = ToV8Traits<IDLDouble>::ToV8(script_state, member_echo_return_loss_enhancement_);
DCHECK(!values[2].IsEmpty());
}
if (hasTotalAudioEnergy()) {
  values[3] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_audio_energy_);
DCHECK(!values[3].IsEmpty());
}
if (hasTotalSamplesDuration()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_samples_duration_);
DCHECK(!values[4].IsEmpty());
}
}

const void* RTCAudioSourceStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCAudioSourceStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCAudioSourceStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCMediaSourceStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCAudioSourceStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("audioLevel");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_audio_level_, member_audio_level_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("echoReturnLoss");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_echo_return_loss_, member_echo_return_loss_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("echoReturnLossEnhancement");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_echo_return_loss_enhancement_, member_echo_return_loss_enhancement_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalAudioEnergy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_total_audio_energy_, member_total_audio_energy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalSamplesDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_total_samples_duration_, member_total_samples_duration_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCAudioSourceStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
