// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ANSWER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ANSWER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_offer_answer_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCAnswerOptions : public RTCOfferAnswerOptions {
  
  public:
static RTCAnswerOptions* Create() {
  return MakeGarbageCollected<RTCAnswerOptions>();
}
static RTCAnswerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCAnswerOptions>(isolate);
}
static RTCAnswerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCAnswerOptions();
explicit  RTCAnswerOptions(v8::Isolate* isolate);



void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCOfferAnswerOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 0;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);






  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ANSWER_OPTIONS_H_
