// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_router_condition.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_urlpattern_urlpatterninit_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_pattern_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_router_condition.h"
#include "third_party/blink/renderer/core/url_pattern/url_pattern.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"not",
"or",
"requestDestination",
"requestMethod",
"requestMode",
"runningStatus",
"urlPattern",
};


}  // namespace 

RouterCondition* RouterCondition::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RouterCondition* dictionary = MakeGarbageCollected<RouterCondition>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RouterCondition";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RouterCondition::RouterCondition() {
  
}

 RouterCondition::RouterCondition(v8::Isolate* isolate) {
  
}










HeapVector<Member<RouterCondition>> RouterCondition::getOrConditionsOr(const HeapVector<Member<RouterCondition>>& fallback_value) const {
  if (!hasOrConditions()) {
  return fallback_value;
}
return member_or_conditions_;
}

HeapVector<Member<RouterCondition>> RouterCondition::getOrConditionsOr(HeapVector<Member<RouterCondition>>&& fallback_value) const {
  if (!hasOrConditions()) {
  return std::move(fallback_value);
}
return member_or_conditions_;
}

void RouterCondition::setOrConditions(const HeapVector<Member<RouterCondition>>& value) {
  member_or_conditions_ = value;
has_or_conditions_ = true;
}

void RouterCondition::setOrConditions(HeapVector<Member<RouterCondition>>&& value) {
  member_or_conditions_ = std::move(value);
has_or_conditions_ = true;
}











String RouterCondition::getRequestMethodOr(const String& fallback_value) const {
  if (!hasRequestMethod()) {
  return fallback_value;
}
return member_request_method_;
}

String RouterCondition::getRequestMethodOr(String&& fallback_value) const {
  if (!hasRequestMethod()) {
  return std::move(fallback_value);
}
return member_request_method_;
}

void RouterCondition::setRequestMethod(const String& value) {
  member_request_method_ = value;
has_request_method_ = true;
}

void RouterCondition::setRequestMethod(String&& value) {
  member_request_method_ = std::move(value);
has_request_method_ = true;
}
























void RouterCondition::Trace(Visitor* visitor) const {
  visitor->Trace(member_not_condition_);
visitor->Trace(member_or_conditions_);
visitor->Trace(member_url_pattern_);
bindings::InputDictionaryBase::Trace(visitor);
}

void RouterCondition::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RouterCondition";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("not");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<RouterCondition, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_not_condition_, member_not_condition_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("or");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RouterCondition>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_or_conditions_, member_or_conditions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestDestination");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestDestination, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_request_destination_, member_request_destination_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestMethod");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByteString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_request_method_, member_request_method_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestMode");
if (!bindings::GetDictionaryMemberFromV8Object<V8RequestMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_request_mode_, member_request_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("runningStatus");
if (!bindings::GetDictionaryMemberFromV8Object<V8RunningStatusEnum, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_running_status_, member_running_status_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("urlPattern");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionURLPatternOrURLPatternInitOrUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_url_pattern_, member_url_pattern_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RouterCondition::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
