// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_JS_ON_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_JS_ON_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AuthenticationExtensionsClientInputsJSON;
class ExceptionState;
class PublicKeyCredentialDescriptorJSON;

class MODULES_EXPORT PublicKeyCredentialRequestOptionsJSON : public bindings::InputDictionaryBase {
  
  public:
static PublicKeyCredentialRequestOptionsJSON* Create() {
  return MakeGarbageCollected<PublicKeyCredentialRequestOptionsJSON>();
}
static PublicKeyCredentialRequestOptionsJSON* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialRequestOptionsJSON>(isolate);
}
static PublicKeyCredentialRequestOptionsJSON* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialRequestOptionsJSON();
explicit  PublicKeyCredentialRequestOptionsJSON(v8::Isolate* isolate);

bool hasAllowCredentials() const {
  return true;
}
const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& allowCredentials() const {
  return member_allow_credentials_;
}
void setAllowCredentials(const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& value);
void setAllowCredentials(HeapVector<Member<PublicKeyCredentialDescriptorJSON>>&& value);

bool hasChallenge() const {
  return has_challenge_;
}
const String& challenge() const {
  DCHECK(hasChallenge());
return member_challenge_;
}
String getChallengeOr(const String& fallback_value) const;
String getChallengeOr(String&& fallback_value) const;
void setChallenge(const String& value);
void setChallenge(String&& value);

bool hasChallengeUrl() const {
  return has_challenge_url_;
}
const String& challengeUrl() const {
  DCHECK(hasChallengeUrl());
return member_challenge_url_;
}
String getChallengeUrlOr(const String& fallback_value) const;
String getChallengeUrlOr(String&& fallback_value) const;
void setChallengeUrl(const String& value);
void setChallengeUrl(String&& value);

bool hasExtensions() const {
  return has_extensions_;
}
AuthenticationExtensionsClientInputsJSON* extensions() const {
  DCHECK(hasExtensions());
return member_extensions_.Get();
}
AuthenticationExtensionsClientInputsJSON* getExtensionsOr(AuthenticationExtensionsClientInputsJSON* fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_.Get();
}
void setExtensions(AuthenticationExtensionsClientInputsJSON* value) {
  member_extensions_ = value;
has_extensions_ = true;
DCHECK(member_extensions_);
}

bool hasHints() const {
  return true;
}
const Vector<String>& hints() const {
  return member_hints_;
}
void setHints(const Vector<String>& value);
void setHints(Vector<String>&& value);

bool hasRpId() const {
  return has_rp_id_;
}
const String& rpId() const {
  DCHECK(hasRpId());
return member_rp_id_;
}
String getRpIdOr(const String& fallback_value) const;
String getRpIdOr(String&& fallback_value) const;
void setRpId(const String& value);
void setRpId(String&& value);

bool hasTimeout() const {
  return has_timeout_;
}
uint32_t timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
uint32_t getTimeoutOr(uint32_t fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(uint32_t value) {
  member_timeout_ = value;
has_timeout_ = true;
}

bool hasUserVerification() const {
  return true;
}
const String& userVerification() const {
  return member_user_verification_;
}
void setUserVerification(const String& value);
void setUserVerification(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_challenge_ = false;
bool has_challenge_url_ = false;
bool has_extensions_ = false;
bool has_rp_id_ = false;
bool has_timeout_ = false;

HeapVector<Member<PublicKeyCredentialDescriptorJSON>> member_allow_credentials_;
String member_challenge_;
String member_challenge_url_;
Member<AuthenticationExtensionsClientInputsJSON> member_extensions_;
Vector<String> member_hints_;
String member_rp_id_;
uint32_t member_timeout_;
String member_user_verification_{"preferred"};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_REQUEST_OPTIONS_JS_ON_H_
