// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_creation_options_js_on.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authenticator_selection_criteria.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_descriptor_js_on.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_rp_entity.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_user_entity_js_on.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attestation",
"authenticatorSelection",
"challenge",
"excludeCredentials",
"extensions",
"hints",
"pubKeyCredParams",
"rp",
"timeout",
"user",
};


}  // namespace 

PublicKeyCredentialCreationOptionsJSON* PublicKeyCredentialCreationOptionsJSON::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PublicKeyCredentialCreationOptionsJSON* dictionary = MakeGarbageCollected<PublicKeyCredentialCreationOptionsJSON>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PublicKeyCredentialCreationOptionsJSON";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PublicKeyCredentialCreationOptionsJSON::PublicKeyCredentialCreationOptionsJSON() {
  
}

 PublicKeyCredentialCreationOptionsJSON::PublicKeyCredentialCreationOptionsJSON(v8::Isolate* isolate) {
  
}



void PublicKeyCredentialCreationOptionsJSON::setAttestation(const String& value) {
  member_attestation_ = value;
}

void PublicKeyCredentialCreationOptionsJSON::setAttestation(String&& value) {
  member_attestation_ = std::move(value);
}











void PublicKeyCredentialCreationOptionsJSON::setChallenge(const String& value) {
  member_challenge_ = value;
}

void PublicKeyCredentialCreationOptionsJSON::setChallenge(String&& value) {
  member_challenge_ = std::move(value);
}




void PublicKeyCredentialCreationOptionsJSON::setExcludeCredentials(const HeapVector<Member<PublicKeyCredentialDescriptorJSON>>& value) {
  member_exclude_credentials_ = value;
}

void PublicKeyCredentialCreationOptionsJSON::setExcludeCredentials(HeapVector<Member<PublicKeyCredentialDescriptorJSON>>&& value) {
  member_exclude_credentials_ = std::move(value);
}











void PublicKeyCredentialCreationOptionsJSON::setHints(const Vector<String>& value) {
  member_hints_ = value;
}

void PublicKeyCredentialCreationOptionsJSON::setHints(Vector<String>&& value) {
  member_hints_ = std::move(value);
}




void PublicKeyCredentialCreationOptionsJSON::setPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value) {
  member_pub_key_cred_params_ = value;
}

void PublicKeyCredentialCreationOptionsJSON::setPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value) {
  member_pub_key_cred_params_ = std::move(value);
}




















void PublicKeyCredentialCreationOptionsJSON::Trace(Visitor* visitor) const {
  visitor->Trace(member_authenticator_selection_);
visitor->Trace(member_exclude_credentials_);
visitor->Trace(member_extensions_);
visitor->Trace(member_pub_key_cred_params_);
visitor->Trace(member_rp_);
visitor->Trace(member_user_);
bindings::InputDictionaryBase::Trace(visitor);
}

void PublicKeyCredentialCreationOptionsJSON::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PublicKeyCredentialCreationOptionsJSON";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attestation");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_attestation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("authenticatorSelection");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticatorSelectionCriteria, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_authenticator_selection_, member_authenticator_selection_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_challenge_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("excludeCredentials");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialDescriptorJSON>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_exclude_credentials_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientInputsJSON, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pubKeyCredParams");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialParameters>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_pub_key_cred_params_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rp");
if (!bindings::GetDictionaryMemberFromV8Object<PublicKeyCredentialRpEntity, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_rp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_timeout_, member_timeout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("user");
if (!bindings::GetDictionaryMemberFromV8Object<PublicKeyCredentialUserEntityJSON, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_user_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PublicKeyCredentialCreationOptionsJSON::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
