// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_BASE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_BASE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class PaymentDetailsModifier;
class PaymentItem;
class PaymentShippingOption;

class MODULES_EXPORT PaymentDetailsBase : public bindings::DictionaryBase {
  
  public:
static PaymentDetailsBase* Create() {
  return MakeGarbageCollected<PaymentDetailsBase>();
}
static PaymentDetailsBase* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PaymentDetailsBase>(isolate);
}
static PaymentDetailsBase* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PaymentDetailsBase();
explicit  PaymentDetailsBase(v8::Isolate* isolate);

bool hasDisplayItems() const {
  return has_display_items_;
}
const HeapVector<Member<PaymentItem>>& displayItems() const {
  DCHECK(hasDisplayItems());
return member_display_items_;
}
HeapVector<Member<PaymentItem>> getDisplayItemsOr(const HeapVector<Member<PaymentItem>>& fallback_value) const;
HeapVector<Member<PaymentItem>> getDisplayItemsOr(HeapVector<Member<PaymentItem>>&& fallback_value) const;
void setDisplayItems(const HeapVector<Member<PaymentItem>>& value);
void setDisplayItems(HeapVector<Member<PaymentItem>>&& value);

bool hasModifiers() const {
  return has_modifiers_;
}
const HeapVector<Member<PaymentDetailsModifier>>& modifiers() const {
  DCHECK(hasModifiers());
return member_modifiers_;
}
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(const HeapVector<Member<PaymentDetailsModifier>>& fallback_value) const;
HeapVector<Member<PaymentDetailsModifier>> getModifiersOr(HeapVector<Member<PaymentDetailsModifier>>&& fallback_value) const;
void setModifiers(const HeapVector<Member<PaymentDetailsModifier>>& value);
void setModifiers(HeapVector<Member<PaymentDetailsModifier>>&& value);

bool hasShippingOptions() const {
  return has_shipping_options_;
}
const HeapVector<Member<PaymentShippingOption>>& shippingOptions() const {
  DCHECK(hasShippingOptions());
return member_shipping_options_;
}
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(const HeapVector<Member<PaymentShippingOption>>& fallback_value) const;
HeapVector<Member<PaymentShippingOption>> getShippingOptionsOr(HeapVector<Member<PaymentShippingOption>>&& fallback_value) const;
void setShippingOptions(const HeapVector<Member<PaymentShippingOption>>& value);
void setShippingOptions(HeapVector<Member<PaymentShippingOption>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_display_items_ = false;
bool has_modifiers_ = false;
bool has_shipping_options_ = false;

HeapVector<Member<PaymentItem>> member_display_items_;
HeapVector<Member<PaymentDetailsModifier>> member_modifiers_;
HeapVector<Member<PaymentShippingOption>> member_shipping_options_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PAYMENT_DETAILS_BASE_H_
