// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_path_2d.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix_2d_init.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point_init.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_dompointinit_unrestricteddouble.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_path2d_string.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/path_2d.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8Path2D::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsPaintWorkletGlobalScope() || execution_context->IsWindow() || execution_context->IsWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8Path2D::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8Path2D::InstallInterfaceTemplate,
    nullptr,
    "Path2D",
    nullptr,
    V8Path2D::kThisTag,
    V8Path2D::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& Path2D::wrapper_type_info_ =
    V8Path2D::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, Path2D>::value,
    "Path2D inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_path_2d {

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_constructor");
BLINK_BINDINGS_TRACE_EVENT("Path2D.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
v8::Local<v8::Object> v8_receiver = info.This();
if (V8PerIsolateData::From(isolate)->InWrapperConstructor()) {
  bindings::V8SetReturnValue(info, v8_receiver);
return;
}



Path2D* return_value;
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ScriptState* script_state = current_script_state;
if (non_undefined_argument_length <= 0) {
  return_value = Path2D::Create(script_state);
break;
}
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<V8UnionPath2DOrString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = Path2D::Create(script_state, arg1_path);
} while (false);
v8::Local<v8::Object> v8_wrapper = return_value->AssociateWithWrapper(isolate, V8Path2D::GetWrapperTypeInfo(), v8_receiver);
bindings::V8SetReturnValue(info, v8_wrapper);
}

void AddPathOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_addPath");
BLINK_BINDINGS_TRACE_EVENT("Path2D.addPath");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<DOMMatrix2DInit>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_transform;
if (info[1]->IsUndefined()) {
  arg2_transform = DOMMatrix2DInit::Create();
} else {
  arg2_transform = NativeValueTraits<DOMMatrix2DInit>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->addPath(arg1_path, arg2_transform, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ArcOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius, double v8_arg4_start_angle, double v8_arg5_end_angle, bool v8_arg6_anticlockwise, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius = v8_arg3_radius;
auto&& arg4_start_angle = v8_arg4_start_angle;
auto&& arg5_end_angle = v8_arg5_end_angle;
auto&& arg6_anticlockwise = v8_arg6_anticlockwise;
ExceptionState exception_state(isolate);
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius, double v8_arg4_start_angle, double v8_arg5_end_angle, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius = v8_arg3_radius;
auto&& arg4_start_angle = v8_arg4_start_angle;
auto&& arg5_end_angle = v8_arg5_end_angle;
auto&& arg6_anticlockwise{false};
ExceptionState exception_state(isolate);
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_arc");
BLINK_BINDINGS_TRACE_EVENT("Path2D.arc");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.arc", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_radius = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_start_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_end_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg6_anticlockwise{false};
if (!info[5]->IsUndefined()) {
  arg6_anticlockwise = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ArcToOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x_1, double v8_arg2_y_1, double v8_arg3_x_2, double v8_arg4_y_2, double v8_arg5_radius, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x_1 = v8_arg1_x_1;
auto&& arg2_y_1 = v8_arg2_y_1;
auto&& arg3_x_2 = v8_arg3_x_2;
auto&& arg4_y_2 = v8_arg4_y_2;
auto&& arg5_radius = v8_arg5_radius;
ExceptionState exception_state(isolate);
blink_receiver->arcTo(arg1_x_1, arg2_y_1, arg3_x_2, arg4_y_2, arg5_radius, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_arcTo");
BLINK_BINDINGS_TRACE_EVENT("Path2D.arcTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x_1 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y_1 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x_2 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y_2 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_radius = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->arcTo(arg1_x_1, arg2_y_1, arg3_x_2, arg4_y_2, arg5_radius, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void BezierCurveToOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_cp_1_x, double v8_arg2_cp_1_y, double v8_arg3_cp_2_x, double v8_arg4_cp_2_y, double v8_arg5_x, double v8_arg6_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_cp_1_x = v8_arg1_cp_1_x;
auto&& arg2_cp_1_y = v8_arg2_cp_1_y;
auto&& arg3_cp_2_x = v8_arg3_cp_2_x;
auto&& arg4_cp_2_y = v8_arg4_cp_2_y;
auto&& arg5_x = v8_arg5_x;
auto&& arg6_y = v8_arg6_y;
blink_receiver->bezierCurveTo(arg1_cp_1_x, arg2_cp_1_y, arg3_cp_2_x, arg4_cp_2_y, arg5_x, arg6_y);
}

void BezierCurveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_bezierCurveTo");
BLINK_BINDINGS_TRACE_EVENT("Path2D.bezierCurveTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cp_1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_cp_1_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_cp_2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_cp_2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bezierCurveTo(arg1_cp_1_x, arg2_cp_1_y, arg3_cp_2_x, arg4_cp_2_y, arg5_x, arg6_y);

}

void ClosePathOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->closePath();
}

void ClosePathOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_closePath");
BLINK_BINDINGS_TRACE_EVENT("Path2D.closePath");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.closePath", info);




v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->closePath();

}

void EllipseOperationNoAllocDirectCallArg8(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius_x, double v8_arg4_radius_y, double v8_arg5_rotation, double v8_arg6_start_angle, double v8_arg7_end_angle, bool v8_arg8_anticlockwise, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius_x = v8_arg3_radius_x;
auto&& arg4_radius_y = v8_arg4_radius_y;
auto&& arg5_rotation = v8_arg5_rotation;
auto&& arg6_start_angle = v8_arg6_start_angle;
auto&& arg7_end_angle = v8_arg7_end_angle;
auto&& arg8_anticlockwise = v8_arg8_anticlockwise;
ExceptionState exception_state(isolate);
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void EllipseOperationNoAllocDirectCallArg7(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius_x, double v8_arg4_radius_y, double v8_arg5_rotation, double v8_arg6_start_angle, double v8_arg7_end_angle, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius_x = v8_arg3_radius_x;
auto&& arg4_radius_y = v8_arg4_radius_y;
auto&& arg5_rotation = v8_arg5_rotation;
auto&& arg6_start_angle = v8_arg6_start_angle;
auto&& arg7_end_angle = v8_arg7_end_angle;
auto&& arg8_anticlockwise{false};
ExceptionState exception_state(isolate);
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void EllipseOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_ellipse");
BLINK_BINDINGS_TRACE_EVENT("Path2D.ellipse");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.ellipse", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_radius_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_radius_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_rotation = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_start_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_end_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg8_anticlockwise{false};
if (!info[7]->IsUndefined()) {
  arg8_anticlockwise = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void LineToOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->lineTo(arg1_x, arg2_y);
}

void LineToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_lineTo");
BLINK_BINDINGS_TRACE_EVENT("Path2D.lineTo");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.lineTo", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->lineTo(arg1_x, arg2_y);

}

void MoveToOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->moveTo(arg1_x, arg2_y);
}

void MoveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_moveTo");
BLINK_BINDINGS_TRACE_EVENT("Path2D.moveTo");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.moveTo", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->moveTo(arg1_x, arg2_y);

}

void QuadraticCurveToOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_cpx, double v8_arg2_cpy, double v8_arg3_x, double v8_arg4_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_cpx = v8_arg1_cpx;
auto&& arg2_cpy = v8_arg2_cpy;
auto&& arg3_x = v8_arg3_x;
auto&& arg4_y = v8_arg4_y;
blink_receiver->quadraticCurveTo(arg1_cpx, arg2_cpy, arg3_x, arg4_y);
}

void QuadraticCurveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_quadraticCurveTo");
BLINK_BINDINGS_TRACE_EVENT("Path2D.quadraticCurveTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cpx = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_cpy = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->quadraticCurveTo(arg1_cpx, arg2_cpy, arg3_x, arg4_y);

}

void RectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_width, double v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->rect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void RectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_rect");
BLINK_BINDINGS_TRACE_EVENT("Path2D.rect");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.rect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->rect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void RoundRectOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.roundRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_w = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_h = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_radii = NativeValueTraits<IDLSequence<V8UnionDOMPointInitOrUnrestrictedDouble>>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->roundRect(arg1_x, arg2_y, arg3_w, arg4_h, std::move(arg5_radii), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RoundRectOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Path2D.roundRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Path2D* blink_receiver = V8Path2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_w = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_h = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<V8UnionDOMPointInitOrUnrestrictedDouble>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_radii;
if (info[4]->IsUndefined()) {
  arg5_radii = MakeGarbageCollected<V8UnionDOMPointInitOrUnrestrictedDouble>(0);
} else {
  arg5_radii = NativeValueTraits<V8UnionDOMPointInitOrUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->roundRect(arg1_x, arg2_y, arg3_w, arg4_h, arg5_radii, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RoundRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Path2D_roundRect");
BLINK_BINDINGS_TRACE_EVENT("Path2D.roundRect");


const int arg_count = std::min(info.Length(), 5);
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 5) {
  if (info[4]->IsUndefined()) {
  return RoundRectOperationOverload2(info);
}
if (info[4]->IsNullOrUndefined()) {
  return RoundRectOperationOverload2(info);
}
if (info[4]->IsObject()) {
  ExceptionState exception_state(isolate);
if (info[4]->IsArray() || bindings::IsEsIterableObject(isolate, info[4], exception_state)) {
  return RoundRectOperationOverload1(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return RoundRectOperationOverload2(info);
}
if (info[4]->IsNumber()) {
  return RoundRectOperationOverload2(info);
}
return RoundRectOperationOverload2(info);
}
if (arg_count == 4) {
  return RoundRectOperationOverload2(info);
}

if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}


}  // namespace v8_path_2d

using namespace v8_path_2d;

}  // namespace 

void V8Path2D::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8Path2D::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "Path2D"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8Path2D::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"addPath", AddPathOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"roundRect", RoundRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Path2D", kOperationTable);
}


{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfArc[] = {
v8::CFunctionBuilder().Fn(ArcOperationNoAllocDirectCallArg6).Build(),
v8::CFunctionBuilder().Fn(ArcOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfArcTo[] = {
v8::CFunctionBuilder().Fn(ArcToOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBezierCurveTo[] = {
v8::CFunctionBuilder().Fn(BezierCurveToOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClosePath[] = {
v8::CFunctionBuilder().Fn(ClosePathOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEllipse[] = {
v8::CFunctionBuilder().Fn(EllipseOperationNoAllocDirectCallArg8).Build(),
v8::CFunctionBuilder().Fn(EllipseOperationNoAllocDirectCallArg7).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfLineTo[] = {
v8::CFunctionBuilder().Fn(LineToOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMoveTo[] = {
v8::CFunctionBuilder().Fn(MoveToOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfQuadraticCurveTo[] = {
v8::CFunctionBuilder().Fn(QuadraticCurveToOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfRect[] = {
v8::CFunctionBuilder().Fn(RectOperationNoAllocDirectCallArg4).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"arc", ArcOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfArc, std::size(kNoAllocDirectCallOverloadsOfArc)}, 
{{"arcTo", ArcToOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfArcTo, std::size(kNoAllocDirectCallOverloadsOfArcTo)}, 
{{"bezierCurveTo", BezierCurveToOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBezierCurveTo, std::size(kNoAllocDirectCallOverloadsOfBezierCurveTo)}, 
{{"closePath", ClosePathOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClosePath, std::size(kNoAllocDirectCallOverloadsOfClosePath)}, 
{{"ellipse", EllipseOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEllipse, std::size(kNoAllocDirectCallOverloadsOfEllipse)}, 
{{"lineTo", LineToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfLineTo, std::size(kNoAllocDirectCallOverloadsOfLineTo)}, 
{{"moveTo", MoveToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMoveTo, std::size(kNoAllocDirectCallOverloadsOfMoveTo)}, 
{{"quadraticCurveTo", QuadraticCurveToOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfQuadraticCurveTo, std::size(kNoAllocDirectCallOverloadsOfQuadraticCurveTo)}, 
{{"rect", RectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfRect, std::size(kNoAllocDirectCallOverloadsOfRect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Path2D", kOperationTable);
}


}




}  // namespace blink
