// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_offscreen_canvas_rendering_context_2d.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_text_align.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_text_baseline.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_css_image_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_matrix_init.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_point_init.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_video_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data_settings.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_svg_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_cluster.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_cluster_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_text_metrics.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_dompointinit_unrestricteddouble.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_begin_layer_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_2d_gpu_transfer_option.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_direction.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_fill_rule.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_font_kerning.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_font_stretch.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_font_variant_caps.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_gradient.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_pattern.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_rendering_context_2d_settings.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_text_rendering.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_image_smoothing_quality.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_index_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_uv_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mesh_2d_vertex_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_path_2d.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_canvasfilter_string.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_cssimagevalue_htmlcanvaselement_htmlimageelement_htmlvideoelement_imagebitmap_offscreencanvas_svgimageelement_videoframe.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/core/css/cssom/css_style_image_value.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/geometry/dom_matrix.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/html/canvas/image_data.h"
#include "third_party/blink/renderer/core/html/canvas/text_cluster.h"
#include "third_party/blink/renderer/core/html/canvas/text_metrics.h"
#include "third_party/blink/renderer/core/html/html_image_element.h"
#include "third_party/blink/renderer/core/html/media/html_video_element.h"
#include "third_party/blink/renderer/core/imagebitmap/image_bitmap.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/core/svg/svg_image_element.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/canvas_filter.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/canvas_gradient.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/canvas_pattern.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/mesh_2d_index_buffer.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/mesh_2d_uv_buffer.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/mesh_2d_vertex_buffer.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/path_2d.h"
#include "third_party/blink/renderer/modules/canvas/offscreencanvas2d/offscreen_canvas_rendering_context_2d.h"
#include "third_party/blink/renderer/modules/webcodecs/video_frame.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8OffscreenCanvasRenderingContext2D::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() || execution_context->IsWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8OffscreenCanvasRenderingContext2D::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8OffscreenCanvasRenderingContext2D::InstallInterfaceTemplate,
    V8OffscreenCanvasRenderingContext2D::InstallContextDependentProperties,
    "OffscreenCanvasRenderingContext2D",
    nullptr,
    V8OffscreenCanvasRenderingContext2D::kThisTag,
    V8OffscreenCanvasRenderingContext2D::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& OffscreenCanvasRenderingContext2D::wrapper_type_info_ =
    V8OffscreenCanvasRenderingContext2D::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, OffscreenCanvasRenderingContext2D>::value,
    "OffscreenCanvasRenderingContext2D does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_offscreen_canvas_rendering_context_2d {


void CanvasAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_canvas_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.canvas.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->offscreenCanvasForBinding();
static_assert(bindings::IsReturnTypeCompatible<OffscreenCanvas, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LangAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lang_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lang.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->lang();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LangAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lang_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lang.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLang(arg1_value);

}


void FontAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_font_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.font.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.font.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->font();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FontAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_font_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.font.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.font.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFont(arg1_value);

}


void TextAlignAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textAlign_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textAlign.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->textAlign();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasTextAlign, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TextAlignAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textAlign_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textAlign.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasTextAlign::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasTextAlign", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setTextAlign(arg1_value);

}


void TextBaselineAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textBaseline_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textBaseline.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->textBaseline();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasTextBaseline, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TextBaselineAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textBaseline_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textBaseline.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasTextBaseline::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasTextBaseline", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setTextBaseline(arg1_value);

}


void DirectionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_direction_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.direction.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->direction();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasDirection, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void DirectionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_direction_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.direction.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasDirection::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasDirection", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setDirection(arg1_value);

}


void FontKerningAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontKerning_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontKerning.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->fontKerning();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasFontKerning, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FontKerningAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontKerning_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontKerning.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasFontKerning::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasFontKerning", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setFontKerning(arg1_value);

}


void FontStretchAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontStretch_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontStretch.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->fontStretch();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasFontStretch, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FontStretchAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontStretch_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontStretch.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasFontStretch::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasFontStretch", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setFontStretch(arg1_value);

}


void FontVariantCapsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontVariantCaps_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontVariantCaps.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->fontVariantCaps();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasFontVariantCaps, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FontVariantCapsAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fontVariantCaps_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fontVariantCaps.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasFontVariantCaps::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasFontVariantCaps", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setFontVariantCaps(arg1_value);

}


void LetterSpacingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_letterSpacing_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.letterSpacing.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->letterSpacing();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LetterSpacingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_letterSpacing_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.letterSpacing.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLetterSpacing(arg1_value);

}


void TextRenderingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textRendering_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textRendering.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->textRendering();
static_assert(bindings::IsReturnTypeCompatible<V8CanvasTextRendering, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TextRenderingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_textRendering_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.textRendering.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8CanvasTextRendering::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "CanvasTextRendering", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setTextRendering(arg1_value);

}


void WordSpacingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_wordSpacing_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.wordSpacing.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->wordSpacing();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void WordSpacingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_wordSpacing_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.wordSpacing.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setWordSpacing(arg1_value);

}

void GlobalAlphaAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setGlobalAlpha(blink_value);
}

void GlobalAlphaAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalAlpha_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalAlpha.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->globalAlpha();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void GlobalAlphaAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalAlpha_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalAlpha.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setGlobalAlpha(arg1_value);

}


void GlobalCompositeOperationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalCompositeOperation_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalCompositeOperation.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.globalCompositeOperation.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->globalCompositeOperation();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void GlobalCompositeOperationAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalCompositeOperation_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalCompositeOperation.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.globalCompositeOperation.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setGlobalCompositeOperation(arg1_value);

}


void FilterAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_filter_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.filter.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DFilter);



v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->filter();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<V8UnionCanvasFilterOrString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<V8UnionCanvasFilterOrString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void FilterAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_filter_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.filter.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DFilter);


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLNullable<V8UnionCanvasFilterOrString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFilter(script_state, arg1_value);

}


void GlobalHDRHeadroomAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalHDRHeadroom_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalHDRHeadroom.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->globalHDRHeadroom();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void GlobalHDRHeadroomAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_globalHDRHeadroom_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.globalHDRHeadroom.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setGlobalHDRHeadroom(arg1_value);

}

void ImageSmoothingEnabledAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, bool value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setImageSmoothingEnabled(blink_value);
}

void ImageSmoothingEnabledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_imageSmoothingEnabled_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.imageSmoothingEnabled.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->imageSmoothingEnabled();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void ImageSmoothingEnabledAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_imageSmoothingEnabled_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.imageSmoothingEnabled.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setImageSmoothingEnabled(arg1_value);

}


void ImageSmoothingQualityAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_imageSmoothingQuality_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.imageSmoothingQuality.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DImageSmoothingQuality2);



v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->imageSmoothingQuality();
static_assert(bindings::IsReturnTypeCompatible<V8ImageSmoothingQuality, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ImageSmoothingQualityAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_imageSmoothingQuality_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.imageSmoothingQuality.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DImageSmoothingQuality2);


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8ImageSmoothingQuality::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "ImageSmoothingQuality", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setImageSmoothingQuality(arg1_value);

}


void StrokeStyleAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_strokeStyle_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.strokeStyle.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.strokeStyle.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->strokeStyle(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void StrokeStyleAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_strokeStyle_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.strokeStyle.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.strokeStyle.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLAny>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setStrokeStyle(isolate, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void FillStyleAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fillStyle_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fillStyle.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fillStyle.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->fillStyle(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void FillStyleAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fillStyle_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fillStyle.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fillStyle.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLAny>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFillStyle(isolate, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ShadowOffsetXAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setShadowOffsetX(blink_value);
}

void ShadowOffsetXAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowOffsetX_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowOffsetX.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowOffsetX.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shadowOffsetX();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void ShadowOffsetXAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowOffsetX_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowOffsetX.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowOffsetX.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setShadowOffsetX(arg1_value);

}

void ShadowOffsetYAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setShadowOffsetY(blink_value);
}

void ShadowOffsetYAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowOffsetY_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowOffsetY.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowOffsetY.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shadowOffsetY();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void ShadowOffsetYAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowOffsetY_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowOffsetY.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowOffsetY.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setShadowOffsetY(arg1_value);

}

void ShadowBlurAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setShadowBlur(blink_value);
}

void ShadowBlurAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowBlur_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowBlur.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowBlur.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shadowBlur();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void ShadowBlurAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowBlur_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowBlur.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowBlur.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setShadowBlur(arg1_value);

}


void ShadowColorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowColor_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowColor.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowColor.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->shadowColor();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ShadowColorAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_shadowColor_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.shadowColor.set");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.shadowColor.set", info);


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setShadowColor(arg1_value);

}

void LineWidthAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setLineWidth(blink_value);
}

void LineWidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineWidth_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineWidth.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->lineWidth();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void LineWidthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineWidth_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineWidth.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLineWidth(arg1_value);

}


void LineCapAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineCap_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineCap.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->lineCap();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LineCapAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineCap_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineCap.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLineCap(arg1_value);

}


void LineJoinAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineJoin_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineJoin.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->lineJoin();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void LineJoinAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineJoin_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineJoin.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLineJoin(arg1_value);

}

void MiterLimitAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setMiterLimit(blink_value);
}

void MiterLimitAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_miterLimit_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.miterLimit.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->miterLimit();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void MiterLimitAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_miterLimit_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.miterLimit.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setMiterLimit(arg1_value);

}

void LineDashOffsetAttributeSetNoAllocDirectCall(v8::Local<v8::Object> v8_arg0_receiver, double value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_arg0_receiver);
auto&& blink_value = value;
blink_receiver->setLineDashOffset(blink_value);
}

void LineDashOffsetAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineDashOffset_Getter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineDashOffset.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->lineDashOffset();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void LineDashOffsetAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineDashOffset_Setter");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineDashOffset.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLineDashOffset(arg1_value);

}

void ArcOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius, double v8_arg4_start_angle, double v8_arg5_end_angle, bool v8_arg6_anticlockwise, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius = v8_arg3_radius;
auto&& arg4_start_angle = v8_arg4_start_angle;
auto&& arg5_end_angle = v8_arg5_end_angle;
auto&& arg6_anticlockwise = v8_arg6_anticlockwise;
ExceptionState exception_state(isolate);
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius, double v8_arg4_start_angle, double v8_arg5_end_angle, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius = v8_arg3_radius;
auto&& arg4_start_angle = v8_arg4_start_angle;
auto&& arg5_end_angle = v8_arg5_end_angle;
auto&& arg6_anticlockwise{false};
ExceptionState exception_state(isolate);
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_arc");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.arc");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.arc", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_radius = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_start_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_end_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg6_anticlockwise{false};
if (!info[5]->IsUndefined()) {
  arg6_anticlockwise = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->arc(arg1_x, arg2_y, arg3_radius, arg4_start_angle, arg5_end_angle, arg6_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ArcToOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x_1, double v8_arg2_y_1, double v8_arg3_x_2, double v8_arg4_y_2, double v8_arg5_radius, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x_1 = v8_arg1_x_1;
auto&& arg2_y_1 = v8_arg2_y_1;
auto&& arg3_x_2 = v8_arg3_x_2;
auto&& arg4_y_2 = v8_arg4_y_2;
auto&& arg5_radius = v8_arg5_radius;
ExceptionState exception_state(isolate);
blink_receiver->arcTo(arg1_x_1, arg2_y_1, arg3_x_2, arg4_y_2, arg5_radius, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void ArcToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_arcTo");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.arcTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x_1 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y_1 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x_2 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y_2 = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_radius = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->arcTo(arg1_x_1, arg2_y_1, arg3_x_2, arg4_y_2, arg5_radius, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void BeginLayerOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DLayers);




v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
blink_receiver->beginLayer(script_state);

}

void BeginLayerOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DLayers);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_options = NativeValueTraits<BeginLayerOptions>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->beginLayer(script_state, arg1_options, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void BeginLayerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_beginLayer");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.beginLayer");


const int arg_count = std::min(info.Length(), 1);
if (RuntimeEnabledFeatures::Canvas2dLayersWithOptionsEnabled()) {
  if (arg_count == 1) {
  return BeginLayerOperationOverload2(info);
}
}
if (RuntimeEnabledFeatures::Canvas2dLayersEnabled()) {
  return BeginLayerOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void BeginPathOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->beginPath();
}

void BeginPathOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_beginPath");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.beginPath");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.beginPath", info);




v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->beginPath();

}

void BezierCurveToOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_cp_1_x, double v8_arg2_cp_1_y, double v8_arg3_cp_2_x, double v8_arg4_cp_2_y, double v8_arg5_x, double v8_arg6_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_cp_1_x = v8_arg1_cp_1_x;
auto&& arg2_cp_1_y = v8_arg2_cp_1_y;
auto&& arg3_cp_2_x = v8_arg3_cp_2_x;
auto&& arg4_cp_2_y = v8_arg4_cp_2_y;
auto&& arg5_x = v8_arg5_x;
auto&& arg6_y = v8_arg6_y;
blink_receiver->bezierCurveTo(arg1_cp_1_x, arg2_cp_1_y, arg3_cp_2_x, arg4_cp_2_y, arg5_x, arg6_y);
}

void BezierCurveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_bezierCurveTo");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.bezierCurveTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cp_1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_cp_1_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_cp_2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_cp_2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bezierCurveTo(arg1_cp_1_x, arg2_cp_1_y, arg3_cp_2_x, arg4_cp_2_y, arg5_x, arg6_y);

}

void ClearRectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_width, double v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->clearRect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void ClearRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_clearRect");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.clearRect");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.clearRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearRect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void ClipOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.clip", info);




do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  blink_receiver->clip();
break;
}
ExceptionState exception_state(isolate);
auto&& arg1_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clip(arg1_winding);
} while (false);

}

void ClipOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.clip", info);


if (info.Length() < 1) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  blink_receiver->clip(arg1_path);
break;
}
auto&& arg2_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clip(arg1_path, arg2_winding);
} while (false);

}

void ClipOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_clip");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.clip");


const int arg_count = std::min(info.Length(), 2);
if (arg_count == 2) {
  return ClipOperationOverload2(info);
}
if (arg_count == 1) {
  if (info[0]->IsUndefined()) {
  return ClipOperationOverload1(info);
}
if (info[0]->IsObject()) {
  v8::Isolate* isolate = info.GetIsolate();
if (V8Path2D::HasInstance(isolate, info[0])) {
  return ClipOperationOverload2(info);
}
}
return ClipOperationOverload1(info);
}
return ClipOperationOverload1(info);
}

void ClosePathOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->closePath();
}

void ClosePathOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_closePath");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.closePath");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.closePath", info);




v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->closePath();

}

void CreateConicGradientOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createConicGradient");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createConicGradient");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_start_angle = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_cx = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_cy = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createConicGradient(arg1_start_angle, arg2_cx, arg3_cy);
static_assert(bindings::IsReturnTypeCompatible<CanvasGradient, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateImageDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_imagedata = NativeValueTraits<ImageData>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createImageData(arg1_imagedata, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ImageData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateImageDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sw = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sh = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createImageData(arg1_sw, arg2_sh, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ImageData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateImageDataOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sw = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sh = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_image_data_settings = NativeValueTraits<ImageDataSettings>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createImageData(arg1_sw, arg2_sh, arg3_image_data_settings, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ImageData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateImageDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createImageData");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createImageData");


const int arg_count = std::min(info.Length(), 3);
if (arg_count == 3) {
  return CreateImageDataOperationOverload3(info);
}
if (arg_count == 2) {
  return CreateImageDataOperationOverload2(info);
}
if (arg_count == 1) {
  return CreateImageDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CreateLinearGradientOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createLinearGradient");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createLinearGradient");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x_0 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y_0 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x_1 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y_1 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createLinearGradient(arg1_x_0, arg2_y_0, arg3_x_1, arg4_y_1);
static_assert(bindings::IsReturnTypeCompatible<CanvasGradient, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateMesh2DIndexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createMesh2DIndexBuffer");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createMesh2DIndexBuffer");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DMesh);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<NotShared<DOMUint16Array>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createMesh2DIndexBuffer(arg1_buffer, exception_state);
static_assert(bindings::IsReturnTypeCompatible<Mesh2DIndexBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateMesh2DUVBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createMesh2DUVBuffer");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createMesh2DUVBuffer");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DMesh);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<NotShared<DOMFloat32Array>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createMesh2DUVBuffer(arg1_buffer, exception_state);
static_assert(bindings::IsReturnTypeCompatible<Mesh2DUVBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateMesh2DVertexBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createMesh2DVertexBuffer");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createMesh2DVertexBuffer");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DMesh);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<NotShared<DOMFloat32Array>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createMesh2DVertexBuffer(arg1_buffer, exception_state);
static_assert(bindings::IsReturnTypeCompatible<Mesh2DVertexBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreatePatternOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createPattern");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createPattern");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_image = NativeValueTraits<V8UnionCSSImageValueOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_repetition_type = NativeValueTraits<IDLStringLegacyNullToEmptyString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createPattern(arg1_image, arg2_repetition_type, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<CanvasPattern>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRadialGradientOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_createRadialGradient");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.createRadialGradient");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x_0 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y_0 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_r_0 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_x_1 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_y_1 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_r_1 = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createRadialGradient(arg1_x_0, arg2_y_0, arg3_r_0, arg4_x_1, arg5_y_1, arg6_r_1, exception_state);
static_assert(bindings::IsReturnTypeCompatible<CanvasGradient, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void DrawImageOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_image = NativeValueTraits<V8UnionCSSImageValueOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawImage(arg1_image, arg2_x, arg3_y, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void DrawImageOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_image = NativeValueTraits<V8UnionCSSImageValueOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawImage(arg1_image, arg2_x, arg3_y, arg4_width, arg5_height, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void DrawImageOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_image = NativeValueTraits<V8UnionCSSImageValueOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sx = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_sy = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_sw = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_sh = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_dx = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_dy = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_dw = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_dh = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawImage(arg1_image, arg2_sx, arg3_sy, arg4_sw, arg5_sh, arg6_dx, arg7_dy, arg8_dw, arg9_dh, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void DrawImageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_drawImage");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.drawImage");


const int arg_count = std::min(info.Length(), 9);
if (arg_count == 9) {
  return DrawImageOperationOverload3(info);
}
if (arg_count == 5) {
  return DrawImageOperationOverload2(info);
}
if (arg_count == 3) {
  return DrawImageOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void DrawMeshOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_drawMesh");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.drawMesh");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.drawMesh", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DMesh);


if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_buffer = NativeValueTraits<Mesh2DVertexBuffer>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uv_buffer = NativeValueTraits<Mesh2DUVBuffer>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_index_buffer = NativeValueTraits<Mesh2DIndexBuffer>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_image = NativeValueTraits<V8UnionCSSImageValueOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrOffscreenCanvasOrSVGImageElementOrVideoFrame>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawMesh(arg1_vertex_buffer, arg2_uv_buffer, arg3_index_buffer, arg4_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void EllipseOperationNoAllocDirectCallArg8(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius_x, double v8_arg4_radius_y, double v8_arg5_rotation, double v8_arg6_start_angle, double v8_arg7_end_angle, bool v8_arg8_anticlockwise, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius_x = v8_arg3_radius_x;
auto&& arg4_radius_y = v8_arg4_radius_y;
auto&& arg5_rotation = v8_arg5_rotation;
auto&& arg6_start_angle = v8_arg6_start_angle;
auto&& arg7_end_angle = v8_arg7_end_angle;
auto&& arg8_anticlockwise = v8_arg8_anticlockwise;
ExceptionState exception_state(isolate);
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void EllipseOperationNoAllocDirectCallArg7(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_radius_x, double v8_arg4_radius_y, double v8_arg5_rotation, double v8_arg6_start_angle, double v8_arg7_end_angle, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_radius_x = v8_arg3_radius_x;
auto&& arg4_radius_y = v8_arg4_radius_y;
auto&& arg5_rotation = v8_arg5_rotation;
auto&& arg6_start_angle = v8_arg6_start_angle;
auto&& arg7_end_angle = v8_arg7_end_angle;
auto&& arg8_anticlockwise{false};
ExceptionState exception_state(isolate);
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void EllipseOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_ellipse");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.ellipse");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.ellipse", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_radius_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_radius_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_rotation = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_start_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_end_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg8_anticlockwise{false};
if (!info[7]->IsUndefined()) {
  arg8_anticlockwise = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->ellipse(arg1_x, arg2_y, arg3_radius_x, arg4_radius_y, arg5_rotation, arg6_start_angle, arg7_end_angle, arg8_anticlockwise, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void EndLayerOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->endLayer(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void EndLayerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_endLayer");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.endLayer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->endLayer(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void FillOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fill", info);




do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  blink_receiver->fill();
break;
}
ExceptionState exception_state(isolate);
auto&& arg1_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fill(arg1_winding);
} while (false);

}

void FillOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fill", info);


if (info.Length() < 1) [[unlikely]] {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  blink_receiver->fill(arg1_path);
break;
}
auto&& arg2_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fill(arg1_path, arg2_winding);
} while (false);

}

void FillOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fill");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fill");


const int arg_count = std::min(info.Length(), 2);
if (arg_count == 2) {
  return FillOperationOverload2(info);
}
if (arg_count == 1) {
  if (info[0]->IsUndefined()) {
  return FillOperationOverload1(info);
}
if (info[0]->IsObject()) {
  v8::Isolate* isolate = info.GetIsolate();
if (V8Path2D::HasInstance(isolate, info[0])) {
  return FillOperationOverload2(info);
}
}
return FillOperationOverload1(info);
}
return FillOperationOverload1(info);
}

void FillRectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_width, double v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->fillRect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void FillRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fillRect");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fillRect");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fillRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fillRect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void FillTextOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fillText");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fillText");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.fillText", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DDrawText);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->fillText(arg1_text, arg2_x, arg3_y);
break;
}
auto&& arg4_max_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fillText(arg1_text, arg2_x, arg3_y, arg4_max_width);
} while (false);

}

void FillTextClusterOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text_cluster = NativeValueTraits<TextCluster>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fillTextCluster(arg1_text_cluster, arg2_x, arg3_y);

}

void FillTextClusterOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text_cluster = NativeValueTraits<TextCluster>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_options = NativeValueTraits<TextClusterOptions>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->fillTextCluster(arg1_text_cluster, arg2_x, arg3_y, arg4_options);

}

void FillTextClusterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_fillTextCluster");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.fillTextCluster");


const int arg_count = std::min(info.Length(), 4);
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  if (arg_count == 4) {
  return FillTextClusterOperationOverload2(info);
}
}
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  if (arg_count == 3) {
  return FillTextClusterOperationOverload1(info);
}
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void GetContextAttributesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_getContextAttributes");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.getContextAttributes");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getContextAttributes();
static_assert(bindings::IsReturnTypeCompatible<CanvasRenderingContext2DSettings, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<CanvasRenderingContext2DSettings>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetImageDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.getImageData", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DGetImageData);


if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sx = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sy = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_sw = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_sh = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getImageData(arg1_sx, arg2_sy, arg3_sw, arg4_sh, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ImageData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetImageDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.getImageData", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DGetImageData);


if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sx = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sy = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_sw = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_sh = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_image_data_settings = NativeValueTraits<ImageDataSettings>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getImageData(arg1_sx, arg2_sy, arg3_sw, arg4_sh, arg5_image_data_settings, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ImageData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetImageDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_getImageData");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.getImageData");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return GetImageDataOperationOverload2(info);
}
if (arg_count == 4) {
  return GetImageDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void GetLineDashOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_getLineDash");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.getLineDash");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getLineDash();
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<IDLUnrestrictedDouble>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<IDLUnrestrictedDouble>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetTextureFormatOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_getTextureFormat");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.getTextureFormat");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getTextureFormat();
static_assert(bindings::IsReturnTypeCompatible<V8GPUTextureFormat, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void GetTransformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_getTransform");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.getTransform");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getTransform();
static_assert(bindings::IsReturnTypeCompatible<DOMMatrix, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void IsContextLostOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_isContextLost");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.isContextLost");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->isContextLost();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsPointInPathOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.isPointInPath", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DIsPointInPath);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


bool return_value;
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  return_value = blink_receiver->isPointInPath(arg1_x, arg2_y);
break;
}
auto&& arg3_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = blink_receiver->isPointInPath(arg1_x, arg2_y, arg3_winding);
} while (false);
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsPointInPathOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.isPointInPath", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DIsPointInPath);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


bool return_value;
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 3) {
  return_value = blink_receiver->isPointInPath(arg1_path, arg2_x, arg3_y);
break;
}
auto&& arg4_winding = NativeValueTraits<V8CanvasFillRule>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = blink_receiver->isPointInPath(arg1_path, arg2_x, arg3_y, arg4_winding);
} while (false);
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsPointInPathOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_isPointInPath");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.isPointInPath");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return IsPointInPathOperationOverload2(info);
}
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 3) {
  if (info[0]->IsObject()) {
  if (V8Path2D::HasInstance(isolate, info[0])) {
  return IsPointInPathOperationOverload2(info);
}
}
if (info[0]->IsNumber()) {
  return IsPointInPathOperationOverload1(info);
}
return IsPointInPathOperationOverload1(info);
}
if (arg_count == 2) {
  return IsPointInPathOperationOverload1(info);
}

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void IsPointInStrokeOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.isPointInStroke", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DIsPointInStroke);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isPointInStroke(arg1_x, arg2_y);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsPointInStrokeOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.isPointInStroke", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DIsPointInStroke);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isPointInStroke(arg1_path, arg2_x, arg3_y);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsPointInStrokeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_isPointInStroke");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.isPointInStroke");


const int arg_count = std::min(info.Length(), 3);
if (arg_count == 3) {
  return IsPointInStrokeOperationOverload2(info);
}
if (arg_count == 2) {
  return IsPointInStrokeOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void LineToOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->lineTo(arg1_x, arg2_y);
}

void LineToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_lineTo");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.lineTo");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.lineTo", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->lineTo(arg1_x, arg2_y);

}

void MeasureTextOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_measureText");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.measureText");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.measureText", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DMeasureText);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_text;
if (info[0]->IsString()) [[likely]] {
  arg1_text.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_text = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->measureText(arg1_text);
static_assert(bindings::IsReturnTypeCompatible<TextMetrics, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void MoveToOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->moveTo(arg1_x, arg2_y);
}

void MoveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_moveTo");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.moveTo");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.moveTo", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->moveTo(arg1_x, arg2_y);

}

void PutImageDataOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_imagedata, int32_t v8_arg2_dx, int32_t v8_arg3_dy, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_imagedata = NativeValueTraits<ImageData>::ArgumentValue(isolate, 0, v8_arg1_imagedata, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dx = v8_arg2_dx;
auto&& arg3_dy = v8_arg3_dy;
blink_receiver->putImageData(arg1_imagedata, arg2_dx, arg3_dy, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void PutImageDataOperationNoAllocDirectCallOverload2Arg7(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_imagedata, int32_t v8_arg2_dx, int32_t v8_arg3_dy, int32_t v8_arg4_dirty_x, int32_t v8_arg5_dirty_y, int32_t v8_arg6_dirty_width, int32_t v8_arg7_dirty_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_imagedata = NativeValueTraits<ImageData>::ArgumentValue(isolate, 0, v8_arg1_imagedata, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dx = v8_arg2_dx;
auto&& arg3_dy = v8_arg3_dy;
auto&& arg4_dirty_x = v8_arg4_dirty_x;
auto&& arg5_dirty_y = v8_arg5_dirty_y;
auto&& arg6_dirty_width = v8_arg6_dirty_width;
auto&& arg7_dirty_height = v8_arg7_dirty_height;
blink_receiver->putImageData(arg1_imagedata, arg2_dx, arg3_dy, arg4_dirty_x, arg5_dirty_y, arg6_dirty_width, arg7_dirty_height, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void PutImageDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_imagedata = NativeValueTraits<ImageData>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dx = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dy = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->putImageData(arg1_imagedata, arg2_dx, arg3_dy, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void PutImageDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_imagedata = NativeValueTraits<ImageData>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dx = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dy = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dirty_x = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_dirty_y = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_dirty_width = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_dirty_height = NativeValueTraits<IDLLongEnforceRange>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->putImageData(arg1_imagedata, arg2_dx, arg3_dy, arg4_dirty_x, arg5_dirty_y, arg6_dirty_width, arg7_dirty_height, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void PutImageDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_putImageData");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.putImageData");


const int arg_count = std::min(info.Length(), 7);
if (arg_count == 7) {
  return PutImageDataOperationOverload2(info);
}
if (arg_count == 3) {
  return PutImageDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void QuadraticCurveToOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_cpx, double v8_arg2_cpy, double v8_arg3_x, double v8_arg4_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_cpx = v8_arg1_cpx;
auto&& arg2_cpy = v8_arg2_cpy;
auto&& arg3_x = v8_arg3_x;
auto&& arg4_y = v8_arg4_y;
blink_receiver->quadraticCurveTo(arg1_cpx, arg2_cpy, arg3_x, arg4_y);
}

void QuadraticCurveToOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_quadraticCurveTo");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.quadraticCurveTo");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cpx = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_cpy = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->quadraticCurveTo(arg1_cpx, arg2_cpy, arg3_x, arg4_y);

}

void RectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_width, double v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->rect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void RectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_rect");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.rect");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.rect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->rect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void ResetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_reset");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.reset");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->reset();

}

void ResetTransformOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->resetTransform();
}

void ResetTransformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_resetTransform");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.resetTransform");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->resetTransform();

}

void RestoreOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->restore(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}

void RestoreOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_restore");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.restore");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->restore(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RotateOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_angle, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_angle = v8_arg1_angle;
blink_receiver->rotate(arg1_angle);
}

void RotateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_rotate");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.rotate");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.rotate", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_angle = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->rotate(arg1_angle);

}

void RoundRectOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.roundRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_w = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_h = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_radii = NativeValueTraits<IDLSequence<V8UnionDOMPointInitOrUnrestrictedDouble>>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->roundRect(arg1_x, arg2_y, arg3_w, arg4_h, std::move(arg5_radii), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RoundRectOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.roundRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_w = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_h = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<V8UnionDOMPointInitOrUnrestrictedDouble>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_radii;
if (info[4]->IsUndefined()) {
  arg5_radii = MakeGarbageCollected<V8UnionDOMPointInitOrUnrestrictedDouble>(0);
} else {
  arg5_radii = NativeValueTraits<V8UnionDOMPointInitOrUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->roundRect(arg1_x, arg2_y, arg3_w, arg4_h, arg5_radii, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RoundRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_roundRect");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.roundRect");


const int arg_count = std::min(info.Length(), 5);
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 5) {
  if (info[4]->IsUndefined()) {
  return RoundRectOperationOverload2(info);
}
if (info[4]->IsNullOrUndefined()) {
  return RoundRectOperationOverload2(info);
}
if (info[4]->IsObject()) {
  ExceptionState exception_state(isolate);
if (info[4]->IsArray() || bindings::IsEsIterableObject(isolate, info[4], exception_state)) {
  return RoundRectOperationOverload1(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return RoundRectOperationOverload2(info);
}
if (info[4]->IsNumber()) {
  return RoundRectOperationOverload2(info);
}
return RoundRectOperationOverload2(info);
}
if (arg_count == 4) {
  return RoundRectOperationOverload2(info);
}

if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SaveOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->save();
}

void SaveOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_save");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.save");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->save();

}

void ScaleOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->scale(arg1_x, arg2_y);
}

void ScaleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_scale");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.scale");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.scale", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->scale(arg1_x, arg2_y);

}

void SetLineDashOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_setLineDash");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.setLineDash");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_dash = NativeValueTraits<IDLSequence<IDLUnrestrictedDouble>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setLineDash(std::move(arg1_dash));

}

void SetTransformOperationNoAllocDirectCallOverload1Arg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_a, double v8_arg2_b, double v8_arg3_c, double v8_arg4_d, double v8_arg5_e, double v8_arg6_f, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_a = v8_arg1_a;
auto&& arg2_b = v8_arg2_b;
auto&& arg3_c = v8_arg3_c;
auto&& arg4_d = v8_arg4_d;
auto&& arg5_e = v8_arg5_e;
auto&& arg6_f = v8_arg6_f;
blink_receiver->setTransform(arg1_a, arg2_b, arg3_c, arg4_d, arg5_e, arg6_f);
}

void SetTransformOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.setTransform", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_a = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_b = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_c = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_d = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_e = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_f = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setTransform(arg1_a, arg2_b, arg3_c, arg4_d, arg5_e, arg6_f);

}

void SetTransformOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  




v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<DOMMatrixInit>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_transform;
ExceptionState exception_state(isolate);
if (info[0]->IsUndefined()) {
  arg1_transform = DOMMatrixInit::Create();
} else {
  arg1_transform = NativeValueTraits<DOMMatrixInit>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->setTransform(arg1_transform, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetTransformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_setTransform");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.setTransform");


const int arg_count = std::min(info.Length(), 6);
if (arg_count == 6) {
  return SetTransformOperationOverload1(info);
}
if (arg_count == 1) {
  return SetTransformOperationOverload2(info);
}
return SetTransformOperationOverload2(info);
}

void StrokeOperationNoAllocDirectCallOverload1Arg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->stroke();
}

void StrokeOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.stroke", info);




v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->stroke();

}

void StrokeOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.stroke", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_path = NativeValueTraits<Path2D>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stroke(arg1_path);

}

void StrokeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_stroke");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.stroke");


const int arg_count = std::min(info.Length(), 1);
if (arg_count == 1) {
  return StrokeOperationOverload2(info);
}
return StrokeOperationOverload1(info);
}

void StrokeRectOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, double v8_arg3_width, double v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->strokeRect(arg1_x, arg2_y, arg3_width, arg4_height);
}

void StrokeRectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_strokeRect");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.strokeRect");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.strokeRect", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->strokeRect(arg1_x, arg2_y, arg3_width, arg4_height);

}

void StrokeTextOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_strokeText");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.strokeText");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.strokeText", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kCanvas2DDrawText);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 3) {
  blink_receiver->strokeText(arg1_text, arg2_x, arg3_y);
break;
}
auto&& arg4_max_width = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->strokeText(arg1_text, arg2_x, arg3_y, arg4_max_width);
} while (false);

}

void StrokeTextClusterOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text_cluster = NativeValueTraits<TextCluster>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->strokeTextCluster(arg1_text_cluster, arg2_x, arg3_y);

}

void StrokeTextClusterOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_text_cluster = NativeValueTraits<TextCluster>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_options = NativeValueTraits<TextClusterOptions>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->strokeTextCluster(arg1_text_cluster, arg2_x, arg3_y, arg4_options);

}

void StrokeTextClusterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_strokeTextCluster");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.strokeTextCluster");


const int arg_count = std::min(info.Length(), 4);
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  if (arg_count == 4) {
  return StrokeTextClusterOperationOverload2(info);
}
}
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  if (arg_count == 3) {
  return StrokeTextClusterOperationOverload1(info);
}
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TransferBackFromGPUTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_transferBackFromGPUTexture");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.transferBackFromGPUTexture");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->transferBackFromGPUTexture(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TransferToGPUTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_transferToGPUTexture");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.transferToGPUTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_options = NativeValueTraits<Canvas2dGPUTransferOption>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->transferToGPUTexture(arg1_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<GPUTexture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void TransformOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_a, double v8_arg2_b, double v8_arg3_c, double v8_arg4_d, double v8_arg5_e, double v8_arg6_f, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_a = v8_arg1_a;
auto&& arg2_b = v8_arg2_b;
auto&& arg3_c = v8_arg3_c;
auto&& arg4_d = v8_arg4_d;
auto&& arg5_e = v8_arg5_e;
auto&& arg6_f = v8_arg6_f;
blink_receiver->transform(arg1_a, arg2_b, arg3_c, arg4_d, arg5_e, arg6_f);
}

void TransformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_transform");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.transform");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.transform", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_a = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_b = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_c = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_d = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_e = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_f = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->transform(arg1_a, arg2_b, arg3_c, arg4_d, arg5_e, arg6_f);

}

void TranslateOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, double v8_arg1_x, double v8_arg2_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
blink_receiver->translate(arg1_x, arg2_y);
}

void TranslateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_OffscreenCanvasRenderingContext2D_translate");
BLINK_BINDINGS_TRACE_EVENT("OffscreenCanvasRenderingContext2D.translate");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("OffscreenCanvasRenderingContext2D.translate", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
OffscreenCanvasRenderingContext2D* blink_receiver = V8OffscreenCanvasRenderingContext2D::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLUnrestrictedDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->translate(arg1_x, arg2_y);

}


}  // namespace v8_offscreen_canvas_rendering_context_2d

using namespace v8_offscreen_canvas_rendering_context_2d;

}  // namespace 

void V8OffscreenCanvasRenderingContext2D::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8OffscreenCanvasRenderingContext2D::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8OffscreenCanvasRenderingContext2D::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"canvas", CanvasAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"lang", LangAttributeGetCallback, LangAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"font", FontAttributeGetCallback, FontAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"textAlign", TextAlignAttributeGetCallback, TextAlignAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"textBaseline", TextBaselineAttributeGetCallback, TextBaselineAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"direction", DirectionAttributeGetCallback, DirectionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"fontKerning", FontKerningAttributeGetCallback, FontKerningAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"fontStretch", FontStretchAttributeGetCallback, FontStretchAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"fontVariantCaps", FontVariantCapsAttributeGetCallback, FontVariantCapsAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"letterSpacing", LetterSpacingAttributeGetCallback, LetterSpacingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"textRendering", TextRenderingAttributeGetCallback, TextRenderingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"wordSpacing", WordSpacingAttributeGetCallback, WordSpacingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"globalCompositeOperation", GlobalCompositeOperationAttributeGetCallback, GlobalCompositeOperationAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"filter", FilterAttributeGetCallback, FilterAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"imageSmoothingQuality", ImageSmoothingQualityAttributeGetCallback, ImageSmoothingQualityAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"strokeStyle", StrokeStyleAttributeGetCallback, StrokeStyleAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"fillStyle", FillStyleAttributeGetCallback, FillStyleAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"shadowColor", ShadowColorAttributeGetCallback, ShadowColorAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"lineCap", LineCapAttributeGetCallback, LineCapAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"lineJoin", LineJoinAttributeGetCallback, LineJoinAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kAttributeTable);
}


{
  static const v8::CFunction kGlobalAlphaAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(GlobalAlphaAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kImageSmoothingEnabledAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(ImageSmoothingEnabledAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kShadowOffsetXAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(ShadowOffsetXAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kShadowOffsetYAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(ShadowOffsetYAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kShadowBlurAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(ShadowBlurAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kLineWidthAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(LineWidthAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kMiterLimitAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(MiterLimitAttributeSetNoAllocDirectCall).Build()};
static const v8::CFunction kLineDashOffsetAttributeSetNoAllocDirectCall[] = {v8::CFunctionBuilder().Fn(LineDashOffsetAttributeSetNoAllocDirectCall).Build()};
static const IDLMemberInstaller::NoAllocDirectCallAttributeConfig kAttributeTable[] = {
{{"globalAlpha", GlobalAlphaAttributeGetCallback, GlobalAlphaAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kGlobalAlphaAttributeSetNoAllocDirectCall},
{{"imageSmoothingEnabled", ImageSmoothingEnabledAttributeGetCallback, ImageSmoothingEnabledAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kImageSmoothingEnabledAttributeSetNoAllocDirectCall},
{{"shadowOffsetX", ShadowOffsetXAttributeGetCallback, ShadowOffsetXAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kShadowOffsetXAttributeSetNoAllocDirectCall},
{{"shadowOffsetY", ShadowOffsetYAttributeGetCallback, ShadowOffsetYAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kShadowOffsetYAttributeSetNoAllocDirectCall},
{{"shadowBlur", ShadowBlurAttributeGetCallback, ShadowBlurAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kShadowBlurAttributeSetNoAllocDirectCall},
{{"lineWidth", LineWidthAttributeGetCallback, LineWidthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kLineWidthAttributeSetNoAllocDirectCall},
{{"miterLimit", MiterLimitAttributeGetCallback, MiterLimitAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kMiterLimitAttributeSetNoAllocDirectCall},
{{"lineDashOffset", LineDashOffsetAttributeGetCallback, LineDashOffsetAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},kLineDashOffsetAttributeSetNoAllocDirectCall},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kAttributeTable);
}




{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clip", ClipOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createConicGradient", CreateConicGradientOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createImageData", CreateImageDataOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createLinearGradient", CreateLinearGradientOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createPattern", CreatePatternOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRadialGradient", CreateRadialGradientOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawImage", DrawImageOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"fill", FillOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"fillText", FillTextOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getImageData", GetImageDataOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getLineDash", GetLineDashOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getTransform", GetTransformOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isContextLost", IsContextLostOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isPointInPath", IsPointInPathOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isPointInStroke", IsPointInStrokeOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"measureText", MeasureTextOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"reset", ResetOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"roundRect", RoundRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setLineDash", SetLineDashOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"strokeText", StrokeTextOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}


{
  // Disable [NoAllocDirectCall] on x86 due to https://crbug.com/1433212
#if defined(ARCH_CPU_X86)
static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"arc", ArcOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"arcTo", ArcToOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"beginPath", BeginPathOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bezierCurveTo", BezierCurveToOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"clearRect", ClearRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"closePath", ClosePathOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"ellipse", EllipseOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"fillRect", FillRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"lineTo", LineToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"moveTo", MoveToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"putImageData", PutImageDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"quadraticCurveTo", QuadraticCurveToOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"rect", RectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"resetTransform", ResetTransformOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"restore", RestoreOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"rotate", RotateOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"save", SaveOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"scale", ScaleOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setTransform", SetTransformOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stroke", StrokeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"strokeRect", StrokeRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"transform", TransformOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"translate", TranslateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
// Disable compiler warnings for unused functions.
std::ignore = ArcOperationNoAllocDirectCallArg6;
std::ignore = ArcOperationNoAllocDirectCallArg5;
std::ignore = ArcToOperationNoAllocDirectCallArg5;
std::ignore = BeginPathOperationNoAllocDirectCallArg0;
std::ignore = BezierCurveToOperationNoAllocDirectCallArg6;
std::ignore = ClearRectOperationNoAllocDirectCallArg4;
std::ignore = ClosePathOperationNoAllocDirectCallArg0;
std::ignore = EllipseOperationNoAllocDirectCallArg8;
std::ignore = EllipseOperationNoAllocDirectCallArg7;
std::ignore = FillRectOperationNoAllocDirectCallArg4;
std::ignore = LineToOperationNoAllocDirectCallArg2;
std::ignore = MoveToOperationNoAllocDirectCallArg2;
std::ignore = PutImageDataOperationNoAllocDirectCallOverload1Arg3;
std::ignore = PutImageDataOperationNoAllocDirectCallOverload2Arg7;
std::ignore = QuadraticCurveToOperationNoAllocDirectCallArg4;
std::ignore = RectOperationNoAllocDirectCallArg4;
std::ignore = ResetTransformOperationNoAllocDirectCallArg0;
std::ignore = RestoreOperationNoAllocDirectCallArg0;
std::ignore = RotateOperationNoAllocDirectCallArg1;
std::ignore = SaveOperationNoAllocDirectCallArg0;
std::ignore = ScaleOperationNoAllocDirectCallArg2;
std::ignore = SetTransformOperationNoAllocDirectCallOverload1Arg6;
std::ignore = StrokeOperationNoAllocDirectCallOverload1Arg0;
std::ignore = StrokeRectOperationNoAllocDirectCallArg4;
std::ignore = TransformOperationNoAllocDirectCallArg6;
std::ignore = TranslateOperationNoAllocDirectCallArg2;
#else   // defined(ARCH_CPU_X86)
static const v8::CFunction kNoAllocDirectCallOverloadsOfArc[] = {
v8::CFunctionBuilder().Fn(ArcOperationNoAllocDirectCallArg6).Build(),
v8::CFunctionBuilder().Fn(ArcOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfArcTo[] = {
v8::CFunctionBuilder().Fn(ArcToOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBeginPath[] = {
v8::CFunctionBuilder().Fn(BeginPathOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBezierCurveTo[] = {
v8::CFunctionBuilder().Fn(BezierCurveToOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearRect[] = {
v8::CFunctionBuilder().Fn(ClearRectOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClosePath[] = {
v8::CFunctionBuilder().Fn(ClosePathOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEllipse[] = {
v8::CFunctionBuilder().Fn(EllipseOperationNoAllocDirectCallArg8).Build(),
v8::CFunctionBuilder().Fn(EllipseOperationNoAllocDirectCallArg7).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfFillRect[] = {
v8::CFunctionBuilder().Fn(FillRectOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfLineTo[] = {
v8::CFunctionBuilder().Fn(LineToOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfMoveTo[] = {
v8::CFunctionBuilder().Fn(MoveToOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfPutImageData[] = {
v8::CFunctionBuilder().Fn(PutImageDataOperationNoAllocDirectCallOverload1Arg3).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
v8::CFunctionBuilder().Fn(PutImageDataOperationNoAllocDirectCallOverload2Arg7).Arg<2, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<3, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<4, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<5, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<6, v8::CTypeInfo::Flags::kEnforceRangeBit>().Arg<7, v8::CTypeInfo::Flags::kEnforceRangeBit>().Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfQuadraticCurveTo[] = {
v8::CFunctionBuilder().Fn(QuadraticCurveToOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfRect[] = {
v8::CFunctionBuilder().Fn(RectOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfResetTransform[] = {
v8::CFunctionBuilder().Fn(ResetTransformOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfRestore[] = {
v8::CFunctionBuilder().Fn(RestoreOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfRotate[] = {
v8::CFunctionBuilder().Fn(RotateOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSave[] = {
v8::CFunctionBuilder().Fn(SaveOperationNoAllocDirectCallArg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfScale[] = {
v8::CFunctionBuilder().Fn(ScaleOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfSetTransform[] = {
v8::CFunctionBuilder().Fn(SetTransformOperationNoAllocDirectCallOverload1Arg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfStroke[] = {
v8::CFunctionBuilder().Fn(StrokeOperationNoAllocDirectCallOverload1Arg0).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfStrokeRect[] = {
v8::CFunctionBuilder().Fn(StrokeRectOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfTransform[] = {
v8::CFunctionBuilder().Fn(TransformOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfTranslate[] = {
v8::CFunctionBuilder().Fn(TranslateOperationNoAllocDirectCallArg2).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"arc", ArcOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfArc, std::size(kNoAllocDirectCallOverloadsOfArc)}, 
{{"arcTo", ArcToOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfArcTo, std::size(kNoAllocDirectCallOverloadsOfArcTo)}, 
{{"beginPath", BeginPathOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBeginPath, std::size(kNoAllocDirectCallOverloadsOfBeginPath)}, 
{{"bezierCurveTo", BezierCurveToOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBezierCurveTo, std::size(kNoAllocDirectCallOverloadsOfBezierCurveTo)}, 
{{"clearRect", ClearRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearRect, std::size(kNoAllocDirectCallOverloadsOfClearRect)}, 
{{"closePath", ClosePathOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClosePath, std::size(kNoAllocDirectCallOverloadsOfClosePath)}, 
{{"ellipse", EllipseOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEllipse, std::size(kNoAllocDirectCallOverloadsOfEllipse)}, 
{{"fillRect", FillRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfFillRect, std::size(kNoAllocDirectCallOverloadsOfFillRect)}, 
{{"lineTo", LineToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfLineTo, std::size(kNoAllocDirectCallOverloadsOfLineTo)}, 
{{"moveTo", MoveToOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfMoveTo, std::size(kNoAllocDirectCallOverloadsOfMoveTo)}, 
{{"putImageData", PutImageDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfPutImageData, std::size(kNoAllocDirectCallOverloadsOfPutImageData)}, 
{{"quadraticCurveTo", QuadraticCurveToOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfQuadraticCurveTo, std::size(kNoAllocDirectCallOverloadsOfQuadraticCurveTo)}, 
{{"rect", RectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfRect, std::size(kNoAllocDirectCallOverloadsOfRect)}, 
{{"resetTransform", ResetTransformOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfResetTransform, std::size(kNoAllocDirectCallOverloadsOfResetTransform)}, 
{{"restore", RestoreOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfRestore, std::size(kNoAllocDirectCallOverloadsOfRestore)}, 
{{"rotate", RotateOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfRotate, std::size(kNoAllocDirectCallOverloadsOfRotate)}, 
{{"save", SaveOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSave, std::size(kNoAllocDirectCallOverloadsOfSave)}, 
{{"scale", ScaleOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfScale, std::size(kNoAllocDirectCallOverloadsOfScale)}, 
{{"setTransform", SetTransformOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfSetTransform, std::size(kNoAllocDirectCallOverloadsOfSetTransform)}, 
{{"stroke", StrokeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfStroke, std::size(kNoAllocDirectCallOverloadsOfStroke)}, 
{{"strokeRect", StrokeRectOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfStrokeRect, std::size(kNoAllocDirectCallOverloadsOfStrokeRect)}, 
{{"transform", TransformOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfTransform, std::size(kNoAllocDirectCallOverloadsOfTransform)}, 
{{"translate", TranslateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfTranslate, std::size(kNoAllocDirectCallOverloadsOfTranslate)}, 
};
#endif  // defined(ARCH_CPU_X86)
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}


}

void V8OffscreenCanvasRenderingContext2D::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::CanvasGlobalHDRHeadroomEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"globalHDRHeadroom", GlobalHDRHeadroomAttributeGetCallback, GlobalHDRHeadroomAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kAttributeTable);
}




if (RuntimeEnabledFeatures::Canvas2dLayersEnabled() || RuntimeEnabledFeatures::Canvas2dLayersWithOptionsEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"beginLayer", BeginLayerOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}
if (RuntimeEnabledFeatures::ExtendedTextMetricsEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"fillTextCluster", FillTextClusterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"strokeTextCluster", StrokeTextClusterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}
if (RuntimeEnabledFeatures::OffscreenCanvasGetContextAttributesEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getContextAttributes", GetContextAttributesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}

if (RuntimeEnabledFeatures::Canvas2dLayersEnabled()) {
  static const v8::CFunction kNoAllocDirectCallOverloadsOfEndLayer[] = {
v8::CFunctionBuilder().Fn(EndLayerOperationNoAllocDirectCallArg0).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"endLayer", EndLayerOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEndLayer, std::size(kNoAllocDirectCallOverloadsOfEndLayer)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}

}

void V8OffscreenCanvasRenderingContext2D::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;





v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::Canvas2dMeshEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kCanvas2dMesh)) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"createMesh2DIndexBuffer", CreateMesh2DIndexBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createMesh2DUVBuffer", CreateMesh2DUVBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createMesh2DVertexBuffer", CreateMesh2DVertexBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawMesh", DrawMeshOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}
const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && (feature_selector.IsAll() && RuntimeEnabledFeatures::Canvas2dGPUTransferEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getTextureFormat", GetTextureFormatOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"transferBackFromGPUTexture", TransferBackFromGPUTextureOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"transferToGPUTexture", TransferToGPUTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "OffscreenCanvasRenderingContext2D", kOperationTable);
}


}


}  // namespace blink
