// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_navigator.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/frozen_array.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fenced_frame_config.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_form_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_geolocation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_model_context.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_model_context_testing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_navigator_ua_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_preference_manager.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scheduling.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_formdata_readablestream_urlsearchparams_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_blob_formdata_urlsearchparams_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_fencedframeconfig_usvstring.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_url_search_params.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_user_activation.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_auction_data_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ad_request_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ads.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_config.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_auction_ad_interest_group_key.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_battery_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_bluetooth.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_clipboard.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_contacts_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_cookie_deprecation_label.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_credentials_container.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_deprecated_storage_quota.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_device_posture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gamepad.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_model_constraint.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_recognizer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_handwriting_recognizer_query_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hid.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ink.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_keyboard.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_locked_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_capabilities.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_devices.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_system_access.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_system_configuration.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_session.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_stream_constraints.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_midi_access.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_midi_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_mime_type_array.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigator_login.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigator_managed_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigator_user_media_error_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_navigator_user_media_success_callback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_network_information.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_permissions.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_plugin_array.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_presentation.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_protected_audience.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_related_application.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_serial.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker_container.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_share_data.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_resource_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_bucket_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_sub_apps.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_usb.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_virtual_keyboard.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_wake_lock.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_install_result.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_window_controls_overlay.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_system.h"
#include "third_party/blink/renderer/core/events/navigator_events.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/navigator.h"
#include "third_party/blink/renderer/core/frame/navigator_cpu_performance.h"
#include "third_party/blink/renderer/core/frame/navigator_ua_data.h"
#include "third_party/blink/renderer/core/frame/navigator_user_activation.h"
#include "third_party/blink/renderer/core/frame/scheduling.h"
#include "third_party/blink/renderer/core/frame/user_activation.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/geolocation/geolocation.h"
#include "third_party/blink/renderer/core/html/fenced_frame/fenced_frame_config.h"
#include "third_party/blink/renderer/core/html/forms/form_data.h"
#include "third_party/blink/renderer/core/preferences/navigator_preferences.h"
#include "third_party/blink/renderer/core/preferences/preference_manager.h"
#include "third_party/blink/renderer/core/script_tools/model_context.h"
#include "third_party/blink/renderer/core/script_tools/model_context_supplement.h"
#include "third_party/blink/renderer/core/script_tools/model_context_testing.h"
#include "third_party/blink/renderer/core/streams/readable_stream.h"
#include "third_party/blink/renderer/core/url/dom_url.h"
#include "third_party/blink/renderer/core/url/url_search_params.h"
#include "third_party/blink/renderer/modules/ad_auction/ads.h"
#include "third_party/blink/renderer/modules/ad_auction/navigator_auction.h"
#include "third_party/blink/renderer/modules/ad_auction/protected_audience.h"
#include "third_party/blink/renderer/modules/badging/navigator_badge.h"
#include "third_party/blink/renderer/modules/battery/battery_manager.h"
#include "third_party/blink/renderer/modules/beacon/navigator_beacon.h"
#include "third_party/blink/renderer/modules/bluetooth/bluetooth.h"
#include "third_party/blink/renderer/modules/buckets/storage_bucket_manager.h"
#include "third_party/blink/renderer/modules/clipboard/clipboard.h"
#include "third_party/blink/renderer/modules/contacts_picker/contacts_manager.h"
#include "third_party/blink/renderer/modules/cookie_deprecation_label/cookie_deprecation_label.h"
#include "third_party/blink/renderer/modules/credentialmanagement/authentication_credentials_container.h"
#include "third_party/blink/renderer/modules/credentialmanagement/credentials_container.h"
#include "third_party/blink/renderer/modules/credentialmanagement/navigator_login.h"
#include "third_party/blink/renderer/modules/delegated_ink/ink.h"
#include "third_party/blink/renderer/modules/device_posture/device_posture.h"
#include "third_party/blink/renderer/modules/device_posture/navigator_device_posture.h"
#include "third_party/blink/renderer/modules/donottrack/navigator_do_not_track.h"
#include "third_party/blink/renderer/modules/encryptedmedia/media_key_system_access.h"
#include "third_party/blink/renderer/modules/encryptedmedia/navigator_request_media_key_system_access.h"
#include "third_party/blink/renderer/modules/gamepad/gamepad.h"
#include "third_party/blink/renderer/modules/gamepad/navigator_gamepad.h"
#include "third_party/blink/renderer/modules/handwriting/handwriting_recognition_service.h"
#include "third_party/blink/renderer/modules/handwriting/handwriting_recognizer.h"
#include "third_party/blink/renderer/modules/hid/hid.h"
#include "third_party/blink/renderer/modules/installedapp/navigator_installed_app.h"
#include "third_party/blink/renderer/modules/keyboard/keyboard.h"
#include "third_party/blink/renderer/modules/keyboard/navigator_keyboard.h"
#include "third_party/blink/renderer/modules/locked_mode/locked_mode.h"
#include "third_party/blink/renderer/modules/locks/lock_manager.h"
#include "third_party/blink/renderer/modules/managed_device/navigator_managed_data.h"
#include "third_party/blink/renderer/modules/media_capabilities/media_capabilities.h"
#include "third_party/blink/renderer/modules/mediasession/media_session.h"
#include "third_party/blink/renderer/modules/mediastream/media_devices.h"
#include "third_party/blink/renderer/modules/mediastream/navigator_media_stream.h"
#include "third_party/blink/renderer/modules/ml/ml.h"
#include "third_party/blink/renderer/modules/ml/navigator_ml.h"
#include "third_party/blink/renderer/modules/navigatorcontentutils/navigator_content_utils.h"
#include "third_party/blink/renderer/modules/netinfo/network_information.h"
#include "third_party/blink/renderer/modules/permissions/permissions.h"
#include "third_party/blink/renderer/modules/plugins/dom_mime_type_array.h"
#include "third_party/blink/renderer/modules/plugins/dom_plugin_array.h"
#include "third_party/blink/renderer/modules/plugins/navigator_plugins.h"
#include "third_party/blink/renderer/modules/presentation/presentation.h"
#include "third_party/blink/renderer/modules/quota/deprecated_storage_quota.h"
#include "third_party/blink/renderer/modules/quota/navigator_storage_quota.h"
#include "third_party/blink/renderer/modules/quota/storage_manager.h"
#include "third_party/blink/renderer/modules/serial/serial.h"
#include "third_party/blink/renderer/modules/service_worker/navigator_service_worker.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker_container.h"
#include "third_party/blink/renderer/modules/smart_card/smart_card_resource_manager.h"
#include "third_party/blink/renderer/modules/subapps/sub_apps.h"
#include "third_party/blink/renderer/modules/vibration/vibration_controller.h"
#include "third_party/blink/renderer/modules/virtualkeyboard/virtual_keyboard.h"
#include "third_party/blink/renderer/modules/wake_lock/wake_lock.h"
#include "third_party/blink/renderer/modules/web_install/navigator_web_install.h"
#include "third_party/blink/renderer/modules/webgpu/gpu.h"
#include "third_party/blink/renderer/modules/webmidi/midi_access.h"
#include "third_party/blink/renderer/modules/webmidi/navigator_web_midi.h"
#include "third_party/blink/renderer/modules/webshare/navigator_share.h"
#include "third_party/blink/renderer/modules/webusb/usb.h"
#include "third_party/blink/renderer/modules/window_controls_overlay/window_controls_overlay.h"
#include "third_party/blink/renderer/modules/xr/xr_system.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



void V8Navigator::Impl::Init() {
  V8Navigator::install_interface_template_func_ = InstallInterfaceTemplate;
V8Navigator::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8Navigator::install_context_independent_props_func_ = InstallContextIndependentProperties;
V8Navigator::install_context_dependent_props_func_ = InstallContextDependentProperties;
}

namespace  {

namespace v8_navigator {


void VendorSubAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_vendorSub_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.vendorSub.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.vendorSub.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorVendorSub);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->vendorSub();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorVendorSub, return_value);
}



void ProductSubAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_productSub_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.productSub.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.productSub.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorProductSub);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->productSub();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorProductSub, return_value);
}



void VendorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_vendor_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.vendor.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.vendor.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorVendor);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->vendor();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorVendor, return_value);
}



void MaxTouchPointsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_maxTouchPoints_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.maxTouchPoints.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.maxTouchPoints.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorMaxTouchPoints);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorEvents::maxTouchPoints(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorMaxTouchPoints, return_value);
}



void CpuPerformanceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_cpuPerformance_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.cpuPerformance.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.cpuPerformance.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorCPUPerformance);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorCPUPerformance::cpuPerformance(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedShort, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint16_t>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorCPUPerformance, return_value);
}



void SchedulingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_scheduling_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.scheduling.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Scheduling::scheduling(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Scheduling, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void UserActivationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_userActivation_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.userActivation.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorUserActivation::userActivation(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<UserActivation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void GeolocationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_geolocation_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.geolocation.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Geolocation::geolocation(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Geolocation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PreferencesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_preferences_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.preferences.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorPreferences::preferences(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<PreferenceManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ModelContextAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_modelContext_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.modelContext.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ModelContextSupplement::modelContext(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<ModelContext, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void ModelContextAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_modelContext_Setter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.modelContext.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "modelContext";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void ModelContextTestingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_modelContextTesting_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.modelContextTesting.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ModelContextSupplement::modelContextTesting(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<ModelContextTesting, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void ModelContextTestingAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_modelContextTesting_Setter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.modelContextTesting.set");

// [Replaceable]
bool did_create;
v8::Local<v8::Object> v8_receiver = info.This();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const char* const property_name = "modelContextTesting";
v8::Local<v8::Value> v8_property_value = info[0];
if (!v8_receiver->CreateDataProperty(current_context, V8AtomicString(isolate, property_name), v8_property_value).To(&did_create)) {
  return;
}
}


void DeprecatedRunAdAuctionEnforcesKAnonymityAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_deprecatedRunAdAuctionEnforcesKAnonymity_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.deprecatedRunAdAuctionEnforcesKAnonymity.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorAuction::deprecatedRunAdAuctionEnforcesKAnonymity(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void ProtectedAudienceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_protectedAudience_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.protectedAudience.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorAuction::protectedAudience(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<ProtectedAudience, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void BluetoothAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_bluetooth_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.bluetooth.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Bluetooth::bluetooth(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Bluetooth, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ClipboardAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_clipboard_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.clipboard.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Clipboard::clipboard(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Clipboard, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ContactsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_contacts_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.contacts.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = ContactsManager::contacts(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<ContactsManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CookieDeprecationLabelAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_cookieDeprecationLabel_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.cookieDeprecationLabel.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = CookieDeprecationLabel::cookieDeprecationLabel(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<CookieDeprecationLabel, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CredentialsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_credentials_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.credentials.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = AuthenticationCredentialsContainer::credentials(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<CredentialsContainer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LoginAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_login_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.login.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorLogin::login(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<NavigatorLogin, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void InkAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_ink_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.ink.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Ink::ink(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Ink, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void DevicePostureAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_devicePosture_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.devicePosture.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDevicePosture);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorDevicePosture::devicePosture(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DevicePosture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void DoNotTrackAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_doNotTrack_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.doNotTrack.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.doNotTrack.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorDoNotTrack);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorDoNotTrack::doNotTrack(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorDoNotTrack, return_value);
}



void HidAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_hid_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.hid.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = HID::hid(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<HID, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void KeyboardAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_keyboard_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.keyboard.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorKeyboard::keyboard(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Keyboard, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LockedModeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_lockedMode_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.lockedMode.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = LockedMode::lockedMode(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<LockedMode, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ManagedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_managed_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.managed.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorManagedData::managed(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<NavigatorManagedData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MediaCapabilitiesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_mediaCapabilities_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.mediaCapabilities.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = MediaCapabilities::mediaCapabilities(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<MediaCapabilities, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MediaSessionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_mediaSession_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.mediaSession.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = MediaSession::mediaSession(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<MediaSession, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MediaDevicesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_mediaDevices_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.mediaDevices.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = MediaDevices::mediaDevices(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<MediaDevices, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PermissionsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_permissions_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.permissions.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Permissions::permissions(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Permissions, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PluginsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_plugins_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.plugins.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.plugins.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorPlugins);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorPlugins::plugins(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DOMPluginArray, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MimeTypesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_mimeTypes_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.mimeTypes.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.mimeTypes.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorMimeTypes);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorPlugins::mimeTypes(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DOMMimeTypeArray, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PdfViewerEnabledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_pdfViewerEnabled_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.pdfViewerEnabled.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.pdfViewerEnabled.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorPdfViewerEnabled);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorPlugins::pdfViewerEnabled(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void PresentationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_presentation_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.presentation.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Presentation::presentation(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Presentation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void WebkitTemporaryStorageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_webkitTemporaryStorage_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.webkitTemporaryStorage.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPrefixedStorageQuota);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorStorageQuota::webkitTemporaryStorage(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DeprecatedStorageQuota, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void WebkitPersistentStorageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_webkitPersistentStorage_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.webkitPersistentStorage.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPrefixedStorageQuota);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorStorageQuota::webkitPersistentStorage(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<DeprecatedStorageQuota, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void StorageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_storage_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.storage.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorStorageQuota::storage(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<StorageManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void SerialAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_serial_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.serial.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = Serial::serial(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<Serial, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ServiceWorkerAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_serviceWorker_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.serviceWorker.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = NavigatorServiceWorker::serviceWorker(script_state, *blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<ServiceWorkerContainer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void SubAppsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_subApps_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.subApps.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = SubApps::subApps(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<SubApps, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void VirtualKeyboardAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_virtualKeyboard_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.virtualKeyboard.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = VirtualKeyboard::virtualKeyboard(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<VirtualKeyboard, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void WakeLockAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_wakeLock_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.wakeLock.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = WakeLock::wakeLock(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<WakeLock, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void GpuAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_gpu_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.gpu.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = GPU::gpu(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<GPU, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void UsbAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_usb_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.usb.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = USB::usb(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<USB, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void WindowControlsOverlayAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_windowControlsOverlay_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.windowControlsOverlay.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = WindowControlsOverlay::windowControlsOverlay(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<WindowControlsOverlay, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void XRAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_xr_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.xr.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorXR);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = XRSystem::xr(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<XRSystem, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void SmartCardAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_smartCard_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.smartCard.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = SmartCardResourceManager::smartCard(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<SmartCardResourceManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void HardwareConcurrencyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_hardwareConcurrency_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.hardwareConcurrency.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.hardwareConcurrency.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorHardwareConcurrency);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->hardwareConcurrency();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLongLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint64_t>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorHardwareConcurrency, return_value);
}



void CookieEnabledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_cookieEnabled_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.cookieEnabled.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.cookieEnabled.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorCookieEnabled);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->cookieEnabled();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorCookieEnabled, return_value);
}



void DeviceMemoryAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_deviceMemory_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.deviceMemory.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.deviceMemory.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorDeviceMemory);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->deviceMemory();
static_assert(bindings::IsReturnTypeCompatible<IDLFloat, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<float>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorDeviceMemory, return_value);
}



void AppCodeNameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_appCodeName_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.appCodeName.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->appCodeName();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void AppNameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_appName_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.appName.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->appName();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void AppVersionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_appVersion_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.appVersion.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.appVersion.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorAppVersion);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->appVersion();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorAppVersion, return_value);
}



void PlatformAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_platform_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.platform.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.platform.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorPlatform);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->platform();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorPlatform, return_value);
}



void ProductAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_product_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.product.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->product();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void UserAgentAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_userAgent_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.userAgent.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.userAgent.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorUserAgent);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->userAgent();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorUserAgent, return_value);
}



void LanguageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_language_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.language.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.language.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorLanguage);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->language();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorLanguage, return_value);
}



void LanguagesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_languages_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.languages.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.languages.get", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNavigatorLanguages);


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
// [CachedAttribute]
static const V8PrivateProperty::SymbolKey kPrivatePropertyCachedAttribute;
auto&& v8_private_cached_attribute =
    V8PrivateProperty::GetSymbol(isolate, kPrivatePropertyCachedAttribute);
if (!blink_receiver->IsLanguagesDirty()) {
  v8::Local<v8::Value> v8_value;
  if (!v8_private_cached_attribute.GetOrUndefined(v8_receiver)
           .ToLocal(&v8_value)) {
    return;
  }
  if (!v8_value->IsUndefined()) {
    bindings::V8SetReturnValue(info, v8_value);
    return;
  }
}

ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->languages();
static_assert(bindings::IsReturnTypeCompatible<IDLArray<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLArray<IDLString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kNavigatorLanguages, return_value);
// [CachedAttribute]
v8_private_cached_attribute.Set(v8_receiver, info.GetReturnValue().Get());
}



void OnLineAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_onLine_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.onLine.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onLine();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void WebdriverAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_webdriver_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.webdriver.get");
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.webdriver.get", info);



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->webdriver();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void UserAgentDataAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_userAgentData_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.userAgentData.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->userAgentData();
static_assert(bindings::IsReturnTypeCompatible<NavigatorUAData, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void StorageBucketsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_storageBuckets_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.storageBuckets.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = StorageBucketManager::storageBuckets(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<StorageBucketManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void LocksAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_locks_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.locks.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = LockManager::locks(*blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<LockManager, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MlAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_ml_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.ml.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorML::ml(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<ML, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ConnectionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_connection_Getter");
BLINK_BINDINGS_TRACE_EVENT("Navigator.connection.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kNetInfo);



v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NetworkInformation::connection(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<NetworkInformation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}


void AdAuctionComponentsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_adAuctionComponents");
BLINK_BINDINGS_TRACE_EVENT("Navigator.adAuctionComponents");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_AdAuctionComponents_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_num_components = NativeValueTraits<IDLUnsignedShortClamp>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::adAuctionComponents(script_state, *blink_receiver, arg1_num_components, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<IDLUSVString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void CanLoadAdAuctionFencedFrameOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_canLoadAdAuctionFencedFrame");
BLINK_BINDINGS_TRACE_EVENT("Navigator.canLoadAdAuctionFencedFrame");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorAuction::canLoadAdAuctionFencedFrame(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void CanShareOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_canShare");
BLINK_BINDINGS_TRACE_EVENT("Navigator.canShare");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebShareCanShare);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<ShareData>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_data;
if (info[0]->IsUndefined()) {
  arg1_data = ShareData::Create();
} else {
  ExceptionState exception_state(isolate);
arg1_data = NativeValueTraits<ShareData>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = NavigatorShare::canShare(script_state, *blink_receiver, arg1_data);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void ClearAppBadgeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_clearAppBadge");
BLINK_BINDINGS_TRACE_EVENT("Navigator.clearAppBadge");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kBadgeClear);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "clearAppBadge";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = NavigatorBadge::clearAppBadge(script_state, *blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void ClearOriginJoinedAdInterestGroupsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_clearOriginJoinedAdInterestGroups");
BLINK_BINDINGS_TRACE_EVENT("Navigator.clearOriginJoinedAdInterestGroups");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_ClearOriginJoinedAdInterestGroups_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptPromise<IDLUndefined> return_value;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "clearOriginJoinedAdInterestGroups";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_owner = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  return_value = NavigatorAuction::clearOriginJoinedAdInterestGroups(script_state, *blink_receiver, arg1_owner, exception_state);
break;
}
auto&& arg2_groups_to_keep = NativeValueTraits<IDLSequence<IDLUSVString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = NavigatorAuction::clearOriginJoinedAdInterestGroups(script_state, *blink_receiver, arg1_owner, std::move(arg2_groups_to_keep), exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateAdRequestOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_createAdRequest");
BLINK_BINDINGS_TRACE_EVENT("Navigator.createAdRequest");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_CreateAdRequest_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "createAdRequest";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_config = NativeValueTraits<AdRequestConfig>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::createAdRequest(script_state, *blink_receiver, arg1_config, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<Ads>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateAuctionNonceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_createAuctionNonce");
BLINK_BINDINGS_TRACE_EVENT("Navigator.createAuctionNonce");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_CreateAuctionNonce_Method);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "createAuctionNonce";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = NavigatorAuction::createAuctionNonce(script_state, *blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void CreateHandwritingRecognizerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_createHandwritingRecognizer");
BLINK_BINDINGS_TRACE_EVENT("Navigator.createHandwritingRecognizer");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kHandwritingRecognitionCreateRecognizer);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "createHandwritingRecognizer";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_constraint = NativeValueTraits<HandwritingModelConstraint>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = HandwritingRecognitionService::createHandwritingRecognizer(script_state, *blink_receiver, arg1_constraint, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<HandwritingRecognizer>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void DeprecatedReplaceInURNOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_deprecatedReplaceInURN");
BLINK_BINDINGS_TRACE_EVENT("Navigator.deprecatedReplaceInURN");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_DeprecatedReplaceInURN_Method);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "deprecatedReplaceInURN";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_urn_or_config = NativeValueTraits<V8UnionFencedFrameConfigOrUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_replacements = NativeValueTraits<IDLRecord<IDLUSVString, IDLUSVString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::deprecatedReplaceInURN(script_state, *blink_receiver, arg1_urn_or_config, arg2_replacements, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void DeprecatedURNToURLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_deprecatedURNToURL");
BLINK_BINDINGS_TRACE_EVENT("Navigator.deprecatedURNToURL");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_DeprecatedURNToURL_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "deprecatedURNToURL";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_urn_or_config = NativeValueTraits<V8UnionFencedFrameConfigOrUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLBoolean>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_send_reports{false};
if (!info[1]->IsUndefined()) {
  arg2_send_reports = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = NavigatorAuction::deprecatedURNToURL(script_state, *blink_receiver, arg1_urn_or_config, arg2_send_reports, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUSVString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void FinalizeAdOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_finalizeAd");
BLINK_BINDINGS_TRACE_EVENT("Navigator.finalizeAd");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_FinalizeAd_Method);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "finalizeAd";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_ads = NativeValueTraits<Ads>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_config = NativeValueTraits<AuctionAdConfig>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::finalizeAd(script_state, *blink_receiver, arg1_ads, arg2_config, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void GetBatteryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_getBattery");
BLINK_BINDINGS_TRACE_EVENT("Navigator.getBattery");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kBatteryStatusGetBattery);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = BatteryManager::getBattery(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<BatteryManager>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetGamepadsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_getGamepads");
BLINK_BINDINGS_TRACE_EVENT("Navigator.getGamepads");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kGetGamepads);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = NavigatorGamepad::getGamepads(*blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<IDLNullable<Gamepad>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<IDLNullable<Gamepad>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetInstalledRelatedAppsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_getInstalledRelatedApps");
BLINK_BINDINGS_TRACE_EVENT("Navigator.getInstalledRelatedApps");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_GetInstalledRelatedApps_Method);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "getInstalledRelatedApps";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = NavigatorInstalledApp::getInstalledRelatedApps(script_state, *blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLSequence<RelatedApplication>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void GetInterestGroupAdAuctionDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_getInterestGroupAdAuctionData");
BLINK_BINDINGS_TRACE_EVENT("Navigator.getInterestGroupAdAuctionData");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_GetInterestGroupAdAuctionData_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "getInterestGroupAdAuctionData";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_config = NativeValueTraits<AdAuctionDataConfig>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::getInterestGroupAdAuctionData(script_state, *blink_receiver, arg1_config, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<AdAuctionData>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void GetUserMediaOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_getUserMedia");
BLINK_BINDINGS_TRACE_EVENT("Navigator.getUserMedia");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.getUserMedia", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kGetUserMediaLegacy);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_constraints = NativeValueTraits<MediaStreamConstraints>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_success_callback = NativeValueTraits<V8NavigatorUserMediaSuccessCallback>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_error_callback = NativeValueTraits<V8NavigatorUserMediaErrorCallback>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
NavigatorMediaStream::getUserMedia(*blink_receiver, arg1_constraints, arg2_success_callback, arg3_error_callback, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void InstallOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kDRAFT_WebInstallAPI);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "install";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = NavigatorWebInstall::install(script_state, *blink_receiver, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<WebInstallResult>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void InstallOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kDRAFT_WebInstallAPI);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "install";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_install_url = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorWebInstall::install(script_state, *blink_receiver, arg1_install_url, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<WebInstallResult>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void InstallOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [Measure], [MeasureAs]
bindings::CountWebDXFeature(isolate, WebDXFeature::kDRAFT_WebInstallAPI);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "install";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_install_url = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_manifest_id = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorWebInstall::install(script_state, *blink_receiver, arg1_install_url, arg2_manifest_id, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<WebInstallResult>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void InstallOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  // Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_install");
BLINK_BINDINGS_TRACE_EVENT("Navigator.install");


const int arg_count = std::min(info.Length(), 2);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
if (RuntimeEnabledFeatures::WebAppInstallationEnabled(execution_context)) {
  if (arg_count == 2) {
  return InstallOperationOverload3(info);
}
}
if (RuntimeEnabledFeatures::WebAppInstallationEnabled(execution_context)) {
  if (arg_count == 1) {
  return InstallOperationOverload2(info);
}
}
if (RuntimeEnabledFeatures::WebAppInstallationEnabled(execution_context)) {
  return InstallOperationOverload1(info);
}

V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void JavaEnabledOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_javaEnabled");
BLINK_BINDINGS_TRACE_EVENT("Navigator.javaEnabled");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.javaEnabled", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_JavaEnabled_Method);




v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = NavigatorPlugins::javaEnabled(*blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kV8Navigator_JavaEnabled_Method, return_value);
}

void JoinAdInterestGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_joinAdInterestGroup");
BLINK_BINDINGS_TRACE_EVENT("Navigator.joinAdInterestGroup");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_JoinAdInterestGroup_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptPromise<IDLUndefined> return_value;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "joinAdInterestGroup";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_group = NativeValueTraits<AuctionAdInterestGroup>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  return_value = NavigatorAuction::joinAdInterestGroup(script_state, *blink_receiver, arg1_group, exception_state);
break;
}
auto&& arg2_duration_seconds = NativeValueTraits<IDLDouble>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = NavigatorAuction::joinAdInterestGroup(script_state, *blink_receiver, arg1_group, arg2_duration_seconds, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void LeaveAdInterestGroupOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_leaveAdInterestGroup");
BLINK_BINDINGS_TRACE_EVENT("Navigator.leaveAdInterestGroup");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_LeaveAdInterestGroup_Method);




ScriptPromise<IDLUndefined> return_value;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "leaveAdInterestGroup";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  return_value = NavigatorAuction::leaveAdInterestGroup(script_state, *blink_receiver, exception_state);
break;
}
auto&& arg1_group = NativeValueTraits<AuctionAdInterestGroupKey>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = NavigatorAuction::leaveAdInterestGroup(script_state, *blink_receiver, arg1_group, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void QueryHandwritingRecognizerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_queryHandwritingRecognizer");
BLINK_BINDINGS_TRACE_EVENT("Navigator.queryHandwritingRecognizer");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kHandwritingRecognitionQueryRecognizer);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "queryHandwritingRecognizer";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_constraint = NativeValueTraits<HandwritingModelConstraint>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = HandwritingRecognitionService::queryHandwritingRecognizer(script_state, *blink_receiver, arg1_constraint, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLNullable<HandwritingRecognizerQueryResult>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void RegisterProtocolHandlerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_registerProtocolHandler");
BLINK_BINDINGS_TRACE_EVENT("Navigator.registerProtocolHandler");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_scheme = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_url = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
NavigatorContentUtils::registerProtocolHandler(*blink_receiver, arg1_scheme, arg2_url, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void RequestMIDIAccessOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_requestMIDIAccess");
BLINK_BINDINGS_TRACE_EVENT("Navigator.requestMIDIAccess");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kRequestMIDIAccess_ObscuredByFootprinting);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<MIDIOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_options;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "requestMIDIAccess";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
if (info[0]->IsUndefined()) {
  arg1_options = MIDIOptions::Create();
} else {
  arg1_options = NativeValueTraits<MIDIOptions>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = NavigatorWebMIDI::requestMIDIAccess(script_state, *blink_receiver, arg1_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<MIDIAccess>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void RequestMediaKeySystemAccessOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_requestMediaKeySystemAccess");
BLINK_BINDINGS_TRACE_EVENT("Navigator.requestMediaKeySystemAccess");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}



if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "requestMediaKeySystemAccess";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_key_system = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_supported_configurations = NativeValueTraits<IDLSequence<MediaKeySystemConfiguration>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorRequestMediaKeySystemAccess::requestMediaKeySystemAccess(script_state, *blink_receiver, arg1_key_system, std::move(arg2_supported_configurations), exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<MediaKeySystemAccess>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void RunAdAuctionOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_runAdAuction");
BLINK_BINDINGS_TRACE_EVENT("Navigator.runAdAuction");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_RunAdAuction_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "runAdAuction";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& arg1_config = NativeValueTraits<AuctionAdConfig>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = NavigatorAuction::runAdAuction(script_state, *blink_receiver, arg1_config, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLNullable<V8UnionFencedFrameConfigOrUSVString>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void SendBeaconOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_sendBeacon");
BLINK_BINDINGS_TRACE_EVENT("Navigator.sendBeacon");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kSendBeacon);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_url = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLNullable<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString>>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_data{nullptr};
if (!info[1]->IsUndefined()) {
  arg2_data = NativeValueTraits<IDLNullable<V8UnionArrayBufferOrArrayBufferViewOrBlobOrFormDataOrReadableStreamOrURLSearchParamsOrUSVString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = NavigatorBeacon::sendBeacon(script_state, *blink_receiver, arg1_url, arg2_data, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void SetAppBadgeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_setAppBadge");
BLINK_BINDINGS_TRACE_EVENT("Navigator.setAppBadge");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kBadgeSet);




ScriptPromise<IDLUndefined> return_value;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "setAppBadge";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  return_value = NavigatorBadge::setAppBadge(script_state, *blink_receiver, exception_state);
break;
}
auto&& arg1_contents = NativeValueTraits<IDLUnsignedLongLongEnforceRange>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = NavigatorBadge::setAppBadge(script_state, *blink_receiver, arg1_contents, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void ShareOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_share");
BLINK_BINDINGS_TRACE_EVENT("Navigator.share");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Navigator::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebShareShare);




ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<ShareData>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_data;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Navigator";
const char* const property_name = "share";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
if (info[0]->IsUndefined()) {
  arg1_data = ShareData::Create();
} else {
  arg1_data = NativeValueTraits<ShareData>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = NavigatorShare::share(script_state, *blink_receiver, arg1_data, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void UnregisterProtocolHandlerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_unregisterProtocolHandler");
BLINK_BINDINGS_TRACE_EVENT("Navigator.unregisterProtocolHandler");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_scheme = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_url = NativeValueTraits<IDLUSVString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
NavigatorContentUtils::unregisterProtocolHandler(*blink_receiver, arg1_scheme, arg2_url, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void UpdateAdInterestGroupsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_updateAdInterestGroups");
BLINK_BINDINGS_TRACE_EVENT("Navigator.updateAdInterestGroups");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Navigator_UpdateAdInterestGroups_Method);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
NavigatorAuction::updateAdInterestGroups(script_state, *blink_receiver, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void VibrateOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pattern = NativeValueTraits<IDLUnsignedLongClamp>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = VibrationController::vibrate(*blink_receiver, arg1_pattern);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void VibrateOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pattern = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = VibrationController::vibrate(*blink_receiver, std::move(arg1_pattern));
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void VibrateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_vibrate");
BLINK_BINDINGS_TRACE_EVENT("Navigator.vibrate");


const int arg_count = std::min(info.Length(), 1);
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 1) {
  if (info[0]->IsObject()) {
  ExceptionState exception_state(isolate);
if (info[0]->IsArray() || bindings::IsEsIterableObject(isolate, info[0], exception_state)) {
  return VibrateOperationOverload2(info);
}
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (info[0]->IsNumber()) {
  return VibrateOperationOverload1(info);
}
return VibrateOperationOverload1(info);
}

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void WebkitGetUserMediaOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Navigator_webkitGetUserMedia");
BLINK_BINDINGS_TRACE_EVENT("Navigator.webkitGetUserMedia");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("Navigator.webkitGetUserMedia", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kGetUserMediaPrefixed);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Navigator* blink_receiver = V8Navigator::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_constraints = NativeValueTraits<MediaStreamConstraints>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_success_callback = NativeValueTraits<V8NavigatorUserMediaSuccessCallback>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_error_callback = NativeValueTraits<V8NavigatorUserMediaErrorCallback>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
NavigatorMediaStream::getUserMedia(*blink_receiver, arg1_constraints, arg2_success_callback, arg3_error_callback, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_navigator

using namespace v8_navigator;

}  // namespace 

void V8Navigator::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8Navigator::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8Navigator::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"vendorSub", VendorSubAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"productSub", ProductSubAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"vendor", VendorAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"maxTouchPoints", MaxTouchPointsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"scheduling", SchedulingAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"userActivation", UserActivationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"geolocation", GeolocationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"doNotTrack", DoNotTrackAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"plugins", PluginsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"mimeTypes", MimeTypesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"pdfViewerEnabled", PdfViewerEnabledAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"webkitTemporaryStorage", WebkitTemporaryStorageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"webkitPersistentStorage", WebkitPersistentStorageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"hardwareConcurrency", HardwareConcurrencyAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"cookieEnabled", CookieEnabledAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"appCodeName", AppCodeNameAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"appName", AppNameAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"appVersion", AppVersionAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"platform", PlatformAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"product", ProductAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"userAgent", UserAgentAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"language", LanguageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"languages", LanguagesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onLine", OnLineAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"webdriver", WebdriverAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"connection", ConnectionAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Navigator", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getGamepads", GetGamepadsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"javaEnabled", JavaEnabledOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"sendBeacon", SendBeaconOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"vibrate", VibrateOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Navigator", kOperationTable);
}



}

void V8Navigator::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::WebMCPEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"modelContext", ModelContextAttributeGetCallback, ModelContextAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Navigator", kAttributeTable);
}
if (RuntimeEnabledFeatures::WebMCPEnabled() && RuntimeEnabledFeatures::WebMCPTestingEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"modelContextTesting", ModelContextTestingAttributeGetCallback, ModelContextTestingAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Navigator", kAttributeTable);
}
if (RuntimeEnabledFeatures::WindowControlsOverlayEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"windowControlsOverlay", WindowControlsOverlayAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Navigator", kAttributeTable);
}






}

void V8Navigator::Impl::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const bool is_in_secure_context = execution_context->IsSecureContext();
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::CpuPerformanceEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"cpuPerformance", CpuPerformanceAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebPreferencesEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"preferences", PreferencesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::EnforceAnonymityExposureEnabled())) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"deprecatedRunAdAuctionEnforcesKAnonymity", DeprecatedRunAdAuctionEnforcesKAnonymityAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"protectedAudience", ProtectedAudienceAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebBluetoothEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"bluetooth", BluetoothAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"clipboard", ClipboardAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"credentials", CredentialsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"keyboard", KeyboardAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"managed", ManagedAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"mediaDevices", MediaDevicesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"storage", StorageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"serviceWorker", ServiceWorkerAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"virtualKeyboard", VirtualKeyboardAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"wakeLock", WakeLockAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"deviceMemory", DeviceMemoryAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"userAgentData", UserAgentDataAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"locks", LocksAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::ContactsManagerEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"contacts", ContactsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::CookieDeprecationFacilitatedTestingEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"cookieDeprecationLabel", CookieDeprecationLabelAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::FedCmEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"login", LoginAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (execution_context->IsWindow() && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ink", InkAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"mediaCapabilities", MediaCapabilitiesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::DevicePostureEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"devicePosture", DevicePostureAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebHIDEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"hid", HidAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::LockedModeEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"lockedMode", LockedModeAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::MediaSessionEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"mediaSession", MediaSessionAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::PermissionsEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"permissions", PermissionsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::PresentationEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"presentation", PresentationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::SerialEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"serial", SerialAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
const bool is_in_isolated_context = execution_context->IsIsolatedContext();
if (is_in_isolated_context && is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::DesktopPWAsSubAppsEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"subApps", SubAppsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && execution_context->IsWindow() && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"gpu", GpuAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebUSBEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"usb", UsbAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebXREnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"xr", XRAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_isolated_context && is_in_secure_context && execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::SmartCardEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"smartCard", SmartCardAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::StorageBucketsEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"storageBuckets", StorageBucketsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"ml", MlAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kAttributeTable);
}




if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::FledgeEnabled())) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"adAuctionComponents", AdAuctionComponentsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"runAdAuction", RunAdAuctionOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::FencedFramesEnabled())) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"canLoadAdAuctionFencedFrame", CanLoadAdAuctionFencedFrameOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebShareEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"canShare", CanShareOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"share", ShareOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && feature_selector.IsAll()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearAppBadge", ClearAppBadgeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getBattery", GetBatteryOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUserMedia", GetUserMediaOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"requestMIDIAccess", RequestMIDIAccessOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"requestMediaKeySystemAccess", RequestMediaKeySystemAccessOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setAppBadge", SetAppBadgeOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"webkitGetUserMedia", WebkitGetUserMediaOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearOriginJoinedAdInterestGroups", ClearOriginJoinedAdInterestGroupsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createAuctionNonce", CreateAuctionNonceOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"joinAdInterestGroup", JoinAdInterestGroupOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"leaveAdInterestGroup", LeaveAdInterestGroupOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"updateAdInterestGroups", UpdateAdInterestGroupsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::ParakeetEnabled(execution_context))) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI, mojom::blink::OriginTrialFeature::kParakeet))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"createAdRequest", CreateAdRequestOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"finalizeAd", FinalizeAdOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::HandwritingRecognitionEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"createHandwritingRecognizer", CreateHandwritingRecognizerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"queryHandwritingRecognizer", QueryHandwritingRecognizerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::AllowURNsInIframesEnabled())) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"deprecatedReplaceInURN", DeprecatedReplaceInURNOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deprecatedURNToURL", DeprecatedURNToURLOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::InstalledAppEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getInstalledRelatedApps", GetInstalledRelatedAppsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && ((feature_selector.IsAll() && (RuntimeEnabledFeatures::AdInterestGroupAPIEnabled(execution_context) && RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIEnabled(execution_context))) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kAdInterestGroupAPI, mojom::blink::OriginTrialFeature::kFledgeBiddingAndAuctionServerAPI))) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getInterestGroupAdAuctionData", GetInterestGroupAdAuctionDataOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::WebAppInstallationEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kWebAppInstallation)) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"install", InstallOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::NavigatorContentUtilsEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"registerProtocolHandler", RegisterProtocolHandlerOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"unregisterProtocolHandler", UnregisterProtocolHandlerOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Navigator", kOperationTable);
}


}


}  // namespace blink
