// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_resample_2d_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"axes",
"mode",
"scales",
"sizes",
};


}  // namespace 

MLResample2dOptions* MLResample2dOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MLResample2dOptions* dictionary = MakeGarbageCollected<MLResample2dOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MLResample2dOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MLResample2dOptions::MLResample2dOptions() {
  
}

 MLResample2dOptions::MLResample2dOptions(v8::Isolate* isolate) : MLOperatorOptions(isolate) {
  
}



Vector<uint32_t> MLResample2dOptions::getAxesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasAxes()) {
  return fallback_value;
}
return member_axes_;
}

Vector<uint32_t> MLResample2dOptions::getAxesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasAxes()) {
  return std::move(fallback_value);
}
return member_axes_;
}

void MLResample2dOptions::setAxes(const Vector<uint32_t>& value) {
  member_axes_ = value;
has_axes_ = true;
}

void MLResample2dOptions::setAxes(Vector<uint32_t>&& value) {
  member_axes_ = std::move(value);
has_axes_ = true;
}









Vector<float> MLResample2dOptions::getScalesOr(const Vector<float>& fallback_value) const {
  if (!hasScales()) {
  return fallback_value;
}
return member_scales_;
}

Vector<float> MLResample2dOptions::getScalesOr(Vector<float>&& fallback_value) const {
  if (!hasScales()) {
  return std::move(fallback_value);
}
return member_scales_;
}

void MLResample2dOptions::setScales(const Vector<float>& value) {
  member_scales_ = value;
has_scales_ = true;
}

void MLResample2dOptions::setScales(Vector<float>&& value) {
  member_scales_ = std::move(value);
has_scales_ = true;
}




Vector<uint32_t> MLResample2dOptions::getSizesOr(const Vector<uint32_t>& fallback_value) const {
  if (!hasSizes()) {
  return fallback_value;
}
return member_sizes_;
}

Vector<uint32_t> MLResample2dOptions::getSizesOr(Vector<uint32_t>&& fallback_value) const {
  if (!hasSizes()) {
  return std::move(fallback_value);
}
return member_sizes_;
}

void MLResample2dOptions::setSizes(const Vector<uint32_t>& value) {
  member_sizes_ = value;
has_sizes_ = true;
}

void MLResample2dOptions::setSizes(Vector<uint32_t>&& value) {
  member_sizes_ = std::move(value);
has_sizes_ = true;
}



void MLResample2dOptions::Trace(Visitor* visitor) const {
  MLOperatorOptions::Trace(visitor);
}

void MLResample2dOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
MLOperatorOptions::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "MLResample2dOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("axes");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_axes_, member_axes_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mode");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8MLInterpolationMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scales");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLFloat>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_scales_, member_scales_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sizes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUnsignedLongEnforceRange>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_sizes_, member_sizes_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MLResample2dOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
