// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OP_SUPPORT_LIMITS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OP_SUPPORT_LIMITS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_input_operand_layout.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLBatchNormalizationSupportLimits;
class MLBinarySupportLimits;
class MLConcatSupportLimits;
class MLConv2dSupportLimits;
class MLGatherSupportLimits;
class MLGemmSupportLimits;
class MLGruCellSupportLimits;
class MLGruSupportLimits;
class MLLogicalNotSupportLimits;
class MLLstmCellSupportLimits;
class MLLstmSupportLimits;
class MLNormalizationSupportLimits;
class MLPreluSupportLimits;
class MLQuantizeDequantizeLinearSupportLimits;
class MLScatterSupportLimits;
class MLSingleInputSupportLimits;
class MLSplitSupportLimits;
class MLTensorLimits;
class MLWhereSupportLimits;

class MODULES_EXPORT MLOpSupportLimits : public bindings::DictionaryBase {
  
  public:
static MLOpSupportLimits* Create() {
  return MakeGarbageCollected<MLOpSupportLimits>();
}
static MLOpSupportLimits* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLOpSupportLimits>(isolate);
}
static MLOpSupportLimits* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLOpSupportLimits();
explicit  MLOpSupportLimits(v8::Isolate* isolate);

bool hasAbs() const {
  return has_abs_;
}
MLSingleInputSupportLimits* abs() const {
  DCHECK(hasAbs());
return member_abs_.Get();
}
MLSingleInputSupportLimits* getAbsOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasAbs()) {
  return fallback_value;
}
return member_abs_.Get();
}
void setAbs(MLSingleInputSupportLimits* value) {
  member_abs_ = value;
has_abs_ = true;
DCHECK(member_abs_);
}

bool hasAdd() const {
  return has_add_;
}
MLBinarySupportLimits* add() const {
  DCHECK(hasAdd());
return member_add_.Get();
}
MLBinarySupportLimits* getAddOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasAdd()) {
  return fallback_value;
}
return member_add_.Get();
}
void setAdd(MLBinarySupportLimits* value) {
  member_add_ = value;
has_add_ = true;
DCHECK(member_add_);
}

bool hasArgMax() const {
  return has_arg_max_;
}
MLSingleInputSupportLimits* argMax() const {
  DCHECK(hasArgMax());
return member_arg_max_.Get();
}
MLSingleInputSupportLimits* getArgMaxOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasArgMax()) {
  return fallback_value;
}
return member_arg_max_.Get();
}
void setArgMax(MLSingleInputSupportLimits* value) {
  member_arg_max_ = value;
has_arg_max_ = true;
DCHECK(member_arg_max_);
}

bool hasArgMin() const {
  return has_arg_min_;
}
MLSingleInputSupportLimits* argMin() const {
  DCHECK(hasArgMin());
return member_arg_min_.Get();
}
MLSingleInputSupportLimits* getArgMinOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasArgMin()) {
  return fallback_value;
}
return member_arg_min_.Get();
}
void setArgMin(MLSingleInputSupportLimits* value) {
  member_arg_min_ = value;
has_arg_min_ = true;
DCHECK(member_arg_min_);
}

bool hasAveragePool2d() const {
  return has_average_pool_2d_;
}
MLSingleInputSupportLimits* averagePool2d() const {
  DCHECK(hasAveragePool2d());
return member_average_pool_2d_.Get();
}
MLSingleInputSupportLimits* getAveragePool2dOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasAveragePool2d()) {
  return fallback_value;
}
return member_average_pool_2d_.Get();
}
void setAveragePool2d(MLSingleInputSupportLimits* value) {
  member_average_pool_2d_ = value;
has_average_pool_2d_ = true;
DCHECK(member_average_pool_2d_);
}

bool hasBatchNormalization() const {
  return has_batch_normalization_;
}
MLBatchNormalizationSupportLimits* batchNormalization() const {
  DCHECK(hasBatchNormalization());
return member_batch_normalization_.Get();
}
MLBatchNormalizationSupportLimits* getBatchNormalizationOr(MLBatchNormalizationSupportLimits* fallback_value) const {
  if (!hasBatchNormalization()) {
  return fallback_value;
}
return member_batch_normalization_.Get();
}
void setBatchNormalization(MLBatchNormalizationSupportLimits* value) {
  member_batch_normalization_ = value;
has_batch_normalization_ = true;
DCHECK(member_batch_normalization_);
}

bool hasCast() const {
  return has_cast_;
}
MLSingleInputSupportLimits* cast() const {
  DCHECK(hasCast());
return member_cast_.Get();
}
MLSingleInputSupportLimits* getCastOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasCast()) {
  return fallback_value;
}
return member_cast_.Get();
}
void setCast(MLSingleInputSupportLimits* value) {
  member_cast_ = value;
has_cast_ = true;
DCHECK(member_cast_);
}

bool hasCeil() const {
  return has_ceil_;
}
MLSingleInputSupportLimits* ceil() const {
  DCHECK(hasCeil());
return member_ceil_.Get();
}
MLSingleInputSupportLimits* getCeilOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasCeil()) {
  return fallback_value;
}
return member_ceil_.Get();
}
void setCeil(MLSingleInputSupportLimits* value) {
  member_ceil_ = value;
has_ceil_ = true;
DCHECK(member_ceil_);
}

bool hasClamp() const {
  return has_clamp_;
}
MLSingleInputSupportLimits* clamp() const {
  DCHECK(hasClamp());
return member_clamp_.Get();
}
MLSingleInputSupportLimits* getClampOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasClamp()) {
  return fallback_value;
}
return member_clamp_.Get();
}
void setClamp(MLSingleInputSupportLimits* value) {
  member_clamp_ = value;
has_clamp_ = true;
DCHECK(member_clamp_);
}

bool hasConcat() const {
  return has_concat_;
}
MLConcatSupportLimits* concat() const {
  DCHECK(hasConcat());
return member_concat_.Get();
}
MLConcatSupportLimits* getConcatOr(MLConcatSupportLimits* fallback_value) const {
  if (!hasConcat()) {
  return fallback_value;
}
return member_concat_.Get();
}
void setConcat(MLConcatSupportLimits* value) {
  member_concat_ = value;
has_concat_ = true;
DCHECK(member_concat_);
}

bool hasConstant() const {
  return has_constant_;
}
MLTensorLimits* constant() const {
  DCHECK(hasConstant());
return member_constant_.Get();
}
MLTensorLimits* getConstantOr(MLTensorLimits* fallback_value) const {
  if (!hasConstant()) {
  return fallback_value;
}
return member_constant_.Get();
}
void setConstant(MLTensorLimits* value) {
  member_constant_ = value;
has_constant_ = true;
DCHECK(member_constant_);
}

bool hasConv2d() const {
  return has_conv_2d_;
}
MLConv2dSupportLimits* conv2d() const {
  DCHECK(hasConv2d());
return member_conv_2d_.Get();
}
MLConv2dSupportLimits* getConv2dOr(MLConv2dSupportLimits* fallback_value) const {
  if (!hasConv2d()) {
  return fallback_value;
}
return member_conv_2d_.Get();
}
void setConv2d(MLConv2dSupportLimits* value) {
  member_conv_2d_ = value;
has_conv_2d_ = true;
DCHECK(member_conv_2d_);
}

bool hasConvTranspose2d() const {
  return has_conv_transpose_2d_;
}
MLConv2dSupportLimits* convTranspose2d() const {
  DCHECK(hasConvTranspose2d());
return member_conv_transpose_2d_.Get();
}
MLConv2dSupportLimits* getConvTranspose2dOr(MLConv2dSupportLimits* fallback_value) const {
  if (!hasConvTranspose2d()) {
  return fallback_value;
}
return member_conv_transpose_2d_.Get();
}
void setConvTranspose2d(MLConv2dSupportLimits* value) {
  member_conv_transpose_2d_ = value;
has_conv_transpose_2d_ = true;
DCHECK(member_conv_transpose_2d_);
}

bool hasCos() const {
  return has_cos_;
}
MLSingleInputSupportLimits* cos() const {
  DCHECK(hasCos());
return member_cos_.Get();
}
MLSingleInputSupportLimits* getCosOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasCos()) {
  return fallback_value;
}
return member_cos_.Get();
}
void setCos(MLSingleInputSupportLimits* value) {
  member_cos_ = value;
has_cos_ = true;
DCHECK(member_cos_);
}

bool hasCumulativeSum() const {
  return has_cumulative_sum_;
}
MLSingleInputSupportLimits* cumulativeSum() const {
  DCHECK(hasCumulativeSum());
return member_cumulative_sum_.Get();
}
MLSingleInputSupportLimits* getCumulativeSumOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasCumulativeSum()) {
  return fallback_value;
}
return member_cumulative_sum_.Get();
}
void setCumulativeSum(MLSingleInputSupportLimits* value) {
  member_cumulative_sum_ = value;
has_cumulative_sum_ = true;
DCHECK(member_cumulative_sum_);
}

bool hasDequantizeLinear() const {
  return has_dequantize_linear_;
}
MLQuantizeDequantizeLinearSupportLimits* dequantizeLinear() const {
  DCHECK(hasDequantizeLinear());
return member_dequantize_linear_.Get();
}
MLQuantizeDequantizeLinearSupportLimits* getDequantizeLinearOr(MLQuantizeDequantizeLinearSupportLimits* fallback_value) const {
  if (!hasDequantizeLinear()) {
  return fallback_value;
}
return member_dequantize_linear_.Get();
}
void setDequantizeLinear(MLQuantizeDequantizeLinearSupportLimits* value) {
  member_dequantize_linear_ = value;
has_dequantize_linear_ = true;
DCHECK(member_dequantize_linear_);
}

bool hasDiv() const {
  return has_div_;
}
MLBinarySupportLimits* div() const {
  DCHECK(hasDiv());
return member_div_.Get();
}
MLBinarySupportLimits* getDivOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasDiv()) {
  return fallback_value;
}
return member_div_.Get();
}
void setDiv(MLBinarySupportLimits* value) {
  member_div_ = value;
has_div_ = true;
DCHECK(member_div_);
}

bool hasElu() const {
  return has_elu_;
}
MLSingleInputSupportLimits* elu() const {
  DCHECK(hasElu());
return member_elu_.Get();
}
MLSingleInputSupportLimits* getEluOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasElu()) {
  return fallback_value;
}
return member_elu_.Get();
}
void setElu(MLSingleInputSupportLimits* value) {
  member_elu_ = value;
has_elu_ = true;
DCHECK(member_elu_);
}

bool hasEqual() const {
  return has_equal_;
}
MLBinarySupportLimits* equal() const {
  DCHECK(hasEqual());
return member_equal_.Get();
}
MLBinarySupportLimits* getEqualOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasEqual()) {
  return fallback_value;
}
return member_equal_.Get();
}
void setEqual(MLBinarySupportLimits* value) {
  member_equal_ = value;
has_equal_ = true;
DCHECK(member_equal_);
}

bool hasErf() const {
  return has_erf_;
}
MLSingleInputSupportLimits* erf() const {
  DCHECK(hasErf());
return member_erf_.Get();
}
MLSingleInputSupportLimits* getErfOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasErf()) {
  return fallback_value;
}
return member_erf_.Get();
}
void setErf(MLSingleInputSupportLimits* value) {
  member_erf_ = value;
has_erf_ = true;
DCHECK(member_erf_);
}

bool hasExp() const {
  return has_exp_;
}
MLSingleInputSupportLimits* exp() const {
  DCHECK(hasExp());
return member_exp_.Get();
}
MLSingleInputSupportLimits* getExpOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasExp()) {
  return fallback_value;
}
return member_exp_.Get();
}
void setExp(MLSingleInputSupportLimits* value) {
  member_exp_ = value;
has_exp_ = true;
DCHECK(member_exp_);
}

bool hasExpand() const {
  return has_expand_;
}
MLSingleInputSupportLimits* expand() const {
  DCHECK(hasExpand());
return member_expand_.Get();
}
MLSingleInputSupportLimits* getExpandOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasExpand()) {
  return fallback_value;
}
return member_expand_.Get();
}
void setExpand(MLSingleInputSupportLimits* value) {
  member_expand_ = value;
has_expand_ = true;
DCHECK(member_expand_);
}

bool hasFloor() const {
  return has_floor_;
}
MLSingleInputSupportLimits* floor() const {
  DCHECK(hasFloor());
return member_floor_.Get();
}
MLSingleInputSupportLimits* getFloorOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasFloor()) {
  return fallback_value;
}
return member_floor_.Get();
}
void setFloor(MLSingleInputSupportLimits* value) {
  member_floor_ = value;
has_floor_ = true;
DCHECK(member_floor_);
}

bool hasGather() const {
  return has_gather_;
}
MLGatherSupportLimits* gather() const {
  DCHECK(hasGather());
return member_gather_.Get();
}
MLGatherSupportLimits* getGatherOr(MLGatherSupportLimits* fallback_value) const {
  if (!hasGather()) {
  return fallback_value;
}
return member_gather_.Get();
}
void setGather(MLGatherSupportLimits* value) {
  member_gather_ = value;
has_gather_ = true;
DCHECK(member_gather_);
}

bool hasGatherElements() const {
  return has_gather_elements_;
}
MLGatherSupportLimits* gatherElements() const {
  DCHECK(hasGatherElements());
return member_gather_elements_.Get();
}
MLGatherSupportLimits* getGatherElementsOr(MLGatherSupportLimits* fallback_value) const {
  if (!hasGatherElements()) {
  return fallback_value;
}
return member_gather_elements_.Get();
}
void setGatherElements(MLGatherSupportLimits* value) {
  member_gather_elements_ = value;
has_gather_elements_ = true;
DCHECK(member_gather_elements_);
}

bool hasGatherND() const {
  return has_gather_nd_;
}
MLGatherSupportLimits* gatherND() const {
  DCHECK(hasGatherND());
return member_gather_nd_.Get();
}
MLGatherSupportLimits* getGatherNDOr(MLGatherSupportLimits* fallback_value) const {
  if (!hasGatherND()) {
  return fallback_value;
}
return member_gather_nd_.Get();
}
void setGatherND(MLGatherSupportLimits* value) {
  member_gather_nd_ = value;
has_gather_nd_ = true;
DCHECK(member_gather_nd_);
}

bool hasGelu() const {
  return has_gelu_;
}
MLSingleInputSupportLimits* gelu() const {
  DCHECK(hasGelu());
return member_gelu_.Get();
}
MLSingleInputSupportLimits* getGeluOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasGelu()) {
  return fallback_value;
}
return member_gelu_.Get();
}
void setGelu(MLSingleInputSupportLimits* value) {
  member_gelu_ = value;
has_gelu_ = true;
DCHECK(member_gelu_);
}

bool hasGemm() const {
  return has_gemm_;
}
MLGemmSupportLimits* gemm() const {
  DCHECK(hasGemm());
return member_gemm_.Get();
}
MLGemmSupportLimits* getGemmOr(MLGemmSupportLimits* fallback_value) const {
  if (!hasGemm()) {
  return fallback_value;
}
return member_gemm_.Get();
}
void setGemm(MLGemmSupportLimits* value) {
  member_gemm_ = value;
has_gemm_ = true;
DCHECK(member_gemm_);
}

bool hasGreater() const {
  return has_greater_;
}
MLBinarySupportLimits* greater() const {
  DCHECK(hasGreater());
return member_greater_.Get();
}
MLBinarySupportLimits* getGreaterOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasGreater()) {
  return fallback_value;
}
return member_greater_.Get();
}
void setGreater(MLBinarySupportLimits* value) {
  member_greater_ = value;
has_greater_ = true;
DCHECK(member_greater_);
}

bool hasGreaterOrEqual() const {
  return has_greater_or_equal_;
}
MLBinarySupportLimits* greaterOrEqual() const {
  DCHECK(hasGreaterOrEqual());
return member_greater_or_equal_.Get();
}
MLBinarySupportLimits* getGreaterOrEqualOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasGreaterOrEqual()) {
  return fallback_value;
}
return member_greater_or_equal_.Get();
}
void setGreaterOrEqual(MLBinarySupportLimits* value) {
  member_greater_or_equal_ = value;
has_greater_or_equal_ = true;
DCHECK(member_greater_or_equal_);
}

bool hasGru() const {
  return has_gru_;
}
MLGruSupportLimits* gru() const {
  DCHECK(hasGru());
return member_gru_.Get();
}
MLGruSupportLimits* getGruOr(MLGruSupportLimits* fallback_value) const {
  if (!hasGru()) {
  return fallback_value;
}
return member_gru_.Get();
}
void setGru(MLGruSupportLimits* value) {
  member_gru_ = value;
has_gru_ = true;
DCHECK(member_gru_);
}

bool hasGruCell() const {
  return has_gru_cell_;
}
MLGruCellSupportLimits* gruCell() const {
  DCHECK(hasGruCell());
return member_gru_cell_.Get();
}
MLGruCellSupportLimits* getGruCellOr(MLGruCellSupportLimits* fallback_value) const {
  if (!hasGruCell()) {
  return fallback_value;
}
return member_gru_cell_.Get();
}
void setGruCell(MLGruCellSupportLimits* value) {
  member_gru_cell_ = value;
has_gru_cell_ = true;
DCHECK(member_gru_cell_);
}

bool hasHardSigmoid() const {
  return has_hard_sigmoid_;
}
MLSingleInputSupportLimits* hardSigmoid() const {
  DCHECK(hasHardSigmoid());
return member_hard_sigmoid_.Get();
}
MLSingleInputSupportLimits* getHardSigmoidOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasHardSigmoid()) {
  return fallback_value;
}
return member_hard_sigmoid_.Get();
}
void setHardSigmoid(MLSingleInputSupportLimits* value) {
  member_hard_sigmoid_ = value;
has_hard_sigmoid_ = true;
DCHECK(member_hard_sigmoid_);
}

bool hasHardSwish() const {
  return has_hard_swish_;
}
MLSingleInputSupportLimits* hardSwish() const {
  DCHECK(hasHardSwish());
return member_hard_swish_.Get();
}
MLSingleInputSupportLimits* getHardSwishOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasHardSwish()) {
  return fallback_value;
}
return member_hard_swish_.Get();
}
void setHardSwish(MLSingleInputSupportLimits* value) {
  member_hard_swish_ = value;
has_hard_swish_ = true;
DCHECK(member_hard_swish_);
}

bool hasIdentity() const {
  return has_identity_;
}
MLSingleInputSupportLimits* identity() const {
  DCHECK(hasIdentity());
return member_identity_.Get();
}
MLSingleInputSupportLimits* getIdentityOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasIdentity()) {
  return fallback_value;
}
return member_identity_.Get();
}
void setIdentity(MLSingleInputSupportLimits* value) {
  member_identity_ = value;
has_identity_ = true;
DCHECK(member_identity_);
}

bool hasInput() const {
  return has_input_;
}
MLTensorLimits* input() const {
  DCHECK(hasInput());
return member_input_.Get();
}
MLTensorLimits* getInputOr(MLTensorLimits* fallback_value) const {
  if (!hasInput()) {
  return fallback_value;
}
return member_input_.Get();
}
void setInput(MLTensorLimits* value) {
  member_input_ = value;
has_input_ = true;
DCHECK(member_input_);
}

bool hasInstanceNormalization() const {
  return has_instance_normalization_;
}
MLNormalizationSupportLimits* instanceNormalization() const {
  DCHECK(hasInstanceNormalization());
return member_instance_normalization_.Get();
}
MLNormalizationSupportLimits* getInstanceNormalizationOr(MLNormalizationSupportLimits* fallback_value) const {
  if (!hasInstanceNormalization()) {
  return fallback_value;
}
return member_instance_normalization_.Get();
}
void setInstanceNormalization(MLNormalizationSupportLimits* value) {
  member_instance_normalization_ = value;
has_instance_normalization_ = true;
DCHECK(member_instance_normalization_);
}

bool hasIsInfinite() const {
  return has_is_infinite_;
}
MLLogicalNotSupportLimits* isInfinite() const {
  DCHECK(hasIsInfinite());
return member_is_infinite_.Get();
}
MLLogicalNotSupportLimits* getIsInfiniteOr(MLLogicalNotSupportLimits* fallback_value) const {
  if (!hasIsInfinite()) {
  return fallback_value;
}
return member_is_infinite_.Get();
}
void setIsInfinite(MLLogicalNotSupportLimits* value) {
  member_is_infinite_ = value;
has_is_infinite_ = true;
DCHECK(member_is_infinite_);
}

bool hasIsNaN() const {
  return has_is_na_n_;
}
MLLogicalNotSupportLimits* isNaN() const {
  DCHECK(hasIsNaN());
return member_is_na_n_.Get();
}
MLLogicalNotSupportLimits* getIsNaNOr(MLLogicalNotSupportLimits* fallback_value) const {
  if (!hasIsNaN()) {
  return fallback_value;
}
return member_is_na_n_.Get();
}
void setIsNaN(MLLogicalNotSupportLimits* value) {
  member_is_na_n_ = value;
has_is_na_n_ = true;
DCHECK(member_is_na_n_);
}

bool hasL2Pool2d() const {
  return has_l_2_pool_2d_;
}
MLSingleInputSupportLimits* l2Pool2d() const {
  DCHECK(hasL2Pool2d());
return member_l_2_pool_2d_.Get();
}
MLSingleInputSupportLimits* getL2Pool2dOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasL2Pool2d()) {
  return fallback_value;
}
return member_l_2_pool_2d_.Get();
}
void setL2Pool2d(MLSingleInputSupportLimits* value) {
  member_l_2_pool_2d_ = value;
has_l_2_pool_2d_ = true;
DCHECK(member_l_2_pool_2d_);
}

bool hasLayerNormalization() const {
  return has_layer_normalization_;
}
MLNormalizationSupportLimits* layerNormalization() const {
  DCHECK(hasLayerNormalization());
return member_layer_normalization_.Get();
}
MLNormalizationSupportLimits* getLayerNormalizationOr(MLNormalizationSupportLimits* fallback_value) const {
  if (!hasLayerNormalization()) {
  return fallback_value;
}
return member_layer_normalization_.Get();
}
void setLayerNormalization(MLNormalizationSupportLimits* value) {
  member_layer_normalization_ = value;
has_layer_normalization_ = true;
DCHECK(member_layer_normalization_);
}

bool hasLeakyRelu() const {
  return has_leaky_relu_;
}
MLSingleInputSupportLimits* leakyRelu() const {
  DCHECK(hasLeakyRelu());
return member_leaky_relu_.Get();
}
MLSingleInputSupportLimits* getLeakyReluOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasLeakyRelu()) {
  return fallback_value;
}
return member_leaky_relu_.Get();
}
void setLeakyRelu(MLSingleInputSupportLimits* value) {
  member_leaky_relu_ = value;
has_leaky_relu_ = true;
DCHECK(member_leaky_relu_);
}

bool hasLesser() const {
  return has_lesser_;
}
MLBinarySupportLimits* lesser() const {
  DCHECK(hasLesser());
return member_lesser_.Get();
}
MLBinarySupportLimits* getLesserOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasLesser()) {
  return fallback_value;
}
return member_lesser_.Get();
}
void setLesser(MLBinarySupportLimits* value) {
  member_lesser_ = value;
has_lesser_ = true;
DCHECK(member_lesser_);
}

bool hasLesserOrEqual() const {
  return has_lesser_or_equal_;
}
MLBinarySupportLimits* lesserOrEqual() const {
  DCHECK(hasLesserOrEqual());
return member_lesser_or_equal_.Get();
}
MLBinarySupportLimits* getLesserOrEqualOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasLesserOrEqual()) {
  return fallback_value;
}
return member_lesser_or_equal_.Get();
}
void setLesserOrEqual(MLBinarySupportLimits* value) {
  member_lesser_or_equal_ = value;
has_lesser_or_equal_ = true;
DCHECK(member_lesser_or_equal_);
}

bool hasLinear() const {
  return has_linear_;
}
MLSingleInputSupportLimits* linear() const {
  DCHECK(hasLinear());
return member_linear_.Get();
}
MLSingleInputSupportLimits* getLinearOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasLinear()) {
  return fallback_value;
}
return member_linear_.Get();
}
void setLinear(MLSingleInputSupportLimits* value) {
  member_linear_ = value;
has_linear_ = true;
DCHECK(member_linear_);
}

bool hasLog() const {
  return has_log_;
}
MLSingleInputSupportLimits* log() const {
  DCHECK(hasLog());
return member_log_.Get();
}
MLSingleInputSupportLimits* getLogOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasLog()) {
  return fallback_value;
}
return member_log_.Get();
}
void setLog(MLSingleInputSupportLimits* value) {
  member_log_ = value;
has_log_ = true;
DCHECK(member_log_);
}

bool hasLogicalAnd() const {
  return has_logical_and_;
}
MLBinarySupportLimits* logicalAnd() const {
  DCHECK(hasLogicalAnd());
return member_logical_and_.Get();
}
MLBinarySupportLimits* getLogicalAndOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasLogicalAnd()) {
  return fallback_value;
}
return member_logical_and_.Get();
}
void setLogicalAnd(MLBinarySupportLimits* value) {
  member_logical_and_ = value;
has_logical_and_ = true;
DCHECK(member_logical_and_);
}

bool hasLogicalNot() const {
  return has_logical_not_;
}
MLLogicalNotSupportLimits* logicalNot() const {
  DCHECK(hasLogicalNot());
return member_logical_not_.Get();
}
MLLogicalNotSupportLimits* getLogicalNotOr(MLLogicalNotSupportLimits* fallback_value) const {
  if (!hasLogicalNot()) {
  return fallback_value;
}
return member_logical_not_.Get();
}
void setLogicalNot(MLLogicalNotSupportLimits* value) {
  member_logical_not_ = value;
has_logical_not_ = true;
DCHECK(member_logical_not_);
}

bool hasLogicalOr() const {
  return has_logical_or_;
}
MLBinarySupportLimits* logicalOr() const {
  DCHECK(hasLogicalOr());
return member_logical_or_.Get();
}
MLBinarySupportLimits* getLogicalOrOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasLogicalOr()) {
  return fallback_value;
}
return member_logical_or_.Get();
}
void setLogicalOr(MLBinarySupportLimits* value) {
  member_logical_or_ = value;
has_logical_or_ = true;
DCHECK(member_logical_or_);
}

bool hasLogicalXor() const {
  return has_logical_xor_;
}
MLBinarySupportLimits* logicalXor() const {
  DCHECK(hasLogicalXor());
return member_logical_xor_.Get();
}
MLBinarySupportLimits* getLogicalXorOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasLogicalXor()) {
  return fallback_value;
}
return member_logical_xor_.Get();
}
void setLogicalXor(MLBinarySupportLimits* value) {
  member_logical_xor_ = value;
has_logical_xor_ = true;
DCHECK(member_logical_xor_);
}

bool hasLstm() const {
  return has_lstm_;
}
MLLstmSupportLimits* lstm() const {
  DCHECK(hasLstm());
return member_lstm_.Get();
}
MLLstmSupportLimits* getLstmOr(MLLstmSupportLimits* fallback_value) const {
  if (!hasLstm()) {
  return fallback_value;
}
return member_lstm_.Get();
}
void setLstm(MLLstmSupportLimits* value) {
  member_lstm_ = value;
has_lstm_ = true;
DCHECK(member_lstm_);
}

bool hasLstmCell() const {
  return has_lstm_cell_;
}
MLLstmCellSupportLimits* lstmCell() const {
  DCHECK(hasLstmCell());
return member_lstm_cell_.Get();
}
MLLstmCellSupportLimits* getLstmCellOr(MLLstmCellSupportLimits* fallback_value) const {
  if (!hasLstmCell()) {
  return fallback_value;
}
return member_lstm_cell_.Get();
}
void setLstmCell(MLLstmCellSupportLimits* value) {
  member_lstm_cell_ = value;
has_lstm_cell_ = true;
DCHECK(member_lstm_cell_);
}

bool hasMatmul() const {
  return has_matmul_;
}
MLBinarySupportLimits* matmul() const {
  DCHECK(hasMatmul());
return member_matmul_.Get();
}
MLBinarySupportLimits* getMatmulOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasMatmul()) {
  return fallback_value;
}
return member_matmul_.Get();
}
void setMatmul(MLBinarySupportLimits* value) {
  member_matmul_ = value;
has_matmul_ = true;
DCHECK(member_matmul_);
}

bool hasMax() const {
  return has_max_;
}
MLBinarySupportLimits* max() const {
  DCHECK(hasMax());
return member_max_.Get();
}
MLBinarySupportLimits* getMaxOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasMax()) {
  return fallback_value;
}
return member_max_.Get();
}
void setMax(MLBinarySupportLimits* value) {
  member_max_ = value;
has_max_ = true;
DCHECK(member_max_);
}

bool hasMaxPool2d() const {
  return has_max_pool_2d_;
}
MLSingleInputSupportLimits* maxPool2d() const {
  DCHECK(hasMaxPool2d());
return member_max_pool_2d_.Get();
}
MLSingleInputSupportLimits* getMaxPool2dOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasMaxPool2d()) {
  return fallback_value;
}
return member_max_pool_2d_.Get();
}
void setMaxPool2d(MLSingleInputSupportLimits* value) {
  member_max_pool_2d_ = value;
has_max_pool_2d_ = true;
DCHECK(member_max_pool_2d_);
}

bool hasMaxTensorByteLength() const {
  return has_max_tensor_byte_length_;
}
uint64_t maxTensorByteLength() const {
  DCHECK(hasMaxTensorByteLength());
return member_max_tensor_byte_length_;
}
uint64_t getMaxTensorByteLengthOr(uint64_t fallback_value) const {
  if (!hasMaxTensorByteLength()) {
  return fallback_value;
}
return member_max_tensor_byte_length_;
}
void setMaxTensorByteLength(uint64_t value) {
  member_max_tensor_byte_length_ = value;
has_max_tensor_byte_length_ = true;
}

bool hasMin() const {
  return has_min_;
}
MLBinarySupportLimits* min() const {
  DCHECK(hasMin());
return member_min_.Get();
}
MLBinarySupportLimits* getMinOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasMin()) {
  return fallback_value;
}
return member_min_.Get();
}
void setMin(MLBinarySupportLimits* value) {
  member_min_ = value;
has_min_ = true;
DCHECK(member_min_);
}

bool hasMul() const {
  return has_mul_;
}
MLBinarySupportLimits* mul() const {
  DCHECK(hasMul());
return member_mul_.Get();
}
MLBinarySupportLimits* getMulOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasMul()) {
  return fallback_value;
}
return member_mul_.Get();
}
void setMul(MLBinarySupportLimits* value) {
  member_mul_ = value;
has_mul_ = true;
DCHECK(member_mul_);
}

bool hasNeg() const {
  return has_neg_;
}
MLSingleInputSupportLimits* neg() const {
  DCHECK(hasNeg());
return member_neg_.Get();
}
MLSingleInputSupportLimits* getNegOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasNeg()) {
  return fallback_value;
}
return member_neg_.Get();
}
void setNeg(MLSingleInputSupportLimits* value) {
  member_neg_ = value;
has_neg_ = true;
DCHECK(member_neg_);
}

bool hasNotEqual() const {
  return has_not_equal_;
}
MLBinarySupportLimits* notEqual() const {
  DCHECK(hasNotEqual());
return member_not_equal_.Get();
}
MLBinarySupportLimits* getNotEqualOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasNotEqual()) {
  return fallback_value;
}
return member_not_equal_.Get();
}
void setNotEqual(MLBinarySupportLimits* value) {
  member_not_equal_ = value;
has_not_equal_ = true;
DCHECK(member_not_equal_);
}

bool hasOutput() const {
  return has_output_;
}
MLTensorLimits* output() const {
  DCHECK(hasOutput());
return member_output_.Get();
}
MLTensorLimits* getOutputOr(MLTensorLimits* fallback_value) const {
  if (!hasOutput()) {
  return fallback_value;
}
return member_output_.Get();
}
void setOutput(MLTensorLimits* value) {
  member_output_ = value;
has_output_ = true;
DCHECK(member_output_);
}

bool hasPad() const {
  return has_pad_;
}
MLSingleInputSupportLimits* pad() const {
  DCHECK(hasPad());
return member_pad_.Get();
}
MLSingleInputSupportLimits* getPadOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasPad()) {
  return fallback_value;
}
return member_pad_.Get();
}
void setPad(MLSingleInputSupportLimits* value) {
  member_pad_ = value;
has_pad_ = true;
DCHECK(member_pad_);
}

bool hasPow() const {
  return has_pow_;
}
MLBinarySupportLimits* pow() const {
  DCHECK(hasPow());
return member_pow_.Get();
}
MLBinarySupportLimits* getPowOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasPow()) {
  return fallback_value;
}
return member_pow_.Get();
}
void setPow(MLBinarySupportLimits* value) {
  member_pow_ = value;
has_pow_ = true;
DCHECK(member_pow_);
}

bool hasPreferredInputLayout() const {
  return has_preferred_input_layout_;
}
V8MLInputOperandLayout preferredInputLayout() const {
  DCHECK(hasPreferredInputLayout());
return member_preferred_input_layout_;
}
V8MLInputOperandLayout getPreferredInputLayoutOr(V8MLInputOperandLayout fallback_value) const {
  if (!hasPreferredInputLayout()) {
  return fallback_value;
}
return member_preferred_input_layout_;
}
void setPreferredInputLayout(V8MLInputOperandLayout value) {
  member_preferred_input_layout_ = value;
has_preferred_input_layout_ = true;
}
void setPreferredInputLayout(V8MLInputOperandLayout::Enum value) {
  member_preferred_input_layout_ = V8MLInputOperandLayout(value);
has_preferred_input_layout_ = true;
}

bool hasPrelu() const {
  return has_prelu_;
}
MLPreluSupportLimits* prelu() const {
  DCHECK(hasPrelu());
return member_prelu_.Get();
}
MLPreluSupportLimits* getPreluOr(MLPreluSupportLimits* fallback_value) const {
  if (!hasPrelu()) {
  return fallback_value;
}
return member_prelu_.Get();
}
void setPrelu(MLPreluSupportLimits* value) {
  member_prelu_ = value;
has_prelu_ = true;
DCHECK(member_prelu_);
}

bool hasQuantizeLinear() const {
  return has_quantize_linear_;
}
MLQuantizeDequantizeLinearSupportLimits* quantizeLinear() const {
  DCHECK(hasQuantizeLinear());
return member_quantize_linear_.Get();
}
MLQuantizeDequantizeLinearSupportLimits* getQuantizeLinearOr(MLQuantizeDequantizeLinearSupportLimits* fallback_value) const {
  if (!hasQuantizeLinear()) {
  return fallback_value;
}
return member_quantize_linear_.Get();
}
void setQuantizeLinear(MLQuantizeDequantizeLinearSupportLimits* value) {
  member_quantize_linear_ = value;
has_quantize_linear_ = true;
DCHECK(member_quantize_linear_);
}

bool hasReciprocal() const {
  return has_reciprocal_;
}
MLSingleInputSupportLimits* reciprocal() const {
  DCHECK(hasReciprocal());
return member_reciprocal_.Get();
}
MLSingleInputSupportLimits* getReciprocalOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReciprocal()) {
  return fallback_value;
}
return member_reciprocal_.Get();
}
void setReciprocal(MLSingleInputSupportLimits* value) {
  member_reciprocal_ = value;
has_reciprocal_ = true;
DCHECK(member_reciprocal_);
}

bool hasReduceL1() const {
  return has_reduce_l_1_;
}
MLSingleInputSupportLimits* reduceL1() const {
  DCHECK(hasReduceL1());
return member_reduce_l_1_.Get();
}
MLSingleInputSupportLimits* getReduceL1Or(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceL1()) {
  return fallback_value;
}
return member_reduce_l_1_.Get();
}
void setReduceL1(MLSingleInputSupportLimits* value) {
  member_reduce_l_1_ = value;
has_reduce_l_1_ = true;
DCHECK(member_reduce_l_1_);
}

bool hasReduceL2() const {
  return has_reduce_l_2_;
}
MLSingleInputSupportLimits* reduceL2() const {
  DCHECK(hasReduceL2());
return member_reduce_l_2_.Get();
}
MLSingleInputSupportLimits* getReduceL2Or(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceL2()) {
  return fallback_value;
}
return member_reduce_l_2_.Get();
}
void setReduceL2(MLSingleInputSupportLimits* value) {
  member_reduce_l_2_ = value;
has_reduce_l_2_ = true;
DCHECK(member_reduce_l_2_);
}

bool hasReduceLogSum() const {
  return has_reduce_log_sum_;
}
MLSingleInputSupportLimits* reduceLogSum() const {
  DCHECK(hasReduceLogSum());
return member_reduce_log_sum_.Get();
}
MLSingleInputSupportLimits* getReduceLogSumOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceLogSum()) {
  return fallback_value;
}
return member_reduce_log_sum_.Get();
}
void setReduceLogSum(MLSingleInputSupportLimits* value) {
  member_reduce_log_sum_ = value;
has_reduce_log_sum_ = true;
DCHECK(member_reduce_log_sum_);
}

bool hasReduceLogSumExp() const {
  return has_reduce_log_sum_exp_;
}
MLSingleInputSupportLimits* reduceLogSumExp() const {
  DCHECK(hasReduceLogSumExp());
return member_reduce_log_sum_exp_.Get();
}
MLSingleInputSupportLimits* getReduceLogSumExpOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceLogSumExp()) {
  return fallback_value;
}
return member_reduce_log_sum_exp_.Get();
}
void setReduceLogSumExp(MLSingleInputSupportLimits* value) {
  member_reduce_log_sum_exp_ = value;
has_reduce_log_sum_exp_ = true;
DCHECK(member_reduce_log_sum_exp_);
}

bool hasReduceMax() const {
  return has_reduce_max_;
}
MLSingleInputSupportLimits* reduceMax() const {
  DCHECK(hasReduceMax());
return member_reduce_max_.Get();
}
MLSingleInputSupportLimits* getReduceMaxOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceMax()) {
  return fallback_value;
}
return member_reduce_max_.Get();
}
void setReduceMax(MLSingleInputSupportLimits* value) {
  member_reduce_max_ = value;
has_reduce_max_ = true;
DCHECK(member_reduce_max_);
}

bool hasReduceMean() const {
  return has_reduce_mean_;
}
MLSingleInputSupportLimits* reduceMean() const {
  DCHECK(hasReduceMean());
return member_reduce_mean_.Get();
}
MLSingleInputSupportLimits* getReduceMeanOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceMean()) {
  return fallback_value;
}
return member_reduce_mean_.Get();
}
void setReduceMean(MLSingleInputSupportLimits* value) {
  member_reduce_mean_ = value;
has_reduce_mean_ = true;
DCHECK(member_reduce_mean_);
}

bool hasReduceMin() const {
  return has_reduce_min_;
}
MLSingleInputSupportLimits* reduceMin() const {
  DCHECK(hasReduceMin());
return member_reduce_min_.Get();
}
MLSingleInputSupportLimits* getReduceMinOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceMin()) {
  return fallback_value;
}
return member_reduce_min_.Get();
}
void setReduceMin(MLSingleInputSupportLimits* value) {
  member_reduce_min_ = value;
has_reduce_min_ = true;
DCHECK(member_reduce_min_);
}

bool hasReduceProduct() const {
  return has_reduce_product_;
}
MLSingleInputSupportLimits* reduceProduct() const {
  DCHECK(hasReduceProduct());
return member_reduce_product_.Get();
}
MLSingleInputSupportLimits* getReduceProductOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceProduct()) {
  return fallback_value;
}
return member_reduce_product_.Get();
}
void setReduceProduct(MLSingleInputSupportLimits* value) {
  member_reduce_product_ = value;
has_reduce_product_ = true;
DCHECK(member_reduce_product_);
}

bool hasReduceSum() const {
  return has_reduce_sum_;
}
MLSingleInputSupportLimits* reduceSum() const {
  DCHECK(hasReduceSum());
return member_reduce_sum_.Get();
}
MLSingleInputSupportLimits* getReduceSumOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceSum()) {
  return fallback_value;
}
return member_reduce_sum_.Get();
}
void setReduceSum(MLSingleInputSupportLimits* value) {
  member_reduce_sum_ = value;
has_reduce_sum_ = true;
DCHECK(member_reduce_sum_);
}

bool hasReduceSumSquare() const {
  return has_reduce_sum_square_;
}
MLSingleInputSupportLimits* reduceSumSquare() const {
  DCHECK(hasReduceSumSquare());
return member_reduce_sum_square_.Get();
}
MLSingleInputSupportLimits* getReduceSumSquareOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReduceSumSquare()) {
  return fallback_value;
}
return member_reduce_sum_square_.Get();
}
void setReduceSumSquare(MLSingleInputSupportLimits* value) {
  member_reduce_sum_square_ = value;
has_reduce_sum_square_ = true;
DCHECK(member_reduce_sum_square_);
}

bool hasRelu() const {
  return has_relu_;
}
MLSingleInputSupportLimits* relu() const {
  DCHECK(hasRelu());
return member_relu_.Get();
}
MLSingleInputSupportLimits* getReluOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasRelu()) {
  return fallback_value;
}
return member_relu_.Get();
}
void setRelu(MLSingleInputSupportLimits* value) {
  member_relu_ = value;
has_relu_ = true;
DCHECK(member_relu_);
}

bool hasResample2d() const {
  return has_resample_2d_;
}
MLSingleInputSupportLimits* resample2d() const {
  DCHECK(hasResample2d());
return member_resample_2d_.Get();
}
MLSingleInputSupportLimits* getResample2dOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasResample2d()) {
  return fallback_value;
}
return member_resample_2d_.Get();
}
void setResample2d(MLSingleInputSupportLimits* value) {
  member_resample_2d_ = value;
has_resample_2d_ = true;
DCHECK(member_resample_2d_);
}

bool hasReshape() const {
  return has_reshape_;
}
MLSingleInputSupportLimits* reshape() const {
  DCHECK(hasReshape());
return member_reshape_.Get();
}
MLSingleInputSupportLimits* getReshapeOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReshape()) {
  return fallback_value;
}
return member_reshape_.Get();
}
void setReshape(MLSingleInputSupportLimits* value) {
  member_reshape_ = value;
has_reshape_ = true;
DCHECK(member_reshape_);
}

bool hasReverse() const {
  return has_reverse_;
}
MLSingleInputSupportLimits* reverse() const {
  DCHECK(hasReverse());
return member_reverse_.Get();
}
MLSingleInputSupportLimits* getReverseOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasReverse()) {
  return fallback_value;
}
return member_reverse_.Get();
}
void setReverse(MLSingleInputSupportLimits* value) {
  member_reverse_ = value;
has_reverse_ = true;
DCHECK(member_reverse_);
}

bool hasRoundEven() const {
  return has_round_even_;
}
MLSingleInputSupportLimits* roundEven() const {
  DCHECK(hasRoundEven());
return member_round_even_.Get();
}
MLSingleInputSupportLimits* getRoundEvenOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasRoundEven()) {
  return fallback_value;
}
return member_round_even_.Get();
}
void setRoundEven(MLSingleInputSupportLimits* value) {
  member_round_even_ = value;
has_round_even_ = true;
DCHECK(member_round_even_);
}

bool hasScatterElements() const {
  return has_scatter_elements_;
}
MLScatterSupportLimits* scatterElements() const {
  DCHECK(hasScatterElements());
return member_scatter_elements_.Get();
}
MLScatterSupportLimits* getScatterElementsOr(MLScatterSupportLimits* fallback_value) const {
  if (!hasScatterElements()) {
  return fallback_value;
}
return member_scatter_elements_.Get();
}
void setScatterElements(MLScatterSupportLimits* value) {
  member_scatter_elements_ = value;
has_scatter_elements_ = true;
DCHECK(member_scatter_elements_);
}

bool hasScatterND() const {
  return has_scatter_nd_;
}
MLScatterSupportLimits* scatterND() const {
  DCHECK(hasScatterND());
return member_scatter_nd_.Get();
}
MLScatterSupportLimits* getScatterNDOr(MLScatterSupportLimits* fallback_value) const {
  if (!hasScatterND()) {
  return fallback_value;
}
return member_scatter_nd_.Get();
}
void setScatterND(MLScatterSupportLimits* value) {
  member_scatter_nd_ = value;
has_scatter_nd_ = true;
DCHECK(member_scatter_nd_);
}

bool hasSigmoid() const {
  return has_sigmoid_;
}
MLSingleInputSupportLimits* sigmoid() const {
  DCHECK(hasSigmoid());
return member_sigmoid_.Get();
}
MLSingleInputSupportLimits* getSigmoidOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSigmoid()) {
  return fallback_value;
}
return member_sigmoid_.Get();
}
void setSigmoid(MLSingleInputSupportLimits* value) {
  member_sigmoid_ = value;
has_sigmoid_ = true;
DCHECK(member_sigmoid_);
}

bool hasSign() const {
  return has_sign_;
}
MLSingleInputSupportLimits* sign() const {
  DCHECK(hasSign());
return member_sign_.Get();
}
MLSingleInputSupportLimits* getSignOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSign()) {
  return fallback_value;
}
return member_sign_.Get();
}
void setSign(MLSingleInputSupportLimits* value) {
  member_sign_ = value;
has_sign_ = true;
DCHECK(member_sign_);
}

bool hasSin() const {
  return has_sin_;
}
MLSingleInputSupportLimits* sin() const {
  DCHECK(hasSin());
return member_sin_.Get();
}
MLSingleInputSupportLimits* getSinOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSin()) {
  return fallback_value;
}
return member_sin_.Get();
}
void setSin(MLSingleInputSupportLimits* value) {
  member_sin_ = value;
has_sin_ = true;
DCHECK(member_sin_);
}

bool hasSlice() const {
  return has_slice_;
}
MLSingleInputSupportLimits* slice() const {
  DCHECK(hasSlice());
return member_slice_.Get();
}
MLSingleInputSupportLimits* getSliceOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSlice()) {
  return fallback_value;
}
return member_slice_.Get();
}
void setSlice(MLSingleInputSupportLimits* value) {
  member_slice_ = value;
has_slice_ = true;
DCHECK(member_slice_);
}

bool hasSoftmax() const {
  return has_softmax_;
}
MLSingleInputSupportLimits* softmax() const {
  DCHECK(hasSoftmax());
return member_softmax_.Get();
}
MLSingleInputSupportLimits* getSoftmaxOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSoftmax()) {
  return fallback_value;
}
return member_softmax_.Get();
}
void setSoftmax(MLSingleInputSupportLimits* value) {
  member_softmax_ = value;
has_softmax_ = true;
DCHECK(member_softmax_);
}

bool hasSoftplus() const {
  return has_softplus_;
}
MLSingleInputSupportLimits* softplus() const {
  DCHECK(hasSoftplus());
return member_softplus_.Get();
}
MLSingleInputSupportLimits* getSoftplusOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSoftplus()) {
  return fallback_value;
}
return member_softplus_.Get();
}
void setSoftplus(MLSingleInputSupportLimits* value) {
  member_softplus_ = value;
has_softplus_ = true;
DCHECK(member_softplus_);
}

bool hasSoftsign() const {
  return has_softsign_;
}
MLSingleInputSupportLimits* softsign() const {
  DCHECK(hasSoftsign());
return member_softsign_.Get();
}
MLSingleInputSupportLimits* getSoftsignOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSoftsign()) {
  return fallback_value;
}
return member_softsign_.Get();
}
void setSoftsign(MLSingleInputSupportLimits* value) {
  member_softsign_ = value;
has_softsign_ = true;
DCHECK(member_softsign_);
}

bool hasSplit() const {
  return has_split_;
}
MLSplitSupportLimits* split() const {
  DCHECK(hasSplit());
return member_split_.Get();
}
MLSplitSupportLimits* getSplitOr(MLSplitSupportLimits* fallback_value) const {
  if (!hasSplit()) {
  return fallback_value;
}
return member_split_.Get();
}
void setSplit(MLSplitSupportLimits* value) {
  member_split_ = value;
has_split_ = true;
DCHECK(member_split_);
}

bool hasSqrt() const {
  return has_sqrt_;
}
MLSingleInputSupportLimits* sqrt() const {
  DCHECK(hasSqrt());
return member_sqrt_.Get();
}
MLSingleInputSupportLimits* getSqrtOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasSqrt()) {
  return fallback_value;
}
return member_sqrt_.Get();
}
void setSqrt(MLSingleInputSupportLimits* value) {
  member_sqrt_ = value;
has_sqrt_ = true;
DCHECK(member_sqrt_);
}

bool hasSub() const {
  return has_sub_;
}
MLBinarySupportLimits* sub() const {
  DCHECK(hasSub());
return member_sub_.Get();
}
MLBinarySupportLimits* getSubOr(MLBinarySupportLimits* fallback_value) const {
  if (!hasSub()) {
  return fallback_value;
}
return member_sub_.Get();
}
void setSub(MLBinarySupportLimits* value) {
  member_sub_ = value;
has_sub_ = true;
DCHECK(member_sub_);
}

bool hasTan() const {
  return has_tan_;
}
MLSingleInputSupportLimits* tan() const {
  DCHECK(hasTan());
return member_tan_.Get();
}
MLSingleInputSupportLimits* getTanOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasTan()) {
  return fallback_value;
}
return member_tan_.Get();
}
void setTan(MLSingleInputSupportLimits* value) {
  member_tan_ = value;
has_tan_ = true;
DCHECK(member_tan_);
}

bool hasTanh() const {
  return has_tanh_;
}
MLSingleInputSupportLimits* tanh() const {
  DCHECK(hasTanh());
return member_tanh_.Get();
}
MLSingleInputSupportLimits* getTanhOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasTanh()) {
  return fallback_value;
}
return member_tanh_.Get();
}
void setTanh(MLSingleInputSupportLimits* value) {
  member_tanh_ = value;
has_tanh_ = true;
DCHECK(member_tanh_);
}

bool hasTile() const {
  return has_tile_;
}
MLSingleInputSupportLimits* tile() const {
  DCHECK(hasTile());
return member_tile_.Get();
}
MLSingleInputSupportLimits* getTileOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasTile()) {
  return fallback_value;
}
return member_tile_.Get();
}
void setTile(MLSingleInputSupportLimits* value) {
  member_tile_ = value;
has_tile_ = true;
DCHECK(member_tile_);
}

bool hasTranspose() const {
  return has_transpose_;
}
MLSingleInputSupportLimits* transpose() const {
  DCHECK(hasTranspose());
return member_transpose_.Get();
}
MLSingleInputSupportLimits* getTransposeOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasTranspose()) {
  return fallback_value;
}
return member_transpose_.Get();
}
void setTranspose(MLSingleInputSupportLimits* value) {
  member_transpose_ = value;
has_transpose_ = true;
DCHECK(member_transpose_);
}

bool hasTriangular() const {
  return has_triangular_;
}
MLSingleInputSupportLimits* triangular() const {
  DCHECK(hasTriangular());
return member_triangular_.Get();
}
MLSingleInputSupportLimits* getTriangularOr(MLSingleInputSupportLimits* fallback_value) const {
  if (!hasTriangular()) {
  return fallback_value;
}
return member_triangular_.Get();
}
void setTriangular(MLSingleInputSupportLimits* value) {
  member_triangular_ = value;
has_triangular_ = true;
DCHECK(member_triangular_);
}

bool hasWhere() const {
  return has_where_;
}
MLWhereSupportLimits* where() const {
  DCHECK(hasWhere());
return member_where_.Get();
}
MLWhereSupportLimits* getWhereOr(MLWhereSupportLimits* fallback_value) const {
  if (!hasWhere()) {
  return fallback_value;
}
return member_where_.Get();
}
void setWhere(MLWhereSupportLimits* value) {
  member_where_ = value;
has_where_ = true;
DCHECK(member_where_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 100;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_abs_ = false;
bool has_add_ = false;
bool has_arg_max_ = false;
bool has_arg_min_ = false;
bool has_average_pool_2d_ = false;
bool has_batch_normalization_ = false;
bool has_cast_ = false;
bool has_ceil_ = false;
bool has_clamp_ = false;
bool has_concat_ = false;
bool has_constant_ = false;
bool has_conv_2d_ = false;
bool has_conv_transpose_2d_ = false;
bool has_cos_ = false;
bool has_cumulative_sum_ = false;
bool has_dequantize_linear_ = false;
bool has_div_ = false;
bool has_elu_ = false;
bool has_equal_ = false;
bool has_erf_ = false;
bool has_exp_ = false;
bool has_expand_ = false;
bool has_floor_ = false;
bool has_gather_ = false;
bool has_gather_elements_ = false;
bool has_gather_nd_ = false;
bool has_gelu_ = false;
bool has_gemm_ = false;
bool has_greater_ = false;
bool has_greater_or_equal_ = false;
bool has_gru_ = false;
bool has_gru_cell_ = false;
bool has_hard_sigmoid_ = false;
bool has_hard_swish_ = false;
bool has_identity_ = false;
bool has_input_ = false;
bool has_instance_normalization_ = false;
bool has_is_infinite_ = false;
bool has_is_na_n_ = false;
bool has_l_2_pool_2d_ = false;
bool has_layer_normalization_ = false;
bool has_leaky_relu_ = false;
bool has_lesser_ = false;
bool has_lesser_or_equal_ = false;
bool has_linear_ = false;
bool has_log_ = false;
bool has_logical_and_ = false;
bool has_logical_not_ = false;
bool has_logical_or_ = false;
bool has_logical_xor_ = false;
bool has_lstm_ = false;
bool has_lstm_cell_ = false;
bool has_matmul_ = false;
bool has_max_ = false;
bool has_max_pool_2d_ = false;
bool has_max_tensor_byte_length_ = false;
bool has_min_ = false;
bool has_mul_ = false;
bool has_neg_ = false;
bool has_not_equal_ = false;
bool has_output_ = false;
bool has_pad_ = false;
bool has_pow_ = false;
bool has_preferred_input_layout_ = false;
bool has_prelu_ = false;
bool has_quantize_linear_ = false;
bool has_reciprocal_ = false;
bool has_reduce_l_1_ = false;
bool has_reduce_l_2_ = false;
bool has_reduce_log_sum_ = false;
bool has_reduce_log_sum_exp_ = false;
bool has_reduce_max_ = false;
bool has_reduce_mean_ = false;
bool has_reduce_min_ = false;
bool has_reduce_product_ = false;
bool has_reduce_sum_ = false;
bool has_reduce_sum_square_ = false;
bool has_relu_ = false;
bool has_resample_2d_ = false;
bool has_reshape_ = false;
bool has_reverse_ = false;
bool has_round_even_ = false;
bool has_scatter_elements_ = false;
bool has_scatter_nd_ = false;
bool has_sigmoid_ = false;
bool has_sign_ = false;
bool has_sin_ = false;
bool has_slice_ = false;
bool has_softmax_ = false;
bool has_softplus_ = false;
bool has_softsign_ = false;
bool has_split_ = false;
bool has_sqrt_ = false;
bool has_sub_ = false;
bool has_tan_ = false;
bool has_tanh_ = false;
bool has_tile_ = false;
bool has_transpose_ = false;
bool has_triangular_ = false;
bool has_where_ = false;

Member<MLSingleInputSupportLimits> member_abs_;
Member<MLBinarySupportLimits> member_add_;
Member<MLSingleInputSupportLimits> member_arg_max_;
Member<MLSingleInputSupportLimits> member_arg_min_;
Member<MLSingleInputSupportLimits> member_average_pool_2d_;
Member<MLBatchNormalizationSupportLimits> member_batch_normalization_;
Member<MLSingleInputSupportLimits> member_cast_;
Member<MLSingleInputSupportLimits> member_ceil_;
Member<MLSingleInputSupportLimits> member_clamp_;
Member<MLConcatSupportLimits> member_concat_;
Member<MLTensorLimits> member_constant_;
Member<MLConv2dSupportLimits> member_conv_2d_;
Member<MLConv2dSupportLimits> member_conv_transpose_2d_;
Member<MLSingleInputSupportLimits> member_cos_;
Member<MLSingleInputSupportLimits> member_cumulative_sum_;
Member<MLQuantizeDequantizeLinearSupportLimits> member_dequantize_linear_;
Member<MLBinarySupportLimits> member_div_;
Member<MLSingleInputSupportLimits> member_elu_;
Member<MLBinarySupportLimits> member_equal_;
Member<MLSingleInputSupportLimits> member_erf_;
Member<MLSingleInputSupportLimits> member_exp_;
Member<MLSingleInputSupportLimits> member_expand_;
Member<MLSingleInputSupportLimits> member_floor_;
Member<MLGatherSupportLimits> member_gather_;
Member<MLGatherSupportLimits> member_gather_elements_;
Member<MLGatherSupportLimits> member_gather_nd_;
Member<MLSingleInputSupportLimits> member_gelu_;
Member<MLGemmSupportLimits> member_gemm_;
Member<MLBinarySupportLimits> member_greater_;
Member<MLBinarySupportLimits> member_greater_or_equal_;
Member<MLGruSupportLimits> member_gru_;
Member<MLGruCellSupportLimits> member_gru_cell_;
Member<MLSingleInputSupportLimits> member_hard_sigmoid_;
Member<MLSingleInputSupportLimits> member_hard_swish_;
Member<MLSingleInputSupportLimits> member_identity_;
Member<MLTensorLimits> member_input_;
Member<MLNormalizationSupportLimits> member_instance_normalization_;
Member<MLLogicalNotSupportLimits> member_is_infinite_;
Member<MLLogicalNotSupportLimits> member_is_na_n_;
Member<MLSingleInputSupportLimits> member_l_2_pool_2d_;
Member<MLNormalizationSupportLimits> member_layer_normalization_;
Member<MLSingleInputSupportLimits> member_leaky_relu_;
Member<MLBinarySupportLimits> member_lesser_;
Member<MLBinarySupportLimits> member_lesser_or_equal_;
Member<MLSingleInputSupportLimits> member_linear_;
Member<MLSingleInputSupportLimits> member_log_;
Member<MLBinarySupportLimits> member_logical_and_;
Member<MLLogicalNotSupportLimits> member_logical_not_;
Member<MLBinarySupportLimits> member_logical_or_;
Member<MLBinarySupportLimits> member_logical_xor_;
Member<MLLstmSupportLimits> member_lstm_;
Member<MLLstmCellSupportLimits> member_lstm_cell_;
Member<MLBinarySupportLimits> member_matmul_;
Member<MLBinarySupportLimits> member_max_;
Member<MLSingleInputSupportLimits> member_max_pool_2d_;
uint64_t member_max_tensor_byte_length_;
Member<MLBinarySupportLimits> member_min_;
Member<MLBinarySupportLimits> member_mul_;
Member<MLSingleInputSupportLimits> member_neg_;
Member<MLBinarySupportLimits> member_not_equal_;
Member<MLTensorLimits> member_output_;
Member<MLSingleInputSupportLimits> member_pad_;
Member<MLBinarySupportLimits> member_pow_;
V8MLInputOperandLayout member_preferred_input_layout_{static_cast<V8MLInputOperandLayout::Enum>(0)};
Member<MLPreluSupportLimits> member_prelu_;
Member<MLQuantizeDequantizeLinearSupportLimits> member_quantize_linear_;
Member<MLSingleInputSupportLimits> member_reciprocal_;
Member<MLSingleInputSupportLimits> member_reduce_l_1_;
Member<MLSingleInputSupportLimits> member_reduce_l_2_;
Member<MLSingleInputSupportLimits> member_reduce_log_sum_;
Member<MLSingleInputSupportLimits> member_reduce_log_sum_exp_;
Member<MLSingleInputSupportLimits> member_reduce_max_;
Member<MLSingleInputSupportLimits> member_reduce_mean_;
Member<MLSingleInputSupportLimits> member_reduce_min_;
Member<MLSingleInputSupportLimits> member_reduce_product_;
Member<MLSingleInputSupportLimits> member_reduce_sum_;
Member<MLSingleInputSupportLimits> member_reduce_sum_square_;
Member<MLSingleInputSupportLimits> member_relu_;
Member<MLSingleInputSupportLimits> member_resample_2d_;
Member<MLSingleInputSupportLimits> member_reshape_;
Member<MLSingleInputSupportLimits> member_reverse_;
Member<MLSingleInputSupportLimits> member_round_even_;
Member<MLScatterSupportLimits> member_scatter_elements_;
Member<MLScatterSupportLimits> member_scatter_nd_;
Member<MLSingleInputSupportLimits> member_sigmoid_;
Member<MLSingleInputSupportLimits> member_sign_;
Member<MLSingleInputSupportLimits> member_sin_;
Member<MLSingleInputSupportLimits> member_slice_;
Member<MLSingleInputSupportLimits> member_softmax_;
Member<MLSingleInputSupportLimits> member_softplus_;
Member<MLSingleInputSupportLimits> member_softsign_;
Member<MLSplitSupportLimits> member_split_;
Member<MLSingleInputSupportLimits> member_sqrt_;
Member<MLBinarySupportLimits> member_sub_;
Member<MLSingleInputSupportLimits> member_tan_;
Member<MLSingleInputSupportLimits> member_tanh_;
Member<MLSingleInputSupportLimits> member_tile_;
Member<MLSingleInputSupportLimits> member_transpose_;
Member<MLSingleInputSupportLimits> member_triangular_;
Member<MLWhereSupportLimits> member_where_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_OP_SUPPORT_LIMITS_H_
