// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LSTM_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LSTM_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_lstm_weight_layout.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_recurrent_network_activation.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_recurrent_network_direction.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MLOperand;

class MODULES_EXPORT MLLstmOptions : public MLOperatorOptions {
  
  public:
static MLLstmOptions* Create() {
  return MakeGarbageCollected<MLLstmOptions>();
}
static MLLstmOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLLstmOptions>(isolate);
}
static MLLstmOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLLstmOptions();
explicit  MLLstmOptions(v8::Isolate* isolate);

bool hasActivations() const {
  return has_activations_;
}
const Vector<V8MLRecurrentNetworkActivation>& activations() const {
  DCHECK(hasActivations());
return member_activations_;
}
Vector<V8MLRecurrentNetworkActivation> getActivationsOr(const Vector<V8MLRecurrentNetworkActivation>& fallback_value) const;
Vector<V8MLRecurrentNetworkActivation> getActivationsOr(Vector<V8MLRecurrentNetworkActivation>&& fallback_value) const;
void setActivations(const Vector<V8MLRecurrentNetworkActivation>& value);
void setActivations(Vector<V8MLRecurrentNetworkActivation>&& value);

bool hasBias() const {
  return has_bias_;
}
MLOperand* bias() const {
  DCHECK(hasBias());
return member_bias_.Get();
}
MLOperand* getBiasOr(MLOperand* fallback_value) const {
  if (!hasBias()) {
  return fallback_value;
}
return member_bias_.Get();
}
void setBias(MLOperand* value) {
  member_bias_ = value;
has_bias_ = true;
DCHECK(member_bias_);
}

bool hasDirection() const {
  return true;
}
V8MLRecurrentNetworkDirection direction() const {
  return member_direction_;
}
void setDirection(V8MLRecurrentNetworkDirection value) {
  member_direction_ = value;
}
void setDirection(V8MLRecurrentNetworkDirection::Enum value) {
  member_direction_ = V8MLRecurrentNetworkDirection(value);
}

bool hasInitialCellState() const {
  return has_initial_cell_state_;
}
MLOperand* initialCellState() const {
  DCHECK(hasInitialCellState());
return member_initial_cell_state_.Get();
}
MLOperand* getInitialCellStateOr(MLOperand* fallback_value) const {
  if (!hasInitialCellState()) {
  return fallback_value;
}
return member_initial_cell_state_.Get();
}
void setInitialCellState(MLOperand* value) {
  member_initial_cell_state_ = value;
has_initial_cell_state_ = true;
DCHECK(member_initial_cell_state_);
}

bool hasInitialHiddenState() const {
  return has_initial_hidden_state_;
}
MLOperand* initialHiddenState() const {
  DCHECK(hasInitialHiddenState());
return member_initial_hidden_state_.Get();
}
MLOperand* getInitialHiddenStateOr(MLOperand* fallback_value) const {
  if (!hasInitialHiddenState()) {
  return fallback_value;
}
return member_initial_hidden_state_.Get();
}
void setInitialHiddenState(MLOperand* value) {
  member_initial_hidden_state_ = value;
has_initial_hidden_state_ = true;
DCHECK(member_initial_hidden_state_);
}

bool hasLayout() const {
  return true;
}
V8MLLstmWeightLayout layout() const {
  return member_layout_;
}
void setLayout(V8MLLstmWeightLayout value) {
  member_layout_ = value;
}
void setLayout(V8MLLstmWeightLayout::Enum value) {
  member_layout_ = V8MLLstmWeightLayout(value);
}

bool hasPeepholeWeight() const {
  return has_peephole_weight_;
}
MLOperand* peepholeWeight() const {
  DCHECK(hasPeepholeWeight());
return member_peephole_weight_.Get();
}
MLOperand* getPeepholeWeightOr(MLOperand* fallback_value) const {
  if (!hasPeepholeWeight()) {
  return fallback_value;
}
return member_peephole_weight_.Get();
}
void setPeepholeWeight(MLOperand* value) {
  member_peephole_weight_ = value;
has_peephole_weight_ = true;
DCHECK(member_peephole_weight_);
}

bool hasRecurrentBias() const {
  return has_recurrent_bias_;
}
MLOperand* recurrentBias() const {
  DCHECK(hasRecurrentBias());
return member_recurrent_bias_.Get();
}
MLOperand* getRecurrentBiasOr(MLOperand* fallback_value) const {
  if (!hasRecurrentBias()) {
  return fallback_value;
}
return member_recurrent_bias_.Get();
}
void setRecurrentBias(MLOperand* value) {
  member_recurrent_bias_ = value;
has_recurrent_bias_ = true;
DCHECK(member_recurrent_bias_);
}

bool hasReturnSequence() const {
  return true;
}
bool returnSequence() const {
  return member_return_sequence_;
}
void setReturnSequence(bool value) {
  member_return_sequence_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_activations_ = false;
bool has_bias_ = false;
bool has_initial_cell_state_ = false;
bool has_initial_hidden_state_ = false;
bool has_peephole_weight_ = false;
bool has_recurrent_bias_ = false;

Vector<V8MLRecurrentNetworkActivation> member_activations_;
Member<MLOperand> member_bias_;
V8MLRecurrentNetworkDirection member_direction_{V8MLRecurrentNetworkDirection::Enum::kForward};
Member<MLOperand> member_initial_cell_state_;
Member<MLOperand> member_initial_hidden_state_;
V8MLLstmWeightLayout member_layout_{V8MLLstmWeightLayout::Enum::kIofg};
Member<MLOperand> member_peephole_weight_;
Member<MLOperand> member_recurrent_bias_;
bool member_return_sequence_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_LSTM_OPTIONS_H_
