// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_HARD_SIGMOID_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_HARD_SIGMOID_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_ml_operator_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MLHardSigmoidOptions : public MLOperatorOptions {
  
  public:
static MLHardSigmoidOptions* Create() {
  return MakeGarbageCollected<MLHardSigmoidOptions>();
}
static MLHardSigmoidOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MLHardSigmoidOptions>(isolate);
}
static MLHardSigmoidOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MLHardSigmoidOptions();
explicit  MLHardSigmoidOptions(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
float alpha() const {
  return member_alpha_;
}
void setAlpha(float value) {
  member_alpha_ = value;
}

bool hasBeta() const {
  return true;
}
float beta() const {
  return member_beta_;
}
void setBeta(float value) {
  member_beta_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MLOperatorOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



float member_alpha_{0.2};
float member_beta_{0.5};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_ML_HARD_SIGMOID_OPTIONS_H_
