// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINT_SET_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINT_SET_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ConstrainBooleanOrDOMStringParameters;
class ConstrainBooleanParameters;
class ConstrainDOMStringParameters;
class ConstrainDoubleRange;
class ConstrainLongRange;
class ConstrainPoint2DParameters;
class ExceptionState;
class Point2D;
class V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString;
class V8UnionBooleanOrConstrainBooleanParameters;
class V8UnionBooleanOrConstrainDoubleRangeOrDouble;
class V8UnionConstrainDOMStringParametersOrStringOrStringSequence;
class V8UnionConstrainDoubleRangeOrDouble;
class V8UnionConstrainLongRangeOrLong;
class V8UnionConstrainPoint2DParametersOrPoint2DSequence;

class MODULES_EXPORT MediaTrackConstraintSet : public bindings::DictionaryBase {
  
  public:
static MediaTrackConstraintSet* Create() {
  return MakeGarbageCollected<MediaTrackConstraintSet>();
}
static MediaTrackConstraintSet* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaTrackConstraintSet>(isolate);
}
static MediaTrackConstraintSet* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaTrackConstraintSet();
explicit  MediaTrackConstraintSet(v8::Isolate* isolate);

bool hasAspectRatio() const {
  return has_aspect_ratio_;
}
V8UnionConstrainDoubleRangeOrDouble* aspectRatio() const {
  DCHECK(hasAspectRatio());
return member_aspect_ratio_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getAspectRatioOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasAspectRatio()) {
  return fallback_value;
}
return member_aspect_ratio_.Get();
}
void setAspectRatio(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_aspect_ratio_ = value;
has_aspect_ratio_ = true;
DCHECK(member_aspect_ratio_);
}

bool hasAutoGainControl() const {
  return has_auto_gain_control_;
}
V8UnionBooleanOrConstrainBooleanParameters* autoGainControl() const {
  DCHECK(hasAutoGainControl());
return member_auto_gain_control_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getAutoGainControlOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasAutoGainControl()) {
  return fallback_value;
}
return member_auto_gain_control_.Get();
}
void setAutoGainControl(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_auto_gain_control_ = value;
has_auto_gain_control_ = true;
DCHECK(member_auto_gain_control_);
}

bool hasBackgroundBlur() const {
  return has_background_blur_;
}
V8UnionBooleanOrConstrainBooleanParameters* backgroundBlur() const {
  DCHECK(hasBackgroundBlur());
return member_background_blur_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getBackgroundBlurOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasBackgroundBlur()) {
  return fallback_value;
}
return member_background_blur_.Get();
}
void setBackgroundBlur(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_background_blur_ = value;
has_background_blur_ = true;
DCHECK(member_background_blur_);
}

bool hasBackgroundSegmentationMask() const {
  return has_background_segmentation_mask_;
}
V8UnionBooleanOrConstrainBooleanParameters* backgroundSegmentationMask() const {
  DCHECK(hasBackgroundSegmentationMask());
return member_background_segmentation_mask_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getBackgroundSegmentationMaskOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasBackgroundSegmentationMask()) {
  return fallback_value;
}
return member_background_segmentation_mask_.Get();
}
void setBackgroundSegmentationMask(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_background_segmentation_mask_ = value;
has_background_segmentation_mask_ = true;
DCHECK(member_background_segmentation_mask_);
}

bool hasBrightness() const {
  return has_brightness_;
}
V8UnionConstrainDoubleRangeOrDouble* brightness() const {
  DCHECK(hasBrightness());
return member_brightness_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getBrightnessOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasBrightness()) {
  return fallback_value;
}
return member_brightness_.Get();
}
void setBrightness(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_brightness_ = value;
has_brightness_ = true;
DCHECK(member_brightness_);
}

bool hasChannelCount() const {
  return has_channel_count_;
}
V8UnionConstrainLongRangeOrLong* channelCount() const {
  DCHECK(hasChannelCount());
return member_channel_count_.Get();
}
V8UnionConstrainLongRangeOrLong* getChannelCountOr(V8UnionConstrainLongRangeOrLong* fallback_value) const {
  if (!hasChannelCount()) {
  return fallback_value;
}
return member_channel_count_.Get();
}
void setChannelCount(V8UnionConstrainLongRangeOrLong* value) {
  member_channel_count_ = value;
has_channel_count_ = true;
DCHECK(member_channel_count_);
}

bool hasColorTemperature() const {
  return has_color_temperature_;
}
V8UnionConstrainDoubleRangeOrDouble* colorTemperature() const {
  DCHECK(hasColorTemperature());
return member_color_temperature_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getColorTemperatureOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasColorTemperature()) {
  return fallback_value;
}
return member_color_temperature_.Get();
}
void setColorTemperature(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_color_temperature_ = value;
has_color_temperature_ = true;
DCHECK(member_color_temperature_);
}

bool hasContrast() const {
  return has_contrast_;
}
V8UnionConstrainDoubleRangeOrDouble* contrast() const {
  DCHECK(hasContrast());
return member_contrast_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getContrastOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasContrast()) {
  return fallback_value;
}
return member_contrast_.Get();
}
void setContrast(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_contrast_ = value;
has_contrast_ = true;
DCHECK(member_contrast_);
}

bool hasDeviceId() const {
  return has_device_id_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* deviceId() const {
  DCHECK(hasDeviceId());
return member_device_id_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getDeviceIdOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasDeviceId()) {
  return fallback_value;
}
return member_device_id_.Get();
}
void setDeviceId(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_device_id_ = value;
has_device_id_ = true;
DCHECK(member_device_id_);
}

bool hasDisplaySurface() const {
  return has_display_surface_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* displaySurface() const {
  DCHECK(hasDisplaySurface());
return member_display_surface_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getDisplaySurfaceOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasDisplaySurface()) {
  return fallback_value;
}
return member_display_surface_.Get();
}
void setDisplaySurface(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_display_surface_ = value;
has_display_surface_ = true;
DCHECK(member_display_surface_);
}

bool hasEchoCancellation() const {
  return has_echo_cancellation_;
}
V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* echoCancellation() const {
  DCHECK(hasEchoCancellation());
return member_echo_cancellation_.Get();
}
V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* getEchoCancellationOr(V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* fallback_value) const {
  if (!hasEchoCancellation()) {
  return fallback_value;
}
return member_echo_cancellation_.Get();
}
void setEchoCancellation(V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* value) {
  member_echo_cancellation_ = value;
has_echo_cancellation_ = true;
DCHECK(member_echo_cancellation_);
}

bool hasExposureCompensation() const {
  return has_exposure_compensation_;
}
V8UnionConstrainDoubleRangeOrDouble* exposureCompensation() const {
  DCHECK(hasExposureCompensation());
return member_exposure_compensation_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getExposureCompensationOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasExposureCompensation()) {
  return fallback_value;
}
return member_exposure_compensation_.Get();
}
void setExposureCompensation(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_exposure_compensation_ = value;
has_exposure_compensation_ = true;
DCHECK(member_exposure_compensation_);
}

bool hasExposureMode() const {
  return has_exposure_mode_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* exposureMode() const {
  DCHECK(hasExposureMode());
return member_exposure_mode_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getExposureModeOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasExposureMode()) {
  return fallback_value;
}
return member_exposure_mode_.Get();
}
void setExposureMode(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_exposure_mode_ = value;
has_exposure_mode_ = true;
DCHECK(member_exposure_mode_);
}

bool hasExposureTime() const {
  return has_exposure_time_;
}
V8UnionConstrainDoubleRangeOrDouble* exposureTime() const {
  DCHECK(hasExposureTime());
return member_exposure_time_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getExposureTimeOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasExposureTime()) {
  return fallback_value;
}
return member_exposure_time_.Get();
}
void setExposureTime(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_exposure_time_ = value;
has_exposure_time_ = true;
DCHECK(member_exposure_time_);
}

bool hasEyeGazeCorrection() const {
  return has_eye_gaze_correction_;
}
V8UnionBooleanOrConstrainBooleanParameters* eyeGazeCorrection() const {
  DCHECK(hasEyeGazeCorrection());
return member_eye_gaze_correction_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getEyeGazeCorrectionOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasEyeGazeCorrection()) {
  return fallback_value;
}
return member_eye_gaze_correction_.Get();
}
void setEyeGazeCorrection(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_eye_gaze_correction_ = value;
has_eye_gaze_correction_ = true;
DCHECK(member_eye_gaze_correction_);
}

bool hasFaceFraming() const {
  return has_face_framing_;
}
V8UnionBooleanOrConstrainBooleanParameters* faceFraming() const {
  DCHECK(hasFaceFraming());
return member_face_framing_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getFaceFramingOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasFaceFraming()) {
  return fallback_value;
}
return member_face_framing_.Get();
}
void setFaceFraming(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_face_framing_ = value;
has_face_framing_ = true;
DCHECK(member_face_framing_);
}

bool hasFacingMode() const {
  return has_facing_mode_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* facingMode() const {
  DCHECK(hasFacingMode());
return member_facing_mode_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getFacingModeOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasFacingMode()) {
  return fallback_value;
}
return member_facing_mode_.Get();
}
void setFacingMode(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_facing_mode_ = value;
has_facing_mode_ = true;
DCHECK(member_facing_mode_);
}

bool hasFocusDistance() const {
  return has_focus_distance_;
}
V8UnionConstrainDoubleRangeOrDouble* focusDistance() const {
  DCHECK(hasFocusDistance());
return member_focus_distance_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getFocusDistanceOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasFocusDistance()) {
  return fallback_value;
}
return member_focus_distance_.Get();
}
void setFocusDistance(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_focus_distance_ = value;
has_focus_distance_ = true;
DCHECK(member_focus_distance_);
}

bool hasFocusMode() const {
  return has_focus_mode_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* focusMode() const {
  DCHECK(hasFocusMode());
return member_focus_mode_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getFocusModeOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasFocusMode()) {
  return fallback_value;
}
return member_focus_mode_.Get();
}
void setFocusMode(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_focus_mode_ = value;
has_focus_mode_ = true;
DCHECK(member_focus_mode_);
}

bool hasFrameRate() const {
  return has_frame_rate_;
}
V8UnionConstrainDoubleRangeOrDouble* frameRate() const {
  DCHECK(hasFrameRate());
return member_frame_rate_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getFrameRateOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasFrameRate()) {
  return fallback_value;
}
return member_frame_rate_.Get();
}
void setFrameRate(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_frame_rate_ = value;
has_frame_rate_ = true;
DCHECK(member_frame_rate_);
}

bool hasGroupId() const {
  return has_group_id_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* groupId() const {
  DCHECK(hasGroupId());
return member_group_id_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getGroupIdOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasGroupId()) {
  return fallback_value;
}
return member_group_id_.Get();
}
void setGroupId(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_group_id_ = value;
has_group_id_ = true;
DCHECK(member_group_id_);
}

bool hasHeight() const {
  return has_height_;
}
V8UnionConstrainLongRangeOrLong* height() const {
  DCHECK(hasHeight());
return member_height_.Get();
}
V8UnionConstrainLongRangeOrLong* getHeightOr(V8UnionConstrainLongRangeOrLong* fallback_value) const {
  if (!hasHeight()) {
  return fallback_value;
}
return member_height_.Get();
}
void setHeight(V8UnionConstrainLongRangeOrLong* value) {
  member_height_ = value;
has_height_ = true;
DCHECK(member_height_);
}

bool hasIso() const {
  return has_iso_;
}
V8UnionConstrainDoubleRangeOrDouble* iso() const {
  DCHECK(hasIso());
return member_iso_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getIsoOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasIso()) {
  return fallback_value;
}
return member_iso_.Get();
}
void setIso(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_iso_ = value;
has_iso_ = true;
DCHECK(member_iso_);
}

bool hasLatency() const {
  return has_latency_;
}
V8UnionConstrainDoubleRangeOrDouble* latency() const {
  DCHECK(hasLatency());
return member_latency_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getLatencyOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasLatency()) {
  return fallback_value;
}
return member_latency_.Get();
}
void setLatency(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_latency_ = value;
has_latency_ = true;
DCHECK(member_latency_);
}

bool hasMandatory() const {
  return has_mandatory_;
}
const ScriptObject& mandatory() const {
  DCHECK(hasMandatory());
return member_mandatory_;
}
ScriptObject getMandatoryOr(const ScriptObject& fallback_value) const {
  if (!hasMandatory()) {
  return fallback_value;
}
return member_mandatory_;
}
void setMandatory(const ScriptObject& value) {
  member_mandatory_ = value;
has_mandatory_ = true;
}

bool hasNoiseSuppression() const {
  return has_noise_suppression_;
}
V8UnionBooleanOrConstrainBooleanParameters* noiseSuppression() const {
  DCHECK(hasNoiseSuppression());
return member_noise_suppression_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getNoiseSuppressionOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasNoiseSuppression()) {
  return fallback_value;
}
return member_noise_suppression_.Get();
}
void setNoiseSuppression(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_noise_suppression_ = value;
has_noise_suppression_ = true;
DCHECK(member_noise_suppression_);
}

bool hasOptional() const {
  return has_optional_;
}
const HeapVector<ScriptObject>& optional() const {
  DCHECK(hasOptional());
return member_optional_;
}
HeapVector<ScriptObject> getOptionalOr(const HeapVector<ScriptObject>& fallback_value) const;
HeapVector<ScriptObject> getOptionalOr(HeapVector<ScriptObject>&& fallback_value) const;
void setOptional(const HeapVector<ScriptObject>& value);
void setOptional(HeapVector<ScriptObject>&& value);

bool hasPan() const {
  return has_pan_;
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* pan() const {
  DCHECK(hasPan());
return member_pan_.Get();
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* getPanOr(V8UnionBooleanOrConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasPan()) {
  return fallback_value;
}
return member_pan_.Get();
}
void setPan(V8UnionBooleanOrConstrainDoubleRangeOrDouble* value) {
  member_pan_ = value;
has_pan_ = true;
DCHECK(member_pan_);
}

bool hasPointsOfInterest() const {
  return has_points_of_interest_;
}
V8UnionConstrainPoint2DParametersOrPoint2DSequence* pointsOfInterest() const {
  DCHECK(hasPointsOfInterest());
return member_points_of_interest_.Get();
}
V8UnionConstrainPoint2DParametersOrPoint2DSequence* getPointsOfInterestOr(V8UnionConstrainPoint2DParametersOrPoint2DSequence* fallback_value) const {
  if (!hasPointsOfInterest()) {
  return fallback_value;
}
return member_points_of_interest_.Get();
}
void setPointsOfInterest(V8UnionConstrainPoint2DParametersOrPoint2DSequence* value) {
  member_points_of_interest_ = value;
has_points_of_interest_ = true;
DCHECK(member_points_of_interest_);
}

bool hasResizeMode() const {
  return has_resize_mode_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* resizeMode() const {
  DCHECK(hasResizeMode());
return member_resize_mode_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getResizeModeOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasResizeMode()) {
  return fallback_value;
}
return member_resize_mode_.Get();
}
void setResizeMode(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_resize_mode_ = value;
has_resize_mode_ = true;
DCHECK(member_resize_mode_);
}

bool hasRestrictOwnAudio() const {
  return has_restrict_own_audio_;
}
V8UnionBooleanOrConstrainBooleanParameters* restrictOwnAudio() const {
  DCHECK(hasRestrictOwnAudio());
return member_restrict_own_audio_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getRestrictOwnAudioOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasRestrictOwnAudio()) {
  return fallback_value;
}
return member_restrict_own_audio_.Get();
}
void setRestrictOwnAudio(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_restrict_own_audio_ = value;
has_restrict_own_audio_ = true;
DCHECK(member_restrict_own_audio_);
}

bool hasSampleRate() const {
  return has_sample_rate_;
}
V8UnionConstrainLongRangeOrLong* sampleRate() const {
  DCHECK(hasSampleRate());
return member_sample_rate_.Get();
}
V8UnionConstrainLongRangeOrLong* getSampleRateOr(V8UnionConstrainLongRangeOrLong* fallback_value) const {
  if (!hasSampleRate()) {
  return fallback_value;
}
return member_sample_rate_.Get();
}
void setSampleRate(V8UnionConstrainLongRangeOrLong* value) {
  member_sample_rate_ = value;
has_sample_rate_ = true;
DCHECK(member_sample_rate_);
}

bool hasSampleSize() const {
  return has_sample_size_;
}
V8UnionConstrainLongRangeOrLong* sampleSize() const {
  DCHECK(hasSampleSize());
return member_sample_size_.Get();
}
V8UnionConstrainLongRangeOrLong* getSampleSizeOr(V8UnionConstrainLongRangeOrLong* fallback_value) const {
  if (!hasSampleSize()) {
  return fallback_value;
}
return member_sample_size_.Get();
}
void setSampleSize(V8UnionConstrainLongRangeOrLong* value) {
  member_sample_size_ = value;
has_sample_size_ = true;
DCHECK(member_sample_size_);
}

bool hasSaturation() const {
  return has_saturation_;
}
V8UnionConstrainDoubleRangeOrDouble* saturation() const {
  DCHECK(hasSaturation());
return member_saturation_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getSaturationOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasSaturation()) {
  return fallback_value;
}
return member_saturation_.Get();
}
void setSaturation(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_saturation_ = value;
has_saturation_ = true;
DCHECK(member_saturation_);
}

bool hasSharpness() const {
  return has_sharpness_;
}
V8UnionConstrainDoubleRangeOrDouble* sharpness() const {
  DCHECK(hasSharpness());
return member_sharpness_.Get();
}
V8UnionConstrainDoubleRangeOrDouble* getSharpnessOr(V8UnionConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasSharpness()) {
  return fallback_value;
}
return member_sharpness_.Get();
}
void setSharpness(V8UnionConstrainDoubleRangeOrDouble* value) {
  member_sharpness_ = value;
has_sharpness_ = true;
DCHECK(member_sharpness_);
}

bool hasSuppressLocalAudioPlayback() const {
  return has_suppress_local_audio_playback_;
}
V8UnionBooleanOrConstrainBooleanParameters* suppressLocalAudioPlayback() const {
  DCHECK(hasSuppressLocalAudioPlayback());
return member_suppress_local_audio_playback_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getSuppressLocalAudioPlaybackOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasSuppressLocalAudioPlayback()) {
  return fallback_value;
}
return member_suppress_local_audio_playback_.Get();
}
void setSuppressLocalAudioPlayback(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_suppress_local_audio_playback_ = value;
has_suppress_local_audio_playback_ = true;
DCHECK(member_suppress_local_audio_playback_);
}

bool hasTilt() const {
  return has_tilt_;
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* tilt() const {
  DCHECK(hasTilt());
return member_tilt_.Get();
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* getTiltOr(V8UnionBooleanOrConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasTilt()) {
  return fallback_value;
}
return member_tilt_.Get();
}
void setTilt(V8UnionBooleanOrConstrainDoubleRangeOrDouble* value) {
  member_tilt_ = value;
has_tilt_ = true;
DCHECK(member_tilt_);
}

bool hasTorch() const {
  return has_torch_;
}
V8UnionBooleanOrConstrainBooleanParameters* torch() const {
  DCHECK(hasTorch());
return member_torch_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getTorchOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasTorch()) {
  return fallback_value;
}
return member_torch_.Get();
}
void setTorch(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_torch_ = value;
has_torch_ = true;
DCHECK(member_torch_);
}

bool hasVoiceIsolation() const {
  return has_voice_isolation_;
}
V8UnionBooleanOrConstrainBooleanParameters* voiceIsolation() const {
  DCHECK(hasVoiceIsolation());
return member_voice_isolation_.Get();
}
V8UnionBooleanOrConstrainBooleanParameters* getVoiceIsolationOr(V8UnionBooleanOrConstrainBooleanParameters* fallback_value) const {
  if (!hasVoiceIsolation()) {
  return fallback_value;
}
return member_voice_isolation_.Get();
}
void setVoiceIsolation(V8UnionBooleanOrConstrainBooleanParameters* value) {
  member_voice_isolation_ = value;
has_voice_isolation_ = true;
DCHECK(member_voice_isolation_);
}

bool hasWhiteBalanceMode() const {
  return has_white_balance_mode_;
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* whiteBalanceMode() const {
  DCHECK(hasWhiteBalanceMode());
return member_white_balance_mode_.Get();
}
V8UnionConstrainDOMStringParametersOrStringOrStringSequence* getWhiteBalanceModeOr(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* fallback_value) const {
  if (!hasWhiteBalanceMode()) {
  return fallback_value;
}
return member_white_balance_mode_.Get();
}
void setWhiteBalanceMode(V8UnionConstrainDOMStringParametersOrStringOrStringSequence* value) {
  member_white_balance_mode_ = value;
has_white_balance_mode_ = true;
DCHECK(member_white_balance_mode_);
}

bool hasWidth() const {
  return has_width_;
}
V8UnionConstrainLongRangeOrLong* width() const {
  DCHECK(hasWidth());
return member_width_.Get();
}
V8UnionConstrainLongRangeOrLong* getWidthOr(V8UnionConstrainLongRangeOrLong* fallback_value) const {
  if (!hasWidth()) {
  return fallback_value;
}
return member_width_.Get();
}
void setWidth(V8UnionConstrainLongRangeOrLong* value) {
  member_width_ = value;
has_width_ = true;
DCHECK(member_width_);
}

bool hasZoom() const {
  return has_zoom_;
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* zoom() const {
  DCHECK(hasZoom());
return member_zoom_.Get();
}
V8UnionBooleanOrConstrainDoubleRangeOrDouble* getZoomOr(V8UnionBooleanOrConstrainDoubleRangeOrDouble* fallback_value) const {
  if (!hasZoom()) {
  return fallback_value;
}
return member_zoom_.Get();
}
void setZoom(V8UnionBooleanOrConstrainDoubleRangeOrDouble* value) {
  member_zoom_ = value;
has_zoom_ = true;
DCHECK(member_zoom_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 42;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_aspect_ratio_ = false;
bool has_auto_gain_control_ = false;
bool has_background_blur_ = false;
bool has_background_segmentation_mask_ = false;
bool has_brightness_ = false;
bool has_channel_count_ = false;
bool has_color_temperature_ = false;
bool has_contrast_ = false;
bool has_device_id_ = false;
bool has_display_surface_ = false;
bool has_echo_cancellation_ = false;
bool has_exposure_compensation_ = false;
bool has_exposure_mode_ = false;
bool has_exposure_time_ = false;
bool has_eye_gaze_correction_ = false;
bool has_face_framing_ = false;
bool has_facing_mode_ = false;
bool has_focus_distance_ = false;
bool has_focus_mode_ = false;
bool has_frame_rate_ = false;
bool has_group_id_ = false;
bool has_height_ = false;
bool has_iso_ = false;
bool has_latency_ = false;
bool has_mandatory_ = false;
bool has_noise_suppression_ = false;
bool has_optional_ = false;
bool has_pan_ = false;
bool has_points_of_interest_ = false;
bool has_resize_mode_ = false;
bool has_restrict_own_audio_ = false;
bool has_sample_rate_ = false;
bool has_sample_size_ = false;
bool has_saturation_ = false;
bool has_sharpness_ = false;
bool has_suppress_local_audio_playback_ = false;
bool has_tilt_ = false;
bool has_torch_ = false;
bool has_voice_isolation_ = false;
bool has_white_balance_mode_ = false;
bool has_width_ = false;
bool has_zoom_ = false;

Member<V8UnionConstrainDoubleRangeOrDouble> member_aspect_ratio_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_auto_gain_control_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_background_blur_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_background_segmentation_mask_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_brightness_;
Member<V8UnionConstrainLongRangeOrLong> member_channel_count_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_color_temperature_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_contrast_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_device_id_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_display_surface_;
Member<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString> member_echo_cancellation_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_exposure_compensation_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_exposure_mode_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_exposure_time_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_eye_gaze_correction_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_face_framing_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_facing_mode_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_focus_distance_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_focus_mode_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_frame_rate_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_group_id_;
Member<V8UnionConstrainLongRangeOrLong> member_height_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_iso_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_latency_;
ScriptObject member_mandatory_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_noise_suppression_;
HeapVector<ScriptObject> member_optional_;
Member<V8UnionBooleanOrConstrainDoubleRangeOrDouble> member_pan_;
Member<V8UnionConstrainPoint2DParametersOrPoint2DSequence> member_points_of_interest_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_resize_mode_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_restrict_own_audio_;
Member<V8UnionConstrainLongRangeOrLong> member_sample_rate_;
Member<V8UnionConstrainLongRangeOrLong> member_sample_size_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_saturation_;
Member<V8UnionConstrainDoubleRangeOrDouble> member_sharpness_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_suppress_local_audio_playback_;
Member<V8UnionBooleanOrConstrainDoubleRangeOrDouble> member_tilt_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_torch_;
Member<V8UnionBooleanOrConstrainBooleanParameters> member_voice_isolation_;
Member<V8UnionConstrainDOMStringParametersOrStringOrStringSequence> member_white_balance_mode_;
Member<V8UnionConstrainLongRangeOrLong> member_width_;
Member<V8UnionBooleanOrConstrainDoubleRangeOrDouble> member_zoom_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_TRACK_CONSTRAINT_SET_H_
