// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_media_track_capabilities.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_string.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_double_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_long_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_settings_range.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"aspectRatio",
"autoGainControl",
"backgroundBlur",
"backgroundSegmentationMask",
"brightness",
"channelCount",
"colorTemperature",
"contrast",
"deviceId",
"displaySurface",
"echoCancellation",
"exposureCompensation",
"exposureMode",
"exposureTime",
"eyeGazeCorrection",
"faceFraming",
"facingMode",
"focusDistance",
"focusMode",
"frameRate",
"groupId",
"height",
"iso",
"latency",
"noiseSuppression",
"pan",
"resizeMode",
"restrictOwnAudio",
"sampleRate",
"sampleSize",
"saturation",
"sharpness",
"tilt",
"torch",
"voiceIsolation",
"whiteBalanceMode",
"width",
"zoom",
};


}  // namespace 

MediaTrackCapabilities* MediaTrackCapabilities::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MediaTrackCapabilities* dictionary = MakeGarbageCollected<MediaTrackCapabilities>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MediaTrackCapabilities";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MediaTrackCapabilities::MediaTrackCapabilities() {
  
}

 MediaTrackCapabilities::MediaTrackCapabilities(v8::Isolate* isolate) {
  
}










Vector<bool> MediaTrackCapabilities::getAutoGainControlOr(const Vector<bool>& fallback_value) const {
  if (!hasAutoGainControl()) {
  return fallback_value;
}
return member_auto_gain_control_;
}

Vector<bool> MediaTrackCapabilities::getAutoGainControlOr(Vector<bool>&& fallback_value) const {
  if (!hasAutoGainControl()) {
  return std::move(fallback_value);
}
return member_auto_gain_control_;
}

void MediaTrackCapabilities::setAutoGainControl(const Vector<bool>& value) {
  member_auto_gain_control_ = value;
has_auto_gain_control_ = true;
}

void MediaTrackCapabilities::setAutoGainControl(Vector<bool>&& value) {
  member_auto_gain_control_ = std::move(value);
has_auto_gain_control_ = true;
}




Vector<bool> MediaTrackCapabilities::getBackgroundBlurOr(const Vector<bool>& fallback_value) const {
  if (!hasBackgroundBlur()) {
  return fallback_value;
}
return member_background_blur_;
}

Vector<bool> MediaTrackCapabilities::getBackgroundBlurOr(Vector<bool>&& fallback_value) const {
  if (!hasBackgroundBlur()) {
  return std::move(fallback_value);
}
return member_background_blur_;
}

void MediaTrackCapabilities::setBackgroundBlur(const Vector<bool>& value) {
  member_background_blur_ = value;
has_background_blur_ = true;
}

void MediaTrackCapabilities::setBackgroundBlur(Vector<bool>&& value) {
  member_background_blur_ = std::move(value);
has_background_blur_ = true;
}




Vector<bool> MediaTrackCapabilities::getBackgroundSegmentationMaskOr(const Vector<bool>& fallback_value) const {
  if (!hasBackgroundSegmentationMask()) {
  return fallback_value;
}
return member_background_segmentation_mask_;
}

Vector<bool> MediaTrackCapabilities::getBackgroundSegmentationMaskOr(Vector<bool>&& fallback_value) const {
  if (!hasBackgroundSegmentationMask()) {
  return std::move(fallback_value);
}
return member_background_segmentation_mask_;
}

void MediaTrackCapabilities::setBackgroundSegmentationMask(const Vector<bool>& value) {
  member_background_segmentation_mask_ = value;
has_background_segmentation_mask_ = true;
}

void MediaTrackCapabilities::setBackgroundSegmentationMask(Vector<bool>&& value) {
  member_background_segmentation_mask_ = std::move(value);
has_background_segmentation_mask_ = true;
}
































String MediaTrackCapabilities::getDeviceIdOr(const String& fallback_value) const {
  if (!hasDeviceId()) {
  return fallback_value;
}
return member_device_id_;
}

String MediaTrackCapabilities::getDeviceIdOr(String&& fallback_value) const {
  if (!hasDeviceId()) {
  return std::move(fallback_value);
}
return member_device_id_;
}

void MediaTrackCapabilities::setDeviceId(const String& value) {
  member_device_id_ = value;
has_device_id_ = true;
}

void MediaTrackCapabilities::setDeviceId(String&& value) {
  member_device_id_ = std::move(value);
has_device_id_ = true;
}




String MediaTrackCapabilities::getDisplaySurfaceOr(const String& fallback_value) const {
  if (!hasDisplaySurface()) {
  return fallback_value;
}
return member_display_surface_;
}

String MediaTrackCapabilities::getDisplaySurfaceOr(String&& fallback_value) const {
  if (!hasDisplaySurface()) {
  return std::move(fallback_value);
}
return member_display_surface_;
}

void MediaTrackCapabilities::setDisplaySurface(const String& value) {
  member_display_surface_ = value;
has_display_surface_ = true;
}

void MediaTrackCapabilities::setDisplaySurface(String&& value) {
  member_display_surface_ = std::move(value);
has_display_surface_ = true;
}




HeapVector<Member<V8UnionBooleanOrString>> MediaTrackCapabilities::getEchoCancellationOr(const HeapVector<Member<V8UnionBooleanOrString>>& fallback_value) const {
  if (!hasEchoCancellation()) {
  return fallback_value;
}
return member_echo_cancellation_;
}

HeapVector<Member<V8UnionBooleanOrString>> MediaTrackCapabilities::getEchoCancellationOr(HeapVector<Member<V8UnionBooleanOrString>>&& fallback_value) const {
  if (!hasEchoCancellation()) {
  return std::move(fallback_value);
}
return member_echo_cancellation_;
}

void MediaTrackCapabilities::setEchoCancellation(const HeapVector<Member<V8UnionBooleanOrString>>& value) {
  member_echo_cancellation_ = value;
has_echo_cancellation_ = true;
}

void MediaTrackCapabilities::setEchoCancellation(HeapVector<Member<V8UnionBooleanOrString>>&& value) {
  member_echo_cancellation_ = std::move(value);
has_echo_cancellation_ = true;
}











Vector<String> MediaTrackCapabilities::getExposureModeOr(const Vector<String>& fallback_value) const {
  if (!hasExposureMode()) {
  return fallback_value;
}
return member_exposure_mode_;
}

Vector<String> MediaTrackCapabilities::getExposureModeOr(Vector<String>&& fallback_value) const {
  if (!hasExposureMode()) {
  return std::move(fallback_value);
}
return member_exposure_mode_;
}

void MediaTrackCapabilities::setExposureMode(const Vector<String>& value) {
  member_exposure_mode_ = value;
has_exposure_mode_ = true;
}

void MediaTrackCapabilities::setExposureMode(Vector<String>&& value) {
  member_exposure_mode_ = std::move(value);
has_exposure_mode_ = true;
}











Vector<bool> MediaTrackCapabilities::getEyeGazeCorrectionOr(const Vector<bool>& fallback_value) const {
  if (!hasEyeGazeCorrection()) {
  return fallback_value;
}
return member_eye_gaze_correction_;
}

Vector<bool> MediaTrackCapabilities::getEyeGazeCorrectionOr(Vector<bool>&& fallback_value) const {
  if (!hasEyeGazeCorrection()) {
  return std::move(fallback_value);
}
return member_eye_gaze_correction_;
}

void MediaTrackCapabilities::setEyeGazeCorrection(const Vector<bool>& value) {
  member_eye_gaze_correction_ = value;
has_eye_gaze_correction_ = true;
}

void MediaTrackCapabilities::setEyeGazeCorrection(Vector<bool>&& value) {
  member_eye_gaze_correction_ = std::move(value);
has_eye_gaze_correction_ = true;
}




Vector<bool> MediaTrackCapabilities::getFaceFramingOr(const Vector<bool>& fallback_value) const {
  if (!hasFaceFraming()) {
  return fallback_value;
}
return member_face_framing_;
}

Vector<bool> MediaTrackCapabilities::getFaceFramingOr(Vector<bool>&& fallback_value) const {
  if (!hasFaceFraming()) {
  return std::move(fallback_value);
}
return member_face_framing_;
}

void MediaTrackCapabilities::setFaceFraming(const Vector<bool>& value) {
  member_face_framing_ = value;
has_face_framing_ = true;
}

void MediaTrackCapabilities::setFaceFraming(Vector<bool>&& value) {
  member_face_framing_ = std::move(value);
has_face_framing_ = true;
}




Vector<String> MediaTrackCapabilities::getFacingModeOr(const Vector<String>& fallback_value) const {
  if (!hasFacingMode()) {
  return fallback_value;
}
return member_facing_mode_;
}

Vector<String> MediaTrackCapabilities::getFacingModeOr(Vector<String>&& fallback_value) const {
  if (!hasFacingMode()) {
  return std::move(fallback_value);
}
return member_facing_mode_;
}

void MediaTrackCapabilities::setFacingMode(const Vector<String>& value) {
  member_facing_mode_ = value;
has_facing_mode_ = true;
}

void MediaTrackCapabilities::setFacingMode(Vector<String>&& value) {
  member_facing_mode_ = std::move(value);
has_facing_mode_ = true;
}











Vector<String> MediaTrackCapabilities::getFocusModeOr(const Vector<String>& fallback_value) const {
  if (!hasFocusMode()) {
  return fallback_value;
}
return member_focus_mode_;
}

Vector<String> MediaTrackCapabilities::getFocusModeOr(Vector<String>&& fallback_value) const {
  if (!hasFocusMode()) {
  return std::move(fallback_value);
}
return member_focus_mode_;
}

void MediaTrackCapabilities::setFocusMode(const Vector<String>& value) {
  member_focus_mode_ = value;
has_focus_mode_ = true;
}

void MediaTrackCapabilities::setFocusMode(Vector<String>&& value) {
  member_focus_mode_ = std::move(value);
has_focus_mode_ = true;
}











String MediaTrackCapabilities::getGroupIdOr(const String& fallback_value) const {
  if (!hasGroupId()) {
  return fallback_value;
}
return member_group_id_;
}

String MediaTrackCapabilities::getGroupIdOr(String&& fallback_value) const {
  if (!hasGroupId()) {
  return std::move(fallback_value);
}
return member_group_id_;
}

void MediaTrackCapabilities::setGroupId(const String& value) {
  member_group_id_ = value;
has_group_id_ = true;
}

void MediaTrackCapabilities::setGroupId(String&& value) {
  member_group_id_ = std::move(value);
has_group_id_ = true;
}

























Vector<bool> MediaTrackCapabilities::getNoiseSuppressionOr(const Vector<bool>& fallback_value) const {
  if (!hasNoiseSuppression()) {
  return fallback_value;
}
return member_noise_suppression_;
}

Vector<bool> MediaTrackCapabilities::getNoiseSuppressionOr(Vector<bool>&& fallback_value) const {
  if (!hasNoiseSuppression()) {
  return std::move(fallback_value);
}
return member_noise_suppression_;
}

void MediaTrackCapabilities::setNoiseSuppression(const Vector<bool>& value) {
  member_noise_suppression_ = value;
has_noise_suppression_ = true;
}

void MediaTrackCapabilities::setNoiseSuppression(Vector<bool>&& value) {
  member_noise_suppression_ = std::move(value);
has_noise_suppression_ = true;
}











Vector<String> MediaTrackCapabilities::getResizeModeOr(const Vector<String>& fallback_value) const {
  if (!hasResizeMode()) {
  return fallback_value;
}
return member_resize_mode_;
}

Vector<String> MediaTrackCapabilities::getResizeModeOr(Vector<String>&& fallback_value) const {
  if (!hasResizeMode()) {
  return std::move(fallback_value);
}
return member_resize_mode_;
}

void MediaTrackCapabilities::setResizeMode(const Vector<String>& value) {
  member_resize_mode_ = value;
has_resize_mode_ = true;
}

void MediaTrackCapabilities::setResizeMode(Vector<String>&& value) {
  member_resize_mode_ = std::move(value);
has_resize_mode_ = true;
}




Vector<bool> MediaTrackCapabilities::getRestrictOwnAudioOr(const Vector<bool>& fallback_value) const {
  if (!hasRestrictOwnAudio()) {
  return fallback_value;
}
return member_restrict_own_audio_;
}

Vector<bool> MediaTrackCapabilities::getRestrictOwnAudioOr(Vector<bool>&& fallback_value) const {
  if (!hasRestrictOwnAudio()) {
  return std::move(fallback_value);
}
return member_restrict_own_audio_;
}

void MediaTrackCapabilities::setRestrictOwnAudio(const Vector<bool>& value) {
  member_restrict_own_audio_ = value;
has_restrict_own_audio_ = true;
}

void MediaTrackCapabilities::setRestrictOwnAudio(Vector<bool>&& value) {
  member_restrict_own_audio_ = std::move(value);
has_restrict_own_audio_ = true;
}














































Vector<bool> MediaTrackCapabilities::getVoiceIsolationOr(const Vector<bool>& fallback_value) const {
  if (!hasVoiceIsolation()) {
  return fallback_value;
}
return member_voice_isolation_;
}

Vector<bool> MediaTrackCapabilities::getVoiceIsolationOr(Vector<bool>&& fallback_value) const {
  if (!hasVoiceIsolation()) {
  return std::move(fallback_value);
}
return member_voice_isolation_;
}

void MediaTrackCapabilities::setVoiceIsolation(const Vector<bool>& value) {
  member_voice_isolation_ = value;
has_voice_isolation_ = true;
}

void MediaTrackCapabilities::setVoiceIsolation(Vector<bool>&& value) {
  member_voice_isolation_ = std::move(value);
has_voice_isolation_ = true;
}




Vector<String> MediaTrackCapabilities::getWhiteBalanceModeOr(const Vector<String>& fallback_value) const {
  if (!hasWhiteBalanceMode()) {
  return fallback_value;
}
return member_white_balance_mode_;
}

Vector<String> MediaTrackCapabilities::getWhiteBalanceModeOr(Vector<String>&& fallback_value) const {
  if (!hasWhiteBalanceMode()) {
  return std::move(fallback_value);
}
return member_white_balance_mode_;
}

void MediaTrackCapabilities::setWhiteBalanceMode(const Vector<String>& value) {
  member_white_balance_mode_ = value;
has_white_balance_mode_ = true;
}

void MediaTrackCapabilities::setWhiteBalanceMode(Vector<String>&& value) {
  member_white_balance_mode_ = std::move(value);
has_white_balance_mode_ = true;
}

















void MediaTrackCapabilities::Trace(Visitor* visitor) const {
  visitor->Trace(member_aspect_ratio_);
visitor->Trace(member_brightness_);
visitor->Trace(member_channel_count_);
visitor->Trace(member_color_temperature_);
visitor->Trace(member_contrast_);
visitor->Trace(member_echo_cancellation_);
visitor->Trace(member_exposure_compensation_);
visitor->Trace(member_exposure_time_);
visitor->Trace(member_focus_distance_);
visitor->Trace(member_frame_rate_);
visitor->Trace(member_height_);
visitor->Trace(member_iso_);
visitor->Trace(member_latency_);
visitor->Trace(member_pan_);
visitor->Trace(member_sample_rate_);
visitor->Trace(member_sample_size_);
visitor->Trace(member_saturation_);
visitor->Trace(member_sharpness_);
visitor->Trace(member_tilt_);
visitor->Trace(member_width_);
visitor->Trace(member_zoom_);
bindings::DictionaryBase::Trace(visitor);
}

void MediaTrackCapabilities::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MediaTrackCapabilities::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAspectRatio()) {
  values[0] = ToV8Traits<DoubleRange>::ToV8(script_state, member_aspect_ratio_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasAutoGainControl()) {
  values[1] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_auto_gain_control_);
DCHECK(!values[1].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  if (hasBackgroundBlur()) {
  values[2] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_background_blur_);
DCHECK(!values[2].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasBackgroundSegmentationMask()) {
  values[3] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_background_segmentation_mask_);
DCHECK(!values[3].IsEmpty());
}
}
if (hasBrightness()) {
  values[4] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_brightness_.Get());
DCHECK(!values[4].IsEmpty());
}
if (hasChannelCount()) {
  values[5] = ToV8Traits<LongRange>::ToV8(script_state, member_channel_count_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasColorTemperature()) {
  values[6] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_color_temperature_.Get());
DCHECK(!values[6].IsEmpty());
}
if (hasContrast()) {
  values[7] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_contrast_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasDeviceId()) {
  values[8] = ToV8Traits<IDLString>::ToV8(script_state, member_device_id_);
DCHECK(!values[8].IsEmpty());
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  if (hasDisplaySurface()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_display_surface_);
DCHECK(!values[9].IsEmpty());
}
}
if (hasEchoCancellation()) {
  values[10] = ToV8Traits<IDLSequence<V8UnionBooleanOrString>>::ToV8(script_state, member_echo_cancellation_);
DCHECK(!values[10].IsEmpty());
}
if (hasExposureCompensation()) {
  values[11] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_exposure_compensation_.Get());
DCHECK(!values[11].IsEmpty());
}
if (hasExposureMode()) {
  values[12] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_exposure_mode_);
DCHECK(!values[12].IsEmpty());
}
if (hasExposureTime()) {
  values[13] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_exposure_time_.Get());
DCHECK(!values[13].IsEmpty());
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasEyeGazeCorrection()) {
  values[14] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_eye_gaze_correction_);
DCHECK(!values[14].IsEmpty());
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  if (hasFaceFraming()) {
  values[15] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_face_framing_);
DCHECK(!values[15].IsEmpty());
}
}
if (hasFacingMode()) {
  values[16] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_facing_mode_);
DCHECK(!values[16].IsEmpty());
}
if (hasFocusDistance()) {
  values[17] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_focus_distance_.Get());
DCHECK(!values[17].IsEmpty());
}
if (hasFocusMode()) {
  values[18] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_focus_mode_);
DCHECK(!values[18].IsEmpty());
}
if (hasFrameRate()) {
  values[19] = ToV8Traits<DoubleRange>::ToV8(script_state, member_frame_rate_.Get());
DCHECK(!values[19].IsEmpty());
}
if (hasGroupId()) {
  values[20] = ToV8Traits<IDLString>::ToV8(script_state, member_group_id_);
DCHECK(!values[20].IsEmpty());
}
if (hasHeight()) {
  values[21] = ToV8Traits<LongRange>::ToV8(script_state, member_height_.Get());
DCHECK(!values[21].IsEmpty());
}
if (hasIso()) {
  values[22] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_iso_.Get());
DCHECK(!values[22].IsEmpty());
}
if (hasLatency()) {
  values[23] = ToV8Traits<DoubleRange>::ToV8(script_state, member_latency_.Get());
DCHECK(!values[23].IsEmpty());
}
if (hasNoiseSuppression()) {
  values[24] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_noise_suppression_);
DCHECK(!values[24].IsEmpty());
}
if (hasPan()) {
  values[25] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_pan_.Get());
DCHECK(!values[25].IsEmpty());
}
if (hasResizeMode()) {
  values[26] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_resize_mode_);
DCHECK(!values[26].IsEmpty());
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  if (hasRestrictOwnAudio()) {
  values[27] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_restrict_own_audio_);
DCHECK(!values[27].IsEmpty());
}
}
if (hasSampleRate()) {
  values[28] = ToV8Traits<LongRange>::ToV8(script_state, member_sample_rate_.Get());
DCHECK(!values[28].IsEmpty());
}
if (hasSampleSize()) {
  values[29] = ToV8Traits<LongRange>::ToV8(script_state, member_sample_size_.Get());
DCHECK(!values[29].IsEmpty());
}
if (hasSaturation()) {
  values[30] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_saturation_.Get());
DCHECK(!values[30].IsEmpty());
}
if (hasSharpness()) {
  values[31] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_sharpness_.Get());
DCHECK(!values[31].IsEmpty());
}
if (hasTilt()) {
  values[32] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_tilt_.Get());
DCHECK(!values[32].IsEmpty());
}
if (hasTorch()) {
  values[33] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_torch_);
DCHECK(!values[33].IsEmpty());
}
if (hasVoiceIsolation()) {
  values[34] = ToV8Traits<IDLSequence<IDLBoolean>>::ToV8(script_state, member_voice_isolation_);
DCHECK(!values[34].IsEmpty());
}
if (hasWhiteBalanceMode()) {
  values[35] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_white_balance_mode_);
DCHECK(!values[35].IsEmpty());
}
if (hasWidth()) {
  values[36] = ToV8Traits<LongRange>::ToV8(script_state, member_width_.Get());
DCHECK(!values[36].IsEmpty());
}
if (hasZoom()) {
  values[37] = ToV8Traits<MediaSettingsRange>::ToV8(script_state, member_zoom_.Get());
DCHECK(!values[37].IsEmpty());
}
}

const void* MediaTrackCapabilities::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MediaTrackCapabilities::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MediaTrackCapabilities::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MediaTrackCapabilities";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("aspectRatio");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<DoubleRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_aspect_ratio_, member_aspect_ratio_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("autoGainControl");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_auto_gain_control_, member_auto_gain_control_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundBlur");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_background_blur_, member_background_blur_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("backgroundSegmentationMask");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_background_segmentation_mask_, member_background_segmentation_mask_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("brightness");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_brightness_, member_brightness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("channelCount");
if (!bindings::GetDictionaryMemberFromV8Object<LongRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_channel_count_, member_channel_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorTemperature");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_color_temperature_, member_color_temperature_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contrast");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_contrast_, member_contrast_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("deviceId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_device_id_, member_device_id_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::GetDisplayMediaEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("displaySurface");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_display_surface_, member_display_surface_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("echoCancellation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionBooleanOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_echo_cancellation_, member_echo_cancellation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureCompensation");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_exposure_compensation_, member_exposure_compensation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_exposure_mode_, member_exposure_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("exposureTime");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_exposure_time_, member_exposure_time_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("eyeGazeCorrection");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_eye_gaze_correction_, member_eye_gaze_correction_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("faceFraming");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_face_framing_, member_face_framing_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("facingMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_facing_mode_, member_facing_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusDistance");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_focus_distance_, member_focus_distance_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("focusMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_focus_mode_, member_focus_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frameRate");
if (!bindings::GetDictionaryMemberFromV8Object<DoubleRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_frame_rate_, member_frame_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("groupId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_group_id_, member_group_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<LongRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_height_, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iso");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_iso_, member_iso_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("latency");
if (!bindings::GetDictionaryMemberFromV8Object<DoubleRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_latency_, member_latency_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("noiseSuppression");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_noise_suppression_, member_noise_suppression_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pan");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), has_pan_, member_pan_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_resize_mode_, member_resize_mode_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::RestrictOwnAudioEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("restrictOwnAudio");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_restrict_own_audio_, member_restrict_own_audio_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleRate");
if (!bindings::GetDictionaryMemberFromV8Object<LongRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_sample_rate_, member_sample_rate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sampleSize");
if (!bindings::GetDictionaryMemberFromV8Object<LongRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[29].Get(isolate), has_sample_size_, member_sample_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("saturation");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[30].Get(isolate), has_saturation_, member_saturation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sharpness");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[31].Get(isolate), has_sharpness_, member_sharpness_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tilt");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[32].Get(isolate), has_tilt_, member_tilt_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("torch");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[33].Get(isolate), has_torch_, member_torch_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("voiceIsolation");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLBoolean>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[34].Get(isolate), has_voice_isolation_, member_voice_isolation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("whiteBalanceMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[35].Get(isolate), has_white_balance_mode_, member_white_balance_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<LongRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[36].Get(isolate), has_width_, member_width_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("zoom");
if (!bindings::GetDictionaryMemberFromV8Object<MediaSettingsRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[37].Get(isolate), has_zoom_, member_zoom_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MediaTrackCapabilities::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
