// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_GENERATOR_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_GENERATOR_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MediaStreamTrack;

class MODULES_EXPORT MediaStreamTrackGeneratorInit : public bindings::InputDictionaryBase {
  
  public:
static MediaStreamTrackGeneratorInit* Create() {
  return MakeGarbageCollected<MediaStreamTrackGeneratorInit>();
}
static MediaStreamTrackGeneratorInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaStreamTrackGeneratorInit>(isolate);
}
static MediaStreamTrackGeneratorInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaStreamTrackGeneratorInit();
explicit  MediaStreamTrackGeneratorInit(v8::Isolate* isolate);

bool hasKind() const {
  return true;
}
const String& kind() const {
  return member_kind_;
}
void setKind(const String& value);
void setKind(String&& value);

bool hasMaxSignalBufferSize() const {
  return has_max_signal_buffer_size_;
}
uint16_t maxSignalBufferSize() const {
  DCHECK(hasMaxSignalBufferSize());
return member_max_signal_buffer_size_;
}
uint16_t getMaxSignalBufferSizeOr(uint16_t fallback_value) const {
  if (!hasMaxSignalBufferSize()) {
  return fallback_value;
}
return member_max_signal_buffer_size_;
}
void setMaxSignalBufferSize(uint16_t value) {
  member_max_signal_buffer_size_ = value;
has_max_signal_buffer_size_ = true;
}

bool hasSignalTarget() const {
  return has_signal_target_;
}
MediaStreamTrack* signalTarget() const {
  DCHECK(hasSignalTarget());
return member_signal_target_.Get();
}
MediaStreamTrack* getSignalTargetOr(MediaStreamTrack* fallback_value) const {
  if (!hasSignalTarget()) {
  return fallback_value;
}
return member_signal_target_.Get();
}
void setSignalTarget(MediaStreamTrack* value) {
  member_signal_target_ = value;
has_signal_target_ = true;
DCHECK(member_signal_target_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_max_signal_buffer_size_ = false;
bool has_signal_target_ = false;

String member_kind_;
uint16_t member_max_signal_buffer_size_;
Member<MediaStreamTrack> member_signal_target_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_STREAM_TRACK_GENERATOR_INIT_H_
