// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_RECORDER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_RECORDER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_bitrate_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaRecorderOptions : public bindings::InputDictionaryBase {
  
  public:
static MediaRecorderOptions* Create() {
  return MakeGarbageCollected<MediaRecorderOptions>();
}
static MediaRecorderOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaRecorderOptions>(isolate);
}
static MediaRecorderOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaRecorderOptions();
explicit  MediaRecorderOptions(v8::Isolate* isolate);

bool hasAudioBitrateMode() const {
  return true;
}
V8BitrateMode audioBitrateMode() const {
  return member_audio_bitrate_mode_;
}
void setAudioBitrateMode(V8BitrateMode value) {
  member_audio_bitrate_mode_ = value;
}
void setAudioBitrateMode(V8BitrateMode::Enum value) {
  member_audio_bitrate_mode_ = V8BitrateMode(value);
}

bool hasAudioBitsPerSecond() const {
  return has_audio_bits_per_second_;
}
uint32_t audioBitsPerSecond() const {
  DCHECK(hasAudioBitsPerSecond());
return member_audio_bits_per_second_;
}
uint32_t getAudioBitsPerSecondOr(uint32_t fallback_value) const {
  if (!hasAudioBitsPerSecond()) {
  return fallback_value;
}
return member_audio_bits_per_second_;
}
void setAudioBitsPerSecond(uint32_t value) {
  member_audio_bits_per_second_ = value;
has_audio_bits_per_second_ = true;
}

bool hasBitsPerSecond() const {
  return has_bits_per_second_;
}
uint32_t bitsPerSecond() const {
  DCHECK(hasBitsPerSecond());
return member_bits_per_second_;
}
uint32_t getBitsPerSecondOr(uint32_t fallback_value) const {
  if (!hasBitsPerSecond()) {
  return fallback_value;
}
return member_bits_per_second_;
}
void setBitsPerSecond(uint32_t value) {
  member_bits_per_second_ = value;
has_bits_per_second_ = true;
}

bool hasMimeType() const {
  return true;
}
const String& mimeType() const {
  return member_mime_type_;
}
void setMimeType(const String& value);
void setMimeType(String&& value);

bool hasVideoBitsPerSecond() const {
  return has_video_bits_per_second_;
}
uint32_t videoBitsPerSecond() const {
  DCHECK(hasVideoBitsPerSecond());
return member_video_bits_per_second_;
}
uint32_t getVideoBitsPerSecondOr(uint32_t fallback_value) const {
  if (!hasVideoBitsPerSecond()) {
  return fallback_value;
}
return member_video_bits_per_second_;
}
void setVideoBitsPerSecond(uint32_t value) {
  member_video_bits_per_second_ = value;
has_video_bits_per_second_ = true;
}

bool hasVideoKeyFrameIntervalCount() const {
  return has_video_key_frame_interval_count_;
}
uint32_t videoKeyFrameIntervalCount() const {
  DCHECK(hasVideoKeyFrameIntervalCount());
return member_video_key_frame_interval_count_;
}
uint32_t getVideoKeyFrameIntervalCountOr(uint32_t fallback_value) const {
  if (!hasVideoKeyFrameIntervalCount()) {
  return fallback_value;
}
return member_video_key_frame_interval_count_;
}
void setVideoKeyFrameIntervalCount(uint32_t value) {
  member_video_key_frame_interval_count_ = value;
has_video_key_frame_interval_count_ = true;
}

bool hasVideoKeyFrameIntervalDuration() const {
  return has_video_key_frame_interval_duration_;
}
double videoKeyFrameIntervalDuration() const {
  DCHECK(hasVideoKeyFrameIntervalDuration());
return member_video_key_frame_interval_duration_;
}
double getVideoKeyFrameIntervalDurationOr(double fallback_value) const {
  if (!hasVideoKeyFrameIntervalDuration()) {
  return fallback_value;
}
return member_video_key_frame_interval_duration_;
}
void setVideoKeyFrameIntervalDuration(double value) {
  member_video_key_frame_interval_duration_ = value;
has_video_key_frame_interval_duration_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_audio_bits_per_second_ = false;
bool has_bits_per_second_ = false;
bool has_video_bits_per_second_ = false;
bool has_video_key_frame_interval_count_ = false;
bool has_video_key_frame_interval_duration_ = false;

V8BitrateMode member_audio_bitrate_mode_{V8BitrateMode::Enum::kVariable};
uint32_t member_audio_bits_per_second_;
uint32_t member_bits_per_second_;
String member_mime_type_{""};
uint32_t member_video_bits_per_second_;
uint32_t member_video_key_frame_interval_count_;
double member_video_key_frame_interval_duration_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_RECORDER_OPTIONS_H_
