// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_ENCRYPTED_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_ENCRYPTED_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT MediaEncryptedEventInit : public EventInit {
  
  public:
static MediaEncryptedEventInit* Create() {
  return MakeGarbageCollected<MediaEncryptedEventInit>();
}
static MediaEncryptedEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MediaEncryptedEventInit>(isolate);
}
static MediaEncryptedEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MediaEncryptedEventInit();
explicit  MediaEncryptedEventInit(v8::Isolate* isolate);

bool hasInitData() const {
  return true;
}
DOMArrayBuffer* initData() const {
  return member_init_data_.Get();
}
void setInitData(DOMArrayBuffer* value) {
  member_init_data_ = value;
}

bool hasInitDataType() const {
  return true;
}
const String& initDataType() const {
  return member_init_data_type_;
}
void setInitDataType(const String& value);
void setInitDataType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<DOMArrayBuffer> member_init_data_{nullptr};
String member_init_data_type_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_MEDIA_ENCRYPTED_EVENT_INIT_H_
