// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_manager_snapshot.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_info.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"held",
"pending",
};


}  // namespace 

LockManagerSnapshot* LockManagerSnapshot::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  LockManagerSnapshot* dictionary = MakeGarbageCollected<LockManagerSnapshot>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "LockManagerSnapshot";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 LockManagerSnapshot::LockManagerSnapshot() {
  
}

 LockManagerSnapshot::LockManagerSnapshot(v8::Isolate* isolate) {
  
}



HeapVector<Member<LockInfo>> LockManagerSnapshot::getHeldOr(const HeapVector<Member<LockInfo>>& fallback_value) const {
  if (!hasHeld()) {
  return fallback_value;
}
return member_held_;
}

HeapVector<Member<LockInfo>> LockManagerSnapshot::getHeldOr(HeapVector<Member<LockInfo>>&& fallback_value) const {
  if (!hasHeld()) {
  return std::move(fallback_value);
}
return member_held_;
}

void LockManagerSnapshot::setHeld(const HeapVector<Member<LockInfo>>& value) {
  member_held_ = value;
has_held_ = true;
}

void LockManagerSnapshot::setHeld(HeapVector<Member<LockInfo>>&& value) {
  member_held_ = std::move(value);
has_held_ = true;
}




HeapVector<Member<LockInfo>> LockManagerSnapshot::getPendingOr(const HeapVector<Member<LockInfo>>& fallback_value) const {
  if (!hasPending()) {
  return fallback_value;
}
return member_pending_;
}

HeapVector<Member<LockInfo>> LockManagerSnapshot::getPendingOr(HeapVector<Member<LockInfo>>&& fallback_value) const {
  if (!hasPending()) {
  return std::move(fallback_value);
}
return member_pending_;
}

void LockManagerSnapshot::setPending(const HeapVector<Member<LockInfo>>& value) {
  member_pending_ = value;
has_pending_ = true;
}

void LockManagerSnapshot::setPending(HeapVector<Member<LockInfo>>&& value) {
  member_pending_ = std::move(value);
has_pending_ = true;
}



void LockManagerSnapshot::Trace(Visitor* visitor) const {
  visitor->Trace(member_held_);
visitor->Trace(member_pending_);
bindings::DictionaryBase::Trace(visitor);
}

void LockManagerSnapshot::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void LockManagerSnapshot::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasHeld()) {
  values[0] = ToV8Traits<IDLSequence<LockInfo>>::ToV8(script_state, member_held_);
DCHECK(!values[0].IsEmpty());
}
if (hasPending()) {
  values[1] = ToV8Traits<IDLSequence<LockInfo>>::ToV8(script_state, member_pending_);
DCHECK(!values[1].IsEmpty());
}
}

const void* LockManagerSnapshot::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> LockManagerSnapshot::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void LockManagerSnapshot::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "LockManagerSnapshot";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("held");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LockInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_held_, member_held_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pending");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<LockInfo>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_pending_, member_pending_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> LockManagerSnapshot::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
