// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_JSON_WEB_KEY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_JSON_WEB_KEY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class RsaOtherPrimesInfo;

class MODULES_EXPORT JsonWebKey : public bindings::InputDictionaryBase {
  
  public:
static JsonWebKey* Create() {
  return MakeGarbageCollected<JsonWebKey>();
}
static JsonWebKey* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<JsonWebKey>(isolate);
}
static JsonWebKey* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  JsonWebKey();
explicit  JsonWebKey(v8::Isolate* isolate);

bool hasAlg() const {
  return has_alg_;
}
const String& alg() const {
  DCHECK(hasAlg());
return member_alg_;
}
String getAlgOr(const String& fallback_value) const;
String getAlgOr(String&& fallback_value) const;
void setAlg(const String& value);
void setAlg(String&& value);

bool hasCrv() const {
  return has_crv_;
}
const String& crv() const {
  DCHECK(hasCrv());
return member_crv_;
}
String getCrvOr(const String& fallback_value) const;
String getCrvOr(String&& fallback_value) const;
void setCrv(const String& value);
void setCrv(String&& value);

bool hasD() const {
  return has_d_;
}
const String& d() const {
  DCHECK(hasD());
return member_d_;
}
String getDOr(const String& fallback_value) const;
String getDOr(String&& fallback_value) const;
void setD(const String& value);
void setD(String&& value);

bool hasDp() const {
  return has_dp_;
}
const String& dp() const {
  DCHECK(hasDp());
return member_dp_;
}
String getDpOr(const String& fallback_value) const;
String getDpOr(String&& fallback_value) const;
void setDp(const String& value);
void setDp(String&& value);

bool hasDq() const {
  return has_dq_;
}
const String& dq() const {
  DCHECK(hasDq());
return member_dq_;
}
String getDqOr(const String& fallback_value) const;
String getDqOr(String&& fallback_value) const;
void setDq(const String& value);
void setDq(String&& value);

bool hasE() const {
  return has_e_;
}
const String& e() const {
  DCHECK(hasE());
return member_e_;
}
String getEOr(const String& fallback_value) const;
String getEOr(String&& fallback_value) const;
void setE(const String& value);
void setE(String&& value);

bool hasExt() const {
  return has_ext_;
}
bool ext() const {
  DCHECK(hasExt());
return member_ext_;
}
bool getExtOr(bool fallback_value) const {
  if (!hasExt()) {
  return fallback_value;
}
return member_ext_;
}
void setExt(bool value) {
  member_ext_ = value;
has_ext_ = true;
}

bool hasK() const {
  return has_k_;
}
const String& k() const {
  DCHECK(hasK());
return member_k_;
}
String getKOr(const String& fallback_value) const;
String getKOr(String&& fallback_value) const;
void setK(const String& value);
void setK(String&& value);

bool hasKeyOps() const {
  return has_key_ops_;
}
const Vector<String>& keyOps() const {
  DCHECK(hasKeyOps());
return member_key_ops_;
}
Vector<String> getKeyOpsOr(const Vector<String>& fallback_value) const;
Vector<String> getKeyOpsOr(Vector<String>&& fallback_value) const;
void setKeyOps(const Vector<String>& value);
void setKeyOps(Vector<String>&& value);

bool hasKty() const {
  return has_kty_;
}
const String& kty() const {
  DCHECK(hasKty());
return member_kty_;
}
String getKtyOr(const String& fallback_value) const;
String getKtyOr(String&& fallback_value) const;
void setKty(const String& value);
void setKty(String&& value);

bool hasN() const {
  return has_n_;
}
const String& n() const {
  DCHECK(hasN());
return member_n_;
}
String getNOr(const String& fallback_value) const;
String getNOr(String&& fallback_value) const;
void setN(const String& value);
void setN(String&& value);

bool hasOth() const {
  return has_oth_;
}
const HeapVector<Member<RsaOtherPrimesInfo>>& oth() const {
  DCHECK(hasOth());
return member_oth_;
}
HeapVector<Member<RsaOtherPrimesInfo>> getOthOr(const HeapVector<Member<RsaOtherPrimesInfo>>& fallback_value) const;
HeapVector<Member<RsaOtherPrimesInfo>> getOthOr(HeapVector<Member<RsaOtherPrimesInfo>>&& fallback_value) const;
void setOth(const HeapVector<Member<RsaOtherPrimesInfo>>& value);
void setOth(HeapVector<Member<RsaOtherPrimesInfo>>&& value);

bool hasP() const {
  return has_p_;
}
const String& p() const {
  DCHECK(hasP());
return member_p_;
}
String getPOr(const String& fallback_value) const;
String getPOr(String&& fallback_value) const;
void setP(const String& value);
void setP(String&& value);

bool hasQ() const {
  return has_q_;
}
const String& q() const {
  DCHECK(hasQ());
return member_q_;
}
String getQOr(const String& fallback_value) const;
String getQOr(String&& fallback_value) const;
void setQ(const String& value);
void setQ(String&& value);

bool hasQi() const {
  return has_qi_;
}
const String& qi() const {
  DCHECK(hasQi());
return member_qi_;
}
String getQiOr(const String& fallback_value) const;
String getQiOr(String&& fallback_value) const;
void setQi(const String& value);
void setQi(String&& value);

bool hasUse() const {
  return has_use_;
}
const String& use() const {
  DCHECK(hasUse());
return member_use_;
}
String getUseOr(const String& fallback_value) const;
String getUseOr(String&& fallback_value) const;
void setUse(const String& value);
void setUse(String&& value);

bool hasX() const {
  return has_x_;
}
const String& x() const {
  DCHECK(hasX());
return member_x_;
}
String getXOr(const String& fallback_value) const;
String getXOr(String&& fallback_value) const;
void setX(const String& value);
void setX(String&& value);

bool hasY() const {
  return has_y_;
}
const String& y() const {
  DCHECK(hasY());
return member_y_;
}
String getYOr(const String& fallback_value) const;
String getYOr(String&& fallback_value) const;
void setY(const String& value);
void setY(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 18;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_alg_ = false;
bool has_crv_ = false;
bool has_d_ = false;
bool has_dp_ = false;
bool has_dq_ = false;
bool has_e_ = false;
bool has_ext_ = false;
bool has_k_ = false;
bool has_key_ops_ = false;
bool has_kty_ = false;
bool has_n_ = false;
bool has_oth_ = false;
bool has_p_ = false;
bool has_q_ = false;
bool has_qi_ = false;
bool has_use_ = false;
bool has_x_ = false;
bool has_y_ = false;

String member_alg_;
String member_crv_;
String member_d_;
String member_dp_;
String member_dq_;
String member_e_;
bool member_ext_;
String member_k_;
Vector<String> member_key_ops_;
String member_kty_;
String member_n_;
HeapVector<Member<RsaOtherPrimesInfo>> member_oth_;
String member_p_;
String member_q_;
String member_qi_;
String member_use_;
String member_x_;
String member_y_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_JSON_WEB_KEY_H_
