// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_config.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"clientId",
"configURL",
"type",
};


}  // namespace 

IdentityProviderConfig* IdentityProviderConfig::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  IdentityProviderConfig* dictionary = MakeGarbageCollected<IdentityProviderConfig>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "IdentityProviderConfig";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 IdentityProviderConfig::IdentityProviderConfig() {
  
}

 IdentityProviderConfig::IdentityProviderConfig(v8::Isolate* isolate) {
  
}



String IdentityProviderConfig::getClientIdOr(const String& fallback_value) const {
  if (!hasClientId()) {
  return fallback_value;
}
return member_client_id_;
}

String IdentityProviderConfig::getClientIdOr(String&& fallback_value) const {
  if (!hasClientId()) {
  return std::move(fallback_value);
}
return member_client_id_;
}

void IdentityProviderConfig::setClientId(const String& value) {
  member_client_id_ = value;
has_client_id_ = true;
}

void IdentityProviderConfig::setClientId(String&& value) {
  member_client_id_ = std::move(value);
has_client_id_ = true;
}




void IdentityProviderConfig::setConfigURL(const String& value) {
  member_config_url_ = value;
}

void IdentityProviderConfig::setConfigURL(String&& value) {
  member_config_url_ = std::move(value);
}




String IdentityProviderConfig::getTypeOr(const String& fallback_value) const {
  if (!hasType()) {
  return fallback_value;
}
return member_type_;
}

String IdentityProviderConfig::getTypeOr(String&& fallback_value) const {
  if (!hasType()) {
  return std::move(fallback_value);
}
return member_type_;
}

void IdentityProviderConfig::setType(const String& value) {
  member_type_ = value;
has_type_ = true;
}

void IdentityProviderConfig::setType(String&& value) {
  member_type_ = std::move(value);
has_type_ = true;
}



void IdentityProviderConfig::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void IdentityProviderConfig::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "IdentityProviderConfig";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("clientId");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_client_id_, member_client_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("configURL");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_config_url_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::FedCmIdPRegistrationEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_type_, member_type_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> IdentityProviderConfig::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
