// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_VERSION_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_VERSION_CHANGE_EVENT_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_data_loss_amount.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT IDBVersionChangeEventInit : public EventInit {
  
  public:
static IDBVersionChangeEventInit* Create() {
  return MakeGarbageCollected<IDBVersionChangeEventInit>();
}
static IDBVersionChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<IDBVersionChangeEventInit>(isolate);
}
static IDBVersionChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  IDBVersionChangeEventInit();
explicit  IDBVersionChangeEventInit(v8::Isolate* isolate);

bool hasDataLoss() const {
  return true;
}
V8IDBDataLossAmount dataLoss() const {
  return member_data_loss_;
}
void setDataLoss(V8IDBDataLossAmount value) {
  member_data_loss_ = value;
}
void setDataLoss(V8IDBDataLossAmount::Enum value) {
  member_data_loss_ = V8IDBDataLossAmount(value);
}

bool hasNewVersion() const {
  return true;
}
const std::optional<uint64_t>& newVersion() const {
  return member_new_version_;
}
void setNewVersion(const std::optional<uint64_t>& value) {
  member_new_version_ = value;
}
void setNewVersion(uint64_t value) {
  member_new_version_ = value;
}

bool hasOldVersion() const {
  return true;
}
uint64_t oldVersion() const {
  return member_old_version_;
}
void setOldVersion(uint64_t value) {
  member_old_version_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8IDBDataLossAmount member_data_loss_{V8IDBDataLossAmount::Enum::kNone};
std::optional<uint64_t> member_new_version_;
uint64_t member_old_version_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_IDB_VERSION_CHANGE_EVENT_INIT_H_
