// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_html_input_element.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/frozen_array.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_file_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_node_list.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_selection_mode.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_validity_state.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_entry.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/dom/node_list.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/fileapi/file_list.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/custom/ce_reactions_scope.h"
#include "third_party/blink/renderer/core/html/forms/html_input_element.h"
#include "third_party/blink/renderer/core/html/forms/validity_state.h"
#include "third_party/blink/renderer/core/html/html_element.h"
#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/keywords.h"
#include "third_party/blink/renderer/modules/filesystem/entry.h"
#include "third_party/blink/renderer/modules/filesystem/html_input_element_file_system.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



void V8HTMLInputElement::Impl::Init() {
  V8HTMLInputElement::install_interface_template_func_ = InstallInterfaceTemplate;
V8HTMLInputElement::install_unconditional_props_func_ = InstallUnconditionalProperties;
V8HTMLInputElement::install_context_independent_props_func_ = InstallContextIndependentProperties;
}

namespace  {

namespace v8_html_input_element {


void AcceptAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_accept_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.accept.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAcceptAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AcceptAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_accept_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.accept.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAcceptAttr);
}


void AltAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_alt_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.alt.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAltAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AltAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_alt_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.alt.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAltAttr);
}


void AutocompleteAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_autocomplete_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.autocomplete.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->IDLExposedAutofillValue();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AutocompleteAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_autocomplete_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.autocomplete.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setIDLExposedAutofillValue(arg1_value);

}


void DefaultCheckedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_defaultChecked_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.defaultChecked.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kCheckedAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void DefaultCheckedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_defaultChecked_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.defaultChecked.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kCheckedAttr);
}


void CheckedAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_checked_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.checked.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->checkedForBinding();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void CheckedAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_checked_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.checked.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setCheckedForBinding(arg1_value);

}


void DirNameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_dirName_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.dirName.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kDirnameAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void DirNameAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_dirName_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.dirName.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kDirnameAttr);
}


void DisabledAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_disabled_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.disabled.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kDisabledAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void DisabledAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_disabled_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.disabled.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kDisabledAttr);
}


void FormAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_form_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.form.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->formForBinding();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<HTMLElement>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void FilesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_files_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.files.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->files();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<FileList>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void FilesAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_files_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.files.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLNullable<FileList>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFiles(arg1_value);

}


void FormActionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formAction_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formAction.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->formAction();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FormActionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formAction_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formAction.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFormAction(arg1_value);

}


void FormEnctypeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formEnctype_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formEnctype.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->formEnctype();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FormEnctypeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formEnctype_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formEnctype.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFormEnctype(arg1_value);

}


void FormMethodAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formMethod_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formMethod.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->formMethod();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FormMethodAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formMethod_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formMethod.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setFormMethod(arg1_value);

}


void FormNoValidateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formNoValidate_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formNoValidate.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kFormnovalidateAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void FormNoValidateAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formNoValidate_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formNoValidate.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kFormnovalidateAttr);
}


void FormTargetAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formTarget_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formTarget.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kFormtargetAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void FormTargetAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_formTarget_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.formTarget.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kFormtargetAttr);
}


void HeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_height_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.height.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->height();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void HeightAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_height_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.height.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLUnsignedLong>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setHeight(arg1_value);

}


void IndeterminateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_indeterminate_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.indeterminate.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->indeterminate();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IndeterminateAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_indeterminate_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.indeterminate.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setIndeterminate(arg1_value);

}


void ListAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_list_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.list.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->listForBinding();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<HTMLElement>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MaxAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_max_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.max.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kMaxAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void MaxAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_max_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.max.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kMaxAttr);
}


void MaxLengthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_maxLength_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.maxLength.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->maxLength();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void MaxLengthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_maxLength_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.maxLength.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLLong>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setMaxLength(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void MinAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_min_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.min.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kMinAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void MinAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_min_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.min.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kMinAttr);
}


void MinLengthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_minLength_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.minLength.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->minLength();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void MinLengthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_minLength_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.minLength.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLLong>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setMinLength(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void MultipleAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_multiple_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.multiple.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kMultipleAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void MultipleAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_multiple_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.multiple.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kMultipleAttr);
}


void NameAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_name_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.name.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetNameAttribute();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void NameAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_name_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.name.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kNameAttr);
}


void PatternAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_pattern_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.pattern.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kPatternAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void PatternAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_pattern_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.pattern.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kPatternAttr);
}


void PlaceholderAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_placeholder_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.placeholder.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kPlaceholderAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void PlaceholderAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_placeholder_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.placeholder.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kPlaceholderAttr);
}


void ReadOnlyAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_readOnly_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.readOnly.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kReadonlyAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void ReadOnlyAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_readOnly_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.readOnly.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kReadonlyAttr);
}


void RequiredAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_required_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.required.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kRequiredAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void RequiredAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_required_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.required.set");

bindings::PerformAttributeSetCEReactionsReflectTypeBoolean(info, html_names::kRequiredAttr);
}


void SizeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_size_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.size.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->size();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void SizeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_size_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.size.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLUnsignedLong>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSize(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void SrcAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_src_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.src.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetURLAttribute(html_names::kSrcAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void SrcAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_src_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.src.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kSrcAttr);
}


void StepAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_step_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.step.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kStepAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void StepAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_step_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.step.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kStepAttr);
}


void TypeAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_type_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.type.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->type();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void TypeAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_type_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.type.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setType(arg1_value);

}


void DefaultValueAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_defaultValue_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.defaultValue.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kValueAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void DefaultValueAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_defaultValue_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.defaultValue.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kValueAttr);
}


void ValueAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_value_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.value.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->valueForBinding();
static_assert(bindings::IsReturnTypeCompatible<IDLStringLegacyNullToEmptyString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void ValueAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_value_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.value.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLStringLegacyNullToEmptyString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setValueForBinding(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void ValueAsDateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_valueAsDate_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.valueAsDate.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->valueAsDate(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLObject>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void ValueAsDateAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_valueAsDate_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.valueAsDate.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLObject>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setValueAsDate(script_state, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void ValueAsNumberAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_valueAsNumber_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.valueAsNumber.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->valueAsNumber();
static_assert(bindings::IsReturnTypeCompatible<IDLUnrestrictedDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void ValueAsNumberAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_valueAsNumber_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.valueAsNumber.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedDouble>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setValueAsNumber(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void WidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_width_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.width.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->width();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void WidthAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_width_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.width.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLUnsignedLong>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setWidth(arg1_value);

}


void WillValidateAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_willValidate_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.willValidate.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->willValidate();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}



void ValidityAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_validity_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.validity.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->validity();
static_assert(bindings::IsReturnTypeCompatible<ValidityState, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void ValidationMessageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_validationMessage_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.validationMessage.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->validationMessage();
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}



void LabelsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_labels_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.labels.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->labels();
static_assert(bindings::IsReturnTypeCompatible<NodeList, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void SelectionStartAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionStart_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionStart.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->selectionStartForBinding(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLUnsignedLong>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void SelectionStartAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionStart_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionStart.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLUnsignedLong>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSelectionStartForBinding(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void SelectionEndAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionEnd_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionEnd.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->selectionEndForBinding(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLUnsignedLong>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void SelectionEndAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionEnd_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionEnd.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLUnsignedLong>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSelectionEndForBinding(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void SelectionDirectionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionDirection_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionDirection.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->selectionDirectionForBinding(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void SelectionDirectionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_selectionDirection_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.selectionDirection.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLNullable<IDLString>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSelectionDirectionForBinding(arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void AlignAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_align_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.align.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kAlignAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void AlignAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_align_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.align.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kAlignAttr);
}


void UseMapAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_useMap_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.useMap.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kUsemapAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void UseMapAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_useMap_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.useMap.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kUsemapAttr);
}


void CaptureAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_capture_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.capture.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8HTMLInputElement_Capture_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastGetAttribute(html_names::kCaptureAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void CaptureAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_capture_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.capture.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8HTMLInputElement_Capture_AttributeSetter);


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setAttribute(html_names::kCaptureAttr, arg1_value);

}


void WebkitdirectoryAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_webkitdirectory_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.webkitdirectory.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPrefixedDirectoryAttribute);



v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kWebkitdirectoryAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void WebkitdirectoryAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_webkitdirectory_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.webkitdirectory.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPrefixedDirectoryAttribute);


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->SetBooleanAttribute(html_names::kWebkitdirectoryAttr, arg1_value);

}


void IncrementalAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_incremental_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.incremental.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kIncrementalAttribute);



v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->FastHasAttribute(html_names::kIncrementalAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IncrementalAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_incremental_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.incremental.set");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kIncrementalAttribute);


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->SetBooleanAttribute(html_names::kIncrementalAttr, arg1_value);

}


void WebkitEntriesAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_webkitEntries_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.webkitEntries.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8HTMLInputElement_WebkitEntries_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = HTMLInputElementFileSystem::webkitEntries(script_state, *blink_receiver);
static_assert(bindings::IsReturnTypeCompatible<IDLArray<Entry>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLArray<Entry>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}



void PopoverTargetElementAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_popoverTargetElement_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.popoverTargetElement.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->GetElementAttribute(html_names::kPopovertargetAttr);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<Element>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void PopoverTargetElementAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_popoverTargetElement_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.popoverTargetElement.set");

v8::Isolate* isolate = info.GetIsolate();
ExceptionState exception_state(isolate);

// [CEReactions]
CEReactionsScope ce_reactions_scope(isolate);

v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
v8::Local<v8::Value> v8_property_value = info[0];
auto&& arg1_value = NativeValueTraits<IDLNullable<Element>>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->SetElementAttribute(html_names::kPopovertargetAttr, arg1_value);

}


void PopoverTargetActionAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_popoverTargetAction_Getter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.popoverTargetAction.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto return_value = blink_receiver->FastGetAttribute(html_names::kPopovertargetactionAttr);

// [ReflectOnly]
const AtomicString reflect_value(return_value.LowerASCII());
if (reflect_value.IsNull()) {
  return_value = keywords::kToggle;
} else if (reflect_value.empty()) {
  return_value = keywords::kToggle;
} else if (reflect_value == keywords::kToggle || reflect_value == keywords::kShow || reflect_value == keywords::kHide) {
  return_value = reflect_value;
} else {
  return_value = keywords::kToggle;
}  
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void PopoverTargetActionAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_popoverTargetAction_Setter");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.popoverTargetAction.set");

bindings::PerformAttributeSetCEReactionsReflectTypeString(info, html_names::kPopovertargetactionAttr);
}

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_constructor");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
if (V8PerIsolateData::From(isolate)->InWrapperConstructor()) {
  v8::Local<v8::Object> v8_receiver = info.This();
bindings::V8SetReturnValue(info, v8_receiver);
return;
}



// [HTMLConstructor]
V8HTMLConstructor::HtmlConstructor(info, *V8HTMLInputElement::GetWrapperTypeInfo(), HTMLElementType::kHTMLInputElement);
}

void CheckValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_checkValidity");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.checkValidity");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->checkValidity();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void ReportValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_reportValidity");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.reportValidity");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->reportValidity();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void SelectOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_select");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.select");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->select();

}

void SetCustomValidityOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_setCustomValidity");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.setCustomValidity");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_error;
if (info[0]->IsString()) [[likely]] {
  arg1_error.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_error = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->setCustomValidity(arg1_error);

}

void SetRangeTextOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_replacement = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setRangeText(arg1_replacement, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetRangeTextOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_replacement = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_start = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_end = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<V8SelectionMode>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_selection_mode{V8SelectionMode::Enum::kPreserve};
if (!info[3]->IsUndefined()) {
  arg4_selection_mode = NativeValueTraits<V8SelectionMode>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->setRangeText(arg1_replacement, arg2_start, arg3_end, arg4_selection_mode, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetRangeTextOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_setRangeText");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.setRangeText");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return SetRangeTextOperationOverload2(info);
}
if (arg_count == 3) {
  return SetRangeTextOperationOverload2(info);
}
if (arg_count == 1) {
  return SetRangeTextOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void SetSelectionRangeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_setSelectionRange");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.setSelectionRange");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_start = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_end = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 2) {
  blink_receiver->setSelectionRangeForBinding(arg1_start, arg2_end, exception_state);
break;
}
auto&& arg3_direction = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setSelectionRangeForBinding(arg1_start, arg2_end, arg3_direction, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ShowPickerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_showPicker");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.showPicker");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8HTMLInputElement_ShowPicker_Method);




v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->showPicker(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void StepDownOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_stepDown");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.stepDown");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_n{1};
ExceptionState exception_state(isolate);
if (!info[0]->IsUndefined()) {
  arg1_n = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->stepDown(arg1_n, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void StepUpOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_HTMLInputElement_stepUp");
BLINK_BINDINGS_TRACE_EVENT("HTMLInputElement.stepUp");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
HTMLInputElement* blink_receiver = V8HTMLInputElement::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_n{1};
ExceptionState exception_state(isolate);
if (!info[0]->IsUndefined()) {
  arg1_n = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->stepUp(arg1_n, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_html_input_element

using namespace v8_html_input_element;

}  // namespace 

void V8HTMLInputElement::Impl::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8HTMLInputElement::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(0);
interface_function_template->SetInterfaceName(V8String(isolate, "HTMLInputElement"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8HTMLInputElement::Impl::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"accept", AcceptAttributeGetCallback, AcceptAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"alt", AltAttributeGetCallback, AltAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"autocomplete", AutocompleteAttributeGetCallback, AutocompleteAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"defaultChecked", DefaultCheckedAttributeGetCallback, DefaultCheckedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"checked", CheckedAttributeGetCallback, CheckedAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"dirName", DirNameAttributeGetCallback, DirNameAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"disabled", DisabledAttributeGetCallback, DisabledAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"form", FormAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"files", FilesAttributeGetCallback, FilesAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"formAction", FormActionAttributeGetCallback, FormActionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"formEnctype", FormEnctypeAttributeGetCallback, FormEnctypeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"formMethod", FormMethodAttributeGetCallback, FormMethodAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"formNoValidate", FormNoValidateAttributeGetCallback, FormNoValidateAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"formTarget", FormTargetAttributeGetCallback, FormTargetAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"height", HeightAttributeGetCallback, HeightAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"indeterminate", IndeterminateAttributeGetCallback, IndeterminateAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"list", ListAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"max", MaxAttributeGetCallback, MaxAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"maxLength", MaxLengthAttributeGetCallback, MaxLengthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"min", MinAttributeGetCallback, MinAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"minLength", MinLengthAttributeGetCallback, MinLengthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"multiple", MultipleAttributeGetCallback, MultipleAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"name", NameAttributeGetCallback, NameAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"pattern", PatternAttributeGetCallback, PatternAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"placeholder", PlaceholderAttributeGetCallback, PlaceholderAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"readOnly", ReadOnlyAttributeGetCallback, ReadOnlyAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"required", RequiredAttributeGetCallback, RequiredAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"size", SizeAttributeGetCallback, SizeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"src", SrcAttributeGetCallback, SrcAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"step", StepAttributeGetCallback, StepAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"type", TypeAttributeGetCallback, TypeAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"defaultValue", DefaultValueAttributeGetCallback, DefaultValueAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"value", ValueAttributeGetCallback, ValueAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"valueAsDate", ValueAsDateAttributeGetCallback, ValueAsDateAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"valueAsNumber", ValueAsNumberAttributeGetCallback, ValueAsNumberAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"width", WidthAttributeGetCallback, WidthAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"willValidate", WillValidateAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"validity", ValidityAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"validationMessage", ValidationMessageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"labels", LabelsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"selectionStart", SelectionStartAttributeGetCallback, SelectionStartAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"selectionEnd", SelectionEndAttributeGetCallback, SelectionEndAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"selectionDirection", SelectionDirectionAttributeGetCallback, SelectionDirectionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"align", AlignAttributeGetCallback, AlignAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"useMap", UseMapAttributeGetCallback, UseMapAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"webkitdirectory", WebkitdirectoryAttributeGetCallback, WebkitdirectoryAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"incremental", IncrementalAttributeGetCallback, IncrementalAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"popoverTargetElement", PopoverTargetElementAttributeGetCallback, PopoverTargetElementAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"popoverTargetAction", PopoverTargetActionAttributeGetCallback, PopoverTargetActionAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLInputElement", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"checkValidity", CheckValidityOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"reportValidity", ReportValidityOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"select", SelectOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setCustomValidity", SetCustomValidityOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setRangeText", SetRangeTextOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setSelectionRange", SetSelectionRangeOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"showPicker", ShowPickerOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stepDown", StepDownOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stepUp", StepUpOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLInputElement", kOperationTable);
}



}

void V8HTMLInputElement::Impl::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::MediaCaptureEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"capture", CaptureAttributeGetCallback, CaptureAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLInputElement", kAttributeTable);
}
if (RuntimeEnabledFeatures::FileSystemEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"webkitEntries", WebkitEntriesAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "HTMLInputElement", kAttributeTable);
}






}



}  // namespace blink
