// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_PREDICTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_PREDICTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class HandwritingSegment;

class MODULES_EXPORT HandwritingPrediction : public bindings::DictionaryBase {
  
  public:
static HandwritingPrediction* Create() {
  return MakeGarbageCollected<HandwritingPrediction>();
}
static HandwritingPrediction* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HandwritingPrediction>(isolate);
}
static HandwritingPrediction* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HandwritingPrediction();
explicit  HandwritingPrediction(v8::Isolate* isolate);

bool hasSegmentationResult() const {
  return has_segmentation_result_;
}
const HeapVector<Member<HandwritingSegment>>& segmentationResult() const {
  DCHECK(hasSegmentationResult());
return member_segmentation_result_;
}
HeapVector<Member<HandwritingSegment>> getSegmentationResultOr(const HeapVector<Member<HandwritingSegment>>& fallback_value) const;
HeapVector<Member<HandwritingSegment>> getSegmentationResultOr(HeapVector<Member<HandwritingSegment>>&& fallback_value) const;
void setSegmentationResult(const HeapVector<Member<HandwritingSegment>>& value);
void setSegmentationResult(HeapVector<Member<HandwritingSegment>>&& value);

bool hasText() const {
  return true;
}
const String& text() const {
  return member_text_;
}
void setText(const String& value);
void setText(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_segmentation_result_ = false;

HeapVector<Member<HandwritingSegment>> member_segmentation_result_;
String member_text_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_HANDWRITING_PREDICTION_H_
