// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view_descriptor.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"arrayLayerCount",
"aspect",
"baseArrayLayer",
"baseMipLevel",
"dimension",
"format",
"mipLevelCount",
"swizzle",
"usage",
};


}  // namespace 

GPUTextureViewDescriptor* GPUTextureViewDescriptor::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  GPUTextureViewDescriptor* dictionary = MakeGarbageCollected<GPUTextureViewDescriptor>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "GPUTextureViewDescriptor";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 GPUTextureViewDescriptor::GPUTextureViewDescriptor() {
  
}

 GPUTextureViewDescriptor::GPUTextureViewDescriptor(v8::Isolate* isolate) : GPUObjectDescriptorBase(isolate) {
  
}














































void GPUTextureViewDescriptor::setSwizzle(const String& value) {
  member_swizzle_ = value;
}

void GPUTextureViewDescriptor::setSwizzle(String&& value) {
  member_swizzle_ = std::move(value);
}








void GPUTextureViewDescriptor::Trace(Visitor* visitor) const {
  GPUObjectDescriptorBase::Trace(visitor);
}

void GPUTextureViewDescriptor::FillTemplateProperties(Vector<std::string_view>& properties) const {
  GPUObjectDescriptorBase::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void GPUTextureViewDescriptor::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  GPUObjectDescriptorBase::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasArrayLayerCount()) {
  values[0] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_array_layer_count_);
DCHECK(!values[0].IsEmpty());
}
if (hasAspect()) {
  values[1] = ToV8Traits<V8GPUTextureAspect>::ToV8(script_state, member_aspect_);
DCHECK(!values[1].IsEmpty());
}
if (hasBaseArrayLayer()) {
  values[2] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_base_array_layer_);
DCHECK(!values[2].IsEmpty());
}
if (hasBaseMipLevel()) {
  values[3] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_base_mip_level_);
DCHECK(!values[3].IsEmpty());
}
if (hasDimension()) {
  values[4] = ToV8Traits<V8GPUTextureViewDimension>::ToV8(script_state, member_dimension_);
DCHECK(!values[4].IsEmpty());
}
if (hasFormat()) {
  values[5] = ToV8Traits<V8GPUTextureFormat>::ToV8(script_state, member_format_);
DCHECK(!values[5].IsEmpty());
}
if (hasMipLevelCount()) {
  values[6] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_mip_level_count_);
DCHECK(!values[6].IsEmpty());
}
if (RuntimeEnabledFeatures::WebGPUTextureComponentSwizzleEnabled()) {
  if (hasSwizzle()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_swizzle_);
DCHECK(!values[7].IsEmpty());
}
}
if (hasUsage()) {
  values[8] = ToV8Traits<IDLUnsignedLongEnforceRange>::ToV8(script_state, member_usage_);
DCHECK(!values[8].IsEmpty());
}
}

const void* GPUTextureViewDescriptor::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> GPUTextureViewDescriptor::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void GPUTextureViewDescriptor::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
GPUObjectDescriptorBase::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "GPUTextureViewDescriptor";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("arrayLayerCount");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_array_layer_count_, member_array_layer_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("aspect");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUTextureAspect, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_aspect_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("baseArrayLayer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_base_array_layer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("baseMipLevel");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_base_mip_level_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("dimension");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUTextureViewDimension, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_dimension_, member_dimension_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8GPUTextureFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_format_, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mipLevelCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_mip_level_count_, member_mip_level_count_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebGPUTextureComponentSwizzleEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("swizzle");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_swizzle_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("usage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_usage_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> GPUTextureViewDescriptor::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
