// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXEL_COPY_BUFFER_LAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXEL_COPY_BUFFER_LAYOUT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPUTexelCopyBufferLayout : public bindings::InputDictionaryBase {
  
  public:
static GPUTexelCopyBufferLayout* Create() {
  return MakeGarbageCollected<GPUTexelCopyBufferLayout>();
}
static GPUTexelCopyBufferLayout* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUTexelCopyBufferLayout>(isolate);
}
static GPUTexelCopyBufferLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUTexelCopyBufferLayout();
explicit  GPUTexelCopyBufferLayout(v8::Isolate* isolate);

bool hasBytesPerRow() const {
  return has_bytes_per_row_;
}
uint32_t bytesPerRow() const {
  DCHECK(hasBytesPerRow());
return member_bytes_per_row_;
}
uint32_t getBytesPerRowOr(uint32_t fallback_value) const {
  if (!hasBytesPerRow()) {
  return fallback_value;
}
return member_bytes_per_row_;
}
void setBytesPerRow(uint32_t value) {
  member_bytes_per_row_ = value;
has_bytes_per_row_ = true;
}

bool hasOffset() const {
  return true;
}
uint64_t offset() const {
  return member_offset_;
}
void setOffset(uint64_t value) {
  member_offset_ = value;
}

bool hasRowsPerImage() const {
  return has_rows_per_image_;
}
uint32_t rowsPerImage() const {
  DCHECK(hasRowsPerImage());
return member_rows_per_image_;
}
uint32_t getRowsPerImageOr(uint32_t fallback_value) const {
  if (!hasRowsPerImage()) {
  return fallback_value;
}
return member_rows_per_image_;
}
void setRowsPerImage(uint32_t value) {
  member_rows_per_image_ = value;
has_rows_per_image_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_bytes_per_row_ = false;
bool has_rows_per_image_ = false;

uint32_t member_bytes_per_row_;
uint64_t member_offset_{0};
uint32_t member_rows_per_image_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_TEXEL_COPY_BUFFER_LAYOUT_H_
