// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_REQUEST_ADAPTER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_REQUEST_ADAPTER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_power_preference.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT GPURequestAdapterOptions : public bindings::InputDictionaryBase {
  
  public:
static GPURequestAdapterOptions* Create() {
  return MakeGarbageCollected<GPURequestAdapterOptions>();
}
static GPURequestAdapterOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPURequestAdapterOptions>(isolate);
}
static GPURequestAdapterOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPURequestAdapterOptions();
explicit  GPURequestAdapterOptions(v8::Isolate* isolate);

bool hasFeatureLevel() const {
  return true;
}
const String& featureLevel() const {
  return member_feature_level_;
}
void setFeatureLevel(const String& value);
void setFeatureLevel(String&& value);

bool hasForceFallbackAdapter() const {
  return true;
}
bool forceFallbackAdapter() const {
  return member_force_fallback_adapter_;
}
void setForceFallbackAdapter(bool value) {
  member_force_fallback_adapter_ = value;
}

bool hasPowerPreference() const {
  return has_power_preference_;
}
V8GPUPowerPreference powerPreference() const {
  DCHECK(hasPowerPreference());
return member_power_preference_;
}
V8GPUPowerPreference getPowerPreferenceOr(V8GPUPowerPreference fallback_value) const {
  if (!hasPowerPreference()) {
  return fallback_value;
}
return member_power_preference_;
}
void setPowerPreference(V8GPUPowerPreference value) {
  member_power_preference_ = value;
has_power_preference_ = true;
}
void setPowerPreference(V8GPUPowerPreference::Enum value) {
  member_power_preference_ = V8GPUPowerPreference(value);
has_power_preference_ = true;
}

bool hasXrCompatible() const {
  return true;
}
bool xrCompatible() const {
  return member_xr_compatible_;
}
void setXrCompatible(bool value) {
  member_xr_compatible_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_power_preference_ = false;

String member_feature_level_{"core"};
bool member_force_fallback_adapter_{false};
V8GPUPowerPreference member_power_preference_{static_cast<V8GPUPowerPreference::Enum>(0)};
bool member_xr_compatible_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_REQUEST_ADAPTER_OPTIONS_H_
