// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTERNAL_TEXTURE_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTERNAL_TEXTURE_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_object_descriptor_base.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLVideoElement;
class V8UnionHTMLVideoElementOrVideoFrame;
class VideoFrame;

class MODULES_EXPORT GPUExternalTextureDescriptor : public GPUObjectDescriptorBase {
  
  public:
static GPUExternalTextureDescriptor* Create() {
  return MakeGarbageCollected<GPUExternalTextureDescriptor>();
}
static GPUExternalTextureDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUExternalTextureDescriptor>(isolate);
}
static GPUExternalTextureDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUExternalTextureDescriptor();
explicit  GPUExternalTextureDescriptor(v8::Isolate* isolate);

bool hasColorSpace() const {
  return true;
}
V8PredefinedColorSpace colorSpace() const {
  return member_color_space_;
}
void setColorSpace(V8PredefinedColorSpace value) {
  member_color_space_ = value;
}
void setColorSpace(V8PredefinedColorSpace::Enum value) {
  member_color_space_ = V8PredefinedColorSpace(value);
}

bool hasSource() const {
  return true;
}
V8UnionHTMLVideoElementOrVideoFrame* source() const {
  return member_source_.Get();
}
void setSource(V8UnionHTMLVideoElementOrVideoFrame* value) {
  member_source_ = value;
DCHECK(member_source_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = GPUObjectDescriptorBase::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8PredefinedColorSpace member_color_space_{V8PredefinedColorSpace::Enum::kSRGB};
Member<V8UnionHTMLVideoElementOrVideoFrame> member_source_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_EXTERNAL_TEXTURE_DESCRIPTOR_H_
