// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBuffer;

class MODULES_EXPORT GPUBufferBinding : public bindings::InputDictionaryBase {
  
  public:
static GPUBufferBinding* Create() {
  return MakeGarbageCollected<GPUBufferBinding>();
}
static GPUBufferBinding* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBufferBinding>(isolate);
}
static GPUBufferBinding* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBufferBinding();
explicit  GPUBufferBinding(v8::Isolate* isolate);

bool hasBuffer() const {
  return true;
}
GPUBuffer* buffer() const {
  return member_buffer_.Get();
}
void setBuffer(GPUBuffer* value) {
  member_buffer_ = value;
DCHECK(member_buffer_);
}

bool hasOffset() const {
  return true;
}
uint64_t offset() const {
  return member_offset_;
}
void setOffset(uint64_t value) {
  member_offset_ = value;
}

bool hasSize() const {
  return has_size_;
}
uint64_t size() const {
  DCHECK(hasSize());
return member_size_;
}
uint64_t getSizeOr(uint64_t fallback_value) const {
  if (!hasSize()) {
  return fallback_value;
}
return member_size_;
}
void setSize(uint64_t value) {
  member_size_ = value;
has_size_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_size_ = false;

Member<GPUBuffer> member_buffer_;
uint64_t member_offset_{0};
uint64_t member_size_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BUFFER_BINDING_H_
