// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_LAYOUT_ENTRY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_LAYOUT_ENTRY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUBufferBindingLayout;
class GPUExternalTextureBindingLayout;
class GPUSamplerBindingLayout;
class GPUStorageTextureBindingLayout;
class GPUTextureBindingLayout;

class MODULES_EXPORT GPUBindGroupLayoutEntry : public bindings::InputDictionaryBase {
  
  public:
static GPUBindGroupLayoutEntry* Create() {
  return MakeGarbageCollected<GPUBindGroupLayoutEntry>();
}
static GPUBindGroupLayoutEntry* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GPUBindGroupLayoutEntry>(isolate);
}
static GPUBindGroupLayoutEntry* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GPUBindGroupLayoutEntry();
explicit  GPUBindGroupLayoutEntry(v8::Isolate* isolate);

bool hasBinding() const {
  return true;
}
uint32_t binding() const {
  return member_binding_;
}
void setBinding(uint32_t value) {
  member_binding_ = value;
}

bool hasBindingArraySize() const {
  return true;
}
uint32_t bindingArraySize() const {
  return member_binding_array_size_;
}
void setBindingArraySize(uint32_t value) {
  member_binding_array_size_ = value;
}

bool hasBuffer() const {
  return has_buffer_;
}
GPUBufferBindingLayout* buffer() const {
  DCHECK(hasBuffer());
return member_buffer_.Get();
}
GPUBufferBindingLayout* getBufferOr(GPUBufferBindingLayout* fallback_value) const {
  if (!hasBuffer()) {
  return fallback_value;
}
return member_buffer_.Get();
}
void setBuffer(GPUBufferBindingLayout* value) {
  member_buffer_ = value;
has_buffer_ = true;
DCHECK(member_buffer_);
}

bool hasExternalTexture() const {
  return has_external_texture_;
}
GPUExternalTextureBindingLayout* externalTexture() const {
  DCHECK(hasExternalTexture());
return member_external_texture_.Get();
}
GPUExternalTextureBindingLayout* getExternalTextureOr(GPUExternalTextureBindingLayout* fallback_value) const {
  if (!hasExternalTexture()) {
  return fallback_value;
}
return member_external_texture_.Get();
}
void setExternalTexture(GPUExternalTextureBindingLayout* value) {
  member_external_texture_ = value;
has_external_texture_ = true;
DCHECK(member_external_texture_);
}

bool hasSampler() const {
  return has_sampler_;
}
GPUSamplerBindingLayout* sampler() const {
  DCHECK(hasSampler());
return member_sampler_.Get();
}
GPUSamplerBindingLayout* getSamplerOr(GPUSamplerBindingLayout* fallback_value) const {
  if (!hasSampler()) {
  return fallback_value;
}
return member_sampler_.Get();
}
void setSampler(GPUSamplerBindingLayout* value) {
  member_sampler_ = value;
has_sampler_ = true;
DCHECK(member_sampler_);
}

bool hasStorageTexture() const {
  return has_storage_texture_;
}
GPUStorageTextureBindingLayout* storageTexture() const {
  DCHECK(hasStorageTexture());
return member_storage_texture_.Get();
}
GPUStorageTextureBindingLayout* getStorageTextureOr(GPUStorageTextureBindingLayout* fallback_value) const {
  if (!hasStorageTexture()) {
  return fallback_value;
}
return member_storage_texture_.Get();
}
void setStorageTexture(GPUStorageTextureBindingLayout* value) {
  member_storage_texture_ = value;
has_storage_texture_ = true;
DCHECK(member_storage_texture_);
}

bool hasTexture() const {
  return has_texture_;
}
GPUTextureBindingLayout* texture() const {
  DCHECK(hasTexture());
return member_texture_.Get();
}
GPUTextureBindingLayout* getTextureOr(GPUTextureBindingLayout* fallback_value) const {
  if (!hasTexture()) {
  return fallback_value;
}
return member_texture_.Get();
}
void setTexture(GPUTextureBindingLayout* value) {
  member_texture_ = value;
has_texture_ = true;
DCHECK(member_texture_);
}

bool hasVisibility() const {
  return true;
}
uint32_t visibility() const {
  return member_visibility_;
}
void setVisibility(uint32_t value) {
  member_visibility_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 8;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_buffer_ = false;
bool has_external_texture_ = false;
bool has_sampler_ = false;
bool has_storage_texture_ = false;
bool has_texture_ = false;

uint32_t member_binding_;
uint32_t member_binding_array_size_{1};
Member<GPUBufferBindingLayout> member_buffer_;
Member<GPUExternalTextureBindingLayout> member_external_texture_;
Member<GPUSamplerBindingLayout> member_sampler_;
Member<GPUStorageTextureBindingLayout> member_storage_texture_;
Member<GPUTextureBindingLayout> member_texture_;
uint32_t member_visibility_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GPU_BIND_GROUP_LAYOUT_ENTRY_H_
