// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Gamepad;

class MODULES_EXPORT GamepadEventInit : public EventInit {
  
  public:
static GamepadEventInit* Create() {
  return MakeGarbageCollected<GamepadEventInit>();
}
static GamepadEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<GamepadEventInit>(isolate);
}
static GamepadEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  GamepadEventInit();
explicit  GamepadEventInit(v8::Isolate* isolate);

bool hasGamepad() const {
  return has_gamepad_;
}
Gamepad* gamepad() const {
  DCHECK(hasGamepad());
return member_gamepad_.Get();
}
Gamepad* getGamepadOr(Gamepad* fallback_value) const {
  if (!hasGamepad()) {
  return fallback_value;
}
return member_gamepad_.Get();
}
void setGamepad(Gamepad* value) {
  member_gamepad_ = value;
has_gamepad_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_gamepad_ = false;

Member<Gamepad> member_gamepad_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_GAMEPAD_EVENT_INIT_H_
