// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_well_known_directory.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class FilePickerAcceptType;
class FileSystemHandle;
class V8UnionFileSystemHandleOrWellKnownDirectory;

class MODULES_EXPORT FilePickerOptions : public bindings::InputDictionaryBase {
  
  public:
static FilePickerOptions* Create() {
  return MakeGarbageCollected<FilePickerOptions>();
}
static FilePickerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FilePickerOptions>(isolate);
}
static FilePickerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FilePickerOptions();
explicit  FilePickerOptions(v8::Isolate* isolate);

bool hasExcludeAcceptAllOption() const {
  return true;
}
bool excludeAcceptAllOption() const {
  return member_exclude_accept_all_option_;
}
void setExcludeAcceptAllOption(bool value) {
  member_exclude_accept_all_option_ = value;
}

bool hasId() const {
  return has_id_;
}
const String& id() const {
  DCHECK(hasId());
return member_id_;
}
String getIdOr(const String& fallback_value) const;
String getIdOr(String&& fallback_value) const;
void setId(const String& value);
void setId(String&& value);

bool hasStartIn() const {
  return has_start_in_;
}
V8UnionFileSystemHandleOrWellKnownDirectory* startIn() const {
  DCHECK(hasStartIn());
return member_start_in_.Get();
}
V8UnionFileSystemHandleOrWellKnownDirectory* getStartInOr(V8UnionFileSystemHandleOrWellKnownDirectory* fallback_value) const {
  if (!hasStartIn()) {
  return fallback_value;
}
return member_start_in_.Get();
}
void setStartIn(V8UnionFileSystemHandleOrWellKnownDirectory* value) {
  member_start_in_ = value;
has_start_in_ = true;
DCHECK(member_start_in_);
}

bool hasTypes() const {
  return has_types_;
}
const HeapVector<Member<FilePickerAcceptType>>& types() const {
  DCHECK(hasTypes());
return member_types_;
}
HeapVector<Member<FilePickerAcceptType>> getTypesOr(const HeapVector<Member<FilePickerAcceptType>>& fallback_value) const;
HeapVector<Member<FilePickerAcceptType>> getTypesOr(HeapVector<Member<FilePickerAcceptType>>&& fallback_value) const;
void setTypes(const HeapVector<Member<FilePickerAcceptType>>& value);
void setTypes(HeapVector<Member<FilePickerAcceptType>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_id_ = false;
bool has_start_in_ = false;
bool has_types_ = false;

bool member_exclude_accept_all_option_{false};
String member_id_;
Member<V8UnionFileSystemHandleOrWellKnownDirectory> member_start_in_;
HeapVector<Member<FilePickerAcceptType>> member_types_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FILE_PICKER_OPTIONS_H_
