// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_federated_credential_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"iconURL",
"name",
"protocol",
"provider",
};


}  // namespace 

FederatedCredentialInit* FederatedCredentialInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  FederatedCredentialInit* dictionary = MakeGarbageCollected<FederatedCredentialInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "FederatedCredentialInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 FederatedCredentialInit::FederatedCredentialInit() {
  
}

 FederatedCredentialInit::FederatedCredentialInit(v8::Isolate* isolate) : CredentialData(isolate) {
  
}



String FederatedCredentialInit::getIconURLOr(const String& fallback_value) const {
  if (!hasIconURL()) {
  return fallback_value;
}
return member_icon_url_;
}

String FederatedCredentialInit::getIconURLOr(String&& fallback_value) const {
  if (!hasIconURL()) {
  return std::move(fallback_value);
}
return member_icon_url_;
}

void FederatedCredentialInit::setIconURL(const String& value) {
  member_icon_url_ = value;
has_icon_url_ = true;
}

void FederatedCredentialInit::setIconURL(String&& value) {
  member_icon_url_ = std::move(value);
has_icon_url_ = true;
}




String FederatedCredentialInit::getNameOr(const String& fallback_value) const {
  if (!hasName()) {
  return fallback_value;
}
return member_name_;
}

String FederatedCredentialInit::getNameOr(String&& fallback_value) const {
  if (!hasName()) {
  return std::move(fallback_value);
}
return member_name_;
}

void FederatedCredentialInit::setName(const String& value) {
  member_name_ = value;
has_name_ = true;
}

void FederatedCredentialInit::setName(String&& value) {
  member_name_ = std::move(value);
has_name_ = true;
}




String FederatedCredentialInit::getProtocolOr(const String& fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}

String FederatedCredentialInit::getProtocolOr(String&& fallback_value) const {
  if (!hasProtocol()) {
  return std::move(fallback_value);
}
return member_protocol_;
}

void FederatedCredentialInit::setProtocol(const String& value) {
  member_protocol_ = value;
has_protocol_ = true;
}

void FederatedCredentialInit::setProtocol(String&& value) {
  member_protocol_ = std::move(value);
has_protocol_ = true;
}




void FederatedCredentialInit::setProvider(const String& value) {
  member_provider_ = value;
}

void FederatedCredentialInit::setProvider(String&& value) {
  member_provider_ = std::move(value);
}



void FederatedCredentialInit::Trace(Visitor* visitor) const {
  CredentialData::Trace(visitor);
}

void FederatedCredentialInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
CredentialData::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "FederatedCredentialInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("iconURL");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_icon_url_, member_icon_url_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("name");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_name_, member_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("provider");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_provider_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> FederatedCredentialInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
