// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FED_CM_TITLE_AND_SUBTITLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FED_CM_TITLE_AND_SUBTITLE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class  FedCmTitleAndSubtitle : public bindings::DictionaryBase {
  
  public:
static FedCmTitleAndSubtitle* Create() {
  return MakeGarbageCollected<FedCmTitleAndSubtitle>();
}
static FedCmTitleAndSubtitle* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FedCmTitleAndSubtitle>(isolate);
}
static FedCmTitleAndSubtitle* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FedCmTitleAndSubtitle();
explicit  FedCmTitleAndSubtitle(v8::Isolate* isolate);

bool hasSubtitle() const {
  return has_subtitle_;
}
const String& subtitle() const {
  DCHECK(hasSubtitle());
return member_subtitle_;
}
String getSubtitleOr(const String& fallback_value) const;
String getSubtitleOr(String&& fallback_value) const;
void setSubtitle(const String& value);
void setSubtitle(String&& value);

bool hasTitle() const {
  return true;
}
const String& title() const {
  return member_title_;
}
void setTitle(const String& value);
void setTitle(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_subtitle_ = false;

String member_subtitle_;
String member_title_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_FED_CM_TITLE_AND_SUBTITLE_H_
